/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.scene;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.enums.dimension.DimMemTypeEnum;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class SceneQuoteValidator
extends AbstractDimensionImportValidator {
    @Override
    public Optional<String> validate(ImportBillData bill) {
        Optional<DynamicObject> existingDy = RowDataExtUtil.getExistingRecord(bill);
        Boolean isversioned = bill.getData().getBoolean("isversioned");
        String newSceneQuoteNumber = null;
        if (bill.getData().getJSONObject("scenequote") != null) {
            newSceneQuoteNumber = bill.getData().getJSONObject("scenequote").getString("number");
        }
        if (existingDy.isPresent()) {
            int dimMemType = existingDy.get().getInt("issysmember");
            String olapNumber = ImportContextHolder.getImportContext().getImportModel().getString("number");
            Boolean oldIsversioned = existingDy.get().getBoolean("isversioned");
            String oldSceneQuoteNumber = existingDy.get().getString("scenequote.number");
            if (isversioned != null && isversioned.booleanValue()) {
                if (dimMemType == DimMemTypeEnum.SYSMEM.getIndex() || dimMemType == DimMemTypeEnum.IMPORTMEM.getIndex()) {
                    return Optional.of(ImportMsgUtils.presetSceneCannotVersioned());
                }
                if (oldIsversioned != null && !oldIsversioned.booleanValue()) {
                    DynamicObject versionScene = QueryServiceHelper.queryOne((String)"bcm_scenemembertree", (String)"name, number", (QFilter[])new QFilter("scenequote", "=", (Object)existingDy.get().getLong("id")).toArray());
                    if (versionScene != null) {
                        return Optional.of(String.format(ResManager.loadKDString((String)"\u8be5\u60c5\u666f\u6210\u5458\u5df2\u88ab\u5176\u5b83\u60c5\u666f\u6210\u5458\u201c%s\u201d\u5f15\u7528\uff0c\u4e0d\u80fd\u7248\u672c\u5316\u3002", (String)"SceneMemberEdit_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), versionScene.getString("number") + " " + versionScene.getString("name")));
                    }
                    if (OlapServiceHelper.hasOlapData((String)olapNumber, (List)Lists.newArrayList((Object[])new String[]{existingDy.get().getString("number")}), (String)"Scenario")) {
                        return Optional.of(ImportMsgUtils.sceneCannotEditVersionInfo());
                    }
                } else if (oldIsversioned != null && oldIsversioned.booleanValue() && (!oldSceneQuoteNumber.equals(newSceneQuoteNumber) || existingDy.get().getBoolean("alonemergeconfig") != bill.getData().getBoolean("alonemergeconfig").booleanValue()) && OlapServiceHelper.hasOlapData((String)olapNumber, (List)Lists.newArrayList((Object[])new String[]{oldSceneQuoteNumber}), (String)"Scenario")) {
                    return Optional.of(ImportMsgUtils.sceneCannotEditVersionInfo());
                }
            } else if (oldIsversioned.booleanValue() && OlapServiceHelper.hasOlapData((String)olapNumber, (List)Lists.newArrayList((Object[])new String[]{oldSceneQuoteNumber}), (String)"Scenario")) {
                return Optional.of(ImportMsgUtils.sceneCannotEditVersionInfo());
            }
        }
        if (isversioned != null && isversioned.booleanValue()) {
            if (StringUtils.isBlank((CharSequence)newSceneQuoteNumber)) {
                return Optional.of(ImportMsgUtils.quoteSceneMustInput());
            }
            DynamicObject sceneQuote = QueryServiceHelper.queryOne((String)"bcm_scenemembertree", (String)"id, scenequote.id", (QFilter[])new QFilter("model", "=", (Object)this.getModelId()).and("number", "=", (Object)newSceneQuoteNumber).toArray());
            if (sceneQuote == null) {
                return Optional.of(ImportMsgUtils.quoteSceneNotValid());
            }
            if (sceneQuote.getLong("scenequote.id") != 0L) {
                return Optional.of(ImportMsgUtils.sceneCannotQuoted());
            }
        }
        return Optional.empty();
    }
}

