/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.userdefinedproperty;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.userdefinedproperty.DBBatchCache;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class CurrentParentExistValidator
extends AbstractDimensionImportValidator {
    private DBBatchCache dbBatchCache;

    @Override
    public int getWeight() {
        return 500;
    }

    public CurrentParentExistValidator(DBBatchCache initDbBatchCache) {
        this.dbBatchCache = initDbBatchCache;
    }

    @Override
    public Optional<String> validate(ImportBillData bill) {
        JSONObject inputRowData = bill.getData();
        String propertyNumber = String.valueOf(inputRowData.get("userdefinedkindnumber"));
        String parentNumber = String.valueOf(inputRowData.get("parentnumber"));
        Set<String> dbHasMember = this.getOnePropertyValues(propertyNumber);
        if (!dbHasMember.contains(parentNumber)) {
            return Optional.of(ImportMsgUtils.parentNumberNotExist());
        }
        return Optional.empty();
    }

    private Set<String> getOnePropertyValues(String propertyNumber) {
        return Arrays.stream(this.dbBatchCache.getAllValues()).filter(x -> x.getString("longnumber").startsWith(propertyNumber)).map(x -> x.getString("number")).collect(Collectors.toSet());
    }
}

