/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.userdefinedproperty;

import com.alibaba.fastjson.JSONObject;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class FormatValidator
extends AbstractDimensionImportValidator {
    private static Pattern pattern = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9._-]*");

    @Override
    public int getWeight() {
        return 1500;
    }

    @Override
    public Optional<String> validate(ImportBillData bill) {
        JSONObject billData = bill.getData();
        if (!this.formatYes(billData.get("number").toString())) {
            return Optional.of(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u548c\u8fde\u63a5\u7b26\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u548c\u8fde\u63a5\u7b26\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"CheckFieldNullValidator_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String entityName = ImportContextHolder.getEntityName();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        if (RowDataExtUtil.checkNumberLength(dataEntityType, bill)) {
            return Optional.of(ImportMsgUtils.tooLongOfNumber());
        }
        if (RowDataExtUtil.checkNameLength(dataEntityType, bill)) {
            return Optional.of(ImportMsgUtils.tooLongOfName());
        }
        return Optional.empty();
    }

    private boolean formatYes(String number) {
        Matcher matcher = pattern.matcher(number);
        if (!matcher.matches()) {
            return false;
        }
        return !number.contains("..") && !number.startsWith(".");
    }
}

