/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.userdefinedproperty;

import com.alibaba.fastjson.JSONObject;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.dimension.batchimp.userdefinedproperty.DBBatchCache;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class NumberNameContentCheck
extends AbstractDimensionImportValidator {
    private Set<String> notOnceNameInExcel;

    public NumberNameContentCheck(Set<String> names) {
        this.notOnceNameInExcel = names;
    }

    @Override
    public int getWeight() {
        return 1500;
    }

    @Override
    public Optional<String> validate(ImportBillData bill) {
        DimensionImportContext context = ImportContextHolder.getImportContext();
        JSONObject billData = bill.getData();
        DBBatchCache dbBatchCache = DBBatchCache.getDBBatchCacheSingleInstance(this.getModelId(), this.getDimensionId());
        DynamicObject dbDy = dbBatchCache.getPropertyValue(String.valueOf(billData.get("number")));
        DynamicObject dbDyOfName = dbBatchCache.getPropertyValue(String.valueOf(billData.get("name")));
        String billName = billData.get("name").toString();
        String billNumber = billData.get("number").toString();
        if ("PR_NONE".equalsIgnoreCase(billNumber)) {
            return Optional.of(ImportMsgUtils.existNumberOfSys());
        }
        if (ImportOperateType.NEW == context.getImportType() && dbDy != null) {
            return Optional.of(ImportMsgUtils.existNumber());
        }
        if (dbDy != null) {
            if (dbDyOfName != null) {
                String dbName = dbDyOfName.getString("name");
                String dbNumber = dbDyOfName.getString("number");
                if (dbName.equals(billName) && !dbNumber.equals(billNumber)) {
                    return Optional.of(ImportMsgUtils.nameHasExist());
                }
            }
        } else if (this.notOnceNameInExcel.contains(billName) || dbDyOfName != null) {
            return Optional.of(ImportMsgUtils.nameHasExist());
        }
        return Optional.empty();
    }
}

