/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.datalock;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.datalock.DataLockHelper;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class DataLockBackupList
extends AbstractBaseListPlugin {
    private static final List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"scenario", "year", "period"});

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap(16);
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
        this.addItemClickListeners("toolbarap", "backup");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshBillByUserSelect(dimKeys, false);
        this.setBackupStatus();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        long sceneId = this.getCtrlId("scenario");
        long yearId = this.getCtrlId("year");
        long periodId = this.getCtrlId("period");
        long lockDim = DataLockHelper.getLockDim((long)this.getModelId());
        if (lockDim == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u5206\u6bb5\u7ef4\u5ea6\u3002", (String)"DataLockDisplayList_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (key) {
            case "search": {
                this.search();
                break;
            }
            case "backup": {
                this.backup(this.getModelId(), sceneId, yearId, periodId);
                break;
            }
            case "redobackup": {
                this.redoBackup(this.getModelId(), sceneId, yearId, periodId);
            }
        }
    }

    private void search() {
        this.setBackupStatus();
        String sceneNum = this.getCtrlNumber("scenario");
        String yearNum = this.getCtrlNumber("year");
        String periodNum = this.getCtrlNumber("period");
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and("scene", "=", (Object)sceneNum);
        filter.and("year", "=", (Object)yearNum);
        filter.and("period", "=", (Object)periodNum);
        filter.and("type", "=", (Object)"0");
        DynamicObject[] members = BusinessDataServiceHelper.load((String)"bcm_lockscope", (String)"id,stage.number,currency,type,scheme.number,lockdim,modifier,modifytime", (QFilter[])filter.toArray());
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        if (members.length == 0) {
            return;
        }
        Set ids = Arrays.stream(members).map(m -> m.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_lockscopeorg", (String)"lockscope,org", (QFilter[])new QFilter("lockscope", "in", ids).toArray());
        HashMap orgMap = new HashMap(16);
        orgs.forEach(o -> orgMap.computeIfAbsent(o.getLong("lockscope"), k -> new HashSet()).add(o.getString("org")));
        model.getDataEntity(true);
        model.batchCreateNewEntryRow("entryentity", members.length);
        int row = 0;
        for (DynamicObject member : members) {
            DynamicObject rowObj = model.getEntryRowEntity("entryentity", row++);
            rowObj.set("stage", (Object)member.getString("stage.number"));
            rowObj.set("plan", (Object)member.getString("scheme.number"));
            rowObj.set("currency", (Object)member.getString("currency"));
            rowObj.set("lockdim", (Object)member.getString("lockdim"));
            rowObj.set("modifier", member.get("modifier"));
            rowObj.set("modifytime", member.get("modifytime"));
            Set orgNum = (Set)orgMap.get(member.getLong("id"));
            if (orgNum == null) continue;
            rowObj.set("org", (Object)String.join((CharSequence)";", orgNum));
        }
        this.getView().updateView();
    }

    private void backup(long modelId, long sceneId, long yearId, long periodId) {
        LockScopeServiceHelper.archiving((long)modelId, (long)sceneId, (long)yearId, (long)periodId);
        this.setBackupStatus();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f52\u6863\u6210\u529f\u3002", (String)"DataLockBackupList_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void redoBackup(long modelId, long sceneId, long yearId, long periodId) {
        LockScopeServiceHelper.antiArchiving((long)modelId, (long)sceneId, (long)yearId, (long)periodId);
        this.setBackupStatus();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5f52\u6863\u6210\u529f\u3002", (String)"DataLockBackupList_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("model".equals(propertyName)) {
            this.propertyChangedModelUse(new ArrayList<String>(dimKeys));
        }
        this.search();
    }

    private void setBackupStatus() {
        Long modelId = this.getModelId();
        String sceneNum = this.getCtrlNumber("scenario");
        String yearNum = this.getCtrlNumber("year");
        String periodNum = this.getCtrlNumber("period");
        if (modelId != null && sceneNum != null && yearNum != null && periodNum != null) {
            boolean isBackup = this.isBackup(modelId, sceneNum, yearNum, periodNum);
            this.getModel().setValue("backupstatus", (Object)(isBackup ? ResManager.loadKDString((String)"\u5df2\u5f52\u6863", (String)"DataLockBackupList_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u5f52\u6863", (String)"DataLockBackupList_2", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        } else {
            this.getModel().setValue("backupstatus", null);
        }
    }

    private String getCtrlNumber(String ctl) {
        DynamicObject obj = (DynamicObject)this.getModel().getValue(ctl);
        return obj != null ? obj.getString("number") : null;
    }

    private long getCtrlId(String ctl) {
        DynamicObject obj = (DynamicObject)this.getModel().getValue(ctl);
        return obj != null ? obj.getLong("id") : 0L;
    }

    private boolean isBackup(long modelId, String scenario, String year, String period) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("scene", "=", (Object)scenario);
        filter.and("year", "=", (Object)year);
        filter.and("period", "=", (Object)period);
        filter.and("type", "=", (Object)"1");
        return QueryServiceHelper.exists((String)"bcm_lockscope", (QFilter[])filter.toArray());
    }
}

