/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.datalock;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.LockScopeTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class DataLockComparePlugin
extends AbstractBaseListPlugin {
    private static final WatchLogger LOGGER = BcmLogFactory.getWatchLogInstance((boolean)true, DataLockComparePlugin.class);
    private static final String TYPE_ONLY_IN_DB = "1";
    private static final String TYPE_ONLY_IN_OLAP = "2";
    private static final String TYPE_NORMAL = "3";
    private static final String ENTRYENTITY = "entryentity";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("model", this.getFormCustomParam("KEY_MODEL_ID"));
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (this.getModel().getValue("model") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DataLockComparePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (key) {
            case "btn_compare": {
                this.compare();
                break;
            }
            case "btn_sycn": {
                EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
                int[] selectRows = eg.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u540c\u6b65\u7684\u6570\u636e\u3002", (String)"DataLockComparePlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u4f1a\u628a\u5173\u7cfb\u5e93\u7684\u9501\u5b9a\u8bbe\u7f6e\u8986\u76d6\u5230\u591a\u7ef4\u5e93\uff0c\u662f\u5426\u786e\u5b9a\u64cd\u4f5c\uff1f", (String)"DataLockComparePlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("sync", (IFormPlugin)this));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if ("sync".equals(callBackId) && MessageBoxResult.Yes == evt.getResult()) {
            Set<String> scopeNames = this.sync();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"DataLockComparePlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u5206\u9636\u6bb5\u9501\u5b9a\u5173\u7cfb\u5e93\u540c\u6b65\u591a\u7ef4\u5e93", "DataLockComparePlugin_15", "fi-bcm-formplugin", "stageLockRelDbSyncOlap");
            OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u9501\u5b9a\u540d\u79f0\uff1a%s\u6210\u529f\u540c\u6b65\u5230\u591a\u7ef4\u5e93\u3002", "DataLockComparePlugin_16", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{String.join((CharSequence)",", scopeNames)}));
            this.writeMultiLangLog(opName, opDes);
            this.compare();
        }
    }

    private Set<String> sync() {
        HashSet<String> reulst = new HashSet<String>(16);
        DynamicObjectCollection entryData = this.getModel().getEntryEntity(ENTRYENTITY);
        EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = eg.getSelectRows();
        HashMap<String, TreeMap> insertScopeMap = new HashMap<String, TreeMap>(16);
        HashMap<String, TreeMap> updateScopeMap = new HashMap<String, TreeMap>(16);
        HashSet<String> deleteScopes = new HashSet<String>(16);
        for (int i : selectRows) {
            DynamicObject dyn = (DynamicObject)entryData.get(i);
            if (TYPE_ONLY_IN_OLAP.equals(dyn.getString("rectype"))) {
                deleteScopes.add(dyn.getString("scopename"));
                continue;
            }
            Map dbcontent = (Map)SerializationUtils.fromJsonString((String)dyn.getString("dbcontent"), Map.class);
            TreeMap lockScope = dbcontent.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((List)v.getValue()).toArray(new String[0]), (e1, e2) -> e2, TreeMap::new));
            if (TYPE_ONLY_IN_DB.equals(dyn.getString("rectype"))) {
                insertScopeMap.put(dyn.getString("scopename"), lockScope);
                continue;
            }
            updateScopeMap.put(dyn.getString("scopename"), lockScope);
        }
        String modelNUm = MemberReader.findModelNumberById((Object)this.getModelId());
        if (!CollectionUtil.isEmpty(deleteScopes)) {
            reulst.addAll(deleteScopes);
            OlapServiceHelper.dropLockDataScope((String)modelNUm, deleteScopes);
        }
        if (!insertScopeMap.isEmpty()) {
            reulst.addAll(insertScopeMap.keySet());
            OlapServiceHelper.createLockDataScope((String)modelNUm, insertScopeMap);
        }
        if (!updateScopeMap.isEmpty()) {
            reulst.addAll(updateScopeMap.keySet());
            OlapServiceHelper.updateLockDataScope((String)modelNUm, updateScopeMap);
        }
        return reulst;
    }

    private void compare() {
        this.getModel().deleteEntryData(ENTRYENTITY);
        ArrayList<Map<String, String>> rowDataList = new ArrayList<Map<String, String>>(16);
        long modelId = this.getModelId();
        DynamicObjectCollection lockScopeDoc = QueryServiceHelper.query((String)"bcm_lockscope", (String)"id,scene,year,period,currency,scopename,type,lockdim", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
        HashMap dbScopeMap = new HashMap(16);
        HashSet archScopes = new HashSet(16);
        lockScopeDoc.stream().filter(e -> LockScopeTypeEnum.ARCHIVING.getValue().equals(e.getString("type"))).forEach(e -> {
            dbScopeMap.put(e.getString("scopename"), e);
            archScopes.add(LockScopeServiceHelper.getCombineKey((String)e.getString("scene"), (String)e.getString("year"), (String)e.getString("period"), null));
        });
        HashSet archScopeIds = new HashSet(16);
        lockScopeDoc.stream().filter(e -> !archScopes.contains(LockScopeServiceHelper.getCombineKey((String)e.getString("scene"), (String)e.getString("year"), (String)e.getString("period"), null))).forEach(e -> {
            dbScopeMap.put(e.getString("scopename"), e);
            archScopeIds.add(e.getLong("id"));
        });
        Map lockOrgMap = LockScopeServiceHelper.getLockOrgNums(archScopeIds);
        String lockDimNum = LockScopeServiceHelper.getLockDimNumber((long)modelId);
        String modelNUm = MemberReader.findModelNumberById((Object)modelId);
        Set<String> lockNames = this.getOlapLockNames(modelNUm);
        HashSet onlyInDb = new HashSet(dbScopeMap.keySet());
        onlyInDb.removeAll(lockNames);
        HashSet<String> onlyInOlap = new HashSet<String>(lockNames);
        onlyInOlap.removeAll(dbScopeMap.keySet());
        onlyInDb.forEach(e -> rowDataList.add(this.createRowData(modelNUm, TYPE_ONLY_IN_DB, (String)e, ResManager.loadKDString((String)"\u53ea\u5b58\u5728\u5173\u7cfb\u5e93", (String)"DataLockComparePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "", (DynamicObject)dbScopeMap.get(e), lockOrgMap, Collections.emptyMap(), lockDimNum)));
        onlyInOlap.forEach(e -> rowDataList.add(this.createRowData(modelNUm, TYPE_ONLY_IN_OLAP, (String)e, "", ResManager.loadKDString((String)"\u53ea\u5b58\u5728\u591a\u7ef4\u5e93", (String)"DataLockComparePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (DynamicObject)dbScopeMap.get(e), lockOrgMap, this.anlysisOlapScope(OlapServiceHelper.queryLockScopeDetail((String)modelNUm, (String)e)), lockDimNum)));
        HashSet common = new HashSet(dbScopeMap.keySet());
        common.retainAll(lockNames);
        for (String scopName : common) {
            Map<String, Set<String>> map = this.anlysisOlapScope(OlapServiceHelper.queryLockScopeDetail((String)modelNUm, (String)scopName));
            Map<String, Set<String>> dbContent = this.createDbContent(modelNUm, (DynamicObject)dbScopeMap.get(scopName), lockOrgMap, lockDimNum);
            HashMap<String, String> dbDiff = new HashMap<String, String>(16);
            HashMap<String, String> olapDiff = new HashMap<String, String>(16);
            this.compareContent(dbContent, map, dbDiff, olapDiff, lockDimNum);
            if (dbDiff.isEmpty() && olapDiff.isEmpty()) continue;
            rowDataList.add(this.createRowData(modelNUm, TYPE_NORMAL, scopName, ((Object)dbDiff).toString(), ((Object)olapDiff).toString(), (DynamicObject)dbScopeMap.get(scopName), lockOrgMap, map, lockDimNum));
        }
        if (!CollectionUtil.isEmpty(rowDataList)) {
            this.getModel().beginInit();
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, rowDataList.size());
            int rowIndex = 0;
            for (Map map : rowDataList) {
                DynamicObject rowObj = this.getModel().getEntryRowEntity(ENTRYENTITY, rowIndex);
                map.forEach((arg_0, arg_1) -> ((DynamicObject)rowObj).set(arg_0, arg_1));
                ++rowIndex;
            }
            this.getModel().endInit();
            this.getView().updateView(ENTRYENTITY);
        }
    }

    private void compareContent(Map<String, Set<String>> dbContent, Map<String, Set<String>> olapContent, Map<String, String> dbDiff, Map<String, String> olapDiff, String lockDimNum) {
        if (dbContent.size() != olapContent.size()) {
            dbDiff.put(ResManager.loadKDString((String)"\u5173\u7cfb\u5e93\u4e0e\u591a\u7ef4\u5e93\u9501\u5b9a\u7ef4\u5ea6\u4e0d\u4e00\u81f4\uff0c\u6570\u636e\u6709\u95ee\u9898", (String)"DataLockComparePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8bf7\u624b\u5de5\u67e5\u770b\u5bf9\u6bd4\u3002", (String)"DataLockComparePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            olapDiff.put(ResManager.loadKDString((String)"\u5173\u7cfb\u5e93\u4e0e\u591a\u7ef4\u5e93\u9501\u5b9a\u7ef4\u5ea6\u4e0d\u4e00\u81f4\uff0c\u6570\u636e\u6709\u95ee\u9898", (String)"DataLockComparePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8bf7\u624b\u5de5\u67e5\u770b\u5bf9\u6bd4\u3002", (String)"DataLockComparePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.compareSet(ResManager.loadKDString((String)"\u60c5\u666f\u591a\u4e86\u6210\u5458", (String)"DataLockComparePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dbContent.get("Scenario"), olapContent.getOrDefault("Scenario", new HashSet(1)), dbDiff, olapDiff);
        this.compareSet(ResManager.loadKDString((String)"\u8d22\u5e74\u591a\u4e86\u6210\u5458", (String)"DataLockComparePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dbContent.get("Year"), olapContent.getOrDefault("Year", new HashSet(1)), dbDiff, olapDiff);
        this.compareSet(ResManager.loadKDString((String)"\u671f\u95f4\u591a\u4e86\u6210\u5458", (String)"DataLockComparePlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dbContent.get("Period"), olapContent.getOrDefault("Period", new HashSet(1)), dbDiff, olapDiff);
        this.compareSet(ResManager.loadKDString((String)"\u5e01\u522b\u591a\u4e86\u6210\u5458", (String)"DataLockComparePlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dbContent.get("Currency"), olapContent.getOrDefault("Currency", new HashSet(1)), dbDiff, olapDiff);
        this.compareSet(ResManager.loadKDString((String)"\u7ec4\u7ec7\u591a\u4e86\u6210\u5458", (String)"DataLockComparePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dbContent.get("Entity"), olapContent.getOrDefault("Entity", new HashSet(1)), dbDiff, olapDiff);
        this.compareSet(ResManager.loadKDString((String)"\u9501\u5b9a\u7ef4\u5ea6\u591a\u4e86\u6210\u5458", (String)"DataLockComparePlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dbContent.get(lockDimNum), olapContent.getOrDefault(lockDimNum, new HashSet(1)), dbDiff, olapDiff);
    }

    private void compareSet(String tipName, Set<String> dbMems, Set<String> olapMems, Map<String, String> dbDiff, Map<String, String> olapDiff) {
        HashSet<String> onlyInDb = new HashSet<String>(dbMems);
        onlyInDb.removeAll(olapMems);
        if (!CollectionUtil.isEmpty(onlyInDb)) {
            dbDiff.put(tipName, ((Object)onlyInDb).toString());
        }
        HashSet<String> onlyInOlap = new HashSet<String>(olapMems);
        onlyInOlap.removeAll(dbMems);
        if (!CollectionUtil.isEmpty(onlyInOlap)) {
            olapDiff.put(tipName, ((Object)onlyInOlap).toString());
        }
    }

    private Map<String, Set<String>> anlysisOlapScope(String olapScopeDetail) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(16);
        try {
            List olapList = (List)SerializationUtils.fromJsonString((String)olapScopeDetail, List.class);
            List dimensions = (List)((Map)olapList.get(0)).get("dimensions");
            List members = (List)((Map)olapList.get(0)).get("members");
            for (int i = 0; i < dimensions.size(); ++i) {
                result.put((String)dimensions.get(i), new HashSet((Collection)members.get(i)));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u91ca\u591a\u7ef4\u5e93\u9501\u5b9a\u8303\u56f4\u62a5\u9519\uff0colapScopeDetail=" + olapScopeDetail);
        }
        return result;
    }

    private Map<String, String> createRowData(String modelNUm, String recType, String scopeName, String dbDiff, String olapDiff, DynamicObject dbDyn, Map<Long, Set<String>> lockOrgMap, Map<String, Set<String>> olapContent, String lockDimNum) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("rectype", recType);
        result.put("scopename", scopeName);
        result.put("dbdiff", dbDiff);
        result.put("olapdiff", olapDiff);
        result.put("dbcontent", SerializationUtils.toJsonString(this.createDbContent(modelNUm, dbDyn, lockOrgMap, lockDimNum)));
        result.put("olapcontent", SerializationUtils.toJsonString((Object)olapContent.toString()));
        return result;
    }

    private Map<String, Set<String>> createDbContent(String modelNUm, DynamicObject dbDyn, Map<Long, Set<String>> lockOrgMap, String lockDimNum) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(16);
        if (dbDyn != null) {
            result.put("Scenario", StringUtils.isBlank((CharSequence)dbDyn.getString("scene")) ? new HashSet(1) : Sets.newHashSet((Object[])new String[]{dbDyn.getString("scene")}));
            result.put("Year", StringUtils.isBlank((CharSequence)dbDyn.getString("year")) ? new HashSet(1) : Sets.newHashSet((Object[])new String[]{dbDyn.getString("year")}));
            result.put("Period", StringUtils.isBlank((CharSequence)dbDyn.getString("period")) ? new HashSet(1) : Sets.newHashSet((Object[])new String[]{dbDyn.getString("period")}));
            if (LockScopeTypeEnum.ARCHIVING.getValue().equals(dbDyn.getString("type"))) {
                HashSet all = Sets.newHashSet((Object[])new String[]{"*"});
                result.put("Currency", all);
                result.put("Entity", all);
                result.put(lockDimNum, all);
            } else {
                result.put("Currency", StringUtils.isBlank((CharSequence)dbDyn.getString("currency")) ? new HashSet(1) : Sets.newHashSet((Object[])new String[]{dbDyn.getString("currency")}));
                result.put("Entity", LockScopeServiceHelper.getParentChilds((String)modelNUm, (Set)lockOrgMap.getOrDefault(dbDyn.getLong("id"), new HashSet(1))));
                Set lockdim = (Set)SerializationUtils.fromJsonString((String)dbDyn.getString("lockdim"), Set.class);
                result.put(lockDimNum, lockdim);
            }
        }
        return result;
    }

    private Set<String> getOlapLockNames(String modelNUm) {
        String olapNames = OlapServiceHelper.queryLockScope((String)modelNUm);
        if (StringUtils.isBlank((CharSequence)olapNames)) {
            return new HashSet<String>(1);
        }
        Set result = (Set)SerializationUtils.fromJsonString((String)olapNames, Set.class);
        return result;
    }
}

