/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.datalock;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.datalock.DataLockHelper;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.log.ErrorLogServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.importhelper.AbsCommonImport;
import kd.fi.bcm.formplugin.util.TreeEntryEntityUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class DataLockDisplayList
extends AbstractBaseListPlugin
implements TreeNodeClickListener {
    protected static final WatchLogger log = BcmLogFactory.getWatchLogInstance(DataLockDisplayList.class);
    private static final List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"scenario"});
    private static final String TREE_VIEW_AP = "treeviewap";
    private static final String ENTRY_ENTITY = "treeentryentity";
    private static final String PLAN_ID = "planId";
    private static final String ACTION_ID_REFRESH = "research";
    private static final String ACTION_ID_DELETE = "delete";
    private static final String DATA_CHANGED_CACHE = "datachangedcache";
    private static final String ACTION_ID_CHANGE1 = "datachange1";
    private static final String ACTION_ID_CHANGE2 = "datachange2";
    private static final String ACTION_ID_IMPORT = "IMPORT_CALL_BACK";

    @Override
    public void initialize() {
        super.initialize();
        TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        HashMap map = new HashMap(16);
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners("btnedit", "btndel", "btnadd", "btnup", "btndown");
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit sceneEdit = (BasedataEdit)this.getControl("scenario");
        sceneEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit stage = (BasedataEdit)this.getControl("editstage");
        stage.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        if (evt.getNodeId() != null) {
            String planId = String.valueOf(evt.getNodeId());
            String oldPlanId = this.getPageCache().get(PLAN_ID);
            this.getPageCache().put(PLAN_ID, planId);
            if (this.getPageCache().get(DATA_CHANGED_CACHE) != null && StringUtils.isNotEmpty((String)oldPlanId) && !oldPlanId.equals(planId)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u6570\u636e\u5df2\u7ecf\u53d1\u751f\u53d8\u5316\uff0c\u662f\u5426\u9700\u8981\u4fdd\u5b58\uff1f", (String)"DataLockDisplayList_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(ACTION_ID_CHANGE1));
            } else {
                this.initRightTree(LongUtil.toLong((Object)planId));
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), "model");
        if (StringUtils.isEmpty((String)modelId)) {
            return;
        }
        this.getModel().setValue("model", (Object)modelId);
        this.refreshBillByUserSelect(dimKeys, false);
        this.initLeftTree();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{ENTRY_ENTITY});
    }

    private void initLeftTree() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        DynamicObject scenario = (DynamicObject)this.getModel().getValue("scenario");
        if (model == null || scenario == null) {
            return;
        }
        TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        tree.deleteAllNodes();
        QFilter filter = new QFilter("model", "=", (Object)model.getLong("id"));
        filter.and("scenario", "=", (Object)scenario.getLong("id"));
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_datalockplanentity", (String)"id,number,name,dimension.name,dseq", (QFilter[])filter.toArray(), (String)"dseq asc");
        TreeNode root = new TreeNode();
        root.setId("root");
        for (DynamicObject obj : docs) {
            TreeNode node = new TreeNode();
            node.setId(obj.getString("id"));
            node.setText(obj.getString("dseq") + "   " + obj.getString("number") + " " + obj.getString("name"));
            node.setData((Object)obj);
            root.addChild(node);
        }
        tree.addNode(root);
        tree.expand("root");
    }

    private void initRightTree(Long planId) {
        this.getPageCache().remove(DATA_CHANGED_CACHE);
        if (planId == null || planId == 0L) {
            return;
        }
        this.getPageCache().put(PLAN_ID, String.valueOf(planId));
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRY_ENTITY);
        if (this.noPermission(planId)) {
            this.getView().updateView();
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"DataLockDisplayList_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        long modelId = this.getModelId();
        long dimId = DataLockHelper.getLockDim((long)modelId);
        String entityName = MemberReader.getDimensionDynById((long)dimId).getString("membermodel");
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("dimension", "=", (Object)dimId);
        DynamicObjectCollection docs = QueryServiceHelper.query((String)entityName, (String)"id,number,name,storagetype,parent,parent.id,level,dseq,isleaf", (QFilter[])filter.toArray(), (String)"level,dseq");
        if (docs != null && docs.size() > 0) {
            this.fillEntryEntity(docs, this.getStageSetting(planId));
            this.getView().setEnable(Boolean.valueOf(true), new String[]{ENTRY_ENTITY});
        }
    }

    private void fillEntryEntity(DynamicObjectCollection members, Map<String, DynamicObject> stageMap) {
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRY_ENTITY);
        model.getDataEntity(true);
        model.beginInit();
        model.batchCreateNewEntryRow(ENTRY_ENTITY, members.size());
        model.endInit();
        LinkedHashMap<Long, TreeSet<DynamicObject>> parentChild = new LinkedHashMap<Long, TreeSet<DynamicObject>>(16);
        Comparator<DynamicObject> comparator = TreeEntryEntityUtil.getSeqComparator();
        TreeSet<DynamicObject> roots = new TreeSet<DynamicObject>(comparator);
        parentChild.put(-1L, roots);
        members.forEach(m -> {
            long parent = m.getLong("parent");
            if (parent == 0L && roots.isEmpty()) {
                roots.add((DynamicObject)m);
                m.set("parent", (Object)-1L);
            } else {
                TreeSet treeSet = (TreeSet)parentChild.get(parent);
                if (treeSet != null) {
                    treeSet.add(m);
                } else {
                    parentChild.computeIfAbsent(parent, k -> new TreeSet(comparator)).add(m);
                }
            }
        });
        DynamicObject root = (DynamicObject)((TreeSet)parentChild.get(-1L)).first();
        this.setProperty(model, stageMap, root, 0);
        this.expandNext(model, root, 0, parentChild, stageMap);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(ENTRY_ENTITY);
        treeEntry.expandOne(0);
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void setProperty(IDataModel model, Map<String, DynamicObject> stageMap, DynamicObject child, int row) {
        DynamicObject rowObj = model.getEntryRowEntity(ENTRY_ENTITY, row);
        DynamicObject stage = stageMap.get(child.getString("number"));
        rowObj.set("id", (Object)child.getLong("id"));
        rowObj.set("pid", (Object)child.getLong("parent.id"));
        rowObj.set("isgroupnode", (Object)(!child.getBoolean("isleaf") ? 1 : 0));
        rowObj.set("number", (Object)child.getString("number"));
        rowObj.set("name", (Object)child.getString("name"));
        rowObj.set("storagetype", (Object)child.getString("storagetype"));
        if (stage != null) {
            rowObj.set("editstage", (Object)stage.getDynamicObject("editstage"));
            rowObj.set("submitstage", (Object)stage.getDynamicObject("submitstage"));
            rowObj.set("modifier", stage.get("modifier"));
            rowObj.set("modifytime", (Object)stage.getDate("modifytime"));
        } else {
            rowObj.set("modifier", null);
            rowObj.set("modifytime", null);
        }
    }

    private int expandNext(IDataModel model, DynamicObject parent, int row, Map<Long, TreeSet<DynamicObject>> parentChild, Map<String, DynamicObject> stageMap) {
        if (parentChild.containsKey(parent.getLong("id"))) {
            TreeSet<DynamicObject> childrenMap = parentChild.get(parent.getLong("id"));
            for (DynamicObject child : childrenMap) {
                this.setProperty(model, stageMap, child, ++row);
                row = this.expandNext(model, child, row, parentChild, stageMap);
            }
        }
        return row;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        long planId = LongUtil.toLong((Object)this.getPageCache().get(PLAN_ID));
        switch (key) {
            case "baritemsetting": {
                this.openSceneSetting();
                break;
            }
            case "baritemrefresh": {
                this.refresh();
                break;
            }
            case "baritemsave": {
                this.saveSetting();
                break;
            }
            case "baritemclear": {
                this.clearSetting();
                break;
            }
            case "baritemsubmit": {
                if (this.isInvalidPlan(planId)) {
                    return;
                }
                if (!this.canWrite(planId)) {
                    return;
                }
                if (this.getPageCache().get(DATA_CHANGED_CACHE) != null) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u6570\u636e\u5df2\u7ecf\u53d1\u751f\u53d8\u5316\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u63d0\u4ea4\uff1f", (String)"DataLockDisplayList_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(ACTION_ID_CHANGE2));
                    break;
                }
                this.submit(planId);
                break;
            }
            case "barexport": {
                this.exportSetting(planId);
                break;
            }
            case "barimport": {
                this.importSetting(planId);
            }
        }
    }

    private boolean canWrite(long planId) {
        if (planId == 0L || MemberPermHelper.isModelManager((Long)this.getModelId())) {
            return true;
        }
        ArrayListMultimap permMap = PermClassEntityHelper.getPermissionMap((String)"bcm_datalockplanentity", (String)String.valueOf(this.getModelId()), (String)String.valueOf(RequestContext.get().getCurrUserId()));
        Set ids = permMap.entries().stream().filter(e -> !DataTypeEnum.WRITEIN.getIndex().equals(e.getKey())).map(m -> (Long)m.getValue()).collect(Collectors.toSet());
        if (ids.contains(planId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"DataLockDisplayList_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean noPermission(long planId) {
        if (MemberPermHelper.isModelManager((Long)this.getModelId())) {
            return false;
        }
        ArrayListMultimap permMap = PermClassEntityHelper.getPermissionMap((String)"bcm_datalockplanentity", (String)String.valueOf(this.getModelId()), (String)String.valueOf(RequestContext.get().getCurrUserId()));
        List ids = permMap.get((Object)DataTypeEnum.NO.getIndex());
        return CollectionUtils.isNotEmpty((Collection)ids) && ids.contains(planId);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Button) {
            String key = ((Control)evt.getSource()).getKey();
            DynamicObject scene = (DynamicObject)this.getModel().getValue("scenario");
            if (scene == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f\u3002", (String)"DataLockDisplayList_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            long lockDim = DataLockHelper.getLockDim((long)this.getModelId());
            if (lockDim == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u5206\u6bb5\u7ef4\u5ea6\u3002", (String)"DataLockDisplayList_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("btnadd".equals(key)) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bcm_datalockplan");
                showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
                showParameter.setCustomParam("KEY_SCENE_ID", (Object)scene.getLong("id"));
                showParameter.setStatus(OperationStatus.ADDNEW);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCaption(ResManager.loadKDString((String)"\u9501\u5b9a\u65b9\u6848", (String)"DataLockDisplayList_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ACTION_ID_REFRESH);
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(showParameter);
            } else if ("btndel".equals(key)) {
                long planId = LongUtil.toLong((Object)this.getPageCache().get(PLAN_ID));
                if (planId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u9501\u5b9a\u65b9\u6848\u3002", (String)"DataLockDisplayList_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!this.canWrite(planId)) {
                    return;
                }
                QFilter mFilter = new QFilter("scheme", "=", (Object)planId);
                if (QueryServiceHelper.exists((String)"bcm_lockscope", (QFilter[])mFilter.toArray())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u9501\u5b9a\u65b9\u6848\u5df2\u6709\u9501\u5b9a\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DataLockDisplayList_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u5df2\u9009\u9501\u5b9a\u65b9\u6848\uff1f", (String)"DataLockDisplayList_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(ACTION_ID_DELETE));
            } else if ("btnedit".equals(key)) {
                long planId = LongUtil.toLong((Object)this.getPageCache().get(PLAN_ID));
                if (planId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4fee\u6539\u7684\u9501\u5b9a\u65b9\u6848\u3002", (String)"DataLockDisplayList_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!this.canWrite(planId)) {
                    return;
                }
                HashMap<String, String> openParameter = new HashMap<String, String>(16);
                openParameter.put("pkId", String.valueOf(planId));
                openParameter.put("formId", "bcm_datalockplan");
                FormShowParameter showParameter = BaseShowParameter.createFormShowParameter(openParameter);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ACTION_ID_REFRESH);
                showParameter.setCloseCallBack(closeCallBack);
                showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
                showParameter.setCustomParam("KEY_SCENE_ID", (Object)scene.getLong("id"));
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.setCaption(ResManager.loadKDString((String)"\u9501\u5b9a\u65b9\u6848", (String)"DataLockDisplayList_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
            } else if ("btnup".equals(key) || "btndown".equals(key)) {
                long planId = LongUtil.toLong((Object)this.getPageCache().get(PLAN_ID));
                if (planId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u52a8\u7684\u9501\u5b9a\u65b9\u6848\u3002", (String)"DataLockDisplayList_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!this.canWrite(planId)) {
                    return;
                }
                this.moveUpAndDown(planId, "btnup".equals(key));
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("model".equals(propertyName)) {
            this.propertyChangedModelUse(new ArrayList<String>(dimKeys));
        }
        if ("model".equals(propertyName) || "scenario".equals(propertyName)) {
            this.getPageCache().remove(PLAN_ID);
            this.refresh();
        }
        if ("editstage".equals(propertyName)) {
            this.getPageCache().put(DATA_CHANGED_CACHE, "true");
            DynamicObject newStage = (DynamicObject)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            DynamicObject currentRow = this.getModel().getEntryRowEntity(ENTRY_ENTITY, rowIndex);
            this.setDefaultValue(this.getModelId(), currentRow.getLong("id"), newStage);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        long planId = LongUtil.toLong((Object)this.getPageCache().get(PLAN_ID));
        String callBackId = event.getCallBackId();
        if (ACTION_ID_DELETE.equals(callBackId) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            String number = QueryServiceHelper.queryOne((String)"bcm_datalockplanentity", (String)"number", (QFilter[])new QFilter("id", "=", (Object)planId).toArray()).getString("number");
            try (TXHandle tx = TX.required();){
                try {
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_datalockplanentity"), (Object[])new Object[]{planId});
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_datalocksettingentity"), (Object[])new Object[]{planId});
                    this.resetSeq();
                }
                catch (Exception ex) {
                    tx.markRollback();
                    log.error("delete fail.cause by:" + ThrowableHelper.toString((Exception)ex));
                    throw new KDBizException(ex.getMessage());
                }
            }
            OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u9501\u5b9a\u65b9\u6848", "DataLockDisplayList_1", "fi-bcm-formplugin", "lockScheme");
            OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u9501\u5b9a\u65b9\u6848\uff1a%s \u5220\u9664\u6210\u529f\u3002", "DataLockDisplayList_29", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{number}));
            this.writeMultiLangLog(opName, opDes);
            this.getPageCache().remove(PLAN_ID);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DataLockDisplayList_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.refresh();
        } else if (ACTION_ID_CHANGE1.equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)event.getResult())) {
                this.saveSetting();
            }
            this.initRightTree(planId);
        } else if (ACTION_ID_CHANGE2.equals(callBackId) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            this.submit(planId);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (ACTION_ID_IMPORT.equals(event.getActionId()) || ACTION_ID_REFRESH.equals(event.getActionId()) && event.getReturnData() != null) {
            this.refresh();
        }
    }

    private void resetSeq() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        DynamicObject scene = (DynamicObject)this.getModel().getValue("scenario");
        if (model == null || scene == null) {
            return;
        }
        QFilter filter = new QFilter("model", "=", (Object)model.getLong("id"));
        filter.and("scenario", "=", (Object)scene.getLong("id"));
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"bcm_datalockplanentity", (String)"id,dseq", (QFilter[])filter.toArray(), (String)"dseq");
        int i = 0;
        for (DynamicObject record : records) {
            record.set("dseq", (Object)(++i));
        }
        SaveServiceHelper.update((DynamicObject[])records);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String key = event.getProperty().getName();
        if (key.equals("editstage")) {
            this.getView().getFormShowParameter().setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
            ListFilterParameter listParameter = parameter.getListFilterParameter();
            DynamicObject scene = (DynamicObject)this.getModel().getValue("scenario");
            listParameter.getQFilters().add(new QFilter("model", "=", (Object)this.getModelId()).and("scenario", "=", (Object)(scene == null ? 0L : scene.getLong("id"))));
        }
    }

    private void moveUpAndDown(long planId, boolean moveUp) {
        OPDescMultiLangEnumBridge opDes;
        DynamicObject plan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)"bcm_datalockplanentity");
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and("scenario", "=", (Object)((DynamicObject)this.getModel().getValue("scenario")).getLong("id"));
        String orderBy = "dseq desc";
        if (moveUp) {
            filter.and("dseq", "<", (Object)plan.getInt("dseq"));
            opDes = new OPDescMultiLangEnumBridge("\u9501\u5b9a\u65b9\u6848\uff1a%s \u4e0a\u79fb\u6210\u529f\u3002", "DataLockDisplayList_27", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{plan.getString("number")}));
        } else {
            filter.and("dseq", ">", (Object)plan.getInt("dseq"));
            orderBy = "dseq";
            opDes = new OPDescMultiLangEnumBridge("\u9501\u5b9a\u65b9\u6848\uff1a%s \u4e0b\u79fb\u6210\u529f\u3002", "DataLockDisplayList_28", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{plan.getString("number")}));
        }
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_datalockplanentity", (String)"id", (QFilter[])filter.toArray(), (String)orderBy, (int)1);
        if (docs == null || docs.size() == 0) {
            if (moveUp) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u5305\u542b\u9996\u884c\uff0c\u65e0\u6cd5\u4e0a\u79fb\u3002", (String)"DataLockDisplayList_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u5305\u542b\u672b\u884c\uff0c\u65e0\u6cd5\u4e0b\u79fb\u3002", (String)"DataLockDisplayList_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        DynamicObject next = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)docs.get(0)).getLong("id"), (String)"bcm_datalockplanentity");
        plan.set("dseq", (Object)(plan.getInt("dseq") + (moveUp ? -1 : 1)));
        next.set("dseq", (Object)(next.getInt("dseq") + (moveUp ? 1 : -1)));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plan, next});
        OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u9501\u5b9a\u65b9\u6848", "DataLockDisplayList_1", "fi-bcm-formplugin", "lockScheme");
        this.writeMultiLangLog(opName, opDes);
        this.refresh();
    }

    private void openSceneSetting() {
        long lockDim = DataLockHelper.getLockDim((long)this.getModelId());
        if (lockDim == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u5206\u6bb5\u7ef4\u5ea6\u3002", (String)"DataLockDisplayList_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_datalockscenelist");
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        parameter.setCaption(ResManager.loadKDString((String)"\u60c5\u666f\u542f\u7528\u9636\u6bb5\u5217\u8868", (String)"DataLockDisplayList_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void saveSetting() {
        this.getPageCache().remove(DATA_CHANGED_CACHE);
        long planId = LongUtil.toLong((Object)this.getPageCache().get(PLAN_ID));
        if (planId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9501\u5b9a\u65b9\u6848\u3002", (String)"DataLockDisplayList_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.canWrite(planId)) {
            return;
        }
        DynamicObjectCollection allRows = this.getModel().getEntryEntity(ENTRY_ENTITY);
        HashMap existRecord = new HashMap(16);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"bcm_datalocksettingentity", (String)"id,number,editstage,submitstage,creator,createtime,modifier,modifytime", (QFilter[])new QFilter("plan", "=", (Object)planId).toArray());
        Arrays.stream(records).forEach(r -> existRecord.put(r.getString("number"), r));
        ArrayList updateRecord = new ArrayList(16);
        ArrayList createRecord = new ArrayList(16);
        allRows.stream().filter(f -> !StorageTypeEnum.isShare((String)f.getString("storagetype"))).forEach(row -> {
            String number = row.getString("number");
            if (existRecord.containsKey(number)) {
                DynamicObject updateObj = (DynamicObject)existRecord.get(number);
                updateObj.set("editstage", row.get("editstage"));
                updateObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
                updateObj.set("modifytime", (Object)TimeServiceHelper.now());
                updateRecord.add(updateObj);
            } else if (row.getInt("editstage.id") != 0) {
                DynamicObject obj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_datalocksettingentity"));
                obj.set("model", (Object)this.getModelId());
                obj.set("plan", (Object)planId);
                obj.set("number", (Object)row.getString("number"));
                obj.set("editstage", row.get("editstage"));
                obj.set("creator", (Object)RequestContext.get().getCurrUserId());
                obj.set("createtime", (Object)TimeServiceHelper.now());
                obj.set("modifier", (Object)RequestContext.get().getCurrUserId());
                obj.set("modifytime", (Object)TimeServiceHelper.now());
                createRecord.add(obj);
            }
        });
        try (TXHandle tx = TX.required();){
            try {
                if (!createRecord.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])createRecord.toArray(new DynamicObject[0]));
                }
                if (!updateRecord.isEmpty()) {
                    SaveServiceHelper.update((DynamicObject[])updateRecord.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception ex) {
                tx.markRollback();
                log.error("save fail.cause by:" + ThrowableHelper.toString((Exception)ex));
                throw new KDBizException(ex.getMessage());
            }
        }
        DynamicObject plan = QueryServiceHelper.queryOne((String)"bcm_datalockplanentity", (String)"number", (QFilter[])new QFilter("id", "=", (Object)planId).toArray());
        OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u5206\u6bb5\u8bbe\u7f6e", "SceneEnableStageList_1", "fi-bcm-formplugin", "stageSet");
        OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u65b9\u6848\uff1a%s \u4fdd\u5b58\u6210\u529f\u3002", "DataLockDisplayList_26", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{plan.getString("number")}));
        this.writeMultiLangLog(opName, opDes);
        GlobalCacheServiceHelper.getCommonCache().invalidateByKey("getStageSetting#" + this.getModelId() + "#" + planId);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DataLockDisplayList_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void submit(long planId) {
        this.getPageCache().remove(DATA_CHANGED_CACHE);
        if (ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isValidateStageSeq")) {
            DynamicObject firstRow = this.getModel().getEntryRowEntity(ENTRY_ENTITY, 0);
            String entityName = MemberReader.getDimensionDynById((long)DataLockHelper.getLockDim((long)this.getModelId())).getString("membermodel");
            IDNumberTreeNode node = MemberReader.findMemberById((long)this.getModelId(), (String)entityName, (Long)firstRow.getLong("id"));
            Map<String, DynamicObject> stageMap = this.getStageSetting(planId);
            HashSet<String> numbers = new HashSet<String>(16);
            this.checkStage(node, stageMap, numbers);
            if (!numbers.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7236\u7ea7\u9636\u6bb5\u5fc5\u987b\u5927\u7b49\u4e8e\u5b50\u7ea7\u9636\u6bb5\u3002", (String)"DataLockDisplayList_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        QFilter filter = new QFilter("plan", "=", (Object)planId);
        QFilter sFilter = new QFilter("submitstage", "=", (Object)0L);
        sFilter.or("submitstage", "is null", null);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"bcm_datalocksettingentity", (String)"id,number,editstage,submitstage,modifier,modifytime", (QFilter[])filter.toArray());
        Arrays.stream(records).forEach(record -> {
            record.set("submitstage", record.get("editstage"));
            record.set("modifier", (Object)RequestContext.get().getCurrUserId());
            record.set("modifytime", (Object)TimeServiceHelper.now());
        });
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.update((DynamicObject[])records);
                DeleteServiceHelper.delete((String)"bcm_datalocksettingentity", (QFilter[])new QFilter[]{filter, sFilter});
            }
            catch (Exception ex) {
                tx.markRollback();
                log.error("submit fail.cause by:" + ThrowableHelper.toString((Exception)ex));
                throw new KDBizException(ex.getMessage());
            }
        }
        this.saveLog(planId);
        GlobalCacheServiceHelper.getCommonCache().invalidateByKey("getStageSetting#" + this.getModel() + "#" + planId);
        this.refresh();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"DataLockDisplayList_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void saveLog(long planId) {
        DynamicObject plan = QueryServiceHelper.queryOne((String)"bcm_datalockplanentity", (String)"number", (QFilter[])new QFilter("id", "=", (Object)planId).toArray());
        if (plan == null) {
            return;
        }
        try {
            OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u5206\u6bb5\u8bbe\u7f6e", "SceneEnableStageList_1", "fi-bcm-formplugin", "stageSet");
            OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u65b9\u6848\uff1a%s \u63d0\u4ea4\u6210\u529f\u3002", "DataLockDisplayList_25", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{plan.getString("number")}));
            this.writeMultiLangLog(opName, opDes);
            QFilter filter = new QFilter("plan", "=", (Object)planId);
            HashMap setting = new HashMap(16);
            DynamicObjectCollection settings = QueryServiceHelper.query((String)"bcm_datalocksettingentity", (String)"id,number,submitstage.number", (QFilter[])filter.toArray());
            settings.forEach(s -> setting.put(s.getString("number"), s.getString("submitstage.number")));
            StringBuilder sb = new StringBuilder("{\"plan number\":\"");
            sb.append(plan.getString("number")).append("\",\"plan id\":").append(planId).append(",\"setting\":");
            sb.append(JSONObject.toJSONString(setting)).append("}");
            ErrorLogServiceHelper.saveErrorLog((Long)this.getModelId(), (String)ResManager.loadKDString((String)"\u5206\u6bb5\u8bbe\u7f6e\u63d0\u4ea4", (String)"DataLockDisplayList_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)sb.toString());
        }
        catch (Exception ex) {
            log.error("save log error.cause by:" + ThrowableHelper.toString((Exception)ex));
        }
    }

    private void clearSetting() {
        if (!this.canWrite(LongUtil.toLong((Object)this.getPageCache().get(PLAN_ID)))) {
            return;
        }
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = grid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u3002", (String)"DataLockDisplayList_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        for (int i = 0; i < selectRows.length; ++i) {
            DynamicObject row = this.getModel().getEntryRowEntity(ENTRY_ENTITY, selectRows[i]);
            if (row == null) continue;
            row.set("editstage", null);
        }
        this.getView().updateView();
    }

    private void checkStage(IDNumberTreeNode parent, Map<String, DynamicObject> stageMap, Set<String> numbers) {
        DynamicObject parentStage = stageMap.get(parent.getNumber());
        parent.getChildren().forEach(c -> {
            DynamicObject childStage = (DynamicObject)stageMap.get(c.getNumber());
            if (parentStage != null && childStage != null && !this.largerThen(parentStage, childStage)) {
                numbers.add(c.getNumber());
            }
            if (!c.getChildren().isEmpty()) {
                this.checkStage((IDNumberTreeNode)c, stageMap, numbers);
            }
        });
    }

    private boolean largerThen(DynamicObject stage1, DynamicObject stage2) {
        return stage1.getInt("editstage.stage") >= stage2.getInt("editstage.stage");
    }

    private Map<String, DynamicObject> getStageSetting(long planId) {
        HashMap<String, DynamicObject> stageMap = new HashMap<String, DynamicObject>(16);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"bcm_datalocksettingentity", (String)"id,number,editstage,editstage.stage,submitstage,creator,createtime,modifier,modifytime", (QFilter[])new QFilter("plan", "=", (Object)planId).toArray());
        if (records != null && records.length > 0) {
            Arrays.stream(records).forEach(r -> stageMap.put(r.getString("number"), (DynamicObject)r));
        }
        return stageMap;
    }

    private void refresh() {
        TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        tree.deleteAllNodes();
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        this.initLeftTree();
        long planId = LongUtil.toLong((Object)this.getPageCache().get(PLAN_ID));
        if (planId != 0L) {
            this.initRightTree(planId);
            tree.treeNodeClick("root", this.getPageCache().get(PLAN_ID));
        }
        this.getView().updateView();
    }

    private void setDefaultValue(long modelId, long currentId, DynamicObject newStage) {
        String entityName = MemberReader.getDimensionDynById((long)DataLockHelper.getLockDim((long)this.getModelId())).getString("membermodel");
        IDNumberTreeNode node = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)currentId);
        if (node.isLeaf()) {
            return;
        }
        Set allIds = node.getAllChildren().stream().filter(f -> !f.isShare()).map(m -> m.getId()).collect(Collectors.toSet());
        DynamicObjectCollection allRows = this.getModel().getEntryEntity(ENTRY_ENTITY);
        allRows.stream().filter(f -> f.get("editstage") == null && allIds.contains(f.getLong("id"))).forEach(row -> row.set("editstage", (Object)newStage));
        this.getView().updateView();
    }

    private boolean isInvalidPlan(long planId) {
        if (planId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9501\u5b9a\u65b9\u6848\u3002", (String)"DataLockDisplayList_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void exportSetting(long planId) {
        DynamicObjectCollection docs;
        if (this.isInvalidPlan(planId)) {
            return;
        }
        if (this.noPermission(planId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"DataLockDisplayList_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = grid.getSelectRows();
        long modelId = this.getModelId();
        long dimId = DataLockHelper.getLockDim((long)modelId);
        String entityName = MemberReader.getDimensionDynById((long)dimId).getString("membermodel");
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("dimension", "=", (Object)dimId);
        if (selectRows.length > 0) {
            HashSet numbers = new HashSet(selectRows.length);
            Arrays.stream(selectRows).forEach(s -> numbers.add(this.getModel().getEntryRowEntity(ENTRY_ENTITY, s).getString("number")));
            filter.and("number", "in", numbers);
        }
        if ((docs = QueryServiceHelper.query((String)entityName, (String)"number,name,storagetype,parent.number,parent.name,longnumber,aggoprt", (QFilter[])filter.toArray(), (String)"level,dseq")) == null || docs.size() == 0) {
            return;
        }
        DynamicObject dim = MemberReader.getDimensionDynById((long)dimId);
        DynamicObject plan = QueryServiceHelper.queryOne((String)"bcm_datalockplanentity", (String)"number,name", (QFilter[])new QFilter("id", "=", (Object)planId).toArray());
        ArrayList<DynamicObject> exportList = new ArrayList<DynamicObject>(docs.size());
        ArrayList fields = Lists.newArrayList((Object[])new String[]{"number", "name", "storagetype", "aggoprt", "longnumber"});
        Map stageSetting = DataLockHelper.getEditSetting((long)modelId, (long)planId);
        Map stageMap = DataLockHelper.getSceneEnableStages((long)modelId);
        for (int i = 0; i < docs.size(); ++i) {
            DynamicObject field = (DynamicObject)docs.get(i);
            DynamicObject exportDyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_datalocksettingimpt");
            if (i == 0) {
                exportDyn.set("plannumber", (Object)plan.getString("number"));
                exportDyn.set("planname", (Object)plan.getString("name"));
                exportDyn.set("dimensionnumber", (Object)dim.getString("number"));
                exportDyn.set("dimensionname", (Object)dim.getString("name"));
            }
            exportDyn.set("parentnumber", (Object)((DynamicObject)docs.get(i)).getString("parent.number"));
            exportDyn.set("parentname", (Object)((DynamicObject)docs.get(i)).getString("parent.name"));
            Long stageId = (Long)stageSetting.get(((DynamicObject)docs.get(i)).getString("number"));
            if (stageId != null) {
                exportDyn.set("stage", stageMap.get(stageId));
            }
            fields.forEach(f -> exportDyn.set(f, field.get(f)));
            exportList.add(exportDyn);
        }
        try {
            FormView formView = (FormView)this.getView();
            DynamicObject[] result = exportList.toArray(new DynamicObject[0]);
            this.handleDys(result);
            String url = ExportUtil.export((DynamicObject[])result, (String)formView.getFormShowParameter().getServiceAppId(), (String)"bcm_datalocksettingimpt");
            this.downloadFile(url, "bcm_dimensionmanager", "485ADI/O38HB");
        }
        catch (Exception e) {
            watchlogger.info(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            throw new KDBizException((Throwable)e, new ErrorCode(kd.bos.util.StringUtils.getEmpty(), ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5bfc\u51fa\u6a21\u677f\u662f\u5426\u5b58\u5728\u3002", (String)"PaperTemplateListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0])), new Object[0]);
        }
    }

    private void importSetting(long planId) {
        if (this.isInvalidPlan(planId)) {
            return;
        }
        String plugin = "kd.fi.bcm.formplugin.dimension.datalock.DataLockSettingImportPlugin";
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ACTION_ID_IMPORT);
        ApplicationTypeEnum typeEnum = ApplicationTypeEnum.getApplication((String)this.getBizAppId());
        AbsCommonImport.invokeOperation("bcm_datalocksettingimpt", plugin, closeCallBack, this.getModelId(), typeEnum, this.getView(), ResManager.loadKDString((String)"\u5206\u6bb5\u8bbe\u7f6e\u5bfc\u5165", (String)"DataLockDisplayList_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }
}

