/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.datalock;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.datalock.DataLockHelper;
import kd.fi.bcm.business.log.ErrorLogServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.YearScopeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class DataLockPlanEdit
extends AbstractBaseFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String YEAR = "year";
    private static final String PERIODS = "periods";
    private static final String YEAR_SCOPE = "yearscope";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("advcontoolbarap");
        this.addClickListeners("btn_cancel", "btn_confirm");
        ((BasedataEdit)this.getControl(YEAR)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl(PERIODS)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl("permclass")), (Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and("isleaf", "=", (Object)true);
        filter.and("storagetype", "!=", (Object)StorageTypeEnum.LABEL.getOIndex());
        if (YEAR.equals(name)) {
            filter.and("number", "not in", (Object)Lists.newArrayList((Object[])new String[]{"LastYear", "CurrentYear"}));
        } else if (PERIODS.equals(name)) {
            filter.and("number", "not in", (Object)Lists.newArrayList((Object[])new String[]{"LastPeriod", "CurrentPeriod"}));
        }
        ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters().add(filter);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        int index = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (YEAR.equals(propertyName)) {
            if (e.getChangeSet()[0].getOldValue() == null) {
                this.getModel().setValue(YEAR_SCOPE, (Object)YearScopeEnum.THISYEAR.getValue(), index);
                this.getView().updateView(YEAR_SCOPE, index);
            } else if (newValue == null) {
                this.getModel().setValue(YEAR_SCOPE, (Object)YearScopeEnum.ALLYEAR.getValue(), index);
                this.getView().updateView(YEAR_SCOPE, index);
            }
        } else if (YEAR_SCOPE.equals(propertyName)) {
            if (this.getModel().getEntryRowEntity(ENTRY_ENTITY, index).get(YEAR) == null) {
                this.getModel().setValue(YEAR_SCOPE, (Object)YearScopeEnum.ALLYEAR.getValue(), index);
                this.getView().updateView(YEAR_SCOPE, index);
            } else if (YearScopeEnum.ALLYEAR.getValue().equals(newValue)) {
                this.getModel().setValue(YEAR, null, index);
                this.getView().updateView(YEAR, index);
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String pkId = (String)customParams.get("pkId");
        long modelId = LongUtil.toLong(customParams.get("KEY_MODEL_ID"));
        IDataModel model = this.getModel();
        model.setValue("dimension", (Object)DataLockHelper.getLockDim((long)modelId));
        if (StringUtils.isNotEmpty((CharSequence)pkId)) {
            this.getPageCache().put("pkId", pkId);
            DynamicObject plan = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bcm_datalockplanentity");
            model.setValue("name", (Object)plan.getString("name"));
            model.setValue("number", (Object)plan.getString("number"));
            model.setValue("description", (Object)plan.getString("description"));
            DynamicObject permission = PermClassEntityHelper.getPermissionClass((String)"bcm_datalockplanentity", (long)modelId, (long)LongUtil.toLong((Object)pkId));
            if (permission != null) {
                model.setValue("permclass", permission.get("permclass.id"));
            }
            model.deleteEntryData(ENTRY_ENTITY);
            DynamicObjectCollection entryDoc = plan.getDynamicObjectCollection(ENTRY_ENTITY);
            if (entryDoc.size() == 0) {
                return;
            }
            this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, entryDoc.size());
            int row = 0;
            for (DynamicObject dyn : entryDoc) {
                DynamicObject rowObj = this.getModel().getEntryRowEntity(ENTRY_ENTITY, row);
                rowObj.set(YEAR, dyn.get(YEAR));
                rowObj.set(YEAR_SCOPE, dyn.get(YEAR_SCOPE));
                rowObj.set(PERIODS, dyn.get(PERIODS));
                ++row;
            }
            this.getView().updateView(ENTRY_ENTITY);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (key.equals("addrow")) {
            this.getModel().createNewEntryRow(ENTRY_ENTITY);
        } else if (key.equals("deleterow")) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u3002", (String)"DataLockDisplayList_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().deleteEntryRows(ENTRY_ENTITY, rows);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_confirm".equals(key)) {
            DynamicObject plan;
            long modelId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
            long sceneId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_SCENE_ID"));
            long pkId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("pkId"));
            String number = (String)this.getModel().getValue("number");
            if (!BCMNumberRule.checkNumber((String)number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"RptAdjustBasicInfoPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            DynamicObjectCollection records = this.getModel().getEntryEntity(ENTRY_ENTITY);
            if (records.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataLockDisplayList_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            HashSet<String> groupCheck = new HashSet<String>(16);
            for (DynamicObject record : records) {
                if (record.get(YEAR) == null && !YearScopeEnum.ALLYEAR.getValue().equals(record.get(YEAR_SCOPE))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d22\u5e74\u3002", (String)"DataLockDisplayList_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                StringBuilder yearPeriod = new StringBuilder();
                yearPeriod.append(record.getString(YEAR));
                yearPeriod.append(record.getString(YEAR_SCOPE));
                record.getDynamicObjectCollection(PERIODS).forEach(r -> yearPeriod.append(r.getLong("fbasedataid.id")));
                if (groupCheck.add(yearPeriod.toString())) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d22\u5e74\u671f\u95f4\u7ec4\u5408\u5b58\u5728\u91cd\u590d\u884c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EffectiveYearPeriodUtil_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (pkId == 0L) {
                plan = BusinessDataServiceHelper.newDynamicObject((String)"bcm_datalockplanentity");
                plan.set("scenario", (Object)sceneId);
                plan.set("dimension", (Object)DataLockHelper.getLockDim((long)modelId));
                plan.set("model", (Object)modelId);
                plan.set("dseq", (Object)(DataLockHelper.getPlanMaxSeq((long)modelId, (long)sceneId) + 1));
                plan.set("creator", (Object)RequestContext.get().getCurrUserId());
                plan.set("createtime", (Object)new Date());
            } else {
                plan = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bcm_datalockplanentity");
                filter.and("id", "!=", (Object)pkId);
            }
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_datalockplanentity", (String)"number", (QFilter[])filter.toArray());
            if (doc.stream().filter(d -> number.equalsIgnoreCase(d.getString("number"))).findFirst().isPresent()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\u3002", (String)"EnumItemEdit_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            plan.set("number", (Object)number);
            plan.set("model", (Object)modelId);
            plan.set("name", this.getModel().getValue("name"));
            plan.set("description", this.getModel().getValue("description"));
            plan.set("permclass", this.getModel().getValue("permclass"));
            plan.set("modifier", (Object)RequestContext.get().getCurrUserId());
            plan.set("modifytime", (Object)TimeServiceHelper.now());
            DynamicObjectCollection entryEntity = plan.getDynamicObjectCollection(ENTRY_ENTITY);
            entryEntity.clear();
            ArrayList logDesc = new ArrayList(16);
            records.forEach(r -> {
                DynamicObject it = entryEntity.addNew();
                it.set(YEAR, r.get(YEAR));
                it.set(YEAR_SCOPE, r.get(YEAR_SCOPE));
                DynamicObjectCollection periods = new DynamicObjectCollection();
                for (DynamicObject period : r.getDynamicObjectCollection(PERIODS)) {
                    periods.add((Object)((DynamicObject)OrmUtils.clone((IDataEntityBase)period, (boolean)true, (boolean)true)));
                }
                it.getDynamicObjectCollection(PERIODS).addAll((Collection)periods);
                Set ps = r.getDynamicObjectCollection(PERIODS).stream().map(m -> m.getDynamicObject("fbasedataid")).collect(Collectors.toSet());
                String numbers = String.join((CharSequence)",", ps.stream().map(x -> x.getString("number")).collect(Collectors.toList()));
                String type = YearScopeEnum.getEnumByType((String)r.getString(YEAR_SCOPE)).getName();
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put(YEAR, r.getString("year.number"));
                map.put("year scope", type);
                map.put("period", numbers);
                logDesc.add(map);
            });
            StringBuilder sb = new StringBuilder("{\"plan number\":\"");
            sb.append(plan.getString("number")).append("\",\"plan id\":").append(plan.getLong("id")).append(",\"periods\":");
            sb.append(JSONObject.toJSONString(logDesc)).append("}");
            ErrorLogServiceHelper.saveErrorLog((Long)this.getModelId(), (String)ResManager.loadKDString((String)"\u9501\u5b9a\u65b9\u6848", (String)"DataLockDisplayList_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)sb.toString());
            try (TXHandle tx = TX.required();){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plan});
                    PermClassEntityHelper.savePermClass((DynamicObject)plan);
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
            OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u9501\u5b9a\u65b9\u6848", "DataLockDisplayList_1", "fi-bcm-formplugin", "lockScheme");
            OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u9501\u5b9a\u65b9\u6848\uff1a%s \u4fdd\u5b58\u6210\u529f\u3002", "DataLockDisplayList_15", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{number}));
            this.writeMultiLangLog(opName, opDes);
            this.getView().returnDataToParent((Object)true);
            this.getView().close();
        }
    }
}

