/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.datalock;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.dimension.datalock.DataLockHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.importhelper.AbsCommonImport;

public class DataLockSettingImportPlugin
extends AbsCommonImport {
    private Long modelId;
    private Long planId;
    private Long sceneId;
    private String modelNumber;
    private String dimNumber;
    private String planNumber;

    @Override
    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        super.setContext(rc, ctx, startArgs);
        this.entityName = "bcm_datalocksettingentity";
        return this;
    }

    @Override
    public Map<Object, String> saveBatch(List<ImportBillData> billDataList) {
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        switch (importType) {
            case OVERRIDE: {
                return this.saveOverride(billDataList);
            }
            case OVERRIDENEW: 
            case NEW: {
                return this.saveOverrideNew(billDataList);
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u7c7b\u578b\u6709\u8bef\u3002", (String)"AbsCommonImport_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    @Override
    public void beforeValidation(List<ImportBillData> rowdatas) {
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        switch (importType) {
            case OVERRIDE: {
                this.updateWithExistId(rowdatas, false);
                break;
            }
            case OVERRIDENEW: 
            case NEW: {
                this.updateWithExistId(rowdatas, true);
                break;
            }
        }
    }

    @Override
    public String getDefaultKeyFields() {
        return "number";
    }

    protected void beforeSave(List<ImportBillData> billData, ImportLogger logger) {
        super.beforeSave(billData, logger);
        this.modelId = LongUtil.toLong(this.ctx.getOption().get("BcmModelId"));
        this.modelNumber = MemberReader.findModelNumberById((Object)this.modelId);
    }

    @Override
    protected Optional<String> validateBillData(ImportBillData bill) {
        String number;
        JSONObject data = bill.getData();
        this.initParam(bill);
        if (data.getInteger("rowNum") == 4 && StringUtils.isEmpty((CharSequence)data.getString("plannumber"))) {
            return Optional.of(ResManager.loadKDString((String)"\u9501\u5b9a\u65b9\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataLockSettingImportPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (this.planId == 0L) {
            return Optional.of(ResManager.loadKDString((String)"\u9501\u5b9a\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"DataLockSettingImportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (!this.canWrite()) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u65e0%s\u65b9\u6848\u7684\u5199\u5165\u6743\u9650\u3002", (String)"DataLockSettingImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.planNumber));
        }
        if (data.get((Object)"stage") != null) {
            String stageNumber = ((JSONObject)data.get((Object)"stage")).getString("number");
            if (DataLockHelper.getSceneEnableStage((long)this.modelId, (long)this.sceneId, (String)stageNumber) == null) {
                return Optional.of(ResManager.loadKDString((String)"\u9501\u5b9a\u9636\u6bb5\u4e0d\u5b58\u5728\u3002", (String)"DataLockSettingImportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        if (MemberReader.findMemberByNumber((String)this.modelNumber, (String)this.dimNumber, (String)(number = data.getString("number"))) == IDNumberTreeNode.NotFoundTreeNode) {
            return Optional.of(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"DataLockSettingImportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    private void initParam(ImportBillData rowData) {
        if (this.planId == null) {
            DynamicObject plan = DataLockHelper.getDataLockPlan((long)this.modelId, (String)rowData.getData().getString("plannumber"));
            if (plan == null) {
                this.planId = 0L;
            } else {
                this.planId = plan.getLong("id");
                this.planNumber = plan.getString("number");
                this.sceneId = plan.getLong("scenario.id");
                this.dimNumber = plan.getString("dimension.number");
            }
        }
    }

    @Override
    protected Optional<DynamicObject> getDbOld(ImportBillData rowData) {
        this.initParam(rowData);
        QFilter filter = new QFilter("model", "=", (Object)this.modelId);
        filter.and("plan", "=", (Object)this.planId);
        filter.and("number", "=", (Object)rowData.getData().getString("number"));
        DynamicObject dyn = QueryServiceHelper.queryOne((String)this.entityName, (String)"id", (QFilter[])filter.toArray());
        if (dyn != null) {
            return Optional.of(BusinessDataServiceHelper.loadSingle((Object)dyn.getLong("id"), (String)this.entityName));
        }
        return Optional.empty();
    }

    @Override
    protected DynamicObject[] buildInsertDynamicObject(List<ImportBillData> billDataList) {
        return this.buildDyn(billDataList);
    }

    @Override
    protected DynamicObject[] buildUpdateDynamicObject(List<ImportBillData> billDataList) {
        return this.buildDyn(billDataList);
    }

    private DynamicObject[] buildDyn(List<ImportBillData> billDataList) {
        ArrayList<DynamicObject> records = new ArrayList<DynamicObject>(billDataList.size());
        for (int i = 0; i < billDataList.size(); ++i) {
            DynamicObject dyn;
            JSONObject data = billDataList.get(i).getData();
            if ("3".equals(data.getString("storagetype"))) continue;
            if (data.get((Object)"existingRecordDy") != null) {
                dyn = (DynamicObject)data.get((Object)"existingRecordDy");
            } else {
                dyn = BusinessDataServiceHelper.newDynamicObject((String)this.entityName);
                dyn.set("creator", (Object)RequestContext.get().getCurrUserId());
                dyn.set("createtime", (Object)TimeServiceHelper.now());
            }
            dyn.set("model", (Object)this.modelId);
            dyn.set("number", data.get((Object)"number"));
            dyn.set("plan", (Object)this.planId);
            if (data.get((Object)"stage") != null) {
                String stageNumber = ((JSONObject)data.get((Object)"stage")).getString("number");
                DynamicObject obj = DataLockHelper.getSceneEnableStage((long)this.modelId, (long)this.sceneId, (String)stageNumber);
                dyn.set("editstage", (Object)(obj == null ? 0L : obj.getLong("id")));
            } else {
                dyn.set("editstage", (Object)0L);
            }
            records.add(dyn);
        }
        return records.toArray(new DynamicObject[0]);
    }

    private boolean canWrite() {
        return (Boolean)ThreadCache.get((Object)("permissionCheck#" + this.planId), () -> {
            if (MemberPermHelper.isModelManager((Long)this.modelId)) {
                return true;
            }
            ArrayListMultimap permMap = PermClassEntityHelper.getPermissionMap((String)"bcm_datalockplanentity", (String)String.valueOf(this.modelId), (String)String.valueOf(RequestContext.get().getCurrUserId()));
            Set ids = permMap.entries().stream().filter(e -> !DataTypeEnum.WRITEIN.getIndex().equals(e.getKey())).map(m -> (Long)m.getValue()).collect(Collectors.toSet());
            return !ids.contains(this.planId);
        });
    }
}

