/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.datalock;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.util.LongUtil;

public class SceneEnableStageEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit sceneEdit = (BasedataEdit)this.getControl("scenario");
        sceneEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getModel().setValue("model", (Object)LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID")));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        long modelId = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        param.getListFilterParameter().getQFilters().add(new QFilter("model", "=", (Object)modelId).and("isleaf", "=", (Object)true));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        long modelId = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
        long pkId = (Long)this.getModel().getValue("id");
        String number = (String)this.getModel().getValue("number");
        if (!BCMNumberRule.checkNumber((String)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"RptAdjustBasicInfoPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject scene = (DynamicObject)this.getModel().getValue("scenario");
        int stage = Integer.parseInt(this.getModel().getValue("stage").toString());
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("id", "!=", (Object)pkId);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_datalockscene", (String)"number,scenario.id,stage", (QFilter[])filter.toArray());
        doc.forEach(d -> {
            if (number.equalsIgnoreCase(d.getString("number"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\u3002", (String)"EnumItemEdit_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (scene.getLong("id") == d.getLong("scenario.id") && stage == d.getInt("stage")) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u60c5\u666f\u5df2\u5b58\u5728%2$s\u9636\u6bb5\u3002", (String)"SceneEnableStageList_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), scene.getString("name"), stage));
                args.setCancel(true);
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        long modelId = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
        GlobalCacheServiceHelper.getCommonCache().invalidateByKey("getDataLockScene#" + modelId);
    }
}

