/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.datalock;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.dimension.datalock.validator.SceneDeleteContext;

public class SceneEnableStageList
extends AbstractBaseListPlugin
implements ClickListener {
    private static final String BILL_LIST_AP = "billlistap";
    private static final String ACTION_ID_REFRESH = "research";
    private static final String ACTION_ID_DELETE = "delete";

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners("toolbarap");
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.addSetFilterListener(this::setFilter);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.addHyperClickListener(event -> {
            HashMap<String, String> openParameter = new HashMap<String, String>(2);
            openParameter.put("formId", "bcm_datalockscene");
            openParameter.put("pkId", String.valueOf(((BillListHyperLinkClickEvent)event).getCurrentRow().getPrimaryKeyValue()));
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(openParameter);
            parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            parameter.setStatus(OperationStatus.EDIT);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCaption(ResManager.loadKDString((String)"\u60c5\u666f\u542f\u7528\u9636\u6bb5", (String)"SceneEnableStageList_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ACTION_ID_REFRESH);
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameter);
        });
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        if ("add".equals(evt.getItemKey())) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bcm_datalockscene");
            parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            parameter.setStatus(OperationStatus.ADDNEW);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCaption(ResManager.loadKDString((String)"\u60c5\u666f\u542f\u7528\u9636\u6bb5", (String)"SceneEnableStageList_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ACTION_ID_REFRESH);
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameter);
        } else if (ACTION_ID_DELETE.equals(evt.getItemKey())) {
            BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
            Object[] select = billList.getSelectedRows().getPrimaryKeyValues();
            if (select == null || select.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u60c5\u666f\u542f\u7528\u9636\u6bb5\u3002", (String)"SceneEnableStageList_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            List<Long> stageIds = Arrays.stream(select).map(s -> LongUtil.toLong((Object)s)).collect(Collectors.toList());
            long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
            Optional<String> msg = new SceneDeleteContext(modelId, stageIds).validate();
            if (msg.isPresent()) {
                this.getView().showTipNotification(msg.get());
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u5df2\u9009\u60c5\u666f\u542f\u7528\u9636\u6bb5\uff1f", (String)"SceneEnableStageList_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(ACTION_ID_DELETE));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (ACTION_ID_REFRESH.equals(event.getActionId())) {
            BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
            billList.refresh();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (ACTION_ID_DELETE.equals(event.getCallBackId()) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
            Object[] select = billList.getSelectedRows().getPrimaryKeyValues();
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_datalockscene"), (Object[])select);
            billList.clearSelection();
            billList.refresh();
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Object modelId = this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (modelId != null && LongUtil.toLong((Object)modelId) != 0L) {
            e.getQFilters().add(new QFilter("model", "=", modelId));
        }
        e.setOrderBy("number,stage");
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
    }
}

