/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.deletemember;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.formplugin.dimension.deletemember.DelMembContext;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.AbstractDeleteMemberValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.BasicValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.ConvertDiffRefValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.ConvertQuoteValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.ExchangeRateValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.HasOlapDataValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.InvAccountSetValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.InvChangeDataCaseSettingValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.InvChangeValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.InvQueryValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.InvRelationSetValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.InveLimSheetRefValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.InveLimTemplateRefValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.LinkMappingValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.OrgReffedValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.RecordTmplSettingValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.ReportDefaultPageSettingValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.RptAdjustValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.ScenePeriodValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.SceneQuoteValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.TaskSettingValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.TemplateQuoteValidator;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.UserDefinedValidator;

public class MemberDelete {
    public static String SHOW_FORM = "SHOW_FORM";
    public static String SHOW_MESSAGE = "SHOW_MESSAGE";

    public static String checkBasic4DeleteMember(DelMembContext ctx) {
        Optional<String> result = new BasicValidator(ctx).doValidate();
        if (result.isPresent()) {
            return result.get();
        }
        return null;
    }

    public static String checkQuote4DeleteMember(DelMembContext ctx) {
        String result;
        if ("bcm_entitymembertree".equals(ctx.getEntityId()) && (result = MemberDelete.validators4Org(ctx)) != null) {
            return result;
        }
        List<AbstractDeleteMemberValidator> validatorRefers = MemberDelete.getValidatorsOfRefer(ctx);
        for (AbstractDeleteMemberValidator validator : validatorRefers) {
            Optional<String> result2 = validator.doValidate();
            if (!result2.isPresent()) continue;
            return result2.get();
        }
        List<AbstractDeleteMemberValidator> validators = MemberDelete.getValidators(ctx);
        for (AbstractDeleteMemberValidator validator : validators) {
            Optional<String> result3 = validator.doValidate();
            if (!result3.isPresent()) continue;
            return result3.get();
        }
        return null;
    }

    private static List<AbstractDeleteMemberValidator> getValidators(DelMembContext ctx) {
        ArrayList<AbstractDeleteMemberValidator> validators = new ArrayList<AbstractDeleteMemberValidator>(10);
        if (!"bcm_entitymembertree".equals(ctx.getEntityId())) {
            validators.add(new ConvertQuoteValidator(ctx));
            validators.add(new ConvertDiffRefValidator(ctx));
        }
        validators.add(new ExchangeRateValidator(ctx));
        validators.add(new HasOlapDataValidator(ctx));
        validators.add(new InveLimSheetRefValidator(ctx));
        validators.add(new InveLimTemplateRefValidator(ctx));
        validators.add(new InvRelationSetValidator(ctx));
        validators.add(new InvAccountSetValidator(ctx));
        validators.add(new InvChangeDataCaseSettingValidator(ctx));
        validators.add(new LinkMappingValidator(ctx));
        validators.add(new OrgReffedValidator(ctx));
        validators.add(new RecordTmplSettingValidator(ctx));
        validators.add(new ReportDefaultPageSettingValidator(ctx));
        validators.add(new RptAdjustValidator(ctx));
        validators.add(new ScenePeriodValidator(ctx));
        validators.add(new SceneQuoteValidator(ctx));
        validators.add(new TaskSettingValidator(ctx));
        validators.add(new UserDefinedValidator(ctx));
        validators.sort((o1, o2) -> o2.getWeight() - o1.getWeight());
        return validators;
    }

    private static List<AbstractDeleteMemberValidator> getValidatorsOfRefer(DelMembContext ctx) {
        ArrayList<AbstractDeleteMemberValidator> validators = new ArrayList<AbstractDeleteMemberValidator>(10);
        if (!"bcm_entitymembertree".equals(ctx.getEntityId())) {
            validators.add(new TemplateQuoteValidator(ctx));
        }
        validators.add(new InvChangeValidator(ctx));
        validators.add(new InvQueryValidator(ctx));
        validators.sort((o1, o2) -> o2.getWeight() - o1.getWeight());
        return validators;
    }

    private static String validators4Org(DelMembContext ctx) {
        Optional<String> result;
        ArrayList<AbstractDeleteMemberValidator> validators = new ArrayList<AbstractDeleteMemberValidator>(10);
        validators.add(new ConvertQuoteValidator(ctx));
        validators.add(new TemplateQuoteValidator(ctx));
        validators.add(new ConvertDiffRefValidator(ctx));
        boolean isPass = true;
        for (AbstractDeleteMemberValidator validator : validators) {
            Optional<String> result2 = validator.doValidate();
            if (!result2.isPresent()) continue;
            isPass = false;
        }
        QFilter qf = new QFilter("number", "in", ctx.getMemberNums());
        qf.and("model", "=", (Object)ctx.getModelId());
        DynamicObjectCollection icEntites = QueryServiceHelper.query((String)"bcm_icmembertree", (String)"id,name", (QFilter[])new QFilter[]{qf});
        DynamicObjectCollection mcEntites = QueryServiceHelper.query((String)"bcm_mycompanymembertree", (String)"id,name", (QFilter[])new QFilter[]{qf});
        if (!CollectionUtils.isEmpty((Collection)icEntites)) {
            HashMap<Long, String> idNameMap1 = new HashMap<Long, String>(16);
            icEntites.forEach(dy -> idNameMap1.put(dy.getLong("id"), dy.getString("name")));
            ctx.setDimensionNum("InternalCompany");
            for (AbstractDeleteMemberValidator validator : validators) {
                validator.setIdNameMap(idNameMap1);
                result = validator.doValidate();
                if (!result.isPresent()) continue;
                isPass = false;
            }
        }
        if (!CollectionUtils.isEmpty((Collection)mcEntites)) {
            HashMap<Long, String> idNameMap2 = new HashMap<Long, String>(16);
            mcEntites.forEach(dy -> idNameMap2.put(dy.getLong("id"), dy.getString("name")));
            ctx.setDimensionNum("MyCompany");
            for (AbstractDeleteMemberValidator validator : validators) {
                validator.setIdNameMap(idNameMap2);
                result = validator.doValidate();
                if (!result.isPresent()) continue;
                isPass = false;
            }
        }
        ctx.setDimensionNum("Entity");
        if (!isPass) {
            return SHOW_FORM;
        }
        return null;
    }
}

