/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.deletemember.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.dimension.deletemember.DelMembContext;
import kd.fi.bcm.formplugin.dimension.deletemember.MemberDelete;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.AbstractDeleteMemberValidator;

public class ConvertDiffRefValidator
extends AbstractDeleteMemberValidator {
    public ConvertDiffRefValidator(DelMembContext ctx) {
        super(ctx);
    }

    @Override
    public int getWeight() {
        return 40;
    }

    @Override
    Optional<String> validate() {
        Map<Long, String> idNameMap = this.getIdNameMap();
        QFBuilder range = new QFBuilder();
        range.and("model", "=", (Object)this.ctx.getModelId());
        if ("Year".equals(this.ctx.getDimensionNum())) {
            range.and("effective.effectiveyear", "in", idNameMap.keySet());
        } else if ("Period".equals(this.ctx.getDimensionNum())) {
            range.and("effective.effectiveperiod", "in", idNameMap.keySet());
        } else {
            range.and("entryentity.memberid", "in", idNameMap.keySet());
        }
        String fields = "number,name,entryentity.memberid";
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bcm_convertdiffentity", (String)fields, (QFilter[])range.toArray());
        if (!CollectionUtils.isEmpty((Collection)dyns)) {
            Map result = new HashMap(2);
            List convertDiffs = new ArrayList(2);
            if (this.ctx.getPageCache().get("convertDiff") != null) {
                result = (Map)SerializationUtils.fromJsonString((String)this.ctx.getPageCache().get("convertDiff"), Map.class);
                convertDiffs = (List)result.get("convertDiff");
            }
            String prefix = "";
            if ("InternalCompany".equals(this.ctx.getDimensionNum())) {
                prefix = DimTypesEnum.INTERCOMPANY.getName() + " : ";
            } else if ("MyCompany".equals(this.ctx.getDimensionNum())) {
                prefix = DimTypesEnum.MYCOMPANY.getName() + " : ";
            }
            for (DynamicObject dy : dyns) {
                HashMap<String, String> data = new HashMap<String, String>(4);
                data.put("number", dy.getString("number"));
                data.put("name", dy.getString("name"));
                data.put("dimensionName", prefix + idNameMap.get(dy.getLong("entryentity.memberid")));
                data.put("formular", "");
                convertDiffs.add(data);
            }
            result.put("convertDiff", convertDiffs);
            this.ctx.getPageCache().put("convertDiff", SerializationUtils.toJsonString(result));
            if (convertDiffs.size() > 0) {
                return Optional.of(MemberDelete.SHOW_FORM);
            }
        }
        return Optional.empty();
    }
}

