/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.deletemember.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.dimension.deletemember.DelMembContext;
import kd.fi.bcm.formplugin.dimension.deletemember.MemberDelete;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.AbstractDeleteMemberValidator;

public class ConvertQuoteValidator
extends AbstractDeleteMemberValidator {
    public ConvertQuoteValidator(DelMembContext delMembContext) {
        super(delMembContext);
    }

    @Override
    public int getWeight() {
        return 40;
    }

    @Override
    Optional<String> validate() {
        if ("AuditTrail".equals(this.ctx.getDimensionNum())) {
            QFilter qModel = new QFilter("model", "=", (Object)this.ctx.getModelId());
            QFilter qDimension = new QFilter("convertaudittrial", "in", this.ctx.getAllMemberIds()).or(new QFilter("cvtdiffaudittrial", "in", this.ctx.getAllMemberIds()));
            if (QueryServiceHelper.exists((String)"bcm_basecvtformula", (QFilter[])new QFilter[]{qModel, qDimension})) {
                return Optional.of(ResManager.loadKDString((String)"\u6210\u5458\u6216\u8005\u4e0b\u7ea7\u6210\u5458\u88ab\u6298\u7b97\u8bbe\u7f6e\u5f15\u7528\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"DimensionDisplayList_62", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
        }
        Map<Long, String> idNameMap = this.getIdNameMap();
        Set<Long> list = idNameMap.keySet();
        ArrayList<Long> specialRateIds = new ArrayList<Long>();
        ArrayList<Long> formulaIds = new ArrayList<Long>();
        HashSet<String> dimensionSet = new HashSet<String>(Arrays.asList("Year", "Period", "Entity", "Scenario"));
        String dimensionNum = this.ctx.getDimensionNum();
        QFBuilder specialRateRange = new QFBuilder();
        QFBuilder formulaRange = new QFBuilder();
        for (Long id : list) {
            boolean userDefcvtformulaFlag;
            specialRateRange.clear();
            specialRateRange.and("model", "=", (Object)this.ctx.getModelId());
            if (dimensionSet.contains(dimensionNum)) {
                switch (dimensionNum) {
                    case "Year": {
                        specialRateRange.add("effective.effectiveyear", "=", (Object)id);
                        break;
                    }
                    case "Period": {
                        specialRateRange.add("effective.effectiveperiod", "=", (Object)id);
                        break;
                    }
                    case "Scenario": {
                        specialRateRange.add("scenario", "=", (Object)id);
                        break;
                    }
                    default: {
                        specialRateRange.add("entryentity.memberid", "=", (Object)id);
                        break;
                    }
                }
            } else {
                specialRateRange.add("entryentity.memberid", "=", (Object)id);
            }
            boolean specialRateFlag = QueryServiceHelper.exists((String)"bcm_specialrate", (QFilter[])specialRateRange.toArray());
            if (specialRateFlag) {
                specialRateIds.add(id);
                break;
            }
            formulaRange.clear();
            formulaRange.and("model", "=", (Object)this.ctx.getModelId());
            if (dimensionSet.contains(dimensionNum)) {
                switch (dimensionNum) {
                    case "Year": {
                        formulaRange.add("effective.effectiveyear", "=", (Object)id);
                        break;
                    }
                    case "Period": {
                        formulaRange.add("effective.effectiveperiod", "=", (Object)id);
                        break;
                    }
                    case "Scenario": {
                        formulaRange.add("scenario", "=", (Object)id);
                        break;
                    }
                    default: {
                        formulaRange.add("entryentity.memberid", "=", (Object)id);
                        break;
                    }
                }
            } else {
                formulaRange.add("entryentity.memberid", "=", (Object)id);
            }
            if (!(userDefcvtformulaFlag = QueryServiceHelper.exists((String)"bcm_userdefcvtformula", (QFilter[])formulaRange.toArray()))) continue;
            formulaIds.add(id);
            break;
        }
        return this.checkSize(dimensionNum, specialRateIds, formulaIds);
    }

    private Optional<String> checkSize(String dimensionNum, List<Long> specialRateIds, List<Long> formulaIds) {
        List resultList;
        HashMap convertMap;
        if (specialRateIds.size() == 0 && formulaIds.size() == 0) {
            return Optional.empty();
        }
        String convertString = this.ctx.getPageCache().get("convertSetting");
        if (convertString != null) {
            convertMap = (HashMap)SerializationUtils.fromJsonString((String)convertString, Map.class);
            resultList = convertMap.computeIfAbsent("convert", k -> new ArrayList(2));
        } else {
            convertMap = new HashMap(2);
            resultList = new ArrayList(2);
        }
        HashMap<String, String> data = new HashMap<String, String>(2);
        if (specialRateIds.size() > 0) {
            ArrayList dataList = new ArrayList();
            specialRateIds.forEach(id -> dataList.add(this.idNameMap.get(id)));
            data.put("specialName", ((Object)dataList).toString());
        } else if (formulaIds.size() > 0) {
            String prefix = "";
            if ("InternalCompany".equals(dimensionNum)) {
                prefix = DimTypesEnum.INTERCOMPANY.getName() + " : ";
            } else if ("MyCompany".equals(dimensionNum)) {
                prefix = DimTypesEnum.MYCOMPANY.getName() + " : ";
            }
            ArrayList<String> dataList = new ArrayList<String>(16);
            for (Long id2 : formulaIds) {
                dataList.add(prefix + (String)this.idNameMap.get(id2));
            }
            data.put("formulaName", ((Object)dataList).toString());
        }
        resultList.add(data);
        convertMap.put("convert", resultList);
        this.ctx.getPageCache().put("convertSetting", SerializationUtils.toJsonString(convertMap));
        return Optional.of(MemberDelete.SHOW_FORM);
    }
}

