/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.deletemember.validator;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.formplugin.dimension.deletemember.DelMembContext;
import kd.fi.bcm.formplugin.dimension.deletemember.MemberDelete;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.AbstractDeleteMemberValidator;

public class InvChangeValidator
extends AbstractDeleteMemberValidator {
    public InvChangeValidator(DelMembContext ctx) {
        super(ctx);
    }

    @Override
    Optional<String> validate() {
        if (this.validateHandle()) {
            this.ctx.getPageCache().put("delete_refer", "bcm_invchangeentry");
            return Optional.of(MemberDelete.SHOW_FORM);
        }
        return Optional.empty();
    }

    public boolean validateHandle() {
        long modelIdLong = this.ctx.getModelId();
        QFilter qModel = new QFilter("model", "=", (Object)modelIdLong);
        if (SysDimensionEnum.getEnumByNumber((String)this.ctx.getDimensionNum()) != null) {
            QFilter qFilter;
            if (DimTypesEnum.ENTITY.getNumber().equals(this.ctx.getDimensionNum())) {
                QFilter qFilter2 = new QFilter("investeecompany", "in", this.ctx.getAllMemberIds());
                boolean exists = QueryServiceHelper.exists((String)"bcm_invchangeentry", (QFilter[])new QFilter[]{qModel, qFilter2});
                if (exists) {
                    this.ctx.getPageCache().put("delete_refer", "bcm_invchangeentry");
                    return true;
                }
                String modelNumber = MemberReader.findModelNumberById((Object)modelIdLong);
                Set icIds = this.ctx.getAllMemberIds().stream().map(id -> MemberReader.findEntityMemberById((Long)modelIdLong, (Long)id)).filter(orgMember -> orgMember.getStorageType() == StorageTypeEnum.STORAGE).map(IDNumberTreeNode::getNumber).map(number -> MemberReader.findMemberByNumber((String)modelNumber, (String)"InternalCompany", (String)number)).map(IDNumberTreeNode::getId).collect(Collectors.toSet());
                if (!icIds.isEmpty()) {
                    QFilter shareQf = new QFilter("shareholder", "in", icIds);
                    qFilter2.or(shareQf);
                }
                if (QueryServiceHelper.exists((String)"bcm_invsharerela", (QFilter[])new QFilter[]{qModel, qFilter2})) {
                    this.ctx.getPageCache().put("delete_refer", "bcm_invsharerela");
                    return true;
                }
            } else if (DimTypesEnum.INTERCOMPANY.getNumber().equals(this.ctx.getDimensionNum()) && (QueryServiceHelper.exists((String)"bcm_invsharerela", (QFilter[])new QFilter[]{qModel, qFilter = new QFilter("shareholder", "in", this.ctx.getAllMemberIds())}) || QueryServiceHelper.exists((String)"bcm_invchangeentry", (QFilter[])new QFilter[]{qModel, qFilter}))) {
                this.ctx.getPageCache().put("delete_refer", "bcm_invsharerela");
                return true;
            }
        }
        return false;
    }
}

