/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.deletemember.validator;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.dimension.deletemember.DelMembContext;
import kd.fi.bcm.formplugin.dimension.deletemember.MemberDelete;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.AbstractDeleteMemberValidator;

public class InvQueryValidator
extends AbstractDeleteMemberValidator {
    public InvQueryValidator(DelMembContext ctx) {
        super(ctx);
    }

    @Override
    Optional<String> validate() {
        if ("bcm_entitymembertree".equals(this.ctx.getEntityId()) || "bcm_icmembertree".equals(this.ctx.getEntityId())) {
            QFilter inQf;
            long modelIdLong = this.ctx.getModelId();
            if ("bcm_entitymembertree".equals(this.ctx.getEntityId())) {
                inQf = new QFilter("investeecompany", "in", this.ctx.getAllMemberIds());
                String modelNumber = MemberReader.findModelNumberById((Object)modelIdLong);
                Set icIds = this.ctx.getAllMemberIds().stream().map(id -> MemberReader.findEntityMemberById((Long)modelIdLong, (Long)id)).filter(orgMember -> orgMember.getStorageType() == StorageTypeEnum.STORAGE).map(IDNumberTreeNode::getNumber).map(number -> MemberReader.findMemberByNumber((String)modelNumber, (String)"InternalCompany", (String)number)).map(IDNumberTreeNode::getId).collect(Collectors.toSet());
                if (!icIds.isEmpty()) {
                    QFilter shareQf = new QFilter("shareholder", "in", icIds);
                    inQf.or(shareQf);
                }
            } else {
                inQf = new QFilter("shareholder", "in", this.ctx.getAllMemberIds());
            }
            QFBuilder qfBuilder = new QFBuilder().add("model", "=", (Object)modelIdLong).and("isdelete", "=", (Object)Character.valueOf('0')).add(inQf);
            if (QueryServiceHelper.exists((String)"bcm_invrelation", (QFilter[])qfBuilder.toArray())) {
                this.ctx.getPageCache().put("delete_refer", "bcm_invrelation");
                return Optional.of(MemberDelete.SHOW_FORM);
            }
        }
        return Optional.empty();
    }

    @Override
    public int getWeight() {
        return 30;
    }
}

