/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.deletemember.validator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.formplugin.dimension.deletemember.DelMembContext;
import kd.fi.bcm.formplugin.dimension.deletemember.validator.AbstractDeleteMemberValidator;

public class RecordTmplSettingValidator
extends AbstractDeleteMemberValidator {
    public RecordTmplSettingValidator(DelMembContext delMembContext) {
        super(delMembContext);
    }

    @Override
    Optional<String> validate() {
        if (this.validateHandle()) {
            return Optional.of(ResManager.loadKDString((String)"\u6210\u5458\u6216\u8005\u4e0b\u7ea7\u6210\u5458\u88ab\u5bf9\u8d26\u6a21\u677f\u5f15\u7528\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"DimensionDisplayList_65", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    private boolean validateHandle() {
        String dimensionNum;
        QFilter qUserDimsion;
        QFilter qDimension;
        QFilter qModel;
        block15: {
            block13: {
                block14: {
                    qModel = new QFilter("model", "=", (Object)this.ctx.getModelId());
                    qDimension = null;
                    qUserDimsion = null;
                    ArrayList<String> list = new ArrayList<String>(16);
                    list.add("Account");
                    list.add("ChangeType");
                    list.add("AuditTrail");
                    list.add("DataSort");
                    list.add("MultiGAAP");
                    dimensionNum = this.ctx.getDimensionNum();
                    if (SysDimensionEnum.getEnumByNumber((String)dimensionNum) == null) break block13;
                    if (!list.contains(dimensionNum)) break block14;
                    qDimension = new QFilter("entryentity." + dimensionNum.toLowerCase(Locale.ENGLISH), "in", this.ctx.getAllMemberIds());
                    if (!"ChangeType".equals(dimensionNum)) break block15;
                    qDimension = qDimension.or(new QFilter("entryentity.elim_changetype", "in", this.ctx.getAllMemberIds()));
                    break block15;
                }
                return false;
            }
            List<String> userDefines = this.getUserDimNums();
            for (int i = 0; i < userDefines.size(); ++i) {
                if (!userDefines.get(i).equals(dimensionNum)) continue;
                QFilter uQfilter = new QFilter(String.format("entryentity.%s.memberid", "detailscope"), "in", this.ctx.getAllMemberIds());
                uQfilter = uQfilter.and(new QFilter(String.format("entryentity.%s.dimension", "detailscope"), "=", (Object)this.ctx.getDimensionId()));
                QFilter elimQfilter = new QFilter(String.format("entryentity.%s.elimmemberid", "elimdetailscope"), "in", this.ctx.getAllMemberIds());
                elimQfilter = elimQfilter.and(new QFilter(String.format("entryentity.%s.elimdimension", "elimdetailscope"), "=", (Object)this.ctx.getDimensionId()));
                qUserDimsion = uQfilter.or(elimQfilter);
                break;
            }
        }
        if (qDimension == null && qUserDimsion == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u677f\u7684\u5f15\u7528\u6821\u9a8c-\u672a\u5339\u914d\u4e0a\u8be5\u7ef4\u5ea6\u3002", (String)"DimensionDisplayList_154", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        ArrayList checkFromEntry = Lists.newArrayList((Object[])new String[]{"Account", "AuditTrail", "DataSort"});
        if (checkFromEntry.contains(dimensionNum)) {
            DataSet result;
            if ("DataSort".equals(dimensionNum)) {
                QFilter qFilter = new QFilter("model", "=", (Object)this.ctx.getModelId());
                qFilter.and(qDimension);
                return QueryServiceHelper.exists((String)"bcm_checktmpl", (QFilter[])new QFilter[]{qFilter});
            }
            if ("Account".equals(dimensionNum)) {
                String str = "select fentryid from t_bcm_checktmpl_detail where fmemberid in(%s)";
                String querySql = String.format(str, this.ctx.getAllMemberIds().toArray());
                result = DB.queryDataSet((String)"checktmpl_detail_account", (DBRoute)DBRoute.of((String)"bcm"), (String)querySql);
                if (result.hasNext()) {
                    return true;
                }
                String elimStr = "select fentryid from t_bcm_checktmpl_eldetail where fmemberid in(%s)";
                String elimQuerySql = String.format(elimStr, this.ctx.getAllMemberIds().toArray());
                DataSet elimResult = DB.queryDataSet((String)"checktmpl_detail_elim_account", (DBRoute)DBRoute.of((String)"bcm"), (String)elimQuerySql);
                if (elimResult.hasNext()) {
                    return true;
                }
            } else if ("AuditTrail".equals(dimensionNum)) {
                String params = StringUtils.join((Object[])this.ctx.getAllMemberIds().toArray(), (String)",");
                String str = "select fentryid from t_bcm_checktmpl_detail where fmemberid in(" + params + ")";
                result = DB.queryDataSet((String)"checktmpl_detail_audit", (DBRoute)DBRoute.of((String)"bcm"), (String)str);
                if (result.hasNext()) {
                    return true;
                }
                String elimStr = "select fentryid from t_bcm_checktmpl_eldetail where fmemberid in(" + params + ")";
                DataSet elimResult = DB.queryDataSet((String)"checktmpl_detail_elim_audit", (DBRoute)DBRoute.of((String)"bcm"), (String)elimStr);
                if (elimResult.hasNext()) {
                    return true;
                }
            }
        } else {
            DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_checktmpl", (String)"entryentity.id", (QFilter[])new QFilter[]{qModel, qDimension, qUserDimsion});
            if (dy != null) {
                return true;
            }
        }
        return false;
    }
}

