/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.factory;

import java.util.List;
import kd.bos.list.IListColumn;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.formplugin.dimension.action.AccountAction;
import kd.fi.bcm.formplugin.dimension.action.AuditTrialAction;
import kd.fi.bcm.formplugin.dimension.action.ChangeTypeAction;
import kd.fi.bcm.formplugin.dimension.action.CurrencyAction;
import kd.fi.bcm.formplugin.dimension.action.DataSortAction;
import kd.fi.bcm.formplugin.dimension.action.DataTypeAction;
import kd.fi.bcm.formplugin.dimension.action.DefinedDimensionAction;
import kd.fi.bcm.formplugin.dimension.action.DimemberBaseAction;
import kd.fi.bcm.formplugin.dimension.action.EntityAction;
import kd.fi.bcm.formplugin.dimension.action.ExtendsAction;
import kd.fi.bcm.formplugin.dimension.action.FYAction;
import kd.fi.bcm.formplugin.dimension.action.InterCompanyAction;
import kd.fi.bcm.formplugin.dimension.action.MyCompanyAction;
import kd.fi.bcm.formplugin.dimension.action.PeriodAction;
import kd.fi.bcm.formplugin.dimension.action.ProcessAction;
import kd.fi.bcm.formplugin.dimension.action.SecenceAction;
import kd.fi.bcm.formplugin.dimension.vo.AccountColumns;
import kd.fi.bcm.formplugin.dimension.vo.BaseColumns;
import kd.fi.bcm.formplugin.dimension.vo.EntityColumns;
import kd.fi.bcm.formplugin.dimension.vo.FYColumns;
import kd.fi.bcm.formplugin.dimension.vo.OtherColumns;
import kd.fi.bcm.formplugin.dimension.vo.PeriodColumns;
import kd.fi.bcm.formplugin.dimension.vo.SceneColumns;

public class DimensionFactory {
    public static List<IListColumn> getDimesionColumn(String dimensionName) {
        if (dimensionName == null) {
            return new BaseColumns();
        }
        if ("Account".equals(dimensionName)) {
            return new AccountColumns();
        }
        if ("Entity".equals(dimensionName)) {
            return new EntityColumns();
        }
        if ("Year".equals(dimensionName)) {
            return new FYColumns();
        }
        if ("Period".equals(dimensionName)) {
            return new PeriodColumns();
        }
        if ("Scenario".equals(dimensionName)) {
            return new SceneColumns();
        }
        return new OtherColumns();
    }

    public static DimemberBaseAction getDimesionMemberAction(String id, String dimensionNumber, String entityid, String actionId) {
        if (DimTypesEnum.ACCOUNT.getNumber().equals(dimensionNumber)) {
            return new AccountAction(id, dimensionNumber, entityid, actionId);
        }
        if (DimTypesEnum.CHANGETYPE.getNumber().equals(dimensionNumber)) {
            return new ChangeTypeAction(id, dimensionNumber, entityid, actionId);
        }
        if (DimTypesEnum.ENTITY.getNumber().equals(dimensionNumber)) {
            return new EntityAction(id, dimensionNumber, entityid, actionId);
        }
        if (DimTypesEnum.YEAR.getNumber().equals(dimensionNumber)) {
            return new FYAction(id, dimensionNumber, entityid, actionId);
        }
        if (DimTypesEnum.CURRENCY.getNumber().equals(dimensionNumber)) {
            return new CurrencyAction(id, dimensionNumber, entityid, actionId);
        }
        if (DimTypesEnum.AUDITTRIAL.getNumber().equals(dimensionNumber)) {
            return new AuditTrialAction(id, dimensionNumber, entityid, actionId);
        }
        if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dimensionNumber)) {
            return new InterCompanyAction(id, dimensionNumber, entityid, actionId);
        }
        if (DimTypesEnum.PROCESS.getNumber().equals(dimensionNumber)) {
            return new ProcessAction(id, dimensionNumber, entityid, actionId);
        }
        if (DimTypesEnum.PERIOD.getNumber().equals(dimensionNumber)) {
            return new PeriodAction(id, dimensionNumber, entityid, actionId);
        }
        if (DimTypesEnum.SCENARIO.getNumber().equals(dimensionNumber)) {
            return new SecenceAction(id, dimensionNumber, entityid, actionId);
        }
        if (DimTypesEnum.MULTIGAAP.getNumber().equals(dimensionNumber)) {
            return new DimemberBaseAction(id, dimensionNumber, entityid, actionId, "");
        }
        if (DimTypesEnum.DATASORT.getNumber().equals(dimensionNumber)) {
            return new DataSortAction(id, dimensionNumber, entityid, actionId);
        }
        if (DimTypesEnum.DATATYPE.getNumber().equals(dimensionNumber)) {
            return new DataTypeAction(id, dimensionNumber, entityid, actionId);
        }
        if (DimTypesEnum.MYCOMPANY.getNumber().equals(dimensionNumber)) {
            return new MyCompanyAction(id, dimensionNumber, entityid, actionId);
        }
        return new DefinedDimensionAction(id, dimensionNumber, entityid, actionId);
    }

    public static DimemberBaseAction getMemberCutAction(String id, String dimensionNumber, String entityName, String actionId, String modelid, long schemeId) {
        if ("bcm_entitymembertree".equals(entityName)) {
            return new EntityAction(id, dimensionNumber, entityName, actionId, modelid, schemeId);
        }
        if ("bcm_structofextend".equals(entityName)) {
            return new ExtendsAction(id, dimensionNumber, entityName, actionId, modelid, schemeId);
        }
        return new DimemberBaseAction(id, dimensionNumber, entityName, actionId, modelid);
    }

    public static DimemberBaseAction getMemberImpAction(String id, String dimensionNumber, String entityName, String actionId, String modelid) {
        if ("bcm_entitymembertree".equals(entityName)) {
            return new EntityAction(id, dimensionNumber, entityName, actionId, modelid);
        }
        return null;
    }
}

