/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.imp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.struct.ShareNodeStructSyncHelper;
import kd.fi.bcm.business.integration.util.IntergrationUtil;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.dimension.imp.DimensionImportBasePlugin;
import org.apache.commons.collections4.CollectionUtils;

public class AccountImportPlugin
extends DimensionImportBasePlugin
implements ClickListener,
TreeNodeQueryListener {
    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("orgunit");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit accounttype = (BasedataEdit)this.getControl("accounttype");
        accounttype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"source"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"orgunit"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"accounttype"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap14"});
        this.getModel().setValue("orgunit", (Object)this.getUserSelect("orgunit"));
        this.getModel().setValue("accounttype", (Object)this.getUserSelect("accounttype"));
        this.initLeftTree();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if ("orgunit".equals(propName)) {
            DynamicObject orgUnit = (DynamicObject)this.getModel().getValue("orgunit");
            if (orgUnit != null) {
                this.cacheUserSelect("orgunit", orgUnit.getString("id"));
            }
            this.initLeftTree();
        }
        if ("accounttype".equals(propName)) {
            DynamicObject accountType = (DynamicObject)this.getModel().getValue("accounttype");
            if (accountType != null) {
                this.cacheUserSelect("accounttype", accountType.getString("id"));
            }
            this.initLeftTree();
        }
    }

    @Override
    protected void collapseAll() {
        TreeNode leftRoot = this.getCacheLeftRoot();
        TreeView treeleft = (TreeView)this.getView().getControl("treeleft");
        if (leftRoot != null && leftRoot.getChildren() != null) {
            leftRoot.setIsOpened(true);
            this.collapseChild(leftRoot, treeleft);
        }
        treeleft.deleteAllNodes();
        treeleft.addNode(leftRoot);
    }

    @Override
    protected void initLeftTree() {
        TreeView treeleft = (TreeView)this.getView().getControl("treeleft");
        treeleft.deleteAllNodes();
        if (this.getModel().getValue("orgunit") == null || this.getModel().getValue("accounttype") == null) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("orgunit");
        DynamicObject accounttype = (DynamicObject)this.getModel().getValue("accounttype");
        QFilter orgFilter = new QFilter("org.id", "=", (Object)org.getLong("id"));
        QFilter bookFilter = new QFilter("bookstype.id", "=", (Object)accounttype.getLong("id"));
        DynamicObject book = QueryServiceHelper.queryOne((String)IntergrationUtil.getAccountBookMetadataNumber(), (String)"accounttable,periodType", (QFilter[])new QFilter[]{orgFilter, bookFilter});
        if (book == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u8d26\u7c3f\u3002", (String)"AccountImportPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getPageCache().remove("lefttree");
        } else {
            if (book.getLong("accounttable") == 0L) {
                this.getPageCache().remove("lefttree");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u79d1\u76ee\u8868\u83b7\u53d6\u5931\u8d25\u3002", (String)"AccountImportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeNode totalRoot = new TreeNode();
            totalRoot.setId("root");
            totalRoot.setText(ResManager.loadKDString((String)"\u79d1\u76ee\u6839\u8282\u70b9", (String)"AccountImportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            totalRoot.setData(new HashMap());
            Long atId = book.getLong("accounttable");
            String selectFields_A = "id, parent,number,name,dc,accounttype.name,accounttype.accounttype";
            QFilter attreefilter = new QFilter("accounttable", "=", (Object)atId);
            QFilter orgFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)org.getLong("id"));
            QFilter[] filters = new QFilter[]{attreefilter, orgFilter1};
            String orderBys_A = "number";
            DynamicObjectCollection accounts = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bd_accountview", (String)selectFields_A, (QFilter[])filters, (String)orderBys_A);
            if (accounts.size() > 0) {
                String parentid;
                HashSet<String> accountNums = new HashSet<String>(16);
                HashMap<String, Map<String, String>> dataInTable = new HashMap<String, Map<String, String>>(16);
                HashMap<String, String> searchChild = new HashMap<String, String>(16);
                for (DynamicObject account : accounts) {
                    if (accountNums.contains(account.getString("number"))) continue;
                    accountNums.add(account.getString("number"));
                    String id = account.getString("id");
                    parentid = account.getString("parent");
                    HashMap<String, String> data = new HashMap<String, String>(16);
                    data.put("id", id);
                    data.put("name", account.getString("name"));
                    data.put("number", account.getString("number"));
                    data.put("parentid", parentid);
                    data.put("dc", account.getString("dc"));
                    data.put("accounttype", AccountImportPlugin.getBaseAccountTypeName(account.getString("accounttype.accounttype")));
                    data.put("isNew", "1");
                    dataInTable.put(id, data);
                    if (!StringUtils.isNotEmpty((String)parentid)) continue;
                    String idstr = (String)searchChild.get(parentid);
                    if (idstr != null) {
                        searchChild.put(parentid, idstr + "," + id);
                        continue;
                    }
                    searchChild.put(parentid, id);
                }
                ArrayList<DynamicObject> roots = new ArrayList<DynamicObject>(10);
                for (DynamicObject account : accounts) {
                    parentid = account.getString("parent");
                    if (!"0".equals(parentid) && dataInTable.containsKey(parentid)) continue;
                    roots.add(account);
                }
                for (DynamicObject account : roots) {
                    String rootId = account.getString("id");
                    Map nodeData = (Map)dataInTable.get(rootId);
                    TreeNode accountLeft = new TreeNode();
                    accountLeft.setId(rootId);
                    if (nodeData == null) continue;
                    accountLeft.setText((String)nodeData.get("number") + " " + (String)nodeData.get("name"));
                    accountLeft.setParentid((String)nodeData.get("parentid"));
                    nodeData.put("isNew", "1");
                    accountLeft.setData((Object)nodeData);
                    this.expandleftNextLevel(dataInTable, searchChild, accountLeft);
                    accountLeft.setIsOpened(true);
                    accountLeft.setExpend(true);
                    totalRoot.addChild(accountLeft);
                    accountLeft.setParentid(totalRoot.getId());
                }
            }
            treeleft.addNode(totalRoot);
            treeleft.expand("root");
            this.cacheLeftRoot(totalRoot);
        }
    }

    private void expandleftNextLevel(Map<String, Map<String, String>> dataInTable, Map<String, String> searchChild, TreeNode accountLeft) {
        String children = searchChild.get(accountLeft.getId());
        if (StringUtils.isNotEmpty((String)children)) {
            String[] childIds;
            for (String childId : childIds = children.split(",")) {
                Map<String, String> nodeData = dataInTable.get(childId);
                TreeNode childLeft = new TreeNode();
                childLeft.setId(nodeData.get("id"));
                childLeft.setText(nodeData.get("number") + " " + nodeData.get("name"));
                childLeft.setParentid(nodeData.get("parentid"));
                nodeData.put("isNew", "1");
                childLeft.setData(nodeData);
                this.expandleftNextLevel(dataInTable, searchChild, childLeft);
                accountLeft.addChild(childLeft);
                childLeft.setParentid(accountLeft.getId());
            }
        }
    }

    @Override
    protected TreeNode getRightRoot() {
        TreeNode rootRight = new TreeNode();
        String membermodel = this.getPageCache().get("membermodel");
        String modelId = this.getPageCache().get("modelID");
        QFilter fnumber = new QFilter("number", "=", (Object)"Account");
        QFilter fmodel = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter[] filters = new QFilter[]{fnumber, fmodel};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)membermodel, (String)this.getRightSelector(), (QFilter[])filters, (String)"dseq");
        DynamicObject rightRootDy = (DynamicObject)dcs.iterator().next();
        String rightRootId = rightRootDy.getString("id");
        String name = rightRootDy.getString("name");
        String number = rightRootDy.getString("number");
        rootRight.setId(rightRootId);
        rootRight.setText(this.concatText(number, name));
        rootRight.setData((Object)rightRootDy);
        return rootRight;
    }

    @Override
    protected void setNodeText(DynamicObject task, TreeNode orgRight) {
        orgRight.setText(this.concatText(task.getString("number"), task.getString("name")));
    }

    private String concatText(String number, String name) {
        return new StringBuffer(number).append(" ").append(name).toString();
    }

    @Override
    protected void assembleOtherInfo(DynamicObject treeMem, Map<String, String> data) {
        treeMem.set("aggoprt", (Object)"1");
        treeMem.set("accountuse", (Object)"1");
        treeMem.set("datatype", (Object)"1");
        treeMem.set("isparticipmerge", (Object)"1");
        treeMem.set("isrelateorg", (Object)"0");
        treeMem.set("isyearendcarried", (Object)"0");
        if ("1".equals(data.get("dc"))) {
            treeMem.set("drcrdirect", (Object)"1");
        } else {
            treeMem.set("drcrdirect", (Object)"2");
        }
        String accountType = data.get("accounttype");
        AccountType[] ats = AccountType.values();
        treeMem.set("accounttype", (Object)"1");
        for (AccountType t : ats) {
            if (!t.getName().equals(accountType)) continue;
            treeMem.set("accounttype", (Object)t.index);
            break;
        }
        treeMem.set("exchange", (Object)"0");
        if (ResManager.loadKDString((String)"\u8d44\u4ea7", (String)"AccountImportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(accountType) || ResManager.loadKDString((String)"\u8d1f\u503a", (String)"AccountImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(accountType) || ResManager.loadKDString((String)"\u6743\u76ca", (String)"AccountImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(accountType)) {
            treeMem.set("exchange", (Object)"1");
        } else if (ResManager.loadKDString((String)"\u635f\u76ca", (String)"AccountImportPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(accountType) || ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf", (String)"AccountImportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(accountType)) {
            treeMem.set("exchange", (Object)"2");
        }
    }

    @Override
    protected String getModelType() {
        return "bcm_accountmember";
    }

    @Override
    protected String getTreeModelType() {
        return "bcm_accountmembertree";
    }

    @Override
    protected String getSlipMsg() {
        return ResManager.loadKDString((String)"\u5df2\u8df3\u8fc7\u5df2\u5b58\u5728\u79d1\u76ee\u3002", (String)"AccountImportPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    protected String getBackSlipMsg() {
        return ResManager.loadKDString((String)"\u5df2\u7ecf\u8df3\u8fc7\u5df2\u4fdd\u5b58\u7684\u79d1\u76ee\u548c\u5171\u4eab\u79d1\u76ee\u3002\u5982\u9700\u6e05\u9664\u5df2\u4fdd\u5b58\u7684\u79d1\u76ee\uff0c\u8bf7\u5728\u6210\u5458\u5217\u8868\u4e2d\u5220\u9664\uff1b\u5982\u9700\u6e05\u9664\u8fde\u5e26\u5171\u4eab\u79d1\u76ee\uff0c\u8bf7\u5728\u5171\u4eab\u7684\u539f\u8282\u70b9\u8fdb\u884c\u6e05\u9664\u3002", (String)"AccountImportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    protected void afterSave(DynamicObject basemem, DynamicObject treeMem, int newIndex, String parentNumber) throws KDBizException {
        try {
            OlapServiceHelper.createMember((String)this.getPageCache().get("modelNum"), (String)"Account", (String)treeMem.getString("number"), (int)treeMem.getInt("aggoprt"), (String)parentNumber);
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"OLAP\u4fa7\u5904\u7406\u5931\u8d25\uff1a%s\u3002", (String)"AccountImportPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    public static String getBaseAccountTypeName(String index) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("0", ResManager.loadKDString((String)"\u8d44\u4ea7", (String)"AccountImportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        mapping.put("1", ResManager.loadKDString((String)"\u8d1f\u503a", (String)"AccountImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        mapping.put("2", ResManager.loadKDString((String)"\u6743\u76ca", (String)"AccountImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        mapping.put("3", ResManager.loadKDString((String)"\u6210\u672c", (String)"AccountImportPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        mapping.put("4", ResManager.loadKDString((String)"\u635f\u76ca", (String)"AccountImportPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        mapping.put("5", ResManager.loadKDString((String)"\u8868\u5916", (String)"AccountImportPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        mapping.put("6", ResManager.loadKDString((String)"\u5171\u540c", (String)"AccountImportPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        mapping.put("7", ResManager.loadKDString((String)"\u5176\u4ed6", (String)"AccountImportPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        return (String)mapping.get(index);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        beforeF7SelectEvent.getSource();
    }

    @Override
    protected void afterOperator() throws KDBizException {
        super.afterOperator();
    }

    @Override
    protected void afterTxResyncShareNode() throws KDBizException {
        String dimensionId = (String)this.getView().getFormShowParameter().getCustomParam("dimensionId");
        String modelId = this.getPageCache().get("modelID");
        if (modelId != null) {
            ShareNodeStructSyncHelper.resyncShareNodeStructure((String)"bcm_accountmembertree", (long)LongUtil.toLong((Object)modelId), (long)LongUtil.toLong((Object)dimensionId));
        }
    }

    private void cacheUserSelect(String key, String value) {
        String cacheKey = this.cacheKey(key);
        AppCacheServiceHelper.put((String)cacheKey, (Object)value);
    }

    private String getUserSelect(String key) {
        String cacheKey = this.cacheKey(key);
        Object value = AppCacheServiceHelper.get((String)cacheKey);
        return value == null ? null : value.toString();
    }

    private String cacheKey(String key) {
        return this.getModelId() + "_" + RequestContext.get().getCurrUserId() + "_" + key;
    }

    @Override
    protected String getNodePropertyOfSto(TreeNode rightNode) {
        return ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM006") && CollectionUtils.isNotEmpty((Collection)rightNode.getChildren()) ? StorageTypeEnum.DYNAMIC.getOIndex() : super.getNodePropertyOfSto(rightNode);
    }

    public static enum AccountType {
        ZC(new MultiLangEnumBridge("\u8d44\u4ea7", "AccountImportPlugin_3", "fi-bcm-formplugin"), "1"),
        FZ(new MultiLangEnumBridge("\u8d1f\u503a", "AccountImportPlugin_4", "fi-bcm-formplugin"), "2"),
        QY(new MultiLangEnumBridge("\u6743\u76ca", "AccountImportPlugin_5", "fi-bcm-formplugin"), "3"),
        XJLL(new MultiLangEnumBridge("\u73b0\u91d1\u6d41\u91cf", "AccountImportPlugin_7", "fi-bcm-formplugin"), "7"),
        HLL(new MultiLangEnumBridge("\u6c47\u7387\u7c7b", "AccountImportPlugin_11", "fi-bcm-formplugin"), "8"),
        FCWL(new MultiLangEnumBridge("\u975e\u8d22\u52a1\u7c7b", "AccountImportPlugin_12", "fi-bcm-formplugin"), "9"),
        SY(new MultiLangEnumBridge("\u635f\u76ca", "AccountImportPlugin_6", "fi-bcm-formplugin"), "10"),
        QT(new MultiLangEnumBridge("\u5176\u4ed6", "AccountImportPlugin_13", "fi-bcm-formplugin"), "11");

        private MultiLangEnumBridge bridge = null;
        private String index;

        private AccountType(MultiLangEnumBridge bridge, String index) {
            this.bridge = bridge;
            this.index = index;
        }

        public String toString() {
            return this.bridge.loadKDString();
        }

        public String getIndex() {
            return this.index;
        }

        public static String getName(String code) {
            if (code == null) {
                return null;
            }
            for (AccountType se : AccountType.values()) {
                if (!code.equals(se.index)) continue;
                return se.getName();
            }
            return null;
        }

        public static String getIndexByName(String name) {
            for (AccountType type : AccountType.values()) {
                if (!type.getName().equals(name)) continue;
                return type.getIndex();
            }
            return ZC.getIndex();
        }

        public String getName() {
            return this.bridge.loadKDString();
        }
    }
}

