/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.imp;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.fi.bcm.business.dimension.datalock.DataLockHelper;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionLockHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.SaveDimMemberHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.log.DimMemberOperateTypeEnum;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.BlackListUtils;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.dimension.action.DimemberBaseAction;
import kd.fi.bcm.formplugin.dimension.factory.DimensionFactory;
import kd.fi.bcm.formplugin.dimension.imp.DimensionImportHelper;
import kd.fi.bcm.formplugin.dimension.vo.BaseDataSource;
import kd.fi.bcm.formplugin.util.SearchUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DimensionImportBasePlugin
extends AbstractBaseListPlugin
implements ClickListener,
TreeNodeQueryListener,
TreeNodeClickListener {
    protected static final String leftTree = "lefttree";
    protected static final String rightTree = "righttree";
    protected static final String rightTreeNodeIds = "rightTreeNodeIds";
    protected static final String rightCurrentNode = "rightCurrentNode";
    protected static final String treeLeft = "treeleft";
    protected static final String treeRight = "treeright";
    protected static final String LList = "llist";
    protected static final String LFocus = "lfocus";
    protected static final int MAXLEVEL = 20;
    protected static final String color = "#0530b6";
    protected static final String BILL_LIST_STAP = "billlistap";
    protected static final String LEFT_CLICK_NODE_ID = "leftClickNodeId";
    protected static final String PRE_SOURCE = "presource";
    protected static final Set<String> OLAP_NOT_ALLOW_NUMBER = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"all", "other", "none", "null"}));
    protected static final int SIZE_BATCH = 1000;
    public List<TreeNode> needUpdates = new TreeNodeList<TreeNode>();

    @Override
    public void initialize() {
        super.initialize();
        TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
        TreeView treeright = (TreeView)this.getView().getControl(treeRight);
        treeleft.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        treeright.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        treeright.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("baritemconfirm", "baritemcancel");
        this.addClickListeners("searchbefore", "searchnext", "searchbefore1", "searchnext1");
        this.addItemClickListeners("toolbarap");
        this.addClickListeners("btngo", "btnallgo", "btnback", "btnallback");
        this.addClickListeners("allchoose", "allclear", "allexpand", "allshrink");
        final IFormView view = this.getView();
        final IPageCache pageCache = this.getPageCache();
        final TreeView leftTreeView = (TreeView)this.getControl(treeLeft);
        final TreeView rightTreeView = (TreeView)this.getControl(treeRight);
        Search sl = (Search)this.getControl("searchapleft");
        sl.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (event.getText() != null && !"".equals(event.getText())) {
                    SearchUtil.searchMember(event.getText().toLowerCase(Locale.ENGLISH).trim(), view, pageCache, leftTreeView, DimensionImportBasePlugin.leftTree, DimensionImportBasePlugin.LList, DimensionImportBasePlugin.LFocus);
                } else {
                    pageCache.put(DimensionImportBasePlugin.LList, null);
                    DimensionImportBasePlugin.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
        Search sr = (Search)this.getControl("searchapright");
        sr.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (event.getText() != null && !"".equals(event.getText())) {
                    SearchUtil.searchMember(event.getText().toLowerCase(Locale.ENGLISH).trim(), view, pageCache, rightTreeView, DimensionImportBasePlugin.rightTree);
                } else {
                    pageCache.put("resultlist", null);
                    view.showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"defaultcurrency"});
        String membermodel = (String)this.getView().getFormShowParameter().getCustomParam("membermodel");
        this.getPageCache().put("membermodel", membermodel);
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        this.getPageCache().put("modelID", modelId);
        String dimensionID = (String)this.getView().getFormShowParameter().getCustomParam("dimensionId");
        this.getPageCache().put("dimensionID", dimensionID);
        this.initLeftTree();
        this.initRightTree();
        QFilter filterNumber = new QFilter("id", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter[] filters = new QFilter[]{filterNumber};
        DynamicObject modelObj = QueryServiceHelper.queryOne((String)"bcm_model", (String)"number", (QFilter[])filters);
        String modelNum = modelObj.getString("number");
        this.getPageCache().put("modelNum", modelNum);
    }

    protected void initLeftTree() {
        TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
        treeleft.deleteAllNodes();
        TreeNode rootleft = this.getLeftRoot();
        if (rootleft == null) {
            return;
        }
        this.expandleftNextLevel(rootleft, true);
        treeleft.updateNode(rootleft);
        this.cacheLeftRoot(rootleft);
        treeleft.addNode(rootleft);
        treeleft.expand(rootleft.getId());
    }

    protected void initRightTree() {
        TreeView treeright = (TreeView)this.getView().getControl(treeRight);
        TreeNode rootRight = this.getRightRoot();
        HashMap<String, String> rightNodeIds = new HashMap<String, String>();
        this.expandRightNextLevel(rootRight, true, rightNodeIds);
        if (this.isCM() && StringUtils.equals((CharSequence)((DynamicObject)rootRight.getData()).getString("number"), (CharSequence)"Entity")) {
            treeright.setRootVisible(false);
            QFilter fmodel = new QFilter("model", "=", (Object)this.getModelId());
            QFilter fefilter = new QFilter("isexchangerate", "=", (Object)"0");
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number", (QFilter[])new QFilter[]{fmodel, fefilter});
            for (DynamicObject dot : collection) {
                rightNodeIds.put(dot.getString("id"), "0");
                rightNodeIds.put(dot.getString("number"), "0");
            }
        }
        if (StringUtils.equals((CharSequence)((DynamicObject)rootRight.getData()).getString("number"), (CharSequence)"Entity")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"defaultcurrency"});
        }
        this.cacheRightRoot(rootRight);
        this.cacheRightIds(rightNodeIds);
        treeright.addNode(rootRight);
        treeright.focusNode(rootRight);
        rootRight.setIsOpened(true);
        treeright.treeNodeClick(null, rootRight.getId());
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    @Override
    public void click(EventObject evt) {
        TreeView treeleft;
        TreeNode leftRoot;
        String message;
        DimemberBaseAction action;
        String rightFocusId;
        TreeView treeright;
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btngo".equals(key)) {
            ArrayList illegalSelectIds;
            treeright = (TreeView)this.getView().getControl(treeRight);
            rightFocusId = this.getPageCache().get(rightCurrentNode);
            if (StringUtils.isEmpty((CharSequence)rightFocusId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f3\u6811\u8282\u70b9\u3002", (String)"DimensionImportBasePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            action = DimensionFactory.getMemberImpAction(rightFocusId, "", this.getPageCache().get("membermodel"), "", String.valueOf(this.getModelId()));
            if (action != null && !kd.bos.util.StringUtils.isEmpty((String)(message = action.checkImpOperation(rightFocusId)))) {
                this.getView().showTipNotification(message);
                return;
            }
            TreeNode rightRoot = this.getCacheRightRoot();
            TreeNode rightFocusNode = rightRoot.getTreeNode(rightFocusId, 20);
            String memberModel = this.getPageCache().get("membermodel");
            boolean canCreate = this.checkCanCreateLeaf(rightFocusId, memberModel);
            if (!canCreate) {
                return;
            }
            TreeView treeleft2 = (TreeView)this.getView().getControl(treeLeft);
            List<String> selectIds = this.getCanMoveNumbers(treeleft2, illegalSelectIds = Lists.newArrayList());
            if (selectIds.size() > 0) {
                selectIds.remove("root");
            }
            if (selectIds.size() == 0 && illegalSelectIds.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u6811\u8282\u70b9\u3002", (String)"DimensionImportBasePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<String> actSelectIds = new ArrayList<String>();
            TreeNode leftRoot2 = this.getCacheLeftRoot();
            Map<String, String> cache = this.getCacheRightIds();
            boolean hasSkip = false;
            for (String string : selectIds) {
                TreeNode treeNode = leftRoot2.getTreeNode(string, 20);
                if (treeNode == null) continue;
                if (!selectIds.contains(treeNode.getParentid())) {
                    actSelectIds.add(string);
                }
                if (!this.isNodeExists(cache, treeNode, rightFocusNode)) continue;
                illegalSelectIds.add(string);
                if (this.checkIsCtrlOrg(selectIds, treeNode)) {
                    return;
                }
                hasSkip = true;
            }
            ArrayList<TreeNode> actNodes = new ArrayList<TreeNode>(actSelectIds.size());
            for (String string : actSelectIds) {
                TreeNode selectNode = leftRoot2.getTreeNode(string, 20);
                actNodes.add(selectNode);
            }
            List<TreeNode> list = this.getRmvedNodes(actNodes, selectIds, illegalSelectIds);
            String string = this.checkCMLeftMove2RightRoot(memberModel, list, rightFocusNode);
            if (kd.bos.util.StringUtils.isNotEmpty((String)string)) {
                this.getView().showTipNotification(string);
                return;
            }
            if (hasSkip || illegalSelectIds.size() != 0) {
                StringBuilder stringBuffer = new StringBuilder();
                stringBuffer.append(ResManager.loadKDString((String)"1\u3001\u53f3\u4fa7\u7f16\u7801\u5df2\u5b58\u5728\uff08\u6216\u56e0\u6743\u9650\u95ee\u9898\u65e0\u6cd5\u67e5\u770b\uff09\uff1b", (String)"DimensionImportBasePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\n");
                stringBuffer.append(ResManager.loadKDString((String)"2\u3001\u5de6\u4fa7\u7f16\u7801\u5b58\u5728\u975e\u6cd5\u5b57\u7b26\uff0c\u5982\u60ca\u53f9\u53f7\u7b49\uff1b", (String)"DimensionImportBasePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\n");
                stringBuffer.append(ResManager.loadKDString((String)"3\u3001\u5de6\u4fa7\u7f16\u7801\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u4e0b\u5212\u7ebf\u3001\u51cf\u53f7\u5f00\u5934\uff1b", (String)"DimensionImportBasePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\n");
                stringBuffer.append(ResManager.loadKDString((String)"4\u3001\u5de6\u4fa7\u7f16\u7801\u4e2d\u4e24\u4e2a\u5c0f\u6570\u70b9\u4e4b\u95f4\u4e0d\u5b58\u5728\u5176\u4ed6\u5b57\u7b26\u3002", (String)"DimensionImportBasePlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\n");
                stringBuffer.append(this.bathFindLeftTreeNodes(illegalSelectIds));
                this.getView().showMessage(ResManager.loadKDString((String)"\u4ee5\u4e0b\u60c5\u51b5\u7684\u5de6\u4fa7\u5185\u5bb9\u5c06\u4e0d\u4f1a\u88ab\u9009\u62e9\u5230\u53f3\u4fa7\uff1a", (String)"DimensionImportBasePlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), stringBuffer.toString(), MessageTypes.Default);
                return;
            }
            if (this.isBackList(selectIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u660e\u7ec6\u7ec4\u7ec7\u4ec5\u6cd5\u4eba\u7ec4\u7ec7\u53ef\u4ee5\u5f15\u5165\uff0c\u5408\u5e76\u5c42\u7ea7\u4e0d\u63a7\u5236\u662f\u5426\u6cd5\u4eba\u3002", (String)"DimensionImportBasePlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.wholeOne(treeright, rightRoot, rightFocusNode, cache, actNodes, false);
            treeright.updateNodes(this.needUpdates);
            treeright.expand(rightFocusNode.getId());
            this.cacheRightRoot(rightRoot);
            this.cacheRightIds(cache);
            treeright.focusNode(rightFocusNode);
            treeleft2.uncheckNodes(actSelectIds);
            treeleft2.uncheckNodes((List)illegalSelectIds);
            this.setLeftTreeNoteColor(key, "blue", actNodes, false);
        } else if ("btnback".equals(key)) {
            treeright = (TreeView)this.getView().getControl(treeRight);
            rightFocusId = this.getPageCache().get(rightCurrentNode);
            if (StringUtils.isEmpty((CharSequence)rightFocusId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f3\u6811\u8282\u70b9\u3002", (String)"DimensionImportBasePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeNode rightRoot = this.getCacheRightRoot();
            if (rightFocusId.equals(rightRoot.getId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u79fb\u9664\u6839\u8282\u70b9\u3002", (String)"DimensionImportBasePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeNode rightFocusNode = rightRoot.getTreeNode(rightFocusId, 20);
            if (this.isShareNode(rightFocusNode)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u76f4\u63a5\u79fb\u9664\u5171\u4eab\u8282\u70b9\u3002", (String)"DimensionImportBasePlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean hasSkip = false;
            Map<String, String> cache = this.getCacheRightIds();
            if (this.isNewNode(rightFocusNode)) {
                TreeNode parentNode = rightRoot.deleteChildNode(rightFocusId);
                this.removeRightCache(cache, rightFocusNode);
                treeright.deleteNode(rightFocusId);
                if (parentNode.getChildren() == null || parentNode.getChildren().size() == 0) {
                    parentNode.setChildren(null);
                }
                this.removeShareNodes(rightRoot, rightFocusNode, cache);
                treeright.focusNode(parentNode);
                treeright.treeNodeClick(null, parentNode.getId());
                treeright.updateNode(parentNode);
                treeright.expand(parentNode.getId());
            } else {
                this.nodeBack(rightRoot, rightFocusNode, cache, false);
                rightFocusNode.setExpend(true);
                treeright.updateNode(rightFocusNode);
                treeright.expand(rightFocusId);
                treeright.focusNode(rightFocusNode);
                hasSkip = true;
            }
            this.cacheRightRoot(rightRoot);
            this.cacheRightIds(cache);
            ArrayList<TreeNode> selNoteLs = new ArrayList<TreeNode>();
            selNoteLs.add(rightFocusNode);
            this.setLeftTreeNoteColor(key, "", selNoteLs, false);
            if (hasSkip) {
                this.getView().showTipNotification(this.getBackSlipMsg());
                return;
            }
        } else if ("btnallgo".equals(key)) {
            boolean canCreate;
            String rightFocusId2 = this.getPageCache().get(rightCurrentNode);
            String memberModel = this.getPageCache().get("membermodel");
            if (memberModel.equals("bcm_entitymembertree") && !(canCreate = this.checkCanCreateLeaf(rightFocusId2, memberModel))) {
                return;
            }
            action = DimensionFactory.getMemberImpAction(rightFocusId2, "", this.getPageCache().get("membermodel"), "", (String)this.getView().getFormShowParameter().getCustomParam("modelID"));
            if (action != null && !kd.bos.util.StringUtils.isEmpty((String)(message = action.checkImpOperation(rightFocusId2)))) {
                this.getView().showTipNotification(message);
                return;
            }
            this.allgo();
            if (!BlackListUtils.hasFeatureInCm((String)"CMOther")) {
                this.setLeftTreeNoteColor(key, "blue", null, true);
            }
        } else if ("btnallback".equals(key)) {
            this.allback();
            this.setLeftTreeNoteColor(key, "", null, true);
        }
        if ("allchoose".equals(key)) {
            leftRoot = this.getCacheLeftRoot();
            if (leftRoot == null) {
                return;
            }
            treeleft = (TreeView)this.getView().getControl(treeLeft);
            treeleft.checkNodes(this.getChildren(leftRoot, new ArrayList<TreeNode>()));
        } else if ("allclear".equals(key)) {
            leftRoot = this.getCacheLeftRoot();
            if (leftRoot == null) {
                return;
            }
            treeleft = (TreeView)this.getView().getControl(treeLeft);
            this.allClear(leftRoot, treeleft);
        } else if ("allexpand".equals(key)) {
            this.spreadAll();
        } else if ("allshrink".equals(key)) {
            this.collapseAll();
        }
        if ("baritemconfirm".equals(key)) {
            this.batchSaveCommonDim();
        } else if ("baritemcancel".equals(key)) {
            this.getView().close();
        }
        if ("searchbefore1".equals(key) || "searchnext1".equals(key)) {
            String rowcache = this.getPageCache().get(LList);
            if (rowcache == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u9700\u8981\u641c\u7d22\u7684\u5185\u5bb9\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"DimensionImportBasePlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            List rowList = (List)SerializationUtils.deSerializeFromBase64((String)rowcache);
            int rowCount = Integer.parseInt(this.getPageCache().get(LFocus));
            if ("searchbefore1".equals(key)) {
                if (0 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"DimensionImportBasePlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                --rowCount;
            } else {
                if (rowList.size() - 1 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"DimensionImportBasePlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                ++rowCount;
            }
            this.getPageCache().put(LFocus, String.valueOf(rowCount));
            TreeNode focusNode = (TreeNode)rowList.get(rowCount);
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject(leftTree), TreeNode.class);
            TreeView tree = (TreeView)this.getControl(treeLeft);
            tree.focusNode(focusNode);
            SearchUtil.expand(focusNode.getParentid(), tree, root);
        }
        if ("searchbefore".equals(key) || "searchnext".equals(key)) {
            String[] btns = new String[]{"searchbefore", "searchnext"};
            SearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), key, (TreeView)this.getControl(treeRight), btns, rightTree);
        }
    }

    protected DynamicObject getDefaultCurrencyByF7() {
        return null;
    }

    private List<TreeNode> getRmvedNodes(List<TreeNode> actNodes, List<String> selectIds, List<String> illegalSelectIds) {
        ArrayList<TreeNode> result = new ArrayList<TreeNode>(actNodes.size());
        for (TreeNode node : actNodes) {
            String id = node.getId();
            if (illegalSelectIds.contains(id) || !selectIds.contains(id)) {
                if (node.getChildren() == null || node.getChildren().size() <= 0) continue;
                result.addAll(this.getRmvedNodes(node.getChildren(), selectIds, illegalSelectIds));
                continue;
            }
            if (!selectIds.contains(id)) continue;
            result.add(node);
        }
        return result;
    }

    protected String bathFindLeftTreeNodes(List<String> illegalSelectIds) {
        TreeNode leftRoot = this.getCacheLeftRoot();
        if (leftRoot != null) {
            StringBuilder stringBuffer = new StringBuilder(ResManager.loadKDString((String)"\u4e0d\u5408\u683c\u7684\u8282\u70b9\u6709\uff1a ", (String)"DimensionImportBasePlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            illegalSelectIds.stream().forEach(p -> {
                TreeNode treeNode = leftRoot.getTreeNode(p, 20);
                if (treeNode != null) {
                    stringBuffer.append(treeNode.getText()).append(" | ");
                }
            });
            return stringBuffer.toString();
        }
        return "";
    }

    protected boolean checkIsCtrlOrg(List<String> selectIds, TreeNode selectNode) {
        Object number;
        QFilter filter2;
        QFilter filter1;
        if (selectNode.getChildren() != null && !selectNode.getChildren().isEmpty() && this.isChildrenInSelectedNodes(selectIds, selectNode.getChildren()) && QueryServiceHelper.exists((String)"bcm_entitymembertree", (QFilter[])new QFilter[]{filter1 = new QFilter("model", "=", (Object)LongUtil.toLong((Object)this.getPageCache().get("modelID"))), filter2 = new QFilter("ctrlorg.number", "=", number = ((Map)selectNode.getData()).get("number"))})) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u88ab\u5176\u4ed6\u7ec4\u7ec7\u6210\u5458\u8bbe\u7f6e\u4e3a\u63a7\u80a1\u7ec4\u7ec7\uff0c\u4e0d\u53ef\u65b0\u589e\u8be5\u7ec4\u7ec7\u6210\u5458\u7684\u4e0b\u7ea7\u3002", (String)"DimensionImportBasePlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), selectNode.getText()));
            return true;
        }
        return false;
    }

    private boolean isChildrenInSelectedNodes(List<String> selectIds, List<TreeNode> children) {
        for (TreeNode child : children) {
            if (!selectIds.contains(child.getId())) continue;
            return true;
        }
        return false;
    }

    public void wholeOne(TreeView treeright, TreeNode rightRoot, TreeNode rightFocusNode, Map<String, String> cache, List<TreeNode> actNodes, boolean isAllgo) {
        List<TreeNode> shareNodes = this.getShareNodes(rightFocusNode, rightRoot, false);
        this.needUpdates.add(rightFocusNode);
        for (TreeNode actNode : actNodes) {
            List<TreeNode> backNodes = this.singleGo(rightFocusNode, actNode, cache, isAllgo, rightRoot);
            shareNodes.forEach(shareNode -> {
                this.singleGo4Share((TreeNode)shareNode, backNodes, cache, false, rightRoot);
                treeright.updateNode(shareNode);
                treeright.expand(shareNode.getId());
            });
        }
    }

    public void wholeOne2(TreeView treeright, TreeNode rightRoot, TreeNode rightFocusNode, Map<String, String> cache, List<TreeNode> actNodes, boolean isAllgo) {
        this.needUpdates.add(rightFocusNode);
        for (TreeNode actNode : actNodes) {
            TreeNode copy = this.cloneNode(actNode, rightFocusNode, isAllgo);
            rightFocusNode.addChild(copy);
            this.addRightCache(cache, copy);
        }
    }

    public void removeShareNodes(TreeNode rightRoot, TreeNode rightFocusNode, Map<String, String> cache) {
        TreeView treeright = (TreeView)this.getView().getControl(treeRight);
        List<TreeNode> shares = this.getShareNodes(rightFocusNode, rightRoot, false);
        if (shares.size() > 0) {
            shares.forEach(shareNode -> {
                treeright.deleteNode(shareNode.getId());
                TreeNode parentNode = rightRoot.deleteChildNode(shareNode.getId());
                if (parentNode.getChildren() != null && parentNode.getChildren().size() == 0) {
                    parentNode.setChildren(null);
                }
                treeright.updateNode(parentNode);
                this.removeRightCache(cache, (TreeNode)shareNode);
            });
        }
    }

    private List<TreeNode> singleGo(TreeNode rightFocusNode, TreeNode selectNode, Map<String, String> cache, boolean isAllgo, TreeNode rightRootNode) {
        TreeNode copy = this.cloneNode(selectNode, rightFocusNode, isAllgo);
        return this.totalMerge(rightFocusNode, cache, copy, rightRootNode);
    }

    private void singleGo4Share(TreeNode rightFocusNode, List<TreeNode> backNodes, Map<String, String> cache, boolean isAllgo, TreeNode rightRootNode) {
        if (backNodes != null) {
            backNodes.forEach(selectNode -> {
                TreeNode copy = this.cloneNode((TreeNode)selectNode, rightFocusNode, true);
                this.formalAddChild(rightFocusNode, copy);
                copy.setParentid(rightFocusNode.getId());
            });
        }
    }

    private void rootGo(TreeNode rightFocusNode, TreeNode leftRoot, Map<String, String> cache, TreeNode rightRootNode) {
        if (!ResManager.loadKDString((String)"\u79d1\u76ee\u6839\u8282\u70b9", (String)"DimensionImportBasePlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(leftRoot.getText())) {
            ArrayList<TreeNode> actNodes = new ArrayList<TreeNode>();
            actNodes.add(leftRoot);
            TreeView treeright = (TreeView)this.getView().getControl(treeRight);
            this.wholeOne(treeright, rightRootNode, rightFocusNode, cache, actNodes, true);
            treeright.updateNodes(this.needUpdates);
            treeright.expand(rightFocusNode.getId());
        } else {
            List children = leftRoot.getChildren();
            if (children != null) {
                leftRoot.getChildren().forEach(selectNode -> this.singleGo(rightFocusNode, (TreeNode)selectNode, cache, true, rightRootNode));
            }
        }
    }

    protected List<TreeNode> totalMerge(TreeNode rightFocusNode, Map<String, String> cache, TreeNode copy, TreeNode rightRootNode) {
        if (!this.isNodeExists(cache, copy, rightFocusNode)) {
            this.slipTreeNode(cache, copy, rightFocusNode);
            this.formalAddChild(rightFocusNode, copy);
            copy.setParentid(rightFocusNode.getId());
            this.addRightCache(cache, copy);
            ArrayList<TreeNode> copys = new ArrayList<TreeNode>();
            copys.add(copy);
            return copys;
        }
        TreeNode matchNode = this.isMatch(rightFocusNode, copy);
        if (matchNode != null) {
            if (copy.getChildren() != null) {
                TreeView treeright = (TreeView)this.getView().getControl(treeRight);
                this.wholeOne(treeright, rightRootNode, matchNode, cache, copy.getChildren(), true);
            }
            return null;
        }
        this.slipTreeNode(cache, copy, rightFocusNode);
        if (copy.getChildren() != null) {
            rightFocusNode.addChildren(copy.getChildren());
            copy.getChildren().forEach(node -> node.setParentid(rightFocusNode.getId()));
            copy.getChildren().forEach(node -> this.addRightCache(cache, (TreeNode)node));
            return copy.getChildren();
        }
        return null;
    }

    private void formalAddChild(TreeNode rightFocusNode, TreeNode copy) {
        rightFocusNode.addChild(copy);
    }

    protected boolean isNodeExists(Map<String, String> cache, TreeNode copy, TreeNode rightFocusNode) {
        String number = (String)this.getNodeProperty("number", copy);
        return cache.containsKey(number);
    }

    private void addRightCache(final Map<String, String> cache, TreeNode copy) {
        String number = (String)this.getNodeProperty("number", copy);
        cache.put(number, "0");
        if (copy.getChildren() != null) {
            copy.getChildren().forEach(new Consumer<TreeNode>(){

                @Override
                public void accept(TreeNode t) {
                    DimensionImportBasePlugin.this.addRightCache(cache, t);
                }
            });
        }
    }

    public void removeRightCache(final Map<String, String> cache, TreeNode copy) {
        String number = (String)this.getNodeProperty("number", copy);
        cache.remove(number);
        if (copy.getChildren() != null) {
            copy.getChildren().forEach(new Consumer<TreeNode>(){

                @Override
                public void accept(TreeNode t) {
                    DimensionImportBasePlugin.this.removeRightCache(cache, t);
                }
            });
        }
    }

    protected TreeNode isMatch(TreeNode rightFocusNode, TreeNode copy) {
        if (rightFocusNode.getChildren() != null) {
            for (TreeNode focusChild : rightFocusNode.getChildren()) {
                if (!focusChild.getId().equals(copy.getId()) && !focusChild.getText().equals(copy.getText())) continue;
                return focusChild;
            }
        }
        return null;
    }

    protected void slipTreeNode(Map<String, String> cache, TreeNode copy, TreeNode rightFocusNode) {
        if (copy.getChildren() != null) {
            for (int i = 0; copy.getChildren() != null && i < copy.getChildren().size(); ++i) {
                TreeNode t = (TreeNode)copy.getChildren().get(i);
                if (this.isNodeExists(cache, t, rightFocusNode)) {
                    copy.deleteChildNode(t.getId());
                    --i;
                    if (copy.getChildren() != null && copy.getChildren().size() == 0) {
                        copy.setChildren(null);
                    }
                    if (t.getChildren() == null) continue;
                    copy.addChildren(t.getChildren());
                    t.getChildren().forEach(node -> node.setParentid(copy.getId()));
                    continue;
                }
                this.slipTreeNode(cache, t, rightFocusNode);
            }
        }
    }

    public void allClear(TreeNode leftRoot, TreeView treeleft) {
        HashSet<TreeNode> nodes = new HashSet<TreeNode>();
        this.doAllClear(leftRoot, treeleft, nodes);
        treeleft.uncheckNodes(nodes.stream().map(node -> node.getId()).collect(Collectors.toList()));
    }

    private void doAllClear(TreeNode leftRoot, final TreeView treeleft, final HashSet<TreeNode> nodes) {
        if (leftRoot.getChildren() != null) {
            nodes.addAll(leftRoot.getChildren());
            leftRoot.getChildren().forEach(new Consumer<TreeNode>(){

                @Override
                public void accept(TreeNode t) {
                    DimensionImportBasePlugin.this.doAllClear(t, treeleft, nodes);
                }
            });
        }
    }

    protected void allgo() {
        this.getPageCache().put("allgo", "1");
        TreeView treeright = (TreeView)this.getView().getControl(treeRight);
        String rightFocusId = this.getPageCache().get(rightCurrentNode);
        if (StringUtils.isEmpty((CharSequence)rightFocusId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f3\u6811\u8282\u70b9\u3002", (String)"DimensionImportBasePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode rightRoot = this.getCacheRightRoot();
        TreeNode rightFocusNode = rightRoot.getTreeNode(rightFocusId, 20);
        if (this.isShareNode(rightFocusNode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u521b\u5efa\u5171\u4eab\u6210\u5458\u7684\u4e0b\u7ea7\u6210\u5458\u3002", (String)"DimensionImportBasePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        final TreeNode leftRoot = this.getCacheLeftRoot();
        if (leftRoot == null) {
            return;
        }
        Map<String, String> cache = this.getCacheRightIds();
        String message = this.checkCMLeftMove2RightRoot(this.getPageCache().get("membermodel"), (List<TreeNode>)new ArrayList<TreeNode>(){
            {
                this.add(leftRoot);
            }
        }, rightFocusNode);
        if (kd.bos.util.StringUtils.isNotEmpty((String)message)) {
            this.getView().showTipNotification(message);
            return;
        }
        ArrayList<String> ids = new ArrayList<String>(16);
        if (this.isBackList(this.getIds(leftRoot, ids))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u660e\u7ec6\u7ec4\u7ec7\u4ec5\u6cd5\u4eba\u7ec4\u7ec7\u53ef\u4ee5\u5f15\u5165\uff0c\u5408\u5e76\u5c42\u7ea7\u4e0d\u63a7\u5236\u662f\u5426\u6cd5\u4eba\u3002", (String)"DimensionImportBasePlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean hasSkip = this.hasSkip(leftRoot, cache, rightFocusNode);
        List<TreeNode> shareNodes = this.getShareNodes(rightFocusNode, rightRoot, true);
        shareNodes.forEach(shareNode -> {
            this.rootGo((TreeNode)shareNode, leftRoot, cache, rightRoot);
            treeright.updateNode(shareNode);
            treeright.expand(shareNode.getId());
        });
        rightFocusNode.setExpend(true);
        this.cacheRightRoot(rightRoot);
        this.cacheRightIds(cache);
        cache.clear();
        treeright.focusNode(rightFocusNode);
        if (hasSkip) {
            this.getView().showTipNotification(this.getSlipMsg());
            return;
        }
    }

    protected void allback() {
        TreeView treeright = (TreeView)this.getView().getControl(treeRight);
        TreeNode rightRoot = this.getCacheRightRoot();
        Map<String, String> cache = this.getCacheRightIds();
        this.nodeAllBack(rightRoot, cache);
        rightRoot.setExpend(true);
        treeright.updateNode(rightRoot);
        treeright.expand(rightRoot.getId());
        this.cacheRightRoot(rightRoot);
        this.cacheRightIds(cache);
        treeright.focusNode(rightRoot);
        treeright.treeNodeClick(null, rightRoot.getId());
    }

    public void nodeBack(TreeNode rightRoot, TreeNode rightFocusNode, Map<String, String> cache, boolean force) {
        List children = rightFocusNode.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        ArrayList needRemove = new ArrayList(children.size() / 2);
        children.forEach(child -> {
            if (this.isNewNode((TreeNode)child) && (force || !this.isShareNode((TreeNode)child))) {
                needRemove.add(child);
                this.removeRightCache(cache, (TreeNode)child);
            } else {
                this.nodeBack(rightRoot, (TreeNode)child, cache, force);
            }
        });
        children.removeAll(needRemove);
        if (rightFocusNode.getChildren() != null && rightFocusNode.getChildren().size() == 0) {
            rightFocusNode.setChildren(null);
        }
    }

    private void nodeAllBack(TreeNode rightFocusNode, Map<String, String> cache) {
        List children = rightFocusNode.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        ArrayList needRemove = new ArrayList(children.size() / 2);
        children.forEach(child -> {
            if (this.isNewNode((TreeNode)child)) {
                needRemove.add(child);
                this.removeRightCache(cache, (TreeNode)child);
            } else {
                this.nodeBack(rightFocusNode, (TreeNode)child, cache, true);
            }
        });
        children.removeAll(needRemove);
        if (rightFocusNode.getChildren() != null && rightFocusNode.getChildren().size() == 0) {
            rightFocusNode.setChildren(null);
        }
    }

    private boolean hasSkip(TreeNode leftRoot, Map<String, String> cache, TreeNode rightFocusNode) {
        if (this.isNodeExists(cache, leftRoot, rightFocusNode)) {
            return true;
        }
        List children = leftRoot.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                if (!this.hasSkip(child, cache, rightFocusNode)) continue;
                return true;
            }
        }
        return false;
    }

    protected void collapseAll() {
        TreeNode leftRoot = this.getCacheLeftRoot();
        if (leftRoot == null) {
            return;
        }
        TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
        if (leftRoot.getChildren() != null) {
            this.collapseChild(leftRoot, treeleft);
        }
        treeleft.deleteAllNodes();
        treeleft.addNode(leftRoot);
    }

    protected void collapseChild(TreeNode leftRoot, final TreeView treeleft) {
        leftRoot.getChildren().forEach(new Consumer<TreeNode>(){

            @Override
            public void accept(TreeNode t) {
                if (t.getChildren() != null) {
                    t.setIsOpened(false);
                    DimensionImportBasePlugin.this.collapseChild(t, treeleft);
                }
            }
        });
    }

    protected void spreadAll() {
        TreeNode leftRoot = this.getCacheLeftRoot();
        if (leftRoot == null) {
            return;
        }
        TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
        if (leftRoot.getChildren() != null) {
            leftRoot.setIsOpened(true);
            this.spreadChild(leftRoot, treeleft);
        }
        treeleft.deleteAllNodes();
        treeleft.addNode(leftRoot);
    }

    protected void spreadChild(TreeNode leftRoot, final TreeView treeleft) {
        leftRoot.getChildren().forEach(new Consumer<TreeNode>(){

            @Override
            public void accept(TreeNode t) {
                if (t.getChildren() != null) {
                    t.setIsOpened(true);
                    DimensionImportBasePlugin.this.spreadChild(t, treeleft);
                }
            }
        });
    }

    protected TreeNode getLeftRoot() {
        return null;
    }

    protected TreeNode getRightRoot() {
        return null;
    }

    protected void expandleftNextLevel(TreeNode parentNode, boolean isAll) {
    }

    protected void expandRightNextLevel(TreeNode parentNode, boolean isAll, Map<String, String> cache) {
        String membermodel = this.getPageCache().get("membermodel");
        String modelId = this.getPageCache().get("modelID");
        QFilter[] filtersAll = this.getRightFilter(modelId);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)membermodel, (String)this.getRightSelector(), (QFilter[])filtersAll, (String)"parent,dseq");
        HashMap<Long, List<TreeNode>> result = new HashMap<Long, List<TreeNode>>();
        long parentId = -1L;
        if (dcs != null && dcs.size() > 0) {
            ArrayList<TreeNode> children = null;
            for (int i = 1; i < dcs.size(); ++i) {
                DynamicObject task = (DynamicObject)dcs.get(i);
                if (task.getLong("parent") != parentId) {
                    children = new ArrayList<TreeNode>();
                    parentId = task.getLong("parent");
                    result.put(parentId, children);
                }
                TreeNode orgRight = new TreeNode();
                String number = task.getString("number");
                this.setNodeText(task, orgRight);
                if (task.getString("storageType") != null && StorageTypeEnum.isShare((String)task.getString("storageType"))) {
                    orgRight.setText(this.getShareText(orgRight.getText()));
                    orgRight.setColor("#0000FF");
                }
                orgRight.setId(task.getString("id"));
                orgRight.setData((Object)task);
                if (children != null) {
                    children.add(orgRight);
                }
                cache.put(number, "0");
            }
        }
        int maxCount = BCMTreeUtils.getMaxCount((long)LongUtil.toLong((Object)modelId));
        this.assember(parentNode, result, maxCount);
    }

    private void assember(TreeNode parentNode, Map<Long, List<TreeNode>> result, int maxCount) {
        Long rootid = Long.valueOf(parentNode.getId());
        List<TreeNode> realChildren = result.get(rootid);
        if (realChildren != null && realChildren.size() > 0) {
            for (TreeNode child : realChildren) {
                if (parentNode.getChildren() != null && maxCount > 0 && parentNode.getChildren().size() >= maxCount) {
                    return;
                }
                parentNode.addChild(child);
                child.setParentid(parentNode.getId());
                this.assember(child, result, maxCount);
            }
        }
    }

    protected QFilter[] getRightFilter(String modelId) {
        QFilter fmodel = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter[] filtersLevel_1 = new QFilter[]{fmodel};
        return filtersLevel_1;
    }

    protected void setNodeText(DynamicObject task, TreeNode orgRight) {
        orgRight.setText(task.getString("number") + " " + task.getString("name"));
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
    }

    protected void cacheLeftRoot(TreeNode rootleft) {
        this.getPageCache().putBigObject(leftTree, SerializationUtils.toJsonString((Object)rootleft));
    }

    protected TreeNode getCacheLeftRoot() {
        String str = this.getPageCache().getBigObject(leftTree);
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            TreeNode leftRoot = (TreeNode)SerializationUtils.fromJsonString((String)str, TreeNode.class);
            return leftRoot;
        }
        return null;
    }

    protected void cacheRightRoot(TreeNode rootRight) {
        Queue<TreeNode> queue = SearchUtil.getQueue(rootRight);
        while (!queue.isEmpty()) {
            TreeNode node = queue.poll();
            List children = node.getChildren();
            if (children == null) continue;
            for (TreeNode child : children) {
                child.setParentid(node.getId());
            }
        }
        this.getPageCache().put(rightTree, SerializationUtils.toJsonString((Object)rootRight));
    }

    protected TreeNode getCacheRightRoot() {
        TreeNode rightRoot = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(rightTree), TreeNode.class);
        return rightRoot;
    }

    protected void cacheRightIds(Map<String, String> rightNodeIds) {
        this.getPageCache().put(rightTreeNodeIds, SerializationUtils.toJsonString(rightNodeIds));
    }

    protected Map<String, String> getCacheRightIds() {
        Map rightIds = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(rightTreeNodeIds), Map.class);
        return rightIds;
    }

    public void assembleRightNode(TreeNode rightNode, TreeNode parent, int seq, int index) {
        HashMap<String, String> cacheMap = new HashMap<String, String>(10);
        ArrayList<DynamicObject> memList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> treeList = new ArrayList<DynamicObject>(10);
        HashSet<Long> oldParentIds = new HashSet<Long>(10);
        ArrayList<DimInfo> infos = new ArrayList<DimInfo>(10);
        long modelID = Long.parseLong(this.getPageCache().get("modelID"));
        long dimensionID = Long.parseLong(this.getPageCache().get("dimensionID"));
        String memTypeName = this.getModelType();
        MainEntityType memType = EntityMetadataCache.getDataEntityType((String)memTypeName);
        String treeTypeName = this.getTreeModelType();
        MainEntityType treeType = EntityMetadataCache.getDataEntityType((String)treeTypeName);
        this.assembleRightNodeHelper(rightNode, parent, seq, index, modelID, dimensionID, cacheMap, oldParentIds, memType, memList, treeType, treeList, infos);
        if (!memList.isEmpty()) {
            this.saveMemDyns(memType, memList);
        }
        if (!treeList.isEmpty()) {
            this.saveTreeDyns(treeType, treeList);
        }
        if (!infos.isEmpty()) {
            this.afterSaveBatch(infos, treeTypeName);
        }
        this.resetParentIsleaf(oldParentIds);
    }

    private void assembleRightNodeHelper(TreeNode rightNode, TreeNode parent, int seq, int newIndex, long modelId, long dimensionId, Map<String, String> cacheMap, Set<Long> parentIds, MainEntityType memType, List<DynamicObject> memList, MainEntityType treeType, List<DynamicObject> treeList, List<DimInfo> infos) {
        List childs = rightNode.getChildren();
        if (this.isNewNode(rightNode) && parent != null) {
            this.assembleMemObj(rightNode, parent, seq, ++newIndex, modelId, dimensionId, cacheMap, memType, memList, treeType, treeList, infos);
            if (memList.size() >= 1000) {
                this.saveMemDyns(memType, memList);
                memList.clear();
            }
            if (treeList.size() >= 1000) {
                this.saveTreeDyns(treeType, treeList);
                treeList.clear();
            }
            if (infos.size() >= 1000) {
                this.afterSaveBatch(infos, treeType.getExtendName());
                infos.clear();
            }
        }
        if (childs != null && !childs.isEmpty()) {
            int dseq = 0;
            if (!this.isNewNode(rightNode)) {
                this.setNodeProperty("isleaf", false, rightNode);
                parentIds.add(Long.valueOf(rightNode.getId()));
            }
            for (TreeNode child : childs) {
                this.assembleRightNodeHelper(child, rightNode, dseq, newIndex, modelId, dimensionId, cacheMap, parentIds, memType, memList, treeType, treeList, infos);
                ++dseq;
            }
        }
    }

    protected void batchSaveCommonDim() {
        long dimensionId = LongUtil.toLong((Object)this.getPageCache().get("dimensionID"));
        DimensionLockHelper.executeWithDimensionLock((long)dimensionId, (int)60, (TimeUnit)TimeUnit.MILLISECONDS, (String)String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u6267\u884c\u6570\u636e\u5bfc\u5165", (String)"BcmBatchImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), RequestContext.get().getUserName()), () -> {
            DynamicObject model;
            DynamicObject defaultcurrency = this.getDefaultCurrencyByF7();
            TreeNode rightRoot = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(rightTree), TreeNode.class);
            int maxSeq = 0;
            if (!StringUtils.isEmpty((CharSequence)this.getPageCache().get("maxSeq"))) {
                maxSeq = Integer.parseInt(this.getPageCache().get("maxSeq"));
            }
            try (TXHandle tx = TX.required();){
                try {
                    if (defaultcurrency != null && this.getPageCache().get("isNew") != null) {
                        QFilter qfnumber = new QFilter("number", "=", (Object)defaultcurrency.getString("number"));
                        QFilter[] filters = new QFilter[]{qfnumber, new QFilter("model", "=", (Object)this.getModelId())};
                        DynamicObject currency = QueryServiceHelper.queryOne((String)"bcm_currencymembertree", (String)"id,number", (QFilter[])filters);
                        DynamicObject processC = QueryServiceHelper.queryOne((String)"bcm_processmembertree", (String)"id,number", (QFilter[])filters);
                        DynamicObject model2 = null;
                        if (currency == null) {
                            model2 = BusinessDataServiceHelper.loadSingle((String)"bcm_model", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getModelId())});
                            if (model2 != null) {
                                DimensionServiceHelper.createCurrencyMember((long)this.getModelId(), (String)model2.getString("number"), (String)defaultcurrency.getString("number"), (String)defaultcurrency.getString("name"), (String)this.getClass().getName());
                            } else {
                                throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728", (String)"DimensionImportBasePlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                            }
                        }
                        if (processC == null) {
                            if (model2 == null) {
                                model2 = BusinessDataServiceHelper.loadSingle((String)"bcm_model", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getModelId())});
                            }
                            if (model2 != null) {
                                DimensionServiceHelper.createProcessMember((long)this.getModelId(), (DynamicObject)defaultcurrency, (String)model2.getString("number"), (String)this.getClass().getName());
                            } else {
                                throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728", (String)"DimensionImportBasePlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                            }
                        }
                    }
                    if (rightRoot.getChildren() != null) {
                        List childs = rightRoot.getChildren();
                        for (int i = 0; i < childs.size(); ++i) {
                            int lastSeq;
                            if (i > 0) {
                                lastSeq = (Integer)this.getNodeProperty("dseq", (TreeNode)childs.get(i - 1));
                            } else if (this.getTreeModelType().equals("bcm_entitymembertree")) {
                                DynamicObjectCollection dot = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id", (QFilter[])new QFBuilder("model", "=", (Object)this.getModelId()).add("level", "=", (Object)2).add("isexchangerate", "=", (Object)false).add("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index).toArray());
                                lastSeq = dot.size();
                            } else {
                                lastSeq = 0;
                            }
                            this.assembleRightNode((TreeNode)childs.get(i), rightRoot, lastSeq, maxSeq);
                        }
                    }
                    this.afterOperator();
                }
                catch (KDBizException e) {
                    tx.markRollback();
                    throw e;
                }
                catch (Throwable e) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u65f6\u51fa\u73b0\u5f02\u5e38\u3002", (String)"DimensionImportBasePlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    tx.markRollback();
                    throw e;
                }
                finally {
                    this.getView().getParentView().setReturnData((Object)this.getTreeModelType());
                }
            }
            this.afterTxResyncShareNode();
            if (rightRoot.getChildren() != null && !rightRoot.getChildren().isEmpty() && (model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"reporttype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)LongUtil.toLong((Object)this.getPageCache().get("modelID")))})) != null && ApplicationTypeEnum.EB.getOIndex().equals(model.getString("reporttype"))) {
                String memberModel = this.getTreeModelType();
                rightRoot.getChildren().removeIf(child -> !"1".equals(((Map)child.getData()).get("isNew")));
                HashMap<String, Object> paramsMap = new HashMap<String, Object>();
                paramsMap.put("model", this.getModelId());
                paramsMap.put("dimension", this.getPageCache().get("dimensionID"));
                paramsMap.put("memberModel", memberModel);
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"SyncMember", (String)"syncImportMember", (Object[])new Object[]{rightRoot.getChildren(), paramsMap});
            }
            this.getView().close();
            return null;
        });
    }

    protected void batchSaveDim() {
        long dimensionId = LongUtil.toLong((Object)this.getPageCache().get("dimensionID"));
        DimensionLockHelper.executeWithDimensionLock((long)dimensionId, (int)60, (TimeUnit)TimeUnit.MILLISECONDS, (String)String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u6267\u884c\u6570\u636e\u5bfc\u5165", (String)"BcmBatchImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), RequestContext.get().getUserName()), () -> {
            TreeNode rightRoot = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(rightTree), TreeNode.class);
            int maxSeq = 0;
            if (!StringUtils.isEmpty((CharSequence)this.getPageCache().get("maxSeq"))) {
                maxSeq = Integer.parseInt(this.getPageCache().get("maxSeq"));
            }
            try (TXHandle tx = TX.required();){
                try {
                    this.assembleRightNode(rightRoot, null, 0, maxSeq);
                    this.afterOperator();
                }
                catch (KDBizException e) {
                    tx.markRollback();
                    throw e;
                }
                catch (Throwable e) {
                    tx.markRollback();
                    this.getView().showErrorNotification(ThrowableHelper.printError((Throwable)e));
                }
                finally {
                    this.getView().getParentView().setReturnData((Object)this.getTreeModelType());
                }
            }
            this.getView().close();
            return null;
        });
    }

    private void saveTreeDyns(MainEntityType treeType, List<DynamicObject> treeList) {
        Set numbers;
        long modelId = Long.parseLong(this.getPageCache().get("modelID"));
        long dimensionId = LongUtil.toLong((Object)this.getPageCache().get("dimensionID"));
        String entityName = treeType.getExtendName();
        List existsNumbers = DimensionServiceHelper.existsNumber((String)entityName, (long)modelId, (long)dimensionId, numbers = treeList.stream().map(m -> m.getString("number")).collect(Collectors.toSet()));
        if (!existsNumbers.isEmpty()) {
            if (existsNumbers.size() > 10) {
                existsNumbers = existsNumbers.subList(0, 10);
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6210\u5458\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u5f15\u5165\u3002", (String)"DimensionImportBasePlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", existsNumbers)));
        }
        this.setCreditAndOrgCode(treeType, treeList, modelId);
        SaveServiceHelper.save((DynamicObject[])treeList.toArray(new DynamicObject[0]));
    }

    protected void setCreditAndOrgCode(MainEntityType treeType, List<DynamicObject> treeList, long modelId) {
    }

    private void saveMemDyns(MainEntityType memType, List<DynamicObject> memList) {
        long modelId = Long.parseLong(this.getPageCache().get("modelID"));
        long dimId = Long.parseLong(this.getPageCache().get("dimensionID"));
        BusinessDataWriter.save((IDataEntityType)memType, (Object[])memList.toArray());
        long userId = this.getUserId();
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(16);
        for (DynamicObject memDyn : memList) {
            String number = memDyn.getString("number");
            String name = memDyn.getString("name");
            int clientType = 1;
            String clientAddress = "192.168.0.1";
            DynamicObject modifyLog = SaveDimMemberHelper.newMemberModifyLog((Long)modelId, (Long)dimId, null, (String)number, (String)name, (String)DimMemberOperateTypeEnum.SYSTEM_IMPORT.getValue(), (String)DimMemberOperateTypeEnum.SYSTEM_IMPORT.getName(), null, null, (long)userId, (int)clientType, (String)clientAddress);
            logs.add(modifyLog);
        }
        SaveDimMemberHelper.batchInsertDimMemberModifyLog(logs);
        ArrayList<String> opDescriotions = new ArrayList<String>(16);
        for (DynamicObject mem : memList) {
            opDescriotions.add(mem.getString("number") + "  " + mem.getString("name"));
        }
        if (opDescriotions.size() > 0) {
            OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u7cfb\u7edf\u5f15\u5165", (String)"DimensionImportBasePlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u7cfb\u7edf\u5f15\u5165\u6210\u529f", (String)"DimensionImportBasePlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Long)this.getModelId());
        }
    }

    private void assembleMemObj(TreeNode rightNode, TreeNode parent, int seq, int newIndex, long modelId, long dimensionId, Map<String, String> cacheMap, MainEntityType memType, List<DynamicObject> memList, MainEntityType treeType, List<DynamicObject> treeList, List<DimInfo> infos) {
        DynamicObject memDyn = this.getMemDyn(rightNode, modelId, dimensionId, cacheMap, memType, memList);
        long memId = memDyn.getLong("id");
        DynamicObject treeDyn = this.getTreeDyn(rightNode, parent, seq, modelId, dimensionId, memId, treeType, treeList);
        String storageType = treeDyn.getString("storageType");
        if (!StorageTypeEnum.SHARE.getOIndex().equals(storageType)) {
            infos.add(new DimInfo(treeDyn, memDyn, newIndex, (String)this.getNodeProperty("number", parent)));
        }
    }

    private DynamicObject getTreeDyn(TreeNode rightNode, TreeNode parent, int seq, long modelID, long dimensionID, long memId, MainEntityType treeType, List<DynamicObject> treeList) {
        String treeTypeName = treeType.getExtendName();
        String storageType = this.getNodePropertyOfSto(rightNode);
        DynamicObject treeDyn = (DynamicObject)treeType.createInstance();
        DimensionServiceHelper.initDimensionDyObject((DynamicObject)treeDyn);
        TextProp tpNameProp = (TextProp)treeType.getProperty("Name");
        int iNameLen = tpNameProp.getMaxLenth();
        TextProp tpNumberProp = (TextProp)treeType.getProperty("number");
        int iNumberLen = tpNumberProp.getMaxLenth();
        TextProp tpSimplenameProp = (TextProp)treeType.getProperty("simplename");
        int iSimplenameProp = tpSimplenameProp.getMaxLenth();
        int share = (Integer)this.getNodeProperty("share", rightNode);
        String number = (String)this.getNodeProperty("number", rightNode);
        treeDyn.set("id", (Object)Long.valueOf(rightNode.getId()));
        treeDyn.set("number", (Object)number);
        treeDyn.set("name", (Object)StringUtils.substring((String)((String)this.getNodeProperty("name", rightNode)), (int)0, (int)(iNameLen / 2)));
        treeDyn.set("simplename", (Object)StringUtils.substring((String)((String)this.getNodeProperty("simplename", rightNode)), (int)0, (int)(iSimplenameProp / 2)));
        treeDyn.set("share", (Object)share);
        treeDyn.set("copyfrom", this.getNodeProperty("copyfrom", rightNode));
        treeDyn.set("storageType", (Object)storageType);
        treeDyn.set("issysmember", (Object)2);
        if (treeTypeName.equals("bcm_userdefinedmembertree") || treeTypeName.equals("bcm_icmembertree")) {
            treeDyn.set("source", this.getModel().getValue("source"));
        }
        treeDyn.set("status", (Object)"C");
        if ((this.isCM() || this.isRPT()) && treeTypeName.equals("bcm_entitymembertree")) {
            treeDyn.set("cslscheme", this.getView().getFormShowParameter().getCustomParam("schemeid"));
            treeDyn.set("shownumber", (Object)StringUtils.substring((String)number, (int)0, (int)iNumberLen));
        }
        Map data = (Map)rightNode.getData();
        String longNumber = this.getNodeProperty("longnumber", parent) + String.valueOf('!') + this.getNodeProperty("number", rightNode);
        treeDyn.set("longnumber", (Object)longNumber);
        int level = (Integer)this.getNodeProperty("level", parent) + 1;
        treeDyn.set("level", (Object)level);
        treeDyn.set("parent", this.getNodeProperty("id", parent));
        treeDyn.set("model", (Object)modelID);
        treeDyn.set("dimension", (Object)dimensionID);
        treeDyn.set("dseq", (Object)seq);
        if (rightNode.getChildren() != null && rightNode.getChildren().size() > 0) {
            treeDyn.set("isleaf", (Object)false);
            if ("bcm_entitymembertree".equals(treeTypeName)) {
                treeDyn.set("isindependentorg", (Object)false);
            }
        } else {
            treeDyn.set("isleaf", (Object)true);
        }
        this.assembleOtherInfo(treeDyn, data);
        treeDyn.set("member", (Object)memId);
        treeList.add(treeDyn);
        this.setNodeProperty("dseq", seq, rightNode);
        this.setNodeProperty("longnumber", longNumber, rightNode);
        this.setNodeProperty("id", Long.valueOf(rightNode.getId()), rightNode);
        this.setNodeProperty("level", level, rightNode);
        return treeDyn;
    }

    private DynamicObject getMemDyn(TreeNode rightNode, long modelID, long dimensionID, Map<String, String> cacheMap, MainEntityType memType, List<DynamicObject> memList) {
        String number = (String)this.getNodeProperty("number", rightNode);
        DynamicObject memDyn = (DynamicObject)memType.createInstance();
        TextProp tpBaseNameProp = (TextProp)memType.getProperty("Name");
        int iBaseNameLen = tpBaseNameProp.getMaxLenth();
        TextProp tpBaseNumberProp = (TextProp)memType.getProperty("number");
        int iBaseNumberLen = tpBaseNumberProp.getMaxLenth();
        memDyn.set("model", (Object)modelID);
        memDyn.set("dimension", (Object)dimensionID);
        memDyn.set("number", (Object)StringUtils.substring((String)((String)this.getNodeProperty("number", rightNode)), (int)0, (int)iBaseNumberLen));
        memDyn.set("name", (Object)StringUtils.substring((String)((String)this.getNodeProperty("name", rightNode)), (int)0, (int)(iBaseNameLen / 2)));
        String memId = cacheMap.get(number);
        if (memId != null) {
            memDyn.set("id", (Object)Long.valueOf(memId));
        } else {
            long id = GlobalIdUtil.genGlobalLongId();
            memDyn.set("id", (Object)id);
            DimensionServiceHelper.initDimensionDyObjectWithOrg((DynamicObject)memDyn);
            memList.add(memDyn);
            cacheMap.put(number, String.valueOf(id));
        }
        return memDyn;
    }

    protected String getOrgCode(String number) {
        Map map = (Map)ThreadCache.get((Object)"DimensionImportBasePlugin.getOrgCode", () -> {
            HashMap<String, String> numberToCode = new HashMap<String, String>();
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)OrgViewServiceHelper.class.getName(), (String)"bos_org", (String)"number,uniformsocialcreditcode", null, null);){
                for (Row d : ds) {
                    numberToCode.put(d.getString("number"), d.getString("uniformsocialcreditcode"));
                }
                HashMap<String, String> hashMap = numberToCode;
                return hashMap;
            }
        });
        return (String)map.get(number);
    }

    protected void assembleOtherInfo(DynamicObject treeMem, Map<String, String> data) {
    }

    protected void afterSave(DynamicObject basemem, DynamicObject treeMem, int newIndex, String parentNumber) throws KDBizException {
    }

    protected void afterSaveBatch(List<DimInfo> infos, String entityName) {
        HashMap<String, Set> orgMap = new HashMap<String, Set>(16);
        for (DimInfo info : infos) {
            this.afterSave(info.getMemDyn(), info.getTreeDyn(), info.getIndex(), info.getParentNumber());
            if (!"bcm_entitymembertree".equals(entityName)) continue;
            orgMap.computeIfAbsent(info.getParentNumber(), o -> new HashSet(16)).add(info.getTreeDyn().getString("number"));
        }
        LockScopeServiceHelper.addOrgToLockScope((long)this.getModelId(), orgMap);
        if ("bcm_accountmembertree".equals(entityName)) {
            DataLockHelper.synchroStageSetting((long)this.getModelId());
        }
    }

    protected void afterOperator() throws KDBizException {
    }

    protected void afterTxResyncShareNode() throws KDBizException {
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        this.getPageCache().put(rightCurrentNode, nodeId);
    }

    protected String getModelType() {
        return "";
    }

    protected String getTreeModelType() {
        return "";
    }

    protected TreeNode cloneNode(TreeNode source, final TreeNode rightFocusNode, final boolean isAllgo) {
        TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
        final HashSet selectIds = new HashSet(treeleft.getTreeState().getSelectedNodeId());
        final TreeNode copy = new TreeNode();
        copy.setId(String.valueOf(GlobalIdUtil.genGlobalLongId()));
        copy.setParentid(source.getParentid());
        Object data = source.getData();
        Map sourceData = (Map)data;
        HashMap copyData = new HashMap(sourceData);
        copy.setData(copyData);
        if (this.isShareNode(rightFocusNode)) {
            copy.setText(this.getShareText(source.getText()));
            this.setNodeProperty("storageType", StorageTypeEnum.SHARE.index, copy);
            this.setNodeProperty("copyfrom", source.getId(), copy);
        } else {
            copy.setText(source.getText());
            this.setNodeProperty("storageType", StorageTypeEnum.STORAGE.index, copy);
        }
        if (this.isTotalShareNode(rightFocusNode)) {
            this.setNodeProperty("share", 1, copy);
        } else {
            this.setNodeProperty("share", 0, copy);
        }
        copy.setColor(color);
        if (source.getChildren() != null) {
            source.getChildren().forEach(new Consumer<TreeNode>(){

                @Override
                public void accept(TreeNode t) {
                    if (selectIds.contains(t.getId()) || isAllgo) {
                        copy.addChild(DimensionImportBasePlugin.this.cloneNode(t, rightFocusNode, isAllgo));
                    }
                }
            });
        }
        return copy;
    }

    protected String getSlipMsg() {
        return ResManager.loadKDString((String)"\u5df2\u8df3\u8fc7\u7f16\u7801\u4e0d\u5408\u6cd5\u6216\u5df2\u5b58\u5728\u7684\u6210\u5458\u3002", (String)"DimensionImportBasePlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    protected String getBackSlipMsg() {
        return ResManager.loadKDString((String)"\u5df2\u7ecf\u8df3\u8fc7\u5df2\u4fdd\u5b58\u7684\u6210\u5458\u548c\u5171\u4eab\u6210\u5458\u3002\u5982\u9700\u6e05\u9664\u5df2\u4fdd\u5b58\u7684\u6210\u5458\uff0c\u8bf7\u5728\u6210\u5458\u5217\u8868\u4e2d\u5220\u9664\uff1b\u5982\u9700\u6e05\u9664\u8fde\u5e26\u5171\u4eab\u7ec4\u7ec7\uff0c\u8bf7\u5728\u5171\u4eab\u7684\u539f\u8282\u70b9\u8fdb\u884c\u6e05\u9664\u3002", (String)"DimensionImportBasePlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    protected <T> T getNodeProperty(String key, TreeNode rightNode) {
        Object data = rightNode.getData();
        Map nodeData = (Map)data;
        Object obj = nodeData.get(key);
        return (T)(obj != null ? obj : nodeData.get(key.toUpperCase(Locale.ENGLISH)));
    }

    protected void setNodeProperty(String key, Object value, TreeNode rightNode) {
        Object data = rightNode.getData();
        Map nodeData = (Map)data;
        nodeData.put(key, value);
    }

    public List<TreeNode> getShareNodes(TreeNode rightNode, TreeNode rightRoot, boolean includeSelf) {
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        if (includeSelf) {
            result.add(rightNode);
        }
        List children = rightRoot.getChildren();
        this.getShareOfExpand(rightNode, result, children);
        return result;
    }

    private boolean isTotalShareNode(TreeNode rightNode) {
        int share = (Integer)this.getNodeProperty("share", rightNode);
        return share == 1;
    }

    public boolean isShareNode(TreeNode rightFocusNode) {
        String storagetype = (String)this.getNodeProperty("storageType", rightFocusNode);
        return storagetype != null && StorageTypeEnum.SHARE.index.equals(storagetype);
    }

    protected boolean isNewNode(TreeNode rightFocusNode) {
        String isNew = (String)this.getNodeProperty("isNew", rightFocusNode);
        return "1".equals(isNew);
    }

    private void getShareOfExpand(TreeNode rightNode, List<TreeNode> result, List<TreeNode> children) {
        if (children != null && children.size() > 0) {
            children.forEach(node -> {
                if (this.getNodeProperty("number", (TreeNode)node).equals(this.getNodeProperty("number", rightNode)) && this.isShareNode((TreeNode)node) && this.isTotalShareNode((TreeNode)node)) {
                    result.add((TreeNode)node);
                } else {
                    this.getShareOfExpand(rightNode, result, node.getChildren());
                }
            });
        }
    }

    private String getShareText(String text) {
        return text + "\uff08S\uff09";
    }

    protected String getRightSelector() {
        String selectFields = "id,name,number,member,parent,parent.number,dseq,level,longnumber,storageType,share,isleaf,copyfrom";
        return selectFields;
    }

    private void resetParentIsleaf(Set<Long> pid) {
        DynamicObject[] dync;
        QFilter idFilter = new QFilter("id", "in", pid);
        QFilter filter = new QFilter("isleaf", "=", (Object)true);
        for (DynamicObject dyn : dync = BusinessDataServiceHelper.load((String)this.getTreeModelType(), (String)"isleaf", (QFilter[])new QFilter[]{idFilter, filter})) {
            dyn.set("isleaf", (Object)Boolean.FALSE);
        }
        SaveServiceHelper.save((DynamicObject[])dync);
    }

    protected void setLeftTreeNoteColor(String key, String strColor, List<TreeNode> selectNode, boolean doAll) {
    }

    public List<TreeNode> getChildren(TreeNode treeNode, List<TreeNode> treeNodes) {
        if (treeNodes != null) {
            treeNodes.add(treeNode);
            if (treeNode.getChildren() != null && treeNode.getChildren().size() > 0) {
                for (TreeNode node : treeNode.getChildren()) {
                    this.getChildren(node, treeNodes);
                    if (node == null || node.getChildren() == null) continue;
                    treeNodes.addAll(node.getChildren());
                }
            }
        }
        return treeNodes;
    }

    protected List<String> getCanMoveNumbers(TreeView treeLeft, List<String> illegalSelectIds) {
        ArrayList<String> result = new ArrayList<String>();
        String regEx = "[A-Za-z0-9][-A-Za-z0-9_.]*";
        Pattern pattern = Pattern.compile(regEx);
        List selectNodes = treeLeft.getTreeState().getSelectedNodes();
        for (Map node : selectNodes) {
            String number = ((String)node.get("text")).trim().split(" ")[0];
            Matcher matcher = pattern.matcher(number);
            if (matcher.matches() && !this.isNotAllowNumber(number) && this.orgNumberCheck(number)) {
                result.add((String)node.get("id"));
                continue;
            }
            illegalSelectIds.add((String)node.get("id"));
        }
        return result;
    }

    private boolean orgNumberCheck(String number) {
        String treeTypeName = this.getTreeModelType();
        return !"bcm_entitymembertree".equals(treeTypeName) || !number.contains("_");
    }

    private String checkCMLeftMove2RightRoot(String entityNum, List<TreeNode> actNodes, TreeNode rightFocusNode) {
        if (!this.isRPT() && entityNum.equals("bcm_entitymembertree") && kd.bos.util.StringUtils.isEmpty((String)rightFocusNode.getParentid())) {
            if (rightFocusNode.getChildren() == null || rightFocusNode.getChildren().isEmpty()) {
                if (actNodes.size() > 1) {
                    return ResManager.loadKDString((String)"\u5f15\u5165\u7684\u7ec4\u7ec7\u53ea\u80fd\u6709\u4e00\u4e2a\u6839\u6210\u5458\uff0c\u4e14\u6210\u5458\u95f4\u6709\u660e\u786e\u7684\u4e0a\u4e0b\u7ea7\u5173\u7cfb\uff0c\u4e0d\u5141\u8bb8\u65ad\u5c42\u3002", (String)"DimensionImportBasePlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                }
            } else {
                return ResManager.loadKDString((String)"\u5f15\u5165\u7684\u7ec4\u7ec7\u53ea\u80fd\u6709\u4e00\u4e2a\u6839\u6210\u5458\uff0c\u4e14\u6210\u5458\u95f4\u6709\u660e\u786e\u7684\u4e0a\u4e0b\u7ea7\u5173\u7cfb\uff0c\u4e0d\u5141\u8bb8\u65ad\u5c42\u3002", (String)"DimensionImportBasePlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private boolean isBackList(List<String> selectIds) {
        if (BlackListUtils.hasFeatureInCm((String)"CMOther")) {
            List ids = selectIds.stream().map(s -> LongUtil.toLong((Object)s)).collect(Collectors.toList());
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)OrgViewServiceHelper.class.getName(), (String)"bos_org_structure", (String)"org.id,org.number,org.name,org.orgpattern,org.fcomment,org.enable,parent.id,isleaf", (QFilter[])new QFilter[]{new QFilter("org.id", "in", ids)}, (String)"level");){
                Iterator it = ds.iterator();
                boolean pattern = false;
                while (it.hasNext()) {
                    Row rootRow = (Row)it.next();
                    String orgpattern = rootRow.getString("org.orgpattern");
                    if ("1".equals(orgpattern)) continue;
                    pattern = true;
                    break;
                }
                boolean bl = pattern;
                return bl;
            }
        }
        return false;
    }

    private List<String> getIds(TreeNode node, List<String> ids) {
        ids.add(node.getId());
        if (node.getChildren() != null) {
            for (TreeNode nodes : node.getChildren()) {
                this.getIds(nodes, ids);
            }
        }
        return ids;
    }

    public Set<Long> getGroupIds(String clickNodeId) {
        TreeNode treeNode = this.getCacheLeftRoot();
        if (Objects.isNull(treeNode)) {
            return Collections.singleton(LongUtil.toLong((Object)clickNodeId));
        }
        HashSet<Long> groupIds = new HashSet<Long>(10);
        TreeNode curNode = treeNode.getTreeNode(clickNodeId, 10);
        if (Objects.nonNull(curNode)) {
            this.getAllChildren(curNode, groupIds);
        }
        return groupIds;
    }

    private void getAllChildren(TreeNode node, Set<Long> nodeIds) {
        nodeIds.add(LongUtil.toLong((Object)node.getId()));
        List children = node.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            children.forEach(child -> this.getAllChildren((TreeNode)child, nodeIds));
        }
    }

    protected BaseDataSource getSourceByIndex() {
        BaseDataSource source;
        String index = (String)this.getModel().getValue("source");
        if (StringUtils.isEmpty((CharSequence)index)) {
            index = "2";
            this.getModel().setValue("source", (Object)"2");
        }
        if ((source = DimensionImportHelper.getSourceByIndex(index)) != null) {
            return source;
        }
        String finalIndex = index;
        return this.getExtendSource().stream().filter(f -> f.getIndex().equals(finalIndex)).findFirst().orElse(null);
    }

    protected long getOrgUnit() {
        return this.getModel().getValue("org") != null ? ((DynamicObject)this.getModel().getValue("org")).getLong("id") : 0L;
    }

    protected String getCacheSource() {
        if (this.getPageCache().get(PRE_SOURCE) != null) {
            return this.getPageCache().get(PRE_SOURCE);
        }
        this.getPageCache().put(PRE_SOURCE, "bd_customer");
        return "bd_customer";
    }

    protected BillList getBillList() {
        return (BillList)this.getView().getControl(BILL_LIST_STAP);
    }

    protected void setBillListFormId() {
        BillList billList = this.getBillList();
        billList.setBillFormId(this.getCacheSource());
        billList.getContext().getEntryEntityDtos().clear();
        billList.setEntityId(this.getCacheSource());
        billList.setEntryEntity(this.getCacheSource());
        FilterParameter fp = billList.getFilterParameter();
        QFilter qFilter = new QFilter("status", "=", (Object)"C").and(new QFilter("enable", "=", (Object)"1")).and(new QFilter("number", "!=", (Object)""));
        if (!fp.getQFilters().stream().anyMatch(q -> "status".equals(q.getProperty()) || "enable".equals(q.getProperty()))) {
            fp.setFilter(qFilter);
        }
    }

    protected boolean checkCanCreateLeaf(String rightFocusId, String memberModel) {
        TreeNode rightRoot = this.getCacheRightRoot();
        TreeNode rightFocusNode = rightRoot.getTreeNode(rightFocusId, 20);
        if (!QueryServiceHelper.exists((String)memberModel, (Object)rightFocusId)) {
            return true;
        }
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)rightFocusId, (String)memberModel, (String)"numebr,model.number,dimension.number,isleaf");
        if (this.isShareNode(rightFocusNode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u521b\u5efa\u5171\u4eab\u6210\u5458\u7684\u4e0b\u7ea7\u6210\u5458\u3002", (String)"DimensionImportBasePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.isDimensionNone(rightFocusNode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u3002", (String)"UserDefinedImportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (dy.getBoolean("isleaf") && OlapServiceHelper.hasOlapData((String)dy.getString("model.number"), (List)Lists.newArrayList((Object[])new String[]{dy.getString("number")}), (String)dy.getString("dimension.number"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u521b\u5efa\u5df2\u7ecf\u5b58\u5728\u6570\u636e\u7684\u660e\u7ec6\u6210\u5458\u7684\u4e0b\u7ea7\u6210\u5458\u3002", (String)"DimensionImportBasePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean isNotAllowNumber(String number) {
        return OLAP_NOT_ALLOW_NUMBER.stream().anyMatch(n -> n.equalsIgnoreCase(number)) || number.contains(" ");
    }

    protected List<String> getIllegalNumbers(ListSelectedRowCollection selectedObj) {
        if (selectedObj == null || selectedObj.isEmpty()) {
            return Collections.emptyList();
        }
        String regEx = "[A-Za-z0-9][-A-Za-z0-9_.]*";
        Pattern pattern = Pattern.compile(regEx);
        ArrayList<String> result = new ArrayList<String>(16);
        for (ListSelectedRow row : selectedObj) {
            String number = row.getNumber();
            Matcher matcher = pattern.matcher(number);
            if (matcher.matches() && !this.isNotAllowNumber(number)) continue;
            result.add(number);
        }
        return result;
    }

    protected boolean isDimensionNone(TreeNode rightFocusNode) {
        HashMap data = (HashMap)rightFocusNode.getData();
        if (data.get("level") == null) {
            return false;
        }
        int level = (Integer)data.get("level");
        String parentNumber = (String)data.get("parent.number");
        String number = (String)data.get("number");
        return level == 2 && number.equalsIgnoreCase(parentNumber + "None");
    }

    protected void goRight(String key) {
        TreeView treeView = (TreeView)this.getView().getControl(treeRight);
        String rightFocusId = this.getPageCache().get(rightCurrentNode);
        TreeNode rightRoot = this.getCacheRightRoot();
        TreeNode rightFocusNode = rightRoot.getTreeNode(rightFocusId, 10);
        if (StringUtils.isEmpty((CharSequence)rightFocusId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f3\u6811\u8282\u70b9\u3002", (String)"UserDefinedImportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String memberModel = this.getPageCache().get("membermodel");
        boolean canCreate = this.checkCanCreateLeaf(rightFocusId, memberModel);
        if (!canCreate) {
            return;
        }
        BillList billList = this.getBillList();
        ListSelectedRowCollection selectedObjs = null;
        if ("btngo".equals(key)) {
            selectedObjs = billList.getSelectedRows();
        } else if ("btnallgo".equals(key)) {
            selectedObjs = this.getAllRowOfBaseData(billList);
        }
        if (selectedObjs == null || selectedObjs.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u8fb9\u5355\u636e\u5217\u8868\u8bb0\u5f55\u3002", (String)"UserDefinedImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, String> cache = this.getCacheRightIds();
        int oriSize = selectedObjs.size();
        List<String> illegalNumbers = this.getIllegalNumbers(selectedObjs);
        Set filterRows = selectedObjs.stream().filter(x -> !cache.containsKey(x.getNumber()) && !illegalNumbers.contains(x.getNumber()) && StringUtils.isNotEmpty((CharSequence)x.getNumber()) && StringUtils.isNotEmpty((CharSequence)x.getName())).collect(Collectors.toSet());
        if ("bcm_icmembertree".equals(memberModel)) {
            Set<String> existNumbers = this.getICOEntityNumber();
            filterRows = filterRows.stream().filter(x -> !existNumbers.contains(x.getNumber())).collect(Collectors.toSet());
        }
        HashSet numbers = new HashSet(filterRows.size());
        Set filterRow = filterRows.stream().filter(s -> numbers.add(s.getNumber())).collect(Collectors.toSet());
        ArrayList<TreeNode> actNodes = new ArrayList<TreeNode>(16);
        for (ListSelectedRow selectedRow : filterRow) {
            TreeNode treeNode = this.assemTreeNode(selectedRow, rightFocusNode);
            actNodes.add(treeNode);
        }
        this.wholeOne2(treeView, rightRoot, rightFocusNode, cache, actNodes, false);
        treeView.updateNodes(new ArrayList<TreeNode>(this.needUpdates));
        treeView.expand(rightFocusNode.getId());
        this.cacheRightRoot(rightRoot);
        this.cacheRightIds(cache);
        treeView.focusNode(rightFocusNode);
        billList.clearSelection();
        if (oriSize > filterRow.size()) {
            this.getView().showTipNotification(this.getSlipMsg());
        }
    }

    protected TreeNode assemTreeNode(ListSelectedRow selectedRow, TreeNode parentNode) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId(String.valueOf(selectedRow.getPrimaryKeyValue()));
        treeNode.setText(selectedRow.getNumber() + " " + selectedRow.getName());
        treeNode.setParentid(parentNode.getId());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("isNew", "1");
        data.put("name", selectedRow.getName());
        data.put("number", selectedRow.getNumber());
        data.put("id", String.valueOf(selectedRow.getPrimaryKeyValue()));
        treeNode.setData(data);
        return treeNode;
    }

    protected Set<String> getICOEntityNumber() {
        Map membersOfDB = MemberReader.getAllNodeFromCache((String)"bcm_icmembertree", (Object)this.getModelId());
        return membersOfDB.values().stream().map(IDNumberTreeNode::getNumber).collect(Collectors.toSet());
    }

    @SDKMark
    public Set<BaseDataSource> getExtendSource() {
        return new HashSet<BaseDataSource>(16);
    }

    public void setComboList() {
        Set<BaseDataSource> extSource;
        ArrayList comboItems = new ArrayList(16);
        ComboEdit fieldEditor = (ComboEdit)this.getView().getControl("source");
        ComboProp prop = (ComboProp)fieldEditor.getProperty();
        List valueMapItems = prop.getComboItems();
        TreeSet sourceSet = new TreeSet();
        sourceSet.addAll(DimensionImportHelper.getDefaultSource().stream().filter(f -> !f.getEntityNum().equals("bos_org") && !f.getEntityNum().equals("bd_accountview")).collect(Collectors.toSet()));
        if (!valueMapItems.isEmpty()) {
            valueMapItems.forEach(v -> {
                BaseDataSource extSource = DimensionImportHelper.getExtSource().stream().filter(e -> e.getEntityNum().equalsIgnoreCase(v.getValue())).findFirst().orElse(null);
                if (extSource != null) {
                    sourceSet.add(extSource);
                }
            });
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(extSource = this.getExtendSource())) {
            extSource.forEach(e -> {
                if (!sourceSet.stream().anyMatch(s -> s.getIndex().equals(e.getIndex()))) {
                    sourceSet.add(e);
                }
            });
        }
        sourceSet.forEach(s -> comboItems.add(new ComboItem(new LocaleString(s.getName()), s.getIndex())));
        fieldEditor.setComboItems(comboItems);
    }

    protected String getNodePropertyOfSto(TreeNode rightNode) {
        return (String)this.getNodeProperty("storageType", rightNode);
    }

    protected ListSelectedRowCollection getAllRowOfBaseData(BillList billList) {
        List<QFilter> filters;
        ListSelectedRowCollection list = new ListSelectedRowCollection();
        String billFormId = billList.getBillFormId();
        DynamicObjectCollection results = QueryServiceHelper.query((String)billFormId, (String)"id, number, name, modifier.name, modifytime", (QFilter[])(filters = this.getFilters()).toArray(new QFilter[0]));
        if (results.size() > 0) {
            results.forEach(ele -> {
                ListSelectedRow selectedRow = new ListSelectedRow((Object)ele.getLong("id"));
                selectedRow.setNumber(ele.getString("number"));
                selectedRow.setName(ele.getString("name"));
                list.add((Object)selectedRow);
            });
        }
        return list;
    }

    protected List<QFilter> getFilters() {
        Set<Long> groupIds;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        String clickNodeId = this.getPageCache().get(LEFT_CLICK_NODE_ID);
        if (kd.bos.util.StringUtils.isNotEmpty((String)clickNodeId) && kd.bos.util.StringUtils.isNotEmpty((String)this.getSourceByIndex().getGroupEntityNum()) && !(groupIds = this.getGroupIds(clickNodeId)).isEmpty()) {
            qFilters.add(new QFilter("group.id", "in", groupIds));
        }
        if (this.getOrgUnit() != 0L && DimensionImportHelper.isOrgFilter(this.getCacheSource())) {
            qFilters.add(new QFilter("org.id", "=", (Object)this.getOrgUnit()));
        }
        QFilter qFilter = new QFilter("status", "=", (Object)"C").and(new QFilter("enable", "=", (Object)"1"));
        if (!qFilters.stream().anyMatch(q -> "status".equals(q.getProperty()) || "enable".equals(q.getProperty()))) {
            qFilters.add(qFilter);
        }
        return qFilters;
    }

    static class DimInfo {
        private DynamicObject treeDyn;
        private DynamicObject memDyn;
        private int index;
        private String parentNumber;

        public DimInfo(DynamicObject treeDyn, DynamicObject memDyn, int index, String parentNumber) {
            this.treeDyn = treeDyn;
            this.memDyn = memDyn;
            this.index = index;
            this.parentNumber = parentNumber;
        }

        public DynamicObject getTreeDyn() {
            return this.treeDyn;
        }

        public DynamicObject getMemDyn() {
            return this.memDyn;
        }

        public int getIndex() {
            return this.index;
        }

        public String getParentNumber() {
            return this.parentNumber;
        }
    }

    public static class TreeNodeList<E>
    extends ArrayList {
        @Override
        public boolean add(Object o) {
            for (Object o1 : this) {
                if (((TreeNode)o).getId() != ((TreeNode)o1).getId()) continue;
                return false;
            }
            return super.add(o);
        }
    }
}

