/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.imp;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.TreeSet;
import kd.fi.bcm.common.enums.DefinedImpSourceEnum;
import kd.fi.bcm.formplugin.dimension.vo.BaseDataSource;

public class DimensionImportHelper {
    public static final String ASSISTANT_DATA = "bos_assistantdata_detail";
    public static final String BD_CUSTOMER = "bd_customer";
    public static final String BD_SUPPLIER = "bd_supplier";
    public static final String BD_MATERIAL = "bd_material";
    public static final String BD_BIZ_PARTNER = "bd_bizpartner";
    public static final String BD_CURRENCY = "bd_currency";
    public static final String BOS_ORG = "bos_org";
    public static final String BD_ACCOUNT_VIEW = "bd_accountview";
    public static Set<String> ORG_FILTER = Sets.newHashSet((Object[])new String[]{"bd_material", "bd_customer", "bd_supplier"});
    public static final Set<String> IC_SOURCE = Sets.newHashSet((Object[])new String[]{"bd_customer", "bd_supplier", "bd_bizpartner"});
    private static final Set<BaseDataSource> sourceList = new TreeSet<BaseDataSource>();
    private static final Set<BaseDataSource> defaultSourceList = new TreeSet<BaseDataSource>();
    private static final Set<BaseDataSource> extSourceList = new TreeSet<BaseDataSource>();

    public static Set<BaseDataSource> getAllBaseDataSource() {
        return sourceList;
    }

    public static Set<BaseDataSource> getDefaultSource() {
        return defaultSourceList;
    }

    public static Set<BaseDataSource> getExtSource() {
        return extSourceList;
    }

    public static String getIndex(String entityNum) {
        BaseDataSource baseDataSource = DimensionImportHelper.getAllBaseDataSource().stream().filter(f -> f.getEntityNum().equals(entityNum)).findFirst().orElse(null);
        if (baseDataSource != null) {
            return baseDataSource.getIndex();
        }
        return null;
    }

    public static BaseDataSource getSourceByIndex(String index) {
        BaseDataSource baseDataSource = DimensionImportHelper.getAllBaseDataSource().stream().filter(f -> f.getIndex().equals(index)).findFirst().orElse(null);
        if (baseDataSource != null) {
            return baseDataSource;
        }
        return null;
    }

    public static boolean isOrgFilter(String source) {
        return ORG_FILTER.contains(source);
    }

    public static boolean isAssistantData(String source) {
        return ASSISTANT_DATA.equals(source);
    }

    static {
        for (DefinedImpSourceEnum t : DefinedImpSourceEnum.values()) {
            if (DefinedImpSourceEnum.staff == t || DefinedImpSourceEnum.accountbank == t) {
                extSourceList.add(new BaseDataSource(t.getIndex(), t.getName(), t.getEntityNum(), t.getGroupEntityNum()));
                continue;
            }
            defaultSourceList.add(new BaseDataSource(t.getIndex(), t.getName(), t.getEntityNum(), t.getGroupEntityNum()));
        }
        sourceList.addAll(defaultSourceList);
        sourceList.addAll(extSourceList);
    }
}

