/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.imp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListGridView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.struct.ShareNodeStructSyncHelper;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.dimension.imp.DimensionImportBasePlugin;
import kd.fi.bcm.spread.common.util.StringUtil;

public class ICOEntityImportPlugin
extends DimensionImportBasePlugin
implements TreeNodeClickListener,
PagerClickListener {
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String TREEVIEW_TREELEFT = "treeleft";
    private static final String TREEVIEW_TREERIGHT = "treeright";
    private static final String ICOENTITYIMPORTPLUGIN_2 = "ICOEntityImportPlugin_2";

    @Override
    public void initialize() {
        super.initialize();
        BillList billList = this.getBillList();
        if (this.getPageCache().get("presource") == null) {
            this.getPageCache().put("presource", "bd_customer");
        }
        if (StringUtils.isEmpty((String)billList.getBillFormId())) {
            this.setBillListFormId();
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"searchflex"});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = this.getBillList();
        TreeView treeleft = (TreeView)this.getView().getControl(TREEVIEW_TREELEFT);
        treeleft.addTreeNodeClickListener((TreeNodeClickListener)this);
        billList.addSetFilterListener(this::setFilter);
        billList.addPagerClickListener(this::pagerClick);
        billList.addListRowClickListener((ListRowClickListener)this);
        billList.addListRowDoubleClickListener((ListRowClickListener)this);
    }

    @Override
    protected QFilter[] getRightFilter(String modelId) {
        QFilter fmodel = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter dimensionId = new QFilter("dimension", "=", (Object)LongUtil.toLong((Object)this.getPageCache().get("dimensionID")));
        QFilter fnumber = new QFilter("number", "=", (Object)"ICOEntity");
        return new QFilter[]{fmodel, dimensionId, fnumber};
    }

    public void pagerClick(PagerClickEvent pagerClickEvent) {
        BillList billList = this.getBillList();
        if (StringUtils.isEmpty((String)billList.getBillFormId()) || !billList.getBillFormId().equals(this.getCacheSource())) {
            billList.setBillFormId(this.getCacheSource());
            billList.getContext().getEntryEntityDtos().clear();
            billList.setEntityId(this.getCacheSource());
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        List<QFilter> filters = this.getFilters();
        if (filters.size() > 0) {
            qFilters.addAll(filters);
        }
    }

    @Override
    public void treeNodeClick(TreeNodeEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        String clickNodeId = (String)evt.getNodeId();
        if (StringUtil.equals((String)key, (String)TREEVIEW_TREELEFT)) {
            BillList billList = this.getBillList();
            this.getPageCache().put("leftClickNodeId", clickNodeId);
            this.setBillListFormId();
            billList.refresh();
        } else {
            super.treeNodeClick(evt);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        this.getPageCache().remove("leftClickNodeId");
        this.getPageCache().put("presource", this.getSourceByIndex().getEntityNum());
        this.initLeftTree();
        this.setBillListFormId();
        BillList billList = this.getBillList();
        billList.clearSelection();
        billList.refresh();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    protected void initLeftTree() {
        TreeView treeleft = (TreeView)this.getView().getControl(TREEVIEW_TREELEFT);
        treeleft.deleteAllNodes();
        TreeNode rootleft = this.getLeftRoot();
        if (rootleft == null) {
            return;
        }
        this.expandleftNextLevel(rootleft, true);
        this.cacheLeftRoot(rootleft);
        treeleft.addNode(rootleft);
        treeleft.expand(rootleft.getId());
        this.getView().updateView(TREEVIEW_TREELEFT);
    }

    @Override
    protected TreeNode getLeftRoot() {
        TreeNode rootleft = new TreeNode();
        rootleft.setId("0");
        rootleft.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"ICOEntityImportPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("isNew", "1");
        data.put("name", ResManager.loadKDString((String)"\u5168\u90e8", (String)"ICOEntityImportPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        data.put("simplename", ResManager.loadKDString((String)"\u5168\u90e8", (String)"ICOEntityImportPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        data.put("number", "all");
        data.put("id", "0");
        rootleft.setData(data);
        return rootleft;
    }

    @Override
    protected void expandleftNextLevel(TreeNode parentNode, boolean isAll) {
        if (StringUtils.isNotEmpty((String)this.getSourceByIndex().getGroupEntityNum())) {
            DynamicObject[] dys;
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("parent.id", "=", (Object)LongUtil.toLong((Object)parentNode.getId()));
            for (DynamicObject dy : dys = BusinessDataServiceHelper.load((String)this.getSourceByIndex().getGroupEntityNum(), (String)this.getLeftSelectProperties(), (QFilter[])qfBuilder.toArray())) {
                TreeNode orgLeft = new TreeNode();
                orgLeft.setId(dy.getString("id"));
                orgLeft.setText(dy.getString("number") + " " + dy.getString("name"));
                orgLeft.setParentid(dy.getString("parent.id") == null ? "0" : parentNode.getId());
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("isNew", "1");
                data.put("name", dy.getString("name"));
                data.put("number", dy.getString("number"));
                data.put("id", dy.getString("id"));
                orgLeft.setData(data);
                if (!dy.getBoolean("isleaf")) {
                    if (isAll) {
                        this.expandleftNextLevel(orgLeft, true);
                    } else {
                        ArrayList tt = new ArrayList();
                        orgLeft.setChildren(tt);
                    }
                }
                parentNode.addChild(orgLeft);
            }
        }
    }

    private String getLeftSelectProperties() {
        return "id,name,number,parent,isleaf";
    }

    private String getRightSelectProperties() {
        return "id,name,number,member,parent,dseq,level,longnumber,storageType,share,isleaf";
    }

    @Override
    protected TreeNode getRightRoot() {
        TreeNode rootRight = new TreeNode();
        String membermodel = this.getPageCache().get("membermodel");
        String modelId = this.getPageCache().get("modelID");
        String dimensionId = this.getPageCache().get("dimensionID");
        QFilter fid = new QFilter("dimension.id", "=", (Object)LongUtil.toLong((Object)dimensionId));
        QFilter fmodel = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter fnumber = new QFilter("number", "=", (Object)"ICOEntity");
        QFilter[] filters = new QFilter[]{fid, fmodel, fnumber};
        DynamicObject rightRootDy = BusinessDataServiceHelper.loadSingle((String)membermodel, (String)this.getRightSelectProperties(), (QFilter[])filters);
        String rightRootId = rightRootDy.getString("id");
        String name = rightRootDy.getString("name");
        rootRight.setId(rightRootId);
        rootRight.setText(rightRootDy.getString("number") + " " + name);
        rootRight.setData((Object)rightRootDy);
        return rootRight;
    }

    @Override
    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        String opkey = btn.getKey();
        this.checkPerm(opkey);
        if (evt.getSource() instanceof Button) {
            String key = btn.getKey();
            if ("btngo".equals(key) || "btnallgo".equals(key)) {
                String rightFocusId = this.getPageCache().get("rightCurrentNode");
                if (!this.checkExistsICOEntityMemb(LongUtil.toLong((Object)rightFocusId))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5916\u90e8\u7ec4\u7ec7\u5141\u8bb8\u5f15\u5165\u3002", (String)"ICOEntityImportPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                this.goRight(key);
            } else if ("btnback".equals(((Button)evt.getSource()).getKey())) {
                TreeView treeright = (TreeView)this.getView().getControl(TREEVIEW_TREERIGHT);
                String rightFocusId = this.getPageCache().get("rightCurrentNode");
                if (StringUtils.isEmpty((String)rightFocusId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f3\u6811\u8282\u70b9\u3002", (String)ICOENTITYIMPORTPLUGIN_2, (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                TreeNode rightRoot = this.getCacheRightRoot();
                if (rightFocusId.equals(rightRoot.getId())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u79fb\u9664\u6839\u8282\u70b9\u3002", (String)"ICOEntityImportPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                TreeNode rightFocusNode = rightRoot.getTreeNode(rightFocusId, 10);
                if (this.isShareNode(rightFocusNode)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u76f4\u63a5\u79fb\u9664\u5171\u4eab\u8282\u70b9\u3002", (String)"ICOEntityImportPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                boolean hasSkip = false;
                Map<String, String> cache = this.getCacheRightIds();
                if (this.isNewNode(rightFocusNode)) {
                    TreeNode parentNode = rightRoot.deleteChildNode(rightFocusId);
                    this.removeRightCache(cache, rightFocusNode);
                    treeright.deleteNode(rightFocusId);
                    if (parentNode.getChildren() == null || parentNode.getChildren().isEmpty()) {
                        parentNode.setChildren(null);
                    }
                    this.removeShareNodes(rightRoot, rightFocusNode, cache);
                    treeright.focusNode(parentNode);
                    treeright.treeNodeClick(null, parentNode.getId());
                    treeright.updateNode(parentNode);
                    treeright.expand(parentNode.getId());
                } else {
                    this.nodeBack(rightRoot, rightFocusNode, cache, false);
                    rightFocusNode.setExpend(true);
                    treeright.updateNode(rightFocusNode);
                    treeright.expand(rightFocusId);
                    treeright.focusNode(rightFocusNode);
                    hasSkip = true;
                }
                this.cacheRightRoot(rightRoot);
                this.cacheRightIds(cache);
                if (hasSkip) {
                    this.getView().showTipNotification(this.getBackSlipMsg());
                    return;
                }
            } else if ("btnallback".equals(((Button)evt.getSource()).getKey())) {
                this.allback();
            }
        }
        if (evt.getSource() instanceof Label) {
            TreeView treeleft;
            TreeNode leftRoot;
            if ("allchoose".equals(((Label)evt.getSource()).getKey())) {
                leftRoot = this.getCacheLeftRoot();
                if (leftRoot == null) {
                    return;
                }
                treeleft = (TreeView)this.getView().getControl(TREEVIEW_TREELEFT);
                treeleft.checkNode(leftRoot);
            } else if ("allclear".equals(((Label)evt.getSource()).getKey())) {
                leftRoot = this.getCacheLeftRoot();
                if (leftRoot == null) {
                    return;
                }
                treeleft = (TreeView)this.getView().getControl(TREEVIEW_TREELEFT);
                this.allClear(leftRoot, treeleft);
            } else if ("allexpand".equals(((Label)evt.getSource()).getKey())) {
                this.spreadAll();
            } else {
                this.collapseAll();
            }
        }
        if ("baritemconfirm".equals(((Control)evt.getSource()).getKey())) {
            this.batchSaveDim();
        } else if ("baritemcancel".equals(((Control)evt.getSource()).getKey())) {
            this.getView().close();
        }
    }

    private boolean checkExistsICOEntityMemb(long rightFocusId) {
        return QueryServiceHelper.exists((String)"bcm_icmembertree", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)rightFocusId).and(new QFilter("number", "=", (Object)"ICOEntity"))});
    }

    @Override
    public boolean isDimensionNone(TreeNode rightFocusNode) {
        HashMap data = (HashMap)rightFocusNode.getData();
        if (data.get("level") == null) {
            return false;
        }
        int level = (Integer)data.get("level");
        String parentNumber = (String)data.get("parent.number");
        String number = (String)data.get("number");
        return level == 2 && number.equalsIgnoreCase(parentNumber + "None");
    }

    @Override
    protected String getTreeModelType() {
        return "bcm_icmembertree";
    }

    @Override
    protected String getModelType() {
        return "bcm_intercompanymember";
    }

    @Override
    protected void afterSave(DynamicObject basemem, DynamicObject treeMem, int newIndex, String parentNumber) throws KDBizException {
        if (ModelUtil.queryApp((IFormView)this.getView()) == ApplicationTypeEnum.BGBD) {
            return;
        }
        try {
            String longnumber = treeMem.getString("longnumber");
            String dimensionNum = longnumber.split("!")[0];
            OlapServiceHelper.createMember((String)this.getPageCache().get("modelNum"), (String)dimensionNum, (String)treeMem.getString("number"), (int)treeMem.getInt("aggoprt"), (String)parentNumber);
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"OLAP\u4fa7\u5904\u7406\u5931\u8d25\uff1a%s\u3002", (String)"ICOEntityImportPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), e.getMessage()));
        }
    }

    @Override
    protected void afterSaveBatch(List<DimensionImportBasePlugin.DimInfo> dimInfo, String entityName) {
        if (!dimInfo.isEmpty()) {
            String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
            ArrayList<Tuple> members = new ArrayList<Tuple>(dimInfo.size());
            for (DimensionImportBasePlugin.DimInfo info : dimInfo) {
                DynamicObject td = info.getTreeDyn();
                members.add(Tuple.create((Object)td.getString("number"), (Object)td.getInt("aggoprt"), (Object)"ICOEntity"));
            }
            OlapServiceHelper.batchCreateDimensionMembers((String)modelNum, (String)"InternalCompany", members);
        }
    }

    @Override
    protected void assembleOtherInfo(DynamicObject treeMem, Map<String, String> data) {
        treeMem.set("aggoprt", (Object)"1");
    }

    @Override
    protected void afterOperator() throws KDBizException {
        super.afterOperator();
        long modelId = LongUtil.toLong((Object)this.getPageCache().get("modelID"));
        long dimensionId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("dimensionId"));
        ShareNodeStructSyncHelper.syncICNodeStorageType((long)modelId, (long)dimensionId);
    }

    public void listRowClick(ListRowClickEvent evt) {
        ((ListGridView)((BillList)evt.getSource()).getItems().get(0)).getItems().remove(2);
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
        ((ListGridView)((BillList)evt.getSource()).getItems().get(0)).getItems().remove(2);
    }
}

