/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.imp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.bizrule.BizRuleCatalogServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.SaveDimMemberHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ScenarioMemberEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.log.DimMemberOperateTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import org.apache.commons.collections.CollectionUtils;

public class ScenarioImportPlugin
extends AbstractBaseFormPlugin
implements ClickListener {
    private static final String entryentity = "entryentity";
    private static List<Map<String, String>> defaultValue = new ArrayList<Map<String, String>>();

    @Override
    public void initialize() {
        super.initialize();
        this.init();
        this.addClickListeners("btn_ok");
    }

    public void init() {
        defaultValue.clear();
        ScenarioMemberEnum[] scenarios = ScenarioMemberEnum.values();
        for (int i = 0; i < scenarios.length; ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", scenarios[i].number);
            map.put("name", scenarios[i].getName());
            map.put("storagetype", StorageTypeEnum.STORAGE.getName());
            map.put("aggoprt", AggOprtEnum.SKIP.getDescription());
            map.put("enablehisrec", ResManager.loadKDString((String)"\u662f", (String)"ScenarioImportPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            defaultValue.add(map);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        int size = defaultValue.size();
        this.getModel().batchCreateNewEntryRow(entryentity, size);
        DynamicObjectCollection dys = this.getModel().getEntryEntity(entryentity);
        for (int i = 0; i < size; ++i) {
            DynamicObject dynamicObject = (DynamicObject)dys.get(i);
            Map<String, String> map = defaultValue.get(i);
            map.entrySet().forEach(m -> dynamicObject.set((String)m.getKey(), m.getValue()));
        }
        this.getView().updateView(entryentity);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Button btn = (Button)evt.getSource();
        String opkey = btn.getKey();
        if ("btn_ok".equals(opkey)) {
            EntryGrid entry = (EntryGrid)this.getControl(entryentity);
            int[] sels = entry.getSelectRows();
            if (sels.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5f15\u5165\u7684\u60c5\u666f\u6210\u5458\u3002", (String)"ScenarioImportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            List<String> sceneStrs = Arrays.asList(ScenarioMemberEnum.YDRPT.number, ScenarioMemberEnum.MRPT.number, ScenarioMemberEnum.QRPT.number, ScenarioMemberEnum.SRPT.number, ScenarioMemberEnum.ARPT.number);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryentity);
            ArrayList<Object> selectRows = new ArrayList<Object>(6);
            for (int i = 0; i < sels.length; ++i) {
                selectRows.add(entryEntity.get(sels[i]));
            }
            Set sceneNums = selectRows.stream().map(x -> x.getString("number")).collect(Collectors.toSet());
            if (!Collections.disjoint(sceneStrs, sceneNums)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5982\u9700\u8981\u540c\u6b65\u521b\u5efa\u671f\u95f4\u6210\u5458\uff0c\u8bf7\u5728\u201c\u5e94\u7528\u4f53\u7cfb\u4e0b\u201d\u9884\u7f6e\u671f\u95f4\u4e2d\u5b8c\u6210\u542f\u7528\u8be5\u60c5\u666f\u64cd\u4f5c\uff0c\u662f\u5426\u7ee7\u7eed\u5bfc\u5165\u60c5\u666f\uff1f", (String)"ScenarioImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("btn_ok_comfirm", (IFormPlugin)this));
                return;
            }
            int length = sels.length;
            ArrayList<String> opDescriotions = new ArrayList<String>(length);
            ArrayList<DynamicObject> noSavedMems = new ArrayList<DynamicObject>(length);
            ArrayList<DynamicObject> noSavedMemTrees = new ArrayList<DynamicObject>(length);
            ArrayList<DynamicObject> bizrules = new ArrayList<DynamicObject>(length);
            ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(length);
            ArrayList<DynamicObject> existMems = new ArrayList<DynamicObject>(length);
            this.fillValueOfDys(opDescriotions, noSavedMems, noSavedMemTrees, bizrules, logs, existMems);
            this.saveDatas(noSavedMems, noSavedMemTrees, bizrules, opDescriotions, logs);
            this.tipExistMems(existMems);
        }
    }

    private void tipExistMems(List<DynamicObject> existMems) {
        if (existMems.size() > 0) {
            StringBuilder sb = new StringBuilder(8);
            for (int i = 0; i < existMems.size(); ++i) {
                sb.append(existMems.get(i).getString("number"));
                if (i == existMems.size() - 1) continue;
                sb.append(",");
            }
            this.getView().getParentView().showTipNotification(String.format(ResManager.loadKDString((String)"\u90e8\u5206\u6210\u5458\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u77e5\u6089\u3002", (String)"ScenarioImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb));
        }
        this.getView().close();
    }

    private void fillValueOfDys(List<String> opDescriotions, List<DynamicObject> noSavedMems, List<DynamicObject> noSavedMemTrees, List<DynamicObject> bizrules, List<DynamicObject> logs, List<DynamicObject> existMems) {
        EntryGrid entry = (EntryGrid)this.getControl(entryentity);
        int[] sels = entry.getSelectRows();
        Long modelId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        String dimensionId = (String)this.getView().getFormShowParameter().getCustomParam("dimensionId");
        long parentTreeid = QueryDimensionServiceHelper.getParentId((long)modelId, (String)"bcm_scenemembertree", (String)PresetConstant.SCENE_DIM, (String)this.getClass().getName());
        int seq = DimensionServiceHelper.getDSeq((long)parentTreeid, (String)"bcm_scenemembertree", (String)this.getClass().getName());
        for (int i = 0; i < sels.length; ++i) {
            DynamicObject sel = (DynamicObject)this.getModel().getEntryEntity(entryentity).get(sels[i]);
            String number = sel.getString("number");
            if (!ScenarioMemberEnum.MRPT.number.equals(number) && !QueryServiceHelper.exists((String)"bcm_scenemembertree", (QFilter[])new QFBuilder("model", "=", (Object)modelId).add("number", "=", (Object)number).toArray())) {
                String name = sel.getString("name");
                DynamicObject basemem = BusinessDataServiceHelper.newDynamicObject((String)"bcm_scenemember");
                basemem.set("model", (Object)modelId);
                basemem.set("dimension", (Object)dimensionId);
                basemem.set("number", (Object)number);
                basemem.set("name", (Object)name);
                DimensionServiceHelper.initDimensionDyObjectWithOrg((DynamicObject)basemem);
                noSavedMems.add(basemem);
                DynamicObject treeMem = BusinessDataServiceHelper.newDynamicObject((String)"bcm_scenemembertree");
                DimensionServiceHelper.initDimensionDyObjectWithOrg((DynamicObject)treeMem);
                treeMem.set("model", (Object)modelId);
                treeMem.set("dimension", (Object)dimensionId);
                treeMem.set("number", (Object)number);
                treeMem.set("name", (Object)name);
                treeMem.set("isleaf", (Object)true);
                treeMem.set("level", (Object)"2");
                treeMem.set("storagetype", (Object)StorageTypeEnum.STORAGE.index);
                treeMem.set("aggoprt", (Object)AggOprtEnum.SKIP.sign);
                treeMem.set("issysmember", (Object)2);
                treeMem.set("longnumber", (Object)(PresetConstant.SCENE_DIM + '!' + number));
                treeMem.set("parent", (Object)parentTreeid);
                treeMem.set("dseq", (Object)seq++);
                treeMem.set("datatype", (Object)DataTypeEnum.DEFAULT.index);
                treeMem.set("dchangetype", (Object)"0");
                if (ApplicationTypeEnum.CM.getAppnum().equals(this.getBizAppId())) {
                    this.initSCConfig(treeMem);
                }
                noSavedMemTrees.add(treeMem);
                DynamicObject dy = BizRuleCatalogServiceHelper.getNewBizRuleSCatalog((String)treeMem.getString("number"), (String)treeMem.getString("name"), (long)treeMem.getLong("model"), (long)treeMem.getLong("id"));
                bizrules.add(dy);
                opDescriotions.add(number + "  " + name);
                DynamicObject modifyLog = SaveDimMemberHelper.newMemberModifyLog((Long)this.getModelId(), (Long)Long.parseLong(dimensionId), null, (String)number, (String)name, (String)DimMemberOperateTypeEnum.SYSTEM_IMPORT.getValue(), (String)DimMemberOperateTypeEnum.SYSTEM_IMPORT.getName(), null, null, (long)RequestContext.get().getCurrUserId(), (int)1, (String)RequestContext.get().getLoginIP());
                logs.add(modifyLog);
                continue;
            }
            existMems.add(sel);
        }
    }

    private void initSCConfig(DynamicObject treeMem) {
        long modelId = treeMem.getLong("model");
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        QFilter qfCsl1 = new QFilter("number", "!=", (Object)"DefaultRateScheme");
        QFilter qfCsl2 = new QFilter("nodetype", "=", (Object)"1");
        DynamicObjectCollection csls = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id", (QFilter[])new QFilter[]{qf, qfCsl1, qfCsl2});
        if (CollectionUtils.isEmpty((Collection)csls)) {
            return;
        }
        DynamicObjectCollection scDys = new DynamicObjectCollection();
        DynamicObjectType dynamicObjectType = treeMem.getDynamicObjectCollection("scenecslscheme").getDynamicObjectType();
        csls.forEach(ele -> {
            DynamicObject dy = new DynamicObject(dynamicObjectType);
            dy.set("fbasedataid", (Object)ele.getLong("id"));
            scDys.add((Object)dy);
        });
        treeMem.set("scenecslscheme", (Object)scDys);
    }

    private void saveDatas(List<DynamicObject> noSavedMems, List<DynamicObject> noSavedMemTrees, List<DynamicObject> bizrules, List<String> opDescriotions, List<DynamicObject> logs) {
        if (noSavedMems.size() == 0) {
            return;
        }
        Long modelId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        DynamicObject modelObj = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id, number, isdetailtoqrt, isdetailtohalfyear", (QFilter[])new QFBuilder("id", "=", (Object)modelId).toArray());
        try (TXHandle tx = TX.required((String)"ScenarioImportPlugin_save");){
            try {
                DynamicObject[] save = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])noSavedMems.toArray(new DynamicObject[0]));
                for (DynamicObject dynamicObject : noSavedMemTrees) {
                    List member = Arrays.stream(save).filter(x -> dynamicObject.getString("number").equals(x.getString("number"))).collect(Collectors.toList());
                    if (member == null || member.size() <= 0) continue;
                    dynamicObject.set("member", member.get(0));
                }
                DynamicObject[] treeSave = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])noSavedMemTrees.toArray(new DynamicObject[0]));
                for (DynamicObject bizrule : bizrules) {
                    List member = Arrays.stream(treeSave).filter(x -> bizrule.getString("number").equals(x.getString("number"))).collect(Collectors.toList());
                    if (member == null || member.size() <= 0) continue;
                    bizrule.set("scene", member.get(0));
                }
                SaveServiceHelper.save((DynamicObject[])bizrules.toArray(new DynamicObject[0]));
                Set<String> set = noSavedMems.stream().filter(x -> ScenarioMemberEnum.QRPT.number.equals(x.getString("number")) || ScenarioMemberEnum.SRPT.number.equals(x.getString("number"))).map(y -> y.getString("number")).collect(Collectors.toSet());
                this.saveSPConfig(modelObj, set);
                Set<String> allNums = noSavedMems.stream().map(x -> x.getString("number")).collect(Collectors.toSet());
                OlapServiceHelper.batchCreateDimensionMembers((String)modelObj.getString("number"), (String)DimTypesEnum.SCENARIO.getNumber(), (String[])allNums.toArray(new String[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)e.getMessage()), new Object[]{e.getMessage()});
            }
        }
        if (logs.size() > 0) {
            try {
                SaveDimMemberHelper.batchInsertDimMemberModifyLog(logs);
            }
            catch (Exception e) {
                log.error("system_import:" + e.getMessage());
            }
        }
        if (opDescriotions.size() > 0) {
            OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u7cfb\u7edf\u5f15\u5165\u6210\u529f", (String)"ScenarioImportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u7cfb\u7edf\u5f15\u5165\u6210\u529f", (String)"ScenarioImportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Long)modelObj.getLong("id"));
        }
    }

    private void saveSPConfig(DynamicObject modelObj, Set<String> numbers) {
        if (numbers == null || numbers.size() == 0) {
            return;
        }
        DynamicObjectCollection qRptColls = new DynamicObjectCollection();
        DynamicObjectCollection sRptColls = new DynamicObjectCollection();
        long modelId = modelObj.getLong("id");
        QFilter qfPeriod = null;
        if (numbers.contains(ScenarioMemberEnum.QRPT.number) && modelObj.getBoolean("isdetailtoqrt")) {
            qfPeriod = new QFilter("model", "=", (Object)modelId);
            qfPeriod.and("number", "like", (Object)"Q_Q%");
        }
        if (numbers.contains(ScenarioMemberEnum.SRPT.number) && modelObj.getBoolean("isdetailtohalfyear")) {
            QFilter srpt = new QFilter("model", "=", (Object)modelId).and("number", "like", (Object)"HF_HF%");
            qfPeriod = qfPeriod != null ? qfPeriod.or(srpt) : srpt;
        }
        DynamicObject[] scenarios = BusinessDataServiceHelper.load((String)"bcm_scenemembertree", (String)String.format("id,number,%s", "sceneperiod"), (QFilter[])new QFBuilder("model", "=", (Object)modelId).add("number", "in", numbers).toArray());
        DynamicObjectType type = scenarios[0].getDynamicObjectCollection("sceneperiod").getDynamicObjectType();
        DynamicObjectCollection periods = null;
        if (qfPeriod != null) {
            periods = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id, number", (QFilter[])qfPeriod.toArray(), (String)"number");
        }
        if (periods == null || periods.size() == 0) {
            return;
        }
        periods.forEach(p -> {
            DynamicObject dy = new DynamicObject(type);
            dy.set("fbasedataid", (Object)p.getLong("id"));
            if (p.getString("number").contains("Q_Q")) {
                qRptColls.add((Object)dy);
            } else {
                sRptColls.add((Object)dy);
            }
        });
        for (DynamicObject scenario : scenarios) {
            if (ScenarioMemberEnum.QRPT.number.equals(scenario.getString("number"))) {
                scenario.set("sceneperiod", (Object)qRptColls);
                continue;
            }
            scenario.set("sceneperiod", (Object)sRptColls);
        }
        SaveServiceHelper.save((DynamicObject[])scenarios);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String actionId = evt.getCallBackId();
        if ("btn_ok_comfirm".equals(actionId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            EntryGrid entry = (EntryGrid)this.getControl(entryentity);
            int[] sels = entry.getSelectRows();
            int length = sels.length;
            ArrayList<String> opDescriotions = new ArrayList<String>(length);
            ArrayList<DynamicObject> noSavedMems = new ArrayList<DynamicObject>(length);
            ArrayList<DynamicObject> noSavedMemTrees = new ArrayList<DynamicObject>(length);
            ArrayList<DynamicObject> bizrules = new ArrayList<DynamicObject>(length);
            ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(length);
            ArrayList<DynamicObject> existMems = new ArrayList<DynamicObject>(length);
            this.fillValueOfDys(opDescriotions, noSavedMems, noSavedMemTrees, bizrules, logs, existMems);
            this.saveDatas(noSavedMems, noSavedMemTrees, bizrules, opDescriotions, logs);
            this.tipExistMems(existMems);
        }
    }
}

