/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.imp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListGridView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.datalock.DataLockHelper;
import kd.fi.bcm.business.dimension.struct.ShareNodeStructSyncHelper;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.dimension.imp.DimensionImportBasePlugin;
import kd.fi.bcm.formplugin.dimension.imp.DimensionImportHelper;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;

public class UserDefinedImportPlugin
extends DimensionImportBasePlugin
implements TreeNodeClickListener,
PagerClickListener {
    @Override
    public void initialize() {
        super.initialize();
        BillList billList = this.getBillList();
        if (this.getPageCache().get("presource") == null) {
            this.getPageCache().put("presource", "bd_customer");
        }
        if (StringUtils.isEmpty((String)billList.getBillFormId())) {
            this.setBillListFormId();
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"searchflex"});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = this.getBillList();
        TreeView treeleft = (TreeView)this.getView().getControl("treeleft");
        treeleft.addTreeNodeClickListener((TreeNodeClickListener)this);
        billList.addSetFilterListener(this::setFilter);
        billList.addPagerClickListener(this::pagerClick);
        billList.addListRowClickListener((ListRowClickListener)this);
        billList.addListRowDoubleClickListener((ListRowClickListener)this);
    }

    @Override
    protected QFilter[] getRightFilter(String modelId) {
        QFilter fmodel = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter userdefinemodel = new QFilter("dimension", "=", (Object)LongUtil.toLong((Object)this.getPageCache().get("dimensionID")));
        return new QFilter[]{fmodel, userdefinemodel};
    }

    public void pagerClick(PagerClickEvent pagerClickEvent) {
        BillList billList = this.getBillList();
        if (StringUtils.isEmpty((String)billList.getBillFormId()) || !billList.getBillFormId().equals(this.getCacheSource())) {
            billList.setBillFormId(this.getCacheSource());
            billList.getContext().getEntryEntityDtos().clear();
            billList.setEntityId(this.getCacheSource());
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        List<QFilter> filters = this.getFilters();
        if (filters.size() > 0) {
            qFilters.addAll(filters);
        }
    }

    @Override
    public void treeNodeClick(TreeNodeEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        String clickNodeId = (String)evt.getNodeId();
        if (StringUtil.equals((String)key, (String)"treeleft")) {
            BillList billList = this.getBillList();
            this.getPageCache().put("leftClickNodeId", clickNodeId);
            this.setBillListFormId();
            billList.refresh();
        } else {
            Long parent = Long.valueOf(clickNodeId);
            String nodeId = this.getPageCache().get("rightCurrentNode");
            if (nodeId == null) {
                super.treeNodeClick(evt);
                return;
            }
            boolean exists = QueryServiceHelper.exists((String)"bcm_userdefinedmembertree", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)parent).and(new QFilter("isseq", "=", (Object)true).or(new QFilter("parent.isseq", "=", (Object)true)))});
            if (exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u5e8f\u53f7\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"UserDefinedImportPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                TreeView treeright = (TreeView)this.getView().getControl("treeright");
                DynamicObject query = QueryServiceHelper.queryOne((String)"bcm_userdefinedmembertree", (String)"id, name, parent", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(nodeId))});
                if (query.getLong("parent") != 0L) {
                    treeright.focusNode(new TreeNode(query.getString("parent"), query.getString("id"), query.getString("name")));
                } else {
                    treeright.focusNode(new TreeNode(null, query.getString("id"), query.getString("name")));
                }
            } else {
                super.treeNodeClick(evt);
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        this.getPageCache().remove("leftClickNodeId");
        this.getPageCache().put("presource", this.getSourceByIndex().getEntityNum());
        this.initLeftTree();
        this.setBillListFormId();
        BillList billList = this.getBillList();
        billList.clearSelection();
        billList.refresh();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    protected void initLeftTree() {
        TreeView treeleft = (TreeView)this.getView().getControl("treeleft");
        treeleft.deleteAllNodes();
        TreeNode rootleft = this.getLeftRoot();
        if (rootleft == null) {
            return;
        }
        this.expandleftNextLevel(rootleft, true);
        this.cacheLeftRoot(rootleft);
        treeleft.addNode(rootleft);
        treeleft.expand(rootleft.getId());
        this.getView().updateView("treeleft");
    }

    @Override
    protected TreeNode getLeftRoot() {
        TreeNode rootleft = new TreeNode();
        rootleft.setId("0");
        rootleft.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"UserDefinedImportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("isNew", "1");
        data.put("name", ResManager.loadKDString((String)"\u5168\u90e8", (String)"UserDefinedImportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        data.put("simplename", ResManager.loadKDString((String)"\u5168\u90e8", (String)"UserDefinedImportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        data.put("number", "all");
        data.put("id", "0");
        rootleft.setData(data);
        return rootleft;
    }

    @Override
    protected void expandleftNextLevel(TreeNode parentNode, boolean isAll) {
        if (StringUtils.isNotEmpty((String)this.getSourceByIndex().getGroupEntityNum())) {
            DynamicObject[] dys;
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("parent.id", "=", (Object)LongUtil.toLong((Object)parentNode.getId()));
            for (DynamicObject dy : dys = BusinessDataServiceHelper.load((String)this.getSourceByIndex().getGroupEntityNum(), (String)this.getLeftSelectProperties(), (QFilter[])qfBuilder.toArray())) {
                TreeNode orgLeft = new TreeNode();
                orgLeft.setId(dy.getString("id"));
                orgLeft.setText(dy.getString("number") + " " + dy.getString("name"));
                orgLeft.setParentid(dy.getString("parent.id") == null ? "0" : parentNode.getId());
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("isNew", "1");
                data.put("name", dy.getString("name"));
                data.put("number", dy.getString("number"));
                data.put("id", dy.getString("id"));
                orgLeft.setData(data);
                if (!DimensionImportHelper.isAssistantData(this.getSourceByIndex().getEntityNum()) && !dy.getBoolean("isleaf")) {
                    if (isAll) {
                        this.expandleftNextLevel(orgLeft, true);
                    } else {
                        ArrayList tt = new ArrayList();
                        orgLeft.setChildren(tt);
                    }
                }
                parentNode.addChild(orgLeft);
            }
        }
    }

    private String getLeftSelectProperties() {
        return "id,name,number,parent,isleaf";
    }

    private String getRightSelectProperties() {
        return "id,name,number,member,parent,dseq,level,longnumber,storageType,share,isleaf";
    }

    @Override
    protected TreeNode getRightRoot() {
        TreeNode rootRight = new TreeNode();
        String membermodel = this.getPageCache().get("membermodel");
        String modelId = this.getPageCache().get("modelID");
        String dimensionId = this.getPageCache().get("dimensionID");
        QFilter fnumber = new QFilter("dimension.id", "=", (Object)LongUtil.toLong((Object)dimensionId));
        QFilter fmodel = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter flevel = new QFilter("level", "=", (Object)1);
        QFilter[] filters = new QFilter[]{fnumber, fmodel, flevel};
        DynamicObject rightRootDy = BusinessDataServiceHelper.loadSingle((String)membermodel, (String)this.getRightSelectProperties(), (QFilter[])filters);
        String rightRootId = rightRootDy.getString("id");
        String name = rightRootDy.getString("name");
        rootRight.setId(rightRootId);
        rootRight.setText(rightRootDy.getString("number") + " " + name);
        rootRight.setData((Object)rightRootDy);
        return rootRight;
    }

    @Override
    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        String opkey = btn.getKey();
        this.checkPerm(opkey);
        if (evt.getSource() instanceof Button) {
            String key = btn.getKey();
            TreeView treeView = (TreeView)this.getView().getControl("treeright");
            if ("btngo".equals(key) || "btnallgo".equals(key)) {
                this.goRight(key);
            } else if ("btnback".equals(((Button)evt.getSource()).getKey())) {
                String rightFocusId = this.getPageCache().get("rightCurrentNode");
                if (StringUtils.isEmpty((String)rightFocusId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f3\u6811\u8282\u70b9\u3002", (String)"UserDefinedImportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                TreeNode rightRoot = this.getCacheRightRoot();
                if (rightFocusId.equals(rightRoot.getId())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u79fb\u9664\u6839\u8282\u70b9\u3002", (String)"UserDefinedImportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                TreeNode rightFocusNode = rightRoot.getTreeNode(rightFocusId, 10);
                if (this.isShareNode(rightFocusNode)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u76f4\u63a5\u79fb\u9664\u5171\u4eab\u8282\u70b9\u3002", (String)"UserDefinedImportPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                boolean hasSkip = false;
                Map<String, String> cache = this.getCacheRightIds();
                if (this.isNewNode(rightFocusNode)) {
                    TreeNode parentNode = rightRoot.deleteChildNode(rightFocusId);
                    this.removeRightCache(cache, rightFocusNode);
                    treeView.deleteNode(rightFocusId);
                    if (parentNode.getChildren() == null || parentNode.getChildren().size() == 0) {
                        parentNode.setChildren(null);
                    }
                    this.removeShareNodes(rightRoot, rightFocusNode, cache);
                    treeView.focusNode(parentNode);
                    treeView.treeNodeClick(null, parentNode.getId());
                    treeView.updateNode(parentNode);
                    treeView.expand(parentNode.getId());
                } else {
                    this.nodeBack(rightRoot, rightFocusNode, cache, false);
                    rightFocusNode.setExpend(true);
                    treeView.updateNode(rightFocusNode);
                    treeView.expand(rightFocusId);
                    treeView.focusNode(rightFocusNode);
                    hasSkip = true;
                }
                this.cacheRightRoot(rightRoot);
                this.cacheRightIds(cache);
                if (hasSkip) {
                    this.getView().showTipNotification(this.getBackSlipMsg());
                    return;
                }
            } else if ("btnallback".equals(((Button)evt.getSource()).getKey())) {
                this.allback();
            }
        }
        if (evt.getSource() instanceof Label) {
            TreeView treeleft;
            TreeNode leftRoot;
            if ("allchoose".equals(((Label)evt.getSource()).getKey())) {
                leftRoot = this.getCacheLeftRoot();
                if (leftRoot == null) {
                    return;
                }
                treeleft = (TreeView)this.getView().getControl("treeleft");
                treeleft.checkNode(leftRoot);
            } else if ("allclear".equals(((Label)evt.getSource()).getKey())) {
                leftRoot = this.getCacheLeftRoot();
                if (leftRoot == null) {
                    return;
                }
                treeleft = (TreeView)this.getView().getControl("treeleft");
                this.allClear(leftRoot, treeleft);
            } else if ("allexpand".equals(((Label)evt.getSource()).getKey())) {
                this.spreadAll();
            } else {
                this.collapseAll();
            }
        }
        if ("baritemconfirm".equals(((Control)evt.getSource()).getKey())) {
            this.batchSaveDim();
        } else if ("baritemcancel".equals(((Control)evt.getSource()).getKey())) {
            this.getView().close();
        }
    }

    @Override
    protected String getTreeModelType() {
        return "bcm_userdefinedmembertree";
    }

    @Override
    protected String getModelType() {
        return "bcm_userdefinedmember";
    }

    @Override
    protected void afterSave(DynamicObject basemem, DynamicObject treeMem, int newIndex, String parentNumber) throws KDBizException {
        try {
            String longnumber = treeMem.getString("longnumber");
            String dimensionNum = longnumber.split("!")[0];
            OlapServiceHelper.createMember((String)this.getPageCache().get("modelNum"), (String)dimensionNum, (String)treeMem.getString("number"), (int)treeMem.getInt("aggoprt"), (String)parentNumber);
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"olap\u4fa7\u5904\u7406\u5931\u8d25\uff1a\u201c%s\u201d\u3002", (String)"UserDefinedImportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    @Override
    protected void afterSaveBatch(List<DimensionImportBasePlugin.DimInfo> infos, String entityName) {
        if (ModelUtil.queryApp((IFormView)this.getView()) == ApplicationTypeEnum.BGBD) {
            return;
        }
        if (infos.size() > 0) {
            DynamicObject treeDyn = infos.get(0).getTreeDyn();
            String dimensionNum = treeDyn.getString("longnumber").split("!")[0];
            String modelNum = this.getPageCache().get("modelNum");
            ArrayList<Tuple> list = new ArrayList<Tuple>(16);
            HashMap<String, Set> parentChild = new HashMap<String, Set>(16);
            for (DimensionImportBasePlugin.DimInfo info : infos) {
                String parentNumber = info.getParentNumber();
                DynamicObject td = info.getTreeDyn();
                list.add(Tuple.create((Object)td.getString("number"), (Object)td.getInt("aggoprt"), (Object)parentNumber));
                parentChild.computeIfAbsent(parentNumber, o -> new HashSet(16)).add(td.getString("number"));
            }
            OlapServiceHelper.batchCreateDimensionMembers((String)modelNum, (String)dimensionNum, list);
            DataLockHelper.synchroStageSetting((long)this.getModelId());
        }
    }

    @Override
    protected void assembleOtherInfo(DynamicObject treeMem, Map<String, String> data) {
        treeMem.set("aggoprt", (Object)"1");
        treeMem.set("datatype", (Object)"1");
    }

    @Override
    protected void afterOperator() throws KDBizException {
        super.afterOperator();
    }

    @Override
    protected void afterTxResyncShareNode() throws KDBizException {
        String dimensionId = (String)this.getView().getFormShowParameter().getCustomParam("dimensionId");
        Long modelId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        ShareNodeStructSyncHelper.resyncShareNodeStructure((String)"bcm_userdefinedmembertree", (long)modelId, (long)LongUtil.toLong((Object)dimensionId));
    }

    public void listRowClick(ListRowClickEvent evt) {
        List items = ((ListGridView)((BillList)evt.getSource()).getItems().get(0)).getItems();
        if (items.size() > 2) {
            items.remove(2);
        }
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
        List items = ((ListGridView)((BillList)evt.getSource()).getItems().get(0)).getItems();
        if (items.size() > 2) {
            items.remove(2);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setComboList();
    }

    @Override
    protected String getNodePropertyOfSto(TreeNode rightNode) {
        return ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM006") && CollectionUtils.isNotEmpty((Collection)rightNode.getChildren()) ? StorageTypeEnum.DYNAMIC.getOIndex() : super.getNodePropertyOfSto(rightNode);
    }
}

