/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.memberf7;

import com.alibaba.fastjson.annotation.JSONField;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.member.f7.tree.BaseTreeBuilder;
import kd.epm.epbs.common.util.QFBuilder;
import kd.fi.bcm.business.permission.cache.MembBaseItem;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.strategy.PermControlStrategy;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.formplugin.dimension.memberf7.BcmCustomPropertyMemberTreeBuilder;
import kd.fi.bcm.formplugin.dimension.memberf7.BcmMemberTreeBuilder;
import kd.fi.bcm.formplugin.dimension.memberf7.enums.F7RangeTypeEnum;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class BcmMemberF7Parameter
extends AbstractMemberF7Parameter {
    private static final String DEFAULT_ORDER = "longnumber";
    private static final String DEFAULT_LEAF_LIST = "bcm_memberf7";
    private static final String DEFAULT_LEAF_RANGE = "bcm_memberf8";
    private static final String DEFAULT_FIELDS = "id,name,number,parent.id,isleaf";
    private static final String DEFAULT_SIMPLENAME = ",simplename";
    private F7RangeTypeEnum rangeType = F7RangeTypeEnum.DEFAULT;
    private boolean includeRateCslScheme;
    private boolean filterExchangeRate = true;
    private boolean permFilterF7 = true;
    private boolean enableGrantPerm = true;
    private boolean showSimpleName = true;

    public BcmMemberF7Parameter() {
    }

    public BcmMemberF7Parameter(@NotNull Long modelId, @NotNull String dimensionNumber) {
        super(modelId, dimensionNumber);
    }

    public boolean isEnableGrantPerm() {
        return this.enableGrantPerm;
    }

    public void setEnableGrantPerm(boolean enableGrantPerm) {
        this.enableGrantPerm = enableGrantPerm;
    }

    public boolean isPermFilterF7() {
        return this.permFilterF7;
    }

    public void setPermFilterF7(boolean permFilterF7) {
        this.permFilterF7 = permFilterF7;
    }

    public boolean isFilterExchangeRate() {
        return this.filterExchangeRate;
    }

    public void setFilterExchangeRate(boolean filterExchangeRate) {
        this.filterExchangeRate = filterExchangeRate;
    }

    public boolean isIncludeRateCslScheme() {
        return this.includeRateCslScheme;
    }

    public void setIncludeRateCslScheme(boolean includeRateCslScheme) {
        this.includeRateCslScheme = includeRateCslScheme;
    }

    public void setRangeType(F7RangeTypeEnum rangeType) {
        this.rangeType = rangeType;
    }

    public F7RangeTypeEnum getRangeType() {
        return this.rangeType;
    }

    public boolean isShowSimpleName() {
        return this.showSimpleName;
    }

    public void setShowSimpleName(boolean showSimpleName) {
        this.showSimpleName = showSimpleName;
    }

    protected Set<Long> loadPermission() {
        Map allNodeFromCache = MemberReader.getAllNodeFromCache((String)this.getEntityNumber(), (String)MemberReader.findModelNumberById((Object)this.getModelId()));
        return PermissionServiceImpl.getInstance((Long)this.getModelId()).matchReadOrWritePermMembers(this.getDimensionId(), this.getEntityNumber(), new ArrayList(allNodeFromCache.keySet()));
    }

    public QFilter getPermissionIdFilter() {
        return PermissionServiceImpl.getInstance((Long)this.getModelId()).getReadOrWritePermFilter(this.getDimensionId(), this.getEntityNumber(), "id");
    }

    public boolean canShowCustomProperty() {
        return true;
    }

    public void check() {
        if (Objects.isNull(this.getModelId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MemberF7Parameter_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (Objects.isNull(this.getDimensionId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MemberF7Parameter_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void loadData() {
        DynamicObject dimension = MemberReader.getDimensionDynById((long)this.getDimensionId());
        if (dimension == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MemberF7Parameter_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.setEntityNumber(dimension.getString("membermodel"));
        this.setDimensionNumber(dimension.getString("number"));
        this.setDimensionName(dimension.getString("name"));
        this.setOrderBy(DEFAULT_ORDER);
        IDNumberTreeNode rootMember = MemberReader.findMemberByNumber((String)this.getEntityNumber(), (String)"id", (String)this.getDimensionNumber());
        if (rootMember != IDNumberTreeNode.NotFoundTreeNode) {
            this.setRootMemberId(rootMember.getId());
        }
        this.setShowView(DimTypesEnum.ENTITY.getNumber().equals(this.getDimensionNumber()));
    }

    protected DynamicObject getDimension(@NotNull Long modelId, @NotNull String dimensionNumber) {
        Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimensionNumber);
        return this.getDimension(dimensionId);
    }

    protected DynamicObject getDimension(@NotNull Long dimensionId) {
        return MemberReader.getDimensionDynById((long)dimensionId);
    }

    public boolean isView() {
        return false;
    }

    public String getF7FormId() {
        return DEFAULT_LEAF_LIST;
    }

    public String getF8FormId() {
        return DEFAULT_LEAF_RANGE;
    }

    @JSONField(serialize=false, deserialize=false)
    public List<ComboItem> getRangeItems() {
        List<Object> items = new ArrayList();
        if (this.rangeType == F7RangeTypeEnum.ALL) {
            items = this.getAllRange();
        }
        if (this.rangeType == F7RangeTypeEnum.DEFAULT) {
            items = this.getDefault();
        }
        if (this.rangeType == F7RangeTypeEnum.SELF) {
            items = this.getSelf();
        }
        return items;
    }

    public String getCustomPropertyValueForm() {
        return "bcm_definedpropertyvalue";
    }

    public String getCustomPropertyForm() {
        return "bcm_definedproperty";
    }

    private List<ComboItem> getSelf() {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>();
        list.add(new ComboItem(new LocaleString(RangeEnum.VALUE_10.getName()), String.valueOf(RangeEnum.VALUE_10.getValue())));
        list.add(new ComboItem(new LocaleString(RangeEnum.VALUE_50.getName()), String.valueOf(RangeEnum.VALUE_10.getValue())));
        return list;
    }

    @JSONField(serialize=false, deserialize=false)
    private List<ComboItem> getDefault() {
        List<ComboItem> items = this.getAllRange();
        items.removeIf(item -> Integer.parseInt(item.getValue()) > RangeEnum.VALUE_110.getValue());
        return items;
    }

    @JSONField(serialize=false, deserialize=false)
    private List<ComboItem> getAllRange() {
        RangeEnum[] values = RangeEnum.values();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(values.length);
        for (RangeEnum _range : values) {
            items.add(new ComboItem(new LocaleString(_range.getName()), String.valueOf(_range.getValue())));
        }
        return items;
    }

    @JSONField(serialize=false, deserialize=false)
    public boolean enableGrantPerm() {
        return this.isEnableGrantPerm() && ConfigServiceHelper.getGlobalBoolParam((String)"isPEnableGrantPerm");
    }

    public String fields() {
        String _fields = this.getFields();
        if (StringUtils.isEmpty((CharSequence)this.getFields())) {
            _fields = DEFAULT_FIELDS;
        }
        if (this.isShowSimpleName()) {
            _fields = _fields + DEFAULT_SIMPLENAME;
        }
        return _fields;
    }

    protected QFBuilder $filters(boolean isBuildTree) {
        if (DimTypesEnum.ENTITY.getNumber().equals(this.getDimensionNumber())) {
            return super.$filters(isBuildTree).add(new QFilter("cslscheme", "=", (Object)this.getViewId()));
        }
        return super.$filters(isBuildTree);
    }

    protected QFilter getSelectRangeFilter() {
        QFBuilder qFilter = new QFBuilder();
        if (this.getSelectRange() != null && !this.getSelectRange().isEmpty()) {
            HashSet memberIds = new HashSet();
            this.getSelectRange().forEach((memberId, range) -> {
                IDNumberTreeNode memberById = MemberReader.findMemberById((long)this.getModelId(), (String)this.getEntityNumber(), (Long)memberId);
                if (memberById == IDNumberTreeNode.NotFoundTreeNode) {
                    if (range.intValue() == RangeEnum.VALUE_10.getValue()) {
                        memberIds.add(memberId);
                    }
                } else {
                    MembRangeItem membBaseItem = new MembRangeItem(this.getEntityNumber(), memberId, memberById.getNumber(), range.intValue(), false, (Object)this.getModelId());
                    BcmMemberF7Parameter.buildFilter(qFilter, PermControlStrategy.getStrategy((RangeEnum)RangeEnum.getRangeByVal((int)range)).buildFilterByScope((MembBaseItem)membBaseItem));
                }
            });
            BcmMemberF7Parameter.buildFilter(qFilter, new QFilter("id", "in", memberIds));
        }
        return qFilter.toFilter();
    }

    private static void buildFilter(QFBuilder builder, QFilter qfilter) {
        if (builder.size() == 0) {
            builder.add(qfilter);
        } else {
            builder.or(qfilter);
        }
    }

    protected boolean isMember(Long memberId) {
        IDNumberTreeNode memberById = MemberReader.findMemberById((long)this.getModelId(), (String)this.getEntityNumber(), (Long)memberId);
        return memberById != IDNumberTreeNode.NotFoundTreeNode;
    }

    public BaseTreeBuilder getCustomPropertyTreeBuilder(AbstractMemberF7Parameter f7Parameter) {
        return BcmCustomPropertyMemberTreeBuilder.get(f7Parameter);
    }

    public BaseTreeBuilder getTreeBuilder(AbstractMemberF7Parameter f7Parameter) {
        return BcmMemberTreeBuilder.get(f7Parameter);
    }

    @JSONField(serialize=false, deserialize=false)
    public List<ComboItem> getStorageTypes() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        for (StorageTypeEnum storageTypeEnum : StorageTypeEnum.values()) {
            comboItems.add(new ComboItem(new LocaleString(storageTypeEnum.getName()), storageTypeEnum.getOIndex()));
        }
        return comboItems;
    }
}

