/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.memberf7;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.ComboEdit;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.formplugin.member.f7.MemberRangeF7;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.RangeF7PropertyCataEnum;
import kd.fi.bcm.formplugin.dimension.memberf7.BcmMemberF7Parameter;
import kd.fi.bcm.formplugin.dimension.util.F7Utils;
import kd.fi.bcm.formplugin.dimension.vo.BcmSelectedMember;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class BcmMemberRangeF7
extends MemberRangeF7 {
    protected void addMember(@NotNull IFormView view, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull String controlKey, @NotNull AbstractMemberF7Parameter f7Param) {
        Map members = f7Param.getSelectedData();
        ArrayList<BcmSelectedMember> selMembers = new ArrayList<BcmSelectedMember>(members.size());
        LinkedHashMap selectedMembers = new LinkedHashMap(members.size());
        for (Map.Entry entry : members.entrySet()) {
            Long memberId = (Long)entry.getKey();
            BcmSelectedMember bcmSelectedMember = this.collectMembers(memberId, "1", f7Param);
            if (bcmSelectedMember == null) {
                bcmSelectedMember = this.collectMembers(memberId, "2", f7Param);
            }
            if (bcmSelectedMember == null) continue;
            bcmSelectedMember.setScope((Integer)entry.getValue());
            selMembers.add(bcmSelectedMember);
        }
        if (!selMembers.isEmpty()) {
            dataModel.beginInit();
            int[] rows = dataModel.batchCreateNewEntryRow("entryentity", selMembers.size());
            for (int i = 0; i < selMembers.size(); ++i) {
                BcmSelectedMember member = (BcmSelectedMember)((Object)selMembers.get(i));
                int rowIndex = rows[i];
                dataModel.setValue("memberid", (Object)member.getId(), rowIndex);
                dataModel.setValue("name", (Object)member.getName(), rowIndex);
                dataModel.setValue("number", (Object)member.getNumber(), rowIndex);
                dataModel.setValue("storagetype", (Object)member.getStorageType(), rowIndex);
                RangeEnum range = RangeEnum.getRangeByVal((int)member.getScope());
                if (range != null) {
                    RangeF7PropertyCataEnum typeEnum;
                    dataModel.setValue("scope", (Object)String.valueOf(range.getValue()), rowIndex);
                    if (f7Param.isLockRangeSelect() || "2".equals(member.getType())) {
                        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"scope"});
                    }
                    if (f7Param.isShowExclude() && f7Param.getExcludeMemberIds() != null && f7Param.getExcludeMemberIds().contains(member.getId())) {
                        member.setExclude(true);
                        dataModel.setValue("exclude", (Object)Boolean.TRUE, rowIndex);
                    }
                    if ((typeEnum = RangeF7PropertyCataEnum.of((String)member.getType())) != null) {
                        dataModel.setValue("type", (Object)typeEnum.getIndex(), rowIndex);
                    }
                    this.putSelectedMember(selectedMembers, member);
                }
                dataModel.endInit();
                this.getView().updateView("entryentity");
            }
            this.cacheSelectMember(pageCache, selectedMembers);
        }
    }

    private BcmSelectedMember collectMembers(Long id, String type, AbstractMemberF7Parameter f7Param) {
        return new BcmSelectedMember().loadMember(id, type, f7Param);
    }

    protected BcmMemberF7Parameter getF7Parameter() {
        return (BcmMemberF7Parameter)super.getF7Parameter();
    }

    protected void initUI(EventObject e) {
        BcmMemberF7Parameter f7Param = this.getF7Parameter();
        ComboEdit rangeEdit = (ComboEdit)this.getControl("scope");
        rangeEdit.setComboItems(f7Param.getRangeItems());
        if (StringUtils.isNotEmpty((CharSequence)f7Param.getShowType())) {
            this.getModel().setValue("showtype", (Object)f7Param.getShowType());
        } else {
            f7Param.setShowType(String.valueOf(this.getModel().getValue("showtype")));
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"level"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"exclude"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        List controls = entryGrid.getControls();
        for (Control control : controls) {
            if (!"storagetype".equals(control.getKey()) || !(control instanceof ComboEdit)) continue;
            ((ComboEdit)control).setComboItems(f7Param.getStorageTypes());
        }
    }

    public void returnData(@NotNull IFormView view, Map<String, List<String>> selectData, @NotNull AbstractMemberF7Parameter f7Param) {
        if (ListSelectedRow.class.getName().equals(f7Param.getReturnClassName())) {
            view.returnDataToParent((Object)F7Utils.getListSelectedRow(selectData));
        } else if (BcmSelectedMember.class.getName().equals(f7Param.getReturnClassName())) {
            view.returnDataToParent(F7Utils.getBcmSelectedMember(selectData, f7Param));
        } else {
            super.returnData(view, selectData, f7Param);
        }
    }
}

