/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.memberf7;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.member.f7.tree.BaseDynamicTreeBuilder;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import org.jetbrains.annotations.NotNull;

public class BcmMemberTreeBuilder
extends BaseDynamicTreeBuilder {
    public static BcmMemberTreeBuilder get(@NotNull AbstractMemberF7Parameter f7Parameter) {
        return new BcmMemberTreeBuilder(f7Parameter);
    }

    protected BcmMemberTreeBuilder(@NotNull AbstractMemberF7Parameter f7Parameter) {
        super(f7Parameter);
    }

    protected List<Map<String, Object>> getFilterData(String entityNumber) {
        AbstractMemberF7Parameter _f7Param = this.getF7Parameter();
        if (BcmMemberTreeBuilder.isIc(entityNumber)) {
            if (!_f7Param.isCutTree()) {
                return null;
            }
            log.info("begin-query-getFilterData.");
            Map member = MemberReader.getAllNodeFromCache((String)entityNumber, (Object)_f7Param.getModelId());
            List<Map<String, Object>> filterData = this.transDataSet(member);
            log.info("end-query-getFilterData.");
            return filterData;
        }
        return super.getFilterData(entityNumber);
    }

    private static boolean isIc(String entityNumber) {
        return DimEntityNumEnum.INTERCOMPANY.getEntityNum().equalsIgnoreCase(entityNumber);
    }

    private List<Map<String, Object>> transDataSet(Map<Long, IDNumberTreeNode> ds) {
        LinkedList<Map<String, Object>> rst = new LinkedList<Map<String, Object>>();
        if (ds == null || ds.isEmpty()) {
            return rst;
        }
        for (Map.Entry<Long, IDNumberTreeNode> entry : ds.entrySet()) {
            IDNumberTreeNode v = entry.getValue();
            LinkedHashMap<String, Object> rowObjs = new LinkedHashMap<String, Object>(5);
            rowObjs.put("id", v.getId());
            rowObjs.put("name", v.getName());
            rowObjs.put("number", v.getNumber());
            rowObjs.put("isleaf", v.isLeaf());
            if (v.getParent() == null || v.getParent() == IDNumberTreeNode.NotFoundTreeNode) {
                rowObjs.put("parent.id", 0L);
            } else {
                rowObjs.put("parent.id", v.getParent().getId());
            }
            rst.add(rowObjs);
        }
        return rst;
    }

    protected Set<String> getAllParentIdSetByLongNumber(AbstractMemberF7Parameter _f7Param, List<String> ids) {
        return new HashSet<String>(ids);
    }

    protected Set<String> queryInitParentData(List<Map<String, Object>> memberTreeData) {
        AbstractMemberF7Parameter _f7Param = this.getF7Parameter();
        if (BcmMemberTreeBuilder.isIc(_f7Param.getEntityNumber())) {
            if (!_f7Param.isCutTree()) {
                return null;
            }
            LinkedHashSet parentData = Sets.newLinkedHashSetWithExpectedSize((int)1024);
            String entityNumber = this.getEntityNumber(_f7Param);
            log.info("begin-query-initParentData.");
            Map member = MemberReader.getAllNodeFromCache((String)entityNumber, (Object)_f7Param.getModelId());
            member.forEach((k, v) -> {
                if (!v.isLeaf()) {
                    parentData.add("" + v.getId());
                }
            });
            log.info("end-query-initParentData.");
            return parentData;
        }
        return super.queryInitParentData(memberTreeData);
    }
}

