/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.search;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.bcm.business.upgrade.DimensionNode;
import kd.fi.bcm.business.upgrade.DimensionTree;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.formplugin.dimension.util.TreeEntryNewUtil;
import kd.fi.bcm.formplugin.util.TreeEntryEntityUtil;

public class DimensionMemberSearch {
    private int searchAtFindListIndex = -1;
    private List<String> findList = new ArrayList<String>(10);
    private DimensionTree<String, DimensionNode> tree;

    public DimensionMemberSearch(DynamicObject[] dimensionMembers, List<String> entryFields, String searchText, String formId) {
        String key = this.getKeyOfTree(dimensionMembers[0], formId);
        this.tree = (DimensionTree)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)key, () -> this.buildTree(dimensionMembers, entryFields));
        this.findIndexListDeep(this.tree, searchText);
    }

    private String getKeyOfTree(DynamicObject dimensionMember, String formId) {
        long modelId = dimensionMember.getLong("model");
        long dimId = dimensionMember.getLong("dimension");
        long cslId = 0L;
        if (dimensionMember.getDynamicObjectType().getProperties().stream().anyMatch(x -> x.getName().equals("cslscheme"))) {
            cslId = dimensionMember.getLong("cslscheme");
        }
        return formId + "_" + modelId + "_" + dimId + "_" + (cslId == 0L ? "" : Long.valueOf(cslId));
    }

    public int doSearch(AbstractFormDataModel pageDataModel, List<String> entryFields, String entryName) {
        LinkedList<DimensionTree<String, DimensionNode>> showList = new LinkedList<DimensionTree<String, DimensionNode>>();
        HashMap<String, Integer> focusId = new HashMap<String, Integer>(16);
        this.searchByLongNumberAndExpandToList(this.tree, showList, this.findList.get(this.searchAtFindListIndex), focusId);
        this.fillPageEntries(pageDataModel, showList, entryFields, entryName);
        return focusId.get("focus") != null ? (Integer)focusId.get("focus") : -1;
    }

    private DimensionTree<String, DimensionNode> buildTree(DynamicObject[] dimensionMembers, List<String> entryFields) {
        DimensionTree tree = DimensionNode.createDimTreeWithShareRef((DynamicObject[])dimensionMembers);
        if (entryFields.contains("longnumber")) {
            DimensionNode.updateLongNumber((DimensionTree)tree);
        }
        return tree;
    }

    private List<String> findIndexListDeep(DimensionTree<String, DimensionNode> dimensionTreeRoot, String searchText) {
        ArrayList<String> fullMatch = new ArrayList<String>(10);
        ArrayList<String> fuzzyMatch = new ArrayList<String>(10);
        this.addThisOneOrNot(dimensionTreeRoot, searchText, fullMatch, fuzzyMatch);
        this.preOrderTravel(dimensionTreeRoot, searchText, fullMatch, fuzzyMatch);
        this.findList.addAll(fullMatch);
        this.findList.addAll(fuzzyMatch);
        return this.findList;
    }

    private void preOrderTravel(DimensionTree<String, DimensionNode> tempTreeNode, String searchText, List<String> fullMatch, List<String> fuzzyMatch) {
        for (DimensionTree child : tempTreeNode.getChildren()) {
            this.addThisOneOrNot((DimensionTree<String, DimensionNode>)child, searchText, fullMatch, fuzzyMatch);
            this.preOrderTravel((DimensionTree<String, DimensionNode>)child, searchText, fullMatch, fuzzyMatch);
        }
    }

    private void addThisOneOrNot(DimensionTree<String, DimensionNode> tempTreeNode, String searchText, List<String> fullMatch, List<String> fuzzyMatch) {
        DynamicObject dyn = ((DimensionNode)tempTreeNode.getData()).getDyn();
        String name = dyn.getString("name").toLowerCase(Locale.ENGLISH);
        String number = dyn.getString("number").toLowerCase(Locale.ENGLISH);
        JSONObject searchContentJson = JSONObject.parseObject((String)searchText);
        JSONArray fields = searchContentJson.getJSONArray("searchFields");
        if (fields == null) {
            fields = searchContentJson.getJSONArray("searchfields");
        }
        for (Object searchJson : fields) {
            JSONObject searchJsonObj = (JSONObject)searchJson;
            JSONArray fieldName = searchJsonObj.getJSONArray("fieldName");
            if (fieldName == null) {
                fieldName = searchJsonObj.getJSONArray("fieldname");
            }
            String longNumber = ((DimensionNode)tempTreeNode.getData()).getLongNumber();
            JSONArray values = searchJsonObj.getJSONArray("value");
            for (Object value : values) {
                String valueStr = ((String)value).toLowerCase(Locale.ENGLISH).trim();
                if (fieldName.size() > 1) {
                    if (name.equalsIgnoreCase(valueStr) || number.equalsIgnoreCase(valueStr)) {
                        fullMatch.add(longNumber);
                        continue;
                    }
                    if (!name.contains(valueStr) && !number.contains(valueStr)) continue;
                    fuzzyMatch.add(longNumber);
                    continue;
                }
                if ("number".equals(fieldName.getString(0))) {
                    if (number.equalsIgnoreCase(valueStr)) {
                        fullMatch.add(longNumber);
                        continue;
                    }
                    if (!number.contains(valueStr)) continue;
                    fuzzyMatch.add(longNumber);
                    continue;
                }
                if (!"name".equals(fieldName.getString(0))) continue;
                if (name.equalsIgnoreCase(valueStr)) {
                    fullMatch.add(longNumber);
                    continue;
                }
                if (!name.contains(valueStr)) continue;
                fuzzyMatch.add(longNumber);
            }
        }
    }

    private void searchByLongNumberAndExpandToList(DimensionTree<String, DimensionNode> root, List<DimensionTree<String, DimensionNode>> showList, String longNumber, Map<String, Integer> focusId) {
        showList.add(root);
        if (this.findAtCurrentLevel(root, showList, longNumber, focusId)) {
            return;
        }
        if (this.findAtNextLevel(root, showList, longNumber, focusId)) {
            showList.addAll(root.getChildren());
        } else {
            for (DimensionTree child : root.getChildren()) {
                if (longNumber.startsWith(((DimensionNode)child.getData()).getLongNumber())) {
                    this.searchByLongNumberAndExpandToList((DimensionTree<String, DimensionNode>)child, showList, longNumber, focusId);
                    continue;
                }
                showList.add((DimensionTree<String, DimensionNode>)child);
            }
        }
    }

    private boolean findAtCurrentLevel(DimensionTree<String, DimensionNode> root, List<DimensionTree<String, DimensionNode>> showList, String longNumber, Map<String, Integer> focusId) {
        if (longNumber.equalsIgnoreCase(((DimensionNode)root.getData()).getLongNumber())) {
            focusId.put("focus", showList.size() - 1);
            return true;
        }
        return false;
    }

    private boolean findAtNextLevel(DimensionTree<String, DimensionNode> root, List<DimensionTree<String, DimensionNode>> showList, String longNumber, Map<String, Integer> focusId) {
        int offsetFocus = 0;
        for (DimensionTree child : root.getChildren()) {
            if (longNumber.equalsIgnoreCase(((DimensionNode)child.getData()).getLongNumber())) {
                focusId.put("focus", showList.size() + offsetFocus);
                return true;
            }
            ++offsetFocus;
        }
        return false;
    }

    private void readyTreeEntriesRows(AbstractFormDataModel formPageModel, String entryName, int size) {
        formPageModel.getDataEntity(true);
        formPageModel.deleteEntryData(entryName);
        formPageModel.beginInit();
        formPageModel.batchCreateNewEntryRow(entryName, size);
        formPageModel.endInit();
    }

    private void fillPageEntries(AbstractFormDataModel dataModel, List<DimensionTree<String, DimensionNode>> treeList, List<String> entryFields, String entryName) {
        this.readyTreeEntriesRows(dataModel, entryName, treeList.size());
        DynamicObjectType type = ((DimensionNode)treeList.get(0).getData()).getDyn().getDynamicObjectType();
        DataEntityPropertyCollection properties = type.getProperties();
        int rowInx = 0;
        for (DimensionTree<String, DimensionNode> treeNode : treeList) {
            DynamicObject rowObj = dataModel.getEntryRowEntity(entryName, rowInx);
            TreeEntryNewUtil.copyDynValue(entryFields, properties, (DimensionNode)treeNode.getData(), rowObj);
            ++rowInx;
        }
    }

    public void expandSearchedMemberRow(AbstractFormPlugin formPlugin, IDataModel dataModel, String entryName, int searchRowIdx) {
        formPlugin.getView().updateView(entryName);
        int[] needExpandIds = TreeEntryEntityUtil.focus(dataModel, searchRowIdx);
        TreeEntryGrid treeEntry = (TreeEntryGrid)formPlugin.getControl(entryName);
        treeEntry.collapse(0);
        treeEntry.expandOne(needExpandIds);
        treeEntry.selectRows(searchRowIdx);
        treeEntry.entryRowClick(Integer.valueOf(searchRowIdx));
    }

    public String setSearchAtFindListIndex(int type) {
        if (this.findList.size() < 1) {
            return ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"DimensionMemberSearch_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        int result = this.searchAtFindListIndex + type;
        if (result >= this.findList.size()) {
            return ResManager.loadKDString((String)"\u5df2\u65e0\u5176\u4ed6\u5339\u914d\u9879\u3002", (String)"DimensionMemberSearch_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (result < 0) {
            this.searchAtFindListIndex = result = 0;
            return ResManager.loadKDString((String)"\u5df2\u65e0\u5176\u4ed6\u5339\u914d\u9879\u3002", (String)"DimensionMemberSearch_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        this.searchAtFindListIndex = result;
        return null;
    }

    public void reSetFindListIndex() {
        this.searchAtFindListIndex = -1;
    }
}

