/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.systemintroduction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.SaveDimMemberHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.dimension.DimMemTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.dimension.imp.DimensionImportHelper;
import kd.fi.bcm.formplugin.dimension.vo.BaseDataSource;

public abstract class AbstractIntroduction {
    protected long modelId;
    protected long dimensionId;
    private static final int NAME_MAX_LENGTH = 200;

    public AbstractIntroduction(long modelId, long dimId) {
        this.modelId = modelId;
        this.dimensionId = dimId;
    }

    abstract DynamicObject[] getNeedDimensionMembers();

    protected Map<String, Map<String, String>> getSystemBasisInfo(DynamicObject[] dys) {
        HashMap<String, List> table2Numbers = new HashMap<String, List>(16);
        for (DynamicObject dy : dys) {
            BaseDataSource source;
            String index = dy.getString("source");
            if (!StringUtils.isNotEmpty((String)index) || (source = DimensionImportHelper.getSourceByIndex(index)) == null || !StringUtils.isNotEmpty((String)source.getEntityNum())) continue;
            table2Numbers.computeIfAbsent(source.getEntityNum(), v -> new ArrayList(10)).add(dy.getString("number"));
        }
        HashMap<String, Map<String, String>> ans = new HashMap<String, Map<String, String>>(16);
        for (Map.Entry stringListEntry : table2Numbers.entrySet()) {
            QFBuilder qfNumber = new QFBuilder("number", "in", stringListEntry.getValue());
            qfNumber.and("status", "=", (Object)"C").add("enable", "=", (Object)"1");
            DynamicObjectCollection dysFormPlatForm = QueryServiceHelper.query((String)((String)stringListEntry.getKey()), (String)"number,name", (QFilter[])qfNumber.toArray());
            for (DynamicObject dy : dysFormPlatForm) {
                HashMap<String, String> ansEle = new HashMap<String, String>(8);
                ansEle.put("name", dy.getString("name"));
                ans.put(dy.getString("number"), ansEle);
            }
        }
        return ans;
    }

    protected int compareAndUpdate(DynamicObject[] dys, Map<String, Map<String, String>> routeNumber) {
        HashSet<Long> updateList = new HashSet<Long>(16);
        ArrayList<DynamicObject> updateDys = new ArrayList<DynamicObject>(10);
        HashMap<Long, String> nameMap = new HashMap<Long, String>(16);
        String entityName = dys[0].getDynamicObjectType().getName();
        if (!CollectionUtils.isEmpty(routeNumber)) {
            for (DynamicObject dy : dys) {
                Map<String, String> info = routeNumber.get(dy.getString("number"));
                if (info == null || !StringUtils.isNotEmpty((String)info.get("name"))) continue;
                String name = info.get("name");
                if (dy.getString("name").equals(name) || name.length() > 200) continue;
                nameMap.put((Long)dy.get("id"), dy.getString("name") + "_" + name);
                dy.set("name", (Object)name);
                updateList.add((Long)dy.get("id"));
                updateDys.add(dy);
            }
            if (!updateDys.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])updateDys.toArray(new DynamicObject[0]));
                if (updateList.size() > 0) {
                    List logs = SaveDimMemberHelper.generateDimIntroduceSynchroLog((String)entityName, updateList, nameMap, (long)Long.parseLong(RequestContext.get().getUserId()));
                    SaveDimMemberHelper.batchInsertDimMemberModifyLog((List)logs);
                }
                this.syncShareNode(entityName, updateDys);
            }
        }
        return updateDys.size();
    }

    protected QFBuilder getSystemTypeOfBcmTreeMember() {
        QFBuilder qf = new QFBuilder("model.id", "=", (Object)this.modelId);
        qf.add("dimension.id", "=", (Object)this.dimensionId);
        qf.add("storagetype", "!=", (Object)"3");
        qf.add("issysmember", "=", (Object)DimMemTypeEnum.IMPORTMEM.getIndex());
        return qf;
    }

    @Deprecated
    public void writeLog(String opName, String opDescriotion, String entityNumber) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)opDescriotion, (Long)this.modelId, (String)entityNumber);
        logService.addLog(logInfo);
    }

    protected void syncShareNode(String entityName, List<DynamicObject> updateDys) {
        for (DynamicObject obj : updateDys) {
            QFilter filter = new QFilter("model", "=", (Object)this.modelId);
            filter.and(new QFilter("copyfrom", "=", (Object)obj.getLong("id")));
            Set<Long> shareNodeIds = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filter}).stream().map(s -> s.getLong("id")).collect(Collectors.toSet());
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            ArrayList shareNodes = new ArrayList(shareNodeIds.size());
            shareNodeIds.forEach(id -> {
                DynamicObject node = BusinessDataReader.loadSingle((Object)id, (DynamicObjectType)dataEntityType);
                node.set("name", obj.get("name"));
                if ("bcm_entitymembertree".equals(entityName)) {
                    DynamicObjectCollection storageRecord = obj.getDynamicObjectCollection("namechangerds");
                    DynamicObjectCollection nameRecords = node.getDynamicObjectCollection("namechangerds");
                    nameRecords.clear();
                    for (DynamicObject s : storageRecord) {
                        DynamicObject newRow = nameRecords.addNew();
                        newRow.set("namerds", s.get("namerds"));
                        newRow.set("simplenamerds", (Object)s.getString("simplenamerds"));
                        newRow.set("nameeffdate", (Object)s.getDate("nameeffdate"));
                        newRow.set("nameexpdate", (Object)s.getDate("nameexpdate"));
                        newRow.set("namemodifytime", (Object)s.getDate("namemodifytime"));
                        newRow.set("namemodifier", s.get("namemodifier"));
                        newRow.set("seq", (Object)s.getInt("seq"));
                    }
                    node.set("namechangerds", (Object)nameRecords);
                }
                shareNodes.add(node);
            });
            if (shareNodes.isEmpty()) continue;
            SaveServiceHelper.save((DynamicObject[])shareNodes.toArray(new DynamicObject[0]));
        }
    }
}

