/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.systemintroduction;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.formplugin.dimension.systemintroduction.AbstractIntroduction;

public class CurrencyIntroduction
extends AbstractIntroduction {
    protected String syncField = "number,name";

    public CurrencyIntroduction(long modelId, long dimId) {
        super(modelId, dimId);
    }

    @Override
    DynamicObject[] getNeedDimensionMembers() {
        String entityName = "bcm_currencymembertree";
        return BusinessDataServiceHelper.load((String)entityName, (String)this.syncField, (QFilter[])this.getSystemTypeOfBcmTreeMember().toArray());
    }

    @Override
    public Map<String, Map<String, String>> getSystemBasisInfo(DynamicObject[] dys) {
        Set bcmNumber = Arrays.stream(dys).map(x -> x.getString("number")).collect(Collectors.toSet());
        String selectFields_A = "number,name";
        QFilter idQf = new QFilter("id", "!=", (Object)0L);
        DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bd_currency", (String)selectFields_A, (QFilter[])new QFilter[]{idQf});
        HashMap<String, String> curryFromPlatform = new HashMap<String, String>(16);
        for (DynamicObject account : accounts) {
            curryFromPlatform.put(account.getString("number"), account.getString("name"));
        }
        HashMap<String, Map<String, String>> routeNumber = new HashMap<String, Map<String, String>>(16);
        for (String number : bcmNumber) {
            String name = (String)curryFromPlatform.get(number);
            if (name == null) continue;
            HashMap<String, String> ele = new HashMap<String, String>(8);
            ele.put("name", name);
            routeNumber.put(number, ele);
        }
        return routeNumber;
    }

    @Override
    protected int compareAndUpdate(DynamicObject[] dys, Map<String, Map<String, String>> routeNumber) {
        return super.compareAndUpdate(dys, routeNumber);
    }
}

