/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.systemintroduction;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bcm.formplugin.dimension.systemintroduction.AbstractIntroduction;
import kd.fi.bcm.formplugin.dimension.systemintroduction.AccountIntroduction;
import kd.fi.bcm.formplugin.dimension.systemintroduction.CurrencyIntroduction;
import kd.fi.bcm.formplugin.dimension.systemintroduction.ICCompanyIntroduction;
import kd.fi.bcm.formplugin.dimension.systemintroduction.OrgIntroduction;
import kd.fi.bcm.formplugin.dimension.systemintroduction.UserDefinedIntroduction;

public class IntroductionContext {
    private long dimensionId;
    private String entityName;
    private long modelId;
    private AbstractIntroduction introduction;

    public IntroductionContext(long dimId, String aEntityName, long aModelId) {
        this.dimensionId = dimId;
        this.entityName = aEntityName;
        this.modelId = aModelId;
        if ("bcm_userdefinedmembertree".equals(this.entityName)) {
            this.introduction = new UserDefinedIntroduction(this.modelId, this.dimensionId);
        } else if ("bcm_icmembertree".equals(this.entityName)) {
            this.introduction = new ICCompanyIntroduction(this.modelId, this.dimensionId);
        } else if ("bcm_entitymembertree".equals(this.entityName)) {
            this.introduction = new OrgIntroduction(this.modelId, this.dimensionId);
        } else if ("bcm_accountmembertree".equals(this.entityName)) {
            this.introduction = new AccountIntroduction(this.modelId, this.dimensionId);
        } else if ("bcm_currencymembertree".equals(this.entityName)) {
            this.introduction = new CurrencyIntroduction(this.modelId, this.dimensionId);
        }
    }

    public int doIntroduction() {
        DynamicObject[] dys;
        if (this.introduction != null && (dys = this.introduction.getNeedDimensionMembers()).length > 0) {
            Map<String, Map<String, String>> routeMap = this.introduction.getSystemBasisInfo(dys);
            return this.introduction.compareAndUpdate(dys, routeMap);
        }
        return 0;
    }

    public void setDimensionId(long dimensionId) {
        this.dimensionId = dimensionId;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void setModelId(long modelId) {
        this.modelId = modelId;
    }

    public void setIntroduction(AbstractIntroduction introduction) {
        this.introduction = introduction;
    }

    public AbstractIntroduction getIntroduction() {
        return this.introduction;
    }
}

