/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.systemintroduction;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.SaveDimMemberHelper;
import kd.fi.bcm.formplugin.dimension.systemintroduction.AbstractIntroduction;

public class OrgIntroduction
extends AbstractIntroduction {
    protected String syncField = "id,name,number,simplename,storagetype,namechangerds.seq,namechangerds.namerds,namechangerds.simplenamerds,namechangerds.nameeffdate,namechangerds.nameexpdate,namechangerds.namemodifier,namechangerds.namemodifytime";

    public OrgIntroduction(long modelId, long dimId) {
        super(modelId, dimId);
    }

    @Override
    DynamicObject[] getNeedDimensionMembers() {
        String entityName = "bcm_entitymembertree";
        return BusinessDataServiceHelper.load((String)entityName, (String)this.syncField, (QFilter[])this.getSystemTypeOfBcmTreeMember().toArray());
    }

    @Override
    public Map<String, Map<String, String>> getSystemBasisInfo(DynamicObject[] dys) {
        Set bcmNumber = Arrays.stream(dys).map(x -> x.getString("number")).collect(Collectors.toSet());
        QFilter orgNumber = new QFilter("org.number", "in", bcmNumber);
        QFilter orgSimpleFilter = new QFilter("number", "in", bcmNumber);
        List orgName = OrgViewServiceHelper.getOrgViewByFilter((QFilter[])orgNumber.toArray());
        List orgSimpleName = QueryDimensionServiceHelper.getOrgByFilter((QFilter[])orgSimpleFilter.toArray());
        Map<String, Integer> number2NameInfoIndex = this.getNumberIndex(orgName);
        Map<String, Integer> number2SimpleNameInfoIndex = this.getNumberIndex(orgSimpleName);
        HashMap<String, Map<String, String>> routeNumber = new HashMap<String, Map<String, String>>(16);
        for (String number : bcmNumber) {
            String nameFromPlatForm = "";
            Integer nameIndex = number2NameInfoIndex.get(number);
            if (nameIndex != null) {
                nameFromPlatForm = (String)((Map)orgName.get(nameIndex)).get("name");
            }
            String sNameFromPlatForm = "";
            Integer sNameIndex = number2SimpleNameInfoIndex.get(number);
            if (sNameIndex != null) {
                sNameFromPlatForm = (String)((Map)orgSimpleName.get(sNameIndex)).get("simplename");
            }
            HashMap<String, String> infoOfSingleMem = new HashMap<String, String>(8);
            infoOfSingleMem.put("name", nameFromPlatForm);
            infoOfSingleMem.put("simplename", sNameFromPlatForm);
            routeNumber.put(number, infoOfSingleMem);
        }
        return routeNumber;
    }

    private Map<String, Integer> getNumberIndex(List<Map<String, String>> orgInfoList) {
        HashMap<String, Integer> ans = new HashMap<String, Integer>(16);
        int i = 0;
        for (Map<String, String> orgInfo : orgInfoList) {
            String number = orgInfo.get("number");
            ans.put(number, i);
            ++i;
        }
        return ans;
    }

    @Override
    public int compareAndUpdate(DynamicObject[] dys, Map<String, Map<String, String>> routeNumber) {
        Date now = TimeServiceHelper.now();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        ArrayList<DynamicObject> toUpdate = new ArrayList<DynamicObject>(dys.length);
        HashMap<Long, String> nameMap = new HashMap<Long, String>(16);
        for (DynamicObject dynamicObject : dys) {
            String name;
            String number = dynamicObject.getString("number");
            if (!this.propertyIsChanged(routeNumber, number, name = dynamicObject.getString("name"))) continue;
            DynamicObjectCollection namechangerds = dynamicObject.getDynamicObjectCollection("namechangerds");
            Date nameexpDate = ((DynamicObject)namechangerds.get(namechangerds.size() - 1)).getDate("nameeffdate");
            String newName = routeNumber.get(number).get("name");
            String newSName = routeNumber.get(number).get("simplename");
            nameMap.put(dynamicObject.getLong("id"), name + "_" + newName);
            if (nameexpDate.compareTo(now) > 0) continue;
            dynamicObject.set("name", (Object)newName);
            dynamicObject.set("simplename", (Object)newSName);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String stringNowDate = df.format(now);
            String stringNameexpDate = df.format(nameexpDate);
            if (stringNameexpDate.equals(stringNowDate)) {
                DynamicObject dynamicObject1 = (DynamicObject)namechangerds.get(namechangerds.size() - 1);
                dynamicObject1.set("namerds", (Object)newName);
                dynamicObject1.set("simplenamerds", (Object)newSName);
                dynamicObject1.set("namemodifier", (Object)RequestContext.get().getCurrUserId());
                dynamicObject1.set("namemodifytime", (Object)now);
            } else {
                DynamicObject dynamicObject2 = namechangerds.addNew();
                dynamicObject2.set("namerds", (Object)newName);
                dynamicObject2.set("simplenamerds", (Object)newSName);
                dynamicObject2.set("nameeffdate", (Object)now);
                dynamicObject2.set("namemodifier", (Object)RequestContext.get().getCurrUserId());
                dynamicObject2.set("namemodifytime", (Object)now);
                dynamicObject2.set("seq", (Object)(namechangerds.size() + 1));
                DynamicObject dynamicObject3 = (DynamicObject)namechangerds.get(namechangerds.size() - 2);
                dynamicObject3.set("nameexpdate", (Object)calendar.getTime());
                dynamicObject3.set("namemodifier", (Object)RequestContext.get().getCurrUserId());
                dynamicObject3.set("namemodifytime", (Object)now);
            }
            toUpdate.add(dynamicObject);
        }
        if (toUpdate.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])toUpdate.toArray(new DynamicObject[0]));
            List logs = SaveDimMemberHelper.generateDimIntroduceSynchroLog((String)"bcm_entitymembertree", nameMap.keySet(), nameMap, (long)Long.parseLong(RequestContext.get().getUserId()));
            SaveDimMemberHelper.batchInsertDimMemberModifyLog((List)logs);
            ArrayList<DynamicObject> icUpdate = new ArrayList<DynamicObject>(toUpdate.size());
            ArrayList<DynamicObject> myOrgUpdate = new ArrayList<DynamicObject>(toUpdate.size());
            QFilter filter1 = new QFilter("model.id", "=", (Object)this.modelId);
            for (DynamicObject entity : toUpdate) {
                DynamicObject myOrgEntity;
                QFilter filter2 = new QFilter("number", "=", (Object)entity.getString("number"));
                DynamicObject icEntity = BusinessDataServiceHelper.loadSingle((String)"bcm_icmembertree", (String)"id,name,number,modifier,modifytime", (QFilter[])new QFilter[]{filter1, filter2});
                if (icEntity != null) {
                    icEntity.set("name", (Object)entity.getString("name"));
                    icEntity.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    icEntity.set("modifytime", (Object)TimeServiceHelper.now());
                    icUpdate.add(icEntity);
                }
                if ((myOrgEntity = BusinessDataServiceHelper.loadSingle((String)"bcm_mycompanymembertree", (String)"id,name,number,modifier,modifytime", (QFilter[])new QFilter[]{filter1, filter2})) == null) continue;
                myOrgEntity.set("name", (Object)entity.getString("name"));
                myOrgEntity.set("modifier", (Object)RequestContext.get().getCurrUserId());
                myOrgEntity.set("modifytime", (Object)TimeServiceHelper.now());
                myOrgUpdate.add(myOrgEntity);
            }
            if (icUpdate.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])icUpdate.toArray(new DynamicObject[0]));
            }
            if (myOrgUpdate.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])myOrgUpdate.toArray(new DynamicObject[0]));
            }
            this.syncShareNode("bcm_entitymembertree", toUpdate);
        }
        return toUpdate.size();
    }

    private boolean propertyIsChanged(Map<String, Map<String, String>> routeNumber, String number, String name) {
        Map<String, String> infos = routeNumber.get(number);
        String sourceName = infos.get("name");
        return StringUtils.isNotEmpty((String)sourceName) && !sourceName.equals(name);
    }
}

