/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.model.ChangeTypeModel;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.util.TreeEntryEntityUtil;

public class DimensionUtil {
    private static String[] fieldmappeds = new String[]{"dim1", "dim2", "dim3", "dim4", "dim5", "dim6"};

    public static String search(String selectField, String filter, Object filvalue, String form) {
        String selectFields = selectField;
        QFilter fmodelid = new QFilter(filter, "=", filvalue);
        QFilter[] filters = new QFilter[]{fmodelid};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"DimMetaUtil", (String)form, (String)selectFields, (QFilter[])filters, null);
        String result = "";
        if (dcs != null && dcs.size() > 0) {
            result = String.valueOf(((DynamicObject)dcs.get(0)).get(0));
        }
        return result;
    }

    public static boolean isExistTemplate(long dimId) {
        boolean is = false;
        long mid = QueryDimensionServiceHelper.getMsgByDimId((Object)dimId).getLong("model");
        QFilter fmodelid = new QFilter("model", "=", (Object)mid);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])new QFilter[]{fmodelid});
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DynamicObject dd : dcs) {
            ids.add(dd.getLong("id"));
        }
        DynamicObject[] oo = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_templateentity"));
        TemplateModel template = new TemplateModel();
        for (DynamicObject tem : oo) {
            template.loadDynaObj2Model(tem);
            boolean bl = is = template.getViewPointDimensionEntries().stream().anyMatch(p -> p.getDimension().getId() == dimId) || template.getPageDimensionEntries().stream().anyMatch(p -> p.getDimension().getId() == dimId) || template.getAreaRangeEntries().stream().anyMatch(p -> p.getColDimEntries().stream().anyMatch(c -> c.getDimension().getId() == dimId) || p.getRowDimEntries().stream().anyMatch(r -> r.getDimension().getId() == dimId));
            if (is) break;
        }
        return is;
    }

    public static boolean isExpand2SecondLevel(String membermodel) {
        boolean is = false;
        if (membermodel.equals("bcm_entitymembertree") || membermodel.equals("bcm_accountmembertree") || membermodel.equals("bcm_changetypemembertree") || membermodel.equals("bcm_userdefinedmembertree")) {
            is = true;
        }
        return is;
    }

    public static boolean isExpand2SecondLevel4MultiMemberF7(String membermodel) {
        boolean is = false;
        if (membermodel.equals("bcm_entitymembertree") || membermodel.equals("bcm_accountmembertree") || membermodel.equals("bcm_changetypemembertree") || membermodel.equals("bcm_icmembertree") || membermodel.equals("bcm_userdefinedmembertree")) {
            is = true;
        }
        return is;
    }

    public static boolean isViable(String modelId) {
        String selectFields = "id";
        QFilter fmodelid = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter fmodelid2 = new QFilter("issysdimension", "=", (Object)"0");
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"DimMetaUtil", (String)"bcm_dimension", (String)selectFields, (QFilter[])filters, null);
        boolean is = false;
        if (dcs.size() < 6) {
            is = true;
        }
        return is;
    }

    public static String getMappedSeq(String modelId) {
        String selectFields = "fieldmapped";
        QFilter fmodelid = new QFilter("model.id", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter fmodelid2 = new QFilter("issysdimension", "=", (Object)"0");
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        DynamicObject[] dcs = (DynamicObject[])QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])filters).toArray((Object[])new DynamicObject[0]);
        String fieldmapped = "dim1";
        HashSet<String> mapSet = new HashSet<String>();
        if (dcs != null && dcs.length > 0) {
            for (DynamicObject dynamicObject : dcs) {
                mapSet.add(dynamicObject.getString("fieldmapped"));
            }
            for (String string : fieldmappeds) {
                if (mapSet.contains(string)) continue;
                fieldmapped = string;
                break;
            }
        }
        return fieldmapped;
    }

    public static Object getOrgCurrency(DynamicObject currency, Long orgId, Long yearId, Long periodId) {
        if (CurrencyEnum.DC.number.equals(currency.getString("number")) || CurrencyEnum.EC.number.equals(currency.getString("number"))) {
            DynamicObject dycurrency = OrgCurrencyServiceHelper.getCurrencyDynById((Long)orgId, (Long)yearId, (Long)periodId);
            Optional.ofNullable(dycurrency).orElseThrow(() -> new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u201c%s\u201d\u6ca1\u6709\u9ed8\u8ba4\u5e01\u79cd\u3002", (String)"DimensionUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgId)));
            return dycurrency.get("id");
        }
        return currency.get("id");
    }

    public static Map<Long, DynamicObject> getCurrencyDynasByModelId(long modelid, Set<Long> orgrange, Long yearId, Long periodId) {
        HashMap<Long, DynamicObject> orgCurr = new HashMap<Long, DynamicObject>();
        QFilter modelFilter = new QFilter("model", "=", (Object)modelid);
        HashMap<Long, String> orgMap = new HashMap<Long, String>();
        DynamicObjectCollection orgCurrencys = OrgCurrencyServiceHelper.getOrgModelAndCurrency(orgrange, (Long)yearId, (Long)periodId);
        for (DynamicObject orgCurrency : orgCurrencys) {
            orgMap.put(orgCurrency.getLong("id"), orgCurrency.getString("currency.number"));
        }
        if (orgMap.isEmpty()) {
            return orgCurr;
        }
        HashMap<String, DynamicObject> currencyMap = new HashMap<String, DynamicObject>(16);
        QFilter numberFilter = new QFilter("number", "in", orgMap.values());
        Collection dyCurrencyCol = BusinessDataServiceHelper.loadFromCache((String)"bcm_currencymembertree", (String)"id,number", (QFilter[])new QFilter[]{modelFilter, numberFilter}).values();
        for (DynamicObject item : dyCurrencyCol) {
            currencyMap.put(item.getString("number"), item);
        }
        if (currencyMap.isEmpty()) {
            return orgCurr;
        }
        Long orgId = 0L;
        for (Map.Entry orgEntry : orgMap.entrySet()) {
            orgId = (Long)orgEntry.getKey();
            if (orgCurr.containsKey(orgId) || currencyMap.get(orgEntry.getValue()) == null) continue;
            orgCurr.put(orgId, (DynamicObject)currencyMap.get(orgEntry.getValue()));
        }
        return orgCurr;
    }

    public static long getIdByNum(String entity, long modelId, String number) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model.id", "=", (Object)modelId);
        qfBuilder.add("number", "=", (Object)number);
        DynamicObject dy = QueryServiceHelper.queryOne((String)entity, (String)"id", (QFilter[])qfBuilder.toArray());
        if (dy == null) {
            return 0L;
        }
        return dy.getLong("id");
    }

    public static int getDSeq(long id, String entity) {
        QFilter filter = new QFilter("parent", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)DimensionUtil.class.getName(), (String)entity, (String)"dseq", (QFilter[])filters, (String)"dseq");
        if (dcs != null) {
            if (dcs.size() == 0) {
                return 1;
            }
            return ((DynamicObject)dcs.get(dcs.size() - 1)).getInt("dseq") + 1;
        }
        return 1;
    }

    public static void initModelAndDimension(DynamicObject dy, String number, long modelId) {
        DynamicObject modelOb = BusinessDataServiceHelper.newDynamicObject((String)"bcm_model");
        DynamicObject dimensionOb = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dimension");
        modelOb.set("id", (Object)modelId);
        String selectFields = "id";
        QFilter filter1 = new QFilter("number", "=", (Object)number);
        QFilter filter2 = new QFilter("model.id", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{filter1, filter2};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)DimensionUtil.class.getName(), (String)"bcm_dimension", (String)selectFields, (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() == 1) {
            String dimensionId = ((DynamicObject)dcs.get(0)).getString("id");
            dimensionOb.set("id", (Object)dimensionId);
        }
        dy.set("model", (Object)modelOb);
        dy.set("dimension", (Object)dimensionOb);
    }

    public static String getDimMembEntityNumByDimNum(String dimNum) {
        return ChkCheckServiceHelper.getDimMembEntityNumByDimNum((String)dimNum);
    }

    public static boolean isUserDefinedDim(String dimNum) {
        return DimensionUtil.getDimMembEntityNumByDimNum(dimNum).equals("bcm_userdefinedmembertree");
    }

    public static Map<Object, Object> getDimMap(String entity, String key, String value, long modelid) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelid);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        try (DataSet col = QueryServiceHelper.queryDataSet((String)"queryDimension", (String)entity, (String)(key + "," + value), (QFilter[])new QFilter[]{qFilter}, null);){
            while (col.hasNext()) {
                Row row = col.next();
                map.put(row.get(key), row.get(value));
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return map;
    }

    public static Map<String, String> getDimIgnoreCaseMapByModelId(long modelId) {
        HashMap<String, String> dimIgnoreCaseMap = new HashMap<String, String>(16);
        Map map = MemberReader.getDimDyoByModelId((long)modelId);
        if (map == null) {
            return null;
        }
        for (Map.Entry entry : map.entrySet()) {
            String number = ((DynamicObject)entry.getValue()).getString("number");
            dimIgnoreCaseMap.put(number.toLowerCase(Locale.ENGLISH), number);
        }
        return dimIgnoreCaseMap;
    }

    public static List<DynamicObject> getOrderedMembers(long modelId, String entityNum, Set<Long> filterIds) {
        DynamicObject[] members = BusinessDataServiceHelper.load((String)entityNum, (String)"id,number,parent.id,isleaf,isadjust,useyear,dseq", (QFilter[])new QFilter("model.id", "=", (Object)modelId).toArray(), (String)"level,dseq");
        LinkedHashMap<Long, List<DynamicObject>> parentMap = new LinkedHashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject member : members) {
            long parentId = member.getLong("parent.id");
            parentMap.computeIfAbsent(parentId, k -> new LinkedList());
            ((List)parentMap.get(parentId)).add(member);
        }
        LinkedList<DynamicObject> afterFilter = new LinkedList<DynamicObject>();
        DimensionUtil.getAllChildren(parentMap, 0L, afterFilter, filterIds);
        return afterFilter;
    }

    public static List<Long> getOrderedMemberIds(long modelId, String entityNum, Set<Long> filterIds) {
        DynamicObject[] members = BusinessDataServiceHelper.load((String)entityNum, (String)"id,number,parent.id,isleaf,isadjust,useyear,dseq", (QFilter[])new QFilter("model.id", "=", (Object)modelId).toArray(), (String)"level,dseq");
        LinkedHashMap<Long, List<DynamicObject>> parentMap = new LinkedHashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject member : members) {
            long parentId = member.getLong("parent.id");
            parentMap.computeIfAbsent(parentId, k -> new LinkedList());
            ((List)parentMap.get(parentId)).add(member);
        }
        LinkedList<DynamicObject> afterFilter = new LinkedList<DynamicObject>();
        DimensionUtil.getAllChildren(parentMap, 0L, afterFilter, filterIds);
        return afterFilter.stream().map(after -> after.getLong("id")).collect(Collectors.toList());
    }

    private static void getAllChildren(Map<Long, List<DynamicObject>> parentMap, long parent, List<DynamicObject> result, Set<Long> filterIds) {
        List<DynamicObject> members = parentMap.get(parent);
        if (filterIds.size() == result.size() || members == null) {
            return;
        }
        for (DynamicObject member : members) {
            if (filterIds.contains(member.getLong("id"))) {
                result.add(member);
            }
            if (member.getBoolean("isleaf")) continue;
            DimensionUtil.getAllChildren(parentMap, member.getLong("id"), result, filterIds);
        }
    }

    public static boolean isAddGeneralFY(String algoKey, String actionName, long id) {
        String selectFields = "parent,number";
        QFilter fdimenId = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{fdimenId};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)algoKey, (String)"bcm_fymembertree", (String)selectFields, (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() == 1) {
            String number = ((DynamicObject)dcs.get(0)).getString("number");
            if ("Year".equals(number)) {
                return true;
            }
            selectFields = "number,level";
            fdimenId = new QFilter("id", "=", (Object)LongUtil.toLong((Object)((DynamicObject)dcs.get(0)).get("parent")));
            filters = new QFilter[]{fdimenId};
            dcs = QueryServiceHelper.query((String)algoKey, (String)"bcm_fymembertree", (String)selectFields, (QFilter[])filters, (String)"");
            if (dcs != null && dcs.size() == 1) {
                int level = ((DynamicObject)dcs.get(0)).getInt("level");
                if (level == 1) {
                    if ("baritemaddsub".equals(actionName)) {
                        return !"AllYear".equals(number);
                    }
                    if ("baritemaddlevel".equals(actionName) && "AllYear".equals(number)) {
                        return true;
                    }
                } else if (level == 2 && !(number = ((DynamicObject)dcs.get(0)).getString("number")).startsWith("FY") && !"AllYear".equals(number)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static String getParentid(String model, String entityform, String number, String algoNmae) {
        String parentid = "";
        String selectFields = "id";
        QFilter filter1 = new QFilter("number", "=", (Object)number);
        QFilter filter2 = new QFilter("model.id", "=", (Object)LongUtil.toLong((Object)model));
        QFilter[] filters = new QFilter[]{filter1, filter2};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)algoNmae, (String)entityform, (String)selectFields, (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() == 1) {
            parentid = ((DynamicObject)dcs.get(0)).getString("id");
        }
        return parentid;
    }

    public static List<String> getpks(String nodeId, String algoName) {
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)algoName, (String)"bcm_entitymembertree", (String)"id,parent", null, null);
        ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>();
        for (DynamicObject a : dcs) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", String.valueOf(a.get(0)));
            map.put("parent", String.valueOf(a.get(1)));
            treeList.add(map);
        }
        ArrayList<String> allnodelist = new ArrayList<String>();
        allnodelist.add(nodeId);
        return DimensionUtil.queryAllChildNodeList(nodeId, treeList, allnodelist);
    }

    public static List<String> queryAllChildNodeList(String nodeid, List<Map<String, String>> treeList, List<String> allnodelist) {
        for (Map<String, String> m : treeList) {
            if (!m.get("parent").equals(nodeid)) continue;
            allnodelist.add(m.get("id"));
            DimensionUtil.queryAllChildNodeList(m.get("id"), treeList, allnodelist);
        }
        return allnodelist;
    }

    public static DynamicObjectCollection queryFYFirstDay(String className, long modelId) {
        String selectFields = "startfy,beginyearofmonth,beginperiod";
        QFilter filter1 = new QFilter("id", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{filter1};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)className, (String)"bcm_model", (String)selectFields, (QFilter[])filters, (String)"");
        return dcs;
    }

    public static void initBizChangeType(Long modelId, ComboEdit comboEdit) {
        Map invChangetypeModel = InvestServiceHelper.getInvChangetypeModel((Long)modelId);
        List dcs = invChangetypeModel.values().stream().filter(x -> !TreeEntryEntityUtil.isContainsNumber(x.number()) && (x.GetIsdefault() || !"0".equals(x.change()))).collect(Collectors.toList());
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invchangetype");
        dy.set("name", (Object)ResManager.getLocaleString((String)"\u7981\u7528", (String)"OpItemEnum_26", (String)"fi-bcm-formplugin"));
        dy.set("number", (Object)"BD000");
        dcs.add(new ChangeTypeModel(dy));
        if (dcs.size() > 0) {
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(dcs.size());
            for (ChangeTypeModel dynamicObject : dcs) {
                String name = dynamicObject.name();
                String number = dynamicObject.number();
                items.add(new ComboItem(new LocaleString(name), number));
            }
            comboEdit.setComboItems(items);
        }
    }

    public static String getMemberName(String entityName) {
        String member = "bcm_icmembertree".equals(entityName) || "bcm_icmember".equals(entityName) ? "bcm_intercompanymember" : entityName.substring(0, entityName.length() - 4);
        if (!member.endsWith("member")) {
            member = member + "member";
        }
        return member;
    }

    public static String checkNumber(String number) {
        String regEx = "^(?!_)[a-zA-Z0-9_.]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        if (!matcher.matches()) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DefinedPropertyEdit_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (number.contains("..") || number.startsWith(".")) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DefinedPropertyEdit_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }
}

