/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.Lang;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.UpgradeStatusUtil;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.util.DynamicEnum;
import kd.fi.bcm.common.util.PeriodUtils;

public class ModelUtil {
    private static final String RPT = "rpt";
    private static final String APP_HOME = "apphome";
    private static final String REPORT_TYPE = "ReportType";
    private static final String PARENTFORMID = "parentFormId";
    public static final Set<String> CM_VIEW_LIST = Sets.newHashSet((Object[])new String[]{"bcm_report_list", "bcm_report_search", "bcm_user_assignperm", "bcm_user_assignrole", "bcm_systemperm_report", "bcm_roleorguser", "report_card_financialdata", "perm_user_assigndisfun", "bcm_functionperm_log", "bcm_chkspeechlist", "bcm_datacollection", "bcm_analyticssolutiondata"});
    public static final Set<String> DIM_MAG_VIEW = Sets.newHashSet((Object[])new String[]{"bcm_dimensionmanager", "bcm_memreferreport", "bcm_sycndimensionmember", "bcm_bdmapping", "bcm_extendsmodel_list", "bcm_extendsmanager"});
    private static final Map<String, String> PAGE_MAP = new HashMap<String, String>(10);
    private static final Map<String, String> PAGE_CHILD2PAR;

    public static Set<String> getAllowPageList() {
        if (ConfigServiceHelper.getGlobalBoolParam((String)"isAllowCmModel")) {
            return CM_VIEW_LIST;
        }
        return new HashSet<String>(0);
    }

    public static ApplicationTypeEnum queryApp(IFormView view) {
        ApplicationTypeEnum application = ApplicationTypeEnum.CM;
        if (view == null) {
            return application;
        }
        String formNumber = ((FormView)view).getFormId();
        String appId = view.getFormShowParameter().getAppId();
        if ("far_cardapphome_bcm".equals(formNumber)) {
            return ApplicationTypeEnum.FAR;
        }
        if (StringUtils.isEmpty((String)appId)) {
            return application;
        }
        return ApplicationTypeEnum.getEnumByNumber((String)appId);
    }

    public static List<QFilter> getModelFilter(IFormView view) {
        String entityName;
        ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{ModelUtil.getModelQfilterByApp(view)});
        QFilter qFilter = view.getFormShowParameter().getCustomParams().containsKey(PARENTFORMID) ? new QFilter("id", "in", (Object)MemberPermHelper.getLimitedModelListByUser((String)((String)view.getFormShowParameter().getCustomParam(PARENTFORMID)), (ApplicationTypeEnum)ModelUtil.queryApp(view))) : new QFilter("id", "in", (Object)MemberPermHelper.getLimitedModelListByUser());
        String string = entityName = view.getParentView() == null ? null : view.getParentView().getEntityId();
        if ("bcm_memberperm_view".equals(view.getEntityId()) && !ConfigServiceHelper.getGlobalBoolParam((String)"isPEnableGrantPerm")) {
            filters.add(qFilter);
            return filters;
        }
        if (DIM_MAG_VIEW.contains(view.getEntityId()) && ConfigServiceHelper.getGlobalBoolParam((String)"isDimLmtAdmin")) {
            filters.add(qFilter);
            return filters;
        }
        if ("bcm_user_assignperm".equals(entityName)) {
            filters.add(qFilter);
            return filters;
        }
        if (!"bcm_card_myvalue".equals(entityName) && !"bcm_upgrademanage".equals(entityName)) {
            filters.add(new QFilter("id", "not in", (Object)UpgradeStatusUtil.getUnUpgradeModels()));
        }
        ModelUtil.addSpecialFilter(view.getEntityId(), qFilter, view);
        QFilter pagePermission = new QFilter("id", "in", (Object)BcmFunPermissionHelper.getEffectiveByPermModel((String)view.getEntityId(), (ApplicationTypeEnum)ModelUtil.queryApp(view)));
        if (ModelUtil.getAllowPageList().contains(view.getEntityId())) {
            QFilter perRoleIds = new QFilter("id", "in", (Object)BcmFunPermissionHelper.getRoleModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)"bcm_model", (ApplicationTypeEnum)ApplicationTypeEnum.CM, (String)view.getEntityId(), (String)"47150e89000000ac"));
            qFilter.or(perRoleIds);
        }
        filters.add(qFilter.or(pagePermission));
        return filters;
    }

    private static void addSpecialFilter(String entryId, QFilter superId, IFormView view) {
        if (PAGE_MAP.containsKey(entryId)) {
            entryId = PAGE_MAP.get(entryId);
        }
        QFilter roleIds = new QFilter("id", "in", (Object)BcmFunPermissionHelper.getRoleModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)"bcm_model", (ApplicationTypeEnum)ModelUtil.queryApp(view), (String)entryId, (String)"47150e89000000ac"));
        superId.or(roleIds);
    }

    public static List<QFilter> getModelFilters(IFormView view) {
        ArrayList<QFilter> qFilterList = ((BasedataEdit)view.getControl("model")).getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList<QFilter>(16);
        }
        QFilter qf = ModelUtil.getModelQfilterByApp(view);
        if (RPT.equals(view.getFormShowParameter().getAppId())) {
            qf = qf.or(REPORT_TYPE, "=", (Object)"1");
        }
        ArrayList<QFilter> modelQFilters = new ArrayList<QFilter>(2);
        modelQFilters.add(qf);
        QFilter upgradedid = new QFilter("id", "in", (Object)UpgradeStatusUtil.getUpgradesModelIds());
        modelQFilters.add(upgradedid);
        QFilter superid = new QFilter("id", "in", (Object)MemberPermHelper.getLimitedModelListByUser());
        modelQFilters.add(superid);
        qFilterList.addAll(modelQFilters);
        return qFilterList;
    }

    public static List<ComboItem> getFYComboItemByCurrentModel(Object modelId) {
        QFilter qcf = new QFilter("model", "=", modelId);
        qcf.and("number", "like", (Object)"FY%");
        DynamicObjectCollection mcs = QueryServiceHelper.query((String)"bcm_fymembertree", (String)"number", (QFilter[])new QFilter[]{qcf}, (String)"dseq");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ArrayList<String[]> keysAndValues = new ArrayList<String[]>(mcs.size());
        boolean language = !Lang.get().equals((Object)Lang.zh_CN) && !Lang.get().equals((Object)Lang.zh_TW);
        for (int i = 0; i < mcs.size(); ++i) {
            String number = ((DynamicObject)mcs.get(i)).getString("number").substring(2);
            String[] keysAndValue = new String[2];
            String year = ResManager.loadKDString((String)"\u5e74", (String)"ModelUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            keysAndValue[0] = language ? number : number + year;
            keysAndValue[1] = number;
            keysAndValues.add(keysAndValue);
        }
        keysAndValues.forEach(new DynamicEnum(items));
        return items;
    }

    public static List<ComboItem> getPeriodComboItemByModel(Object modelId) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ArrayList<String[]> keysAndValues = new ArrayList<String[]>();
        QFilter qcf = new QFilter("model", "=", modelId);
        QFilter qcf2 = new QFilter("number", "like", (Object)"M_M%");
        qcf2.or("number", "like", (Object)"Q_Q%");
        qcf2.or("number", "like", (Object)"HF_HF%");
        DataSet ds = QueryServiceHelper.queryDataSet((String)"bcm", (String)"bcm_periodmembertree", (String)"number,name", (QFilter[])new QFilter[]{qcf, qcf2}, (String)"number");
        for (Row row : ds) {
            String[] keysAndValue = new String[]{row.getString("name"), ModelUtil.getPeriodValue(row.getString("number"))};
            keysAndValues.add(keysAndValue);
        }
        keysAndValues.forEach(new DynamicEnum(items));
        return items;
    }

    private static String getPeriodValue(String number) {
        String pre = "";
        if (number.startsWith("Q_Q")) {
            pre = "Q";
        } else if (number.startsWith("HF_HF")) {
            pre = "HF";
        }
        String temp = PeriodUtils.splitPeriod((String)number)[1];
        if (temp.startsWith("0")) {
            temp = temp.substring(1);
        }
        return pre + temp;
    }

    public static QFilter getModelQfilterByApp(IFormView view) {
        ApplicationTypeEnum application = ModelUtil.queryApp(view);
        QFilter qcf = new QFilter(REPORT_TYPE, "=", (Object)application.getOIndex());
        switch (application) {
            case RPT: {
                qcf = BcmFunPermissionHelper.getRptAdminModelQFilter();
                IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
                if (!ModelUtil.getAllowPageList().contains(view.getEntityId()) && (parentView == null || !ModelUtil.getAllowPageList().contains(parentView.getEntityId()) && !APP_HOME.contains(parentView.getEntityId()))) break;
                qcf.or(new QFilter(REPORT_TYPE, "=", (Object)ApplicationTypeEnum.CM.getOIndex()));
                break;
            }
            case IEP: 
            case DI: {
                qcf = new QFilter(REPORT_TYPE, "=", (Object)ApplicationTypeEnum.CM.getOIndex());
                break;
            }
            case BGM: {
                qcf = new QFilter(REPORT_TYPE, "=", (Object)ApplicationTypeEnum.BGMD.getOIndex());
                break;
            }
            case EB: {
                qcf = new QFilter(REPORT_TYPE, "=", (Object)ApplicationTypeEnum.EB.getOIndex());
                break;
            }
            case BGC: 
            case BGBD: {
                qcf = new QFilter(REPORT_TYPE, "=", (Object)ApplicationTypeEnum.EB.getOIndex()).or(REPORT_TYPE, "=", (Object)ApplicationTypeEnum.BGMD.getOIndex());
                break;
            }
            case AEF: {
                qcf = new QFilter(REPORT_TYPE, "in", Arrays.asList(ApplicationTypeEnum.CM.getOIndex(), ApplicationTypeEnum.RPT.getOIndex(), ApplicationTypeEnum.PUB.getOIndex()));
                break;
            }
        }
        return qcf;
    }

    public static List<Long> getParPermItemModels(String entityName, String appNum, String permItem) {
        HasPermDimObjResult perResult;
        if (PAGE_CHILD2PAR.containsKey(entityName)) {
            entityName = PAGE_CHILD2PAR.get(entityName);
        }
        if ((perResult = PermissionServiceHelper.getHasPermDimObjs((long)RequestContext.get().getCurrUserId(), (String)AppMetadataCache.getAppInfo((String)appNum).getId(), (String)entityName, (String)permItem)).hasAllDimObjPerm()) {
            return new ArrayList<Long>(0);
        }
        return perResult.getHasPermDimObjs();
    }

    public static Set<Long> getHasPermissionModels(IFormView view) {
        if (view == null) {
            return Sets.newHashSet();
        }
        List<QFilter> filters = ModelUtil.getModelFilter(view);
        return QueryServiceHelper.query((String)"bcm_model", (String)"id", (QFilter[])filters.toArray(filters.toArray(new QFilter[0]))).stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
    }

    static {
        PAGE_MAP.put("bcm_bdmapping", "bcm_dimensionmanager");
        PAGE_MAP.put("bcm_sycndimensionmember", "bcm_dimensionmanager");
        PAGE_MAP.put("bcm_showprogress", "bcm_mergecontrollist");
        PAGE_MAP.put("bcm_mergeoperationlog", "bcm_mergecontrollist");
        PAGE_MAP.put("bcm_analyticssolutionlist", "bcm_analyticssolutiondata");
        PAGE_MAP.put("bcm_extendsmodel_list", "bcm_dimensionmanager");
        PAGE_MAP.put("bcm_memreferreport", "bcm_dimensionmanager");
        PAGE_MAP.put("bcm_report_workbenchback", "bcm_report_list");
        PAGE_MAP.put("bcm_formulasreport_list", "bcm_templatelist");
        PAGE_MAP.put("bcm_rptadjust_list_dt", "bcm_rptadjust_list");
        PAGE_MAP.put("bcm_datalocksetting", "bcm_dimensionmanager");
        PAGE_MAP.put("bcm_singleformula", "bcm_templatelist");
        PAGE_MAP.put("bcm_multiformula", "bcm_templatelist");
        PAGE_CHILD2PAR = new HashMap<String, String>(10);
        PAGE_CHILD2PAR.put("bcm_bdmapping", "bcm_dimensionmanager");
    }
}

