/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.util;

import java.util.Comparator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.upgrade.DimensionNode;
import kd.fi.bcm.business.upgrade.DimensionTree;

public class TreeEntryNewUtil {
    public static final String ENTRY_ENTITY = "treeentryentity";
    public static final String SHAREMEMBERPROPSHOW_CHANGETYPE = "sharePop_cache_01";
    public static final String SHAREMEMBERPROPSHOW_NAME = "sharePop_cache_03";
    public static final String SHAREMEMBERPROPSHOW_BIZEFFDATE = "sharePop_cache_02";

    public static void newTreeEntry(IDataModel dataModel, DynamicObjectCollection dync, List<String> entryFields) {
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.deleteEntryData(ENTRY_ENTITY);
        model.getDataEntity(true);
        DimensionTree tree = DimensionNode.createDimTreeWithShareRef((DynamicObject[])((DynamicObject[])dync.toArray((Object[])new DynamicObject[0])));
        if (tree == null) {
            return;
        }
        if (entryFields.contains("longnumber")) {
            DimensionNode.updateLongNumber((DimensionTree)tree);
        }
        List children = tree.getChildren();
        children.sort(Comparator.comparingInt(o -> ((DimensionNode)o.getData()).getDseq()));
        model.beginInit();
        model.batchCreateNewEntryRow(ENTRY_ENTITY, tree.count());
        model.endInit();
        DynamicObjectType type = ((DimensionNode)tree.getData()).getDyn().getDynamicObjectType();
        DataEntityPropertyCollection properties = type.getProperties();
        tree.dfsWithIdx((t, idx) -> {
            DimensionNode node = (DimensionNode)t.getData();
            DynamicObject rowObj = model.getEntryRowEntity(ENTRY_ENTITY, idx.intValue());
            TreeEntryNewUtil.copyDynValue(entryFields, properties, node, rowObj);
        }, Integer.valueOf(0));
        if (dync.size() == 1) {
            model.getEntryRowEntity(ENTRY_ENTITY, 0).set("isgroupnode", (Object)false);
        }
    }

    public static void insertTreeEntry(IDataModel model, DynamicObjectCollection members, List<String> entryFields, int pRow, long pid, String storageType, String entityName) {
        DimensionTree tree = DimensionNode.createDimTreeWithShareRef((DynamicObject[])((DynamicObject[])members.toArray((Object[])new DynamicObject[0])));
        if (tree == null) {
            return;
        }
        DimensionNode rootStoredNode = (DimensionNode)tree.getData();
        DynamicObject rootStoredDyn = rootStoredNode.getDyn();
        List children = tree.getChildren();
        children.sort(Comparator.comparingInt(o -> ((DimensionNode)o.getData()).getDseq()));
        DimensionNode rootSharedNode = new DimensionNode(rootStoredDyn);
        rootSharedNode.setId(pid);
        rootSharedNode.setStorageType(storageType);
        DimensionTree rootSharedTree = new DimensionTree((Object)rootStoredDyn.getString("number"), (Object)rootSharedNode);
        DimensionNode.refChildrenOfDim((DimensionTree)rootSharedTree, (DimensionTree)tree, (int)0, (String)entityName);
        int count = rootSharedTree.count();
        if (count <= 1) {
            return;
        }
        model.getDataEntity(true);
        if (entryFields.contains("longnumber")) {
            DynamicObject pRowEntity = model.getEntryRowEntity(ENTRY_ENTITY, pRow);
            String longnumber = pRowEntity.getString("longnumber");
            ((DimensionNode)rootSharedTree.getData()).setLongNumber(longnumber);
            DimensionNode.updateLongNumber((DimensionTree)rootSharedTree);
        }
        model.beginInit();
        model.batchInsertEntryRow(ENTRY_ENTITY, pRow, count - 1);
        model.endInit();
        DynamicObjectType type = rootStoredDyn.getDynamicObjectType();
        DataEntityPropertyCollection properties = type.getProperties();
        rootSharedTree.dfsWithoutRoot((t, idx) -> {
            DimensionNode node = (DimensionNode)t.getData();
            DynamicObject rowObj = model.getEntryRowEntity(ENTRY_ENTITY, idx.intValue());
            TreeEntryNewUtil.copyDynValue(entryFields, properties, node, rowObj);
        }, Integer.valueOf(++pRow));
    }

    public static void copyDynValue(List<String> entryFields, DataEntityPropertyCollection properties, DimensionNode node, DynamicObject rowObj) {
        DynamicObject dyn = node.getDyn();
        for (String field : entryFields) {
            if ("showdproperty".equals(field)) {
                StringBuilder sb = new StringBuilder();
                for (int i = 1; i <= 10; ++i) {
                    String dpname = (String)((IDataEntityProperty)properties.get((Object)("dpname" + i))).getValueFast((Object)dyn);
                    String dppaname = (String)((IDataEntityProperty)properties.get((Object)("dppaname" + i))).getValueFast((Object)dyn);
                    if (!StringUtils.isNotEmpty((String)dpname) || !StringUtils.isNotEmpty((String)dppaname)) continue;
                    sb.append(dppaname).append(':').append(dpname).append(';');
                }
                rowObj.set(field, (Object)sb.toString());
                continue;
            }
            if ("cycle".equals(field)) {
                rowObj.set("daterangefield_startdate", ((IDataEntityProperty)properties.get((Object)"daterangefield_startdate1")).getValueFast((Object)dyn));
                rowObj.set("daterangefield_enddate", ((IDataEntityProperty)properties.get((Object)"daterangefield_enddate1")).getValueFast((Object)dyn));
                continue;
            }
            if ("memberid".equals(field)) {
                rowObj.set(field, (Object)node.getMemberId());
                continue;
            }
            if ("storagetype".equals(field)) {
                rowObj.set(field, (Object)node.getStorageType());
                continue;
            }
            if ("aggoprt".equals(field)) {
                rowObj.set(field, (Object)node.getAggoprt());
                continue;
            }
            if ("modifytime".equals(field)) {
                rowObj.set(field, (Object)node.getModifyTime());
                continue;
            }
            if ("modifier".equals(field)) {
                rowObj.set(field, (Object)node.getModifier());
                continue;
            }
            if ("longnumber".equals(field)) {
                rowObj.set(field, (Object)node.getLongNumber());
                continue;
            }
            if ("diffstatus".equals(field)) {
                rowObj.set("diffstatus", node.getPropExtend("diffstatus"));
                continue;
            }
            if ("nodetype".equals(field)) {
                rowObj.set(field, (Object)node.getNodeType().getValue());
                continue;
            }
            if ("belongscheme".equals(field)) {
                rowObj.set(field, (Object)node.getDyn().getString("belongscheme"));
                continue;
            }
            rowObj.set(field, ((IDataEntityProperty)properties.get((Object)field)).getValueFast((Object)dyn));
        }
        rowObj.set("id", (Object)node.getId());
        rowObj.set("isgroupnode", (Object)(!node.isLeaf() ? 1 : 0));
        rowObj.set("pid", (Object)node.getParent());
    }
}

