/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimensionnew;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.olap.scale.CurrencyScaleHandler;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.upgrade.DimNodeType;
import kd.fi.bcm.common.enums.AccountDataTypeEnum;
import kd.fi.bcm.common.enums.AccountTypeEnum;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.ExchangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.BlackListUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.dimensionnew.MemberSomeCommonFunEdit;
import kd.fi.bcm.formplugin.dimensionnew.prpertychangeaction.PropertyChangeTips;

public class AccountMemberEdit
extends MemberSomeCommonFunEdit {
    private static final String ACCOUNTSCALE = "accountscale";
    protected static List<String> property = Arrays.asList("aggoprt", "storagetype", "accounttype", "drcrdirect", "datatype", "exchange", "isparticipmerge");
    private static final String[] drcrdNoneArrary = new String[]{"8", "9"};
    private static final String EXISTDATA = "EXISTDATA";

    @Override
    protected String getModelType() {
        return "bcm_accountmember";
    }

    @Override
    protected String getTreeModelType() {
        return "bcm_accountmembertree";
    }

    public void loadData(LoadDataEventArgs e) {
        super.loadData(e);
    }

    @Override
    public void afterLoadData(EventObject e) {
        DimNodeType type;
        super.afterLoadData(e);
        IDataModel iDataModel = this.getModel();
        DynamicObject model = (DynamicObject)iDataModel.getValue("model");
        ArrayList<String> accountList = new ArrayList<String>();
        accountList.add(String.valueOf(iDataModel.getValue("number")));
        Map accountScale = CurrencyScaleHandler.getAccountScale((long)LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID")), accountList);
        if (accountScale.size() != 0) {
            iDataModel.setValue(ACCOUNTSCALE, accountScale.get(accountList.get(0)));
        }
        if ((type = this.getNodeType()) != DimNodeType.STORE) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"advconap3", "currencyrds"});
        }
        HashSet<String> memberSet = new HashSet<String>(1);
        memberSet.add(String.valueOf(iDataModel.getValue("number")));
        Map hasData = OlapServiceHelper.judgeExistMDDataByMember((String)model.getString("number"), (String)SysDimensionEnum.Account.getNumber(), memberSet);
        if (((Boolean)hasData.get(iDataModel.getValue("number"))).booleanValue()) {
            this.getPageCache().put(EXISTDATA, "1");
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ACCOUNTSCALE});
        } else {
            this.getPageCache().put(EXISTDATA, "0");
        }
        if ("1".equals(iDataModel.getValue("storagetype")) || "5".equals(iDataModel.getValue("storagetype"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ACCOUNTSCALE});
            this.getModel().setValue(ACCOUNTSCALE, null);
        }
        if (ModelUtil.queryApp((IFormView)this.getView()) == ApplicationTypeEnum.RPT) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isparticipmerge"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isrelateorg"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isyearendcarried"});
        }
        String accountType = (String)this.getModel().getValue("accounttype");
        Integer level = (Integer)this.getModel().getValue("level");
        if (level != 1) {
            int datatype = Integer.parseInt(this.getModel().getValue("datatype").toString());
            this.lockExchangeByAccountType(accountType, datatype, true);
        }
        iDataModel.setDataChanged(false);
        if (StorageTypeEnum.isShare((String)((String)this.getModel().getValue("storagetype")))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"entryrate"});
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"value"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"value"});
        if (ModelUtil.queryApp((IFormView)this.getView()) == ApplicationTypeEnum.RPT) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isparticipmerge"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isrelateorg"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isyearendcarried"});
        }
        this.setDefaultValue();
        String accountType = (String)this.getModel().getValue("accounttype");
        int datatype = Integer.parseInt(this.getModel().getValue("datatype").toString());
        this.lockExchangeByAccountType(accountType, datatype, false);
        this.addUserdefinedRate();
        IDataModel iDataModel = this.getModel();
        if ("1".equals(iDataModel.getValue("storagetype")) || "5".equals(iDataModel.getValue("storagetype"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ACCOUNTSCALE});
        }
        iDataModel.setDataChanged(false);
    }

    private void setDefaultValue() {
        long id = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("id"));
        QFilter filter = new QFilter("id", "=", (Object)id);
        String selectFields = "number, aggoprt, storagetype, accounttype, drcrdirect, datatype, exchange, isparticipmerge";
        DynamicObject dot = QueryServiceHelper.queryOne((String)"bcm_accountmembertree", (String)selectFields, (QFilter[])new QFilter[]{filter});
        for (String pro : property) {
            this.getModel().setValue(pro, dot.get(pro));
            if (pro.equals("storagetype") && StorageTypeEnum.DYNAMIC.index.equals(dot.get(pro).toString())) {
                this.getModel().setValue(pro, (Object)StorageTypeEnum.STORAGE.index);
                this.getModel().setValue("aggoprt", (Object)AggOprtEnum.ADD.sign);
            }
            if (!pro.equals("storagetype") || !StorageTypeEnum.SHARE.index.equals(dot.get(pro).toString())) continue;
            this.getModel().setValue(pro, (Object)StorageTypeEnum.STORAGE.index);
        }
        if (dot.getString("datatype").equals(DataTypeEnum.ENUMTP.index)) {
            this.initEnumValueCtrl();
            this.getValueItemIdMap();
            Map.Entry firstMap = (Map.Entry)this.indexToIds.entrySet().stream().findFirst().get();
            this.getModel().setValue("value", firstMap.getKey());
            this.getModel().setValue("enumitem", firstMap.getKey());
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"value"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"value"});
        }
        if ("Account".equals(dot.getString("number"))) {
            this.getModel().setValue("storagetype", (Object)2);
            this.getModel().setValue("aggoprt", (Object)1);
            this.getModel().setValue("accounttype", (Object)AccountTypeEnum.UNFINNANCE.getOIndex());
            this.getModel().setValue("drcrdirect", (Object)1);
            this.getModel().setValue("datatype", (Object)0);
        }
    }

    private void addUserdefinedRate() {
        DynamicObject dynamicObject;
        String actionName = (String)this.getView().getFormShowParameter().getCustomParam("actionName");
        String selectId = (String)this.getView().getFormShowParameter().getCustomParam("id");
        QFilter fid = new QFilter("id", "=", (Object)Long.valueOf(selectId));
        if ("baritemaddsub".equals(actionName)) {
            DynamicObject dynamicObject2 = QueryServiceHelper.queryOne((String)"bcm_accountmembertree", (String)"number,accounttype,drcrdirect", (QFilter[])new QFilter[]{fid});
            if ("ExchangeRate".equalsIgnoreCase(dynamicObject2.getString("number"))) {
                this.createNumberName();
            }
        } else if ("baritemaddlevel".equals(actionName) && "ExchangeRate".equalsIgnoreCase((dynamicObject = QueryServiceHelper.queryOne((String)"bcm_accountmembertree", (String)"parent.number", (QFilter[])new QFilter[]{fid})).getString("parent.number"))) {
            this.createNumberName();
        }
    }

    private void createNumberName() {
        Integer newNum = 0;
        String preset = "UserdefinedRate";
        QFilter notPreset = new QFilter("number", "<>", (Object)preset);
        QFilter pnumf = new QFilter("parent.number", "=", (Object)"ExchangeRate");
        QFilter numf = new QFilter("number", "like", (Object)(preset + "%"));
        QFilter modelf = new QFilter("model", "=", (Object)LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID")));
        QFilter[] filters = new QFilter[]{notPreset, pnumf, numf, modelf};
        DynamicObjectCollection last = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)"number", (QFilter[])filters, (String)"dseq desc", (int)1);
        newNum = last == null || last.isEmpty() ? Integer.valueOf(1) : Integer.valueOf(Integer.parseInt(((DynamicObject)last.get(0)).getString("number").replace(preset, "")) + 1);
        this.getModel().setValue("number", (Object)(preset + newNum));
        this.getModel().setValue("name", (Object)String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6c47\u7387%s", (String)"AccountMemberEdit_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), newNum));
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        this.getModel().setValue("accountuse", (Object)4);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setFilter2LossCarry();
        String dataTypeValue = (String)this.getModel().getValue("datatype");
        this.setAggoprtStatus(dataTypeValue);
        DynamicObject part = (DynamicObject)this.getModel().getValue("accountpart");
        if (part != null) {
            DynamicObject partDy = BusinessDataServiceHelper.loadSingle((Object)part.getLong("id"), (String)"bcm_structofaccountp");
            this.getModel().setValue("isaccountoffset", partDy.get("isaccountoffset"));
        }
        this.getModel().setDataChanged(false);
        this.setEnableOfListPage();
        this.setEnableOfAsso();
        this.setRootMemberProp();
        PropertyChangeTips.afterOpenPage(this.getModel(), this.getView());
    }

    private void setRootMemberProp() {
        Integer level = (Integer)this.getModel().getValue("level");
        if (level == 1) {
            this.getModel().setValue("isparticipmerge", (Object)false);
            this.getModel().setValue("entryrate", null);
            this.getModel().setDataChanged(false);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"simplename", "shielddim", "aggoprt", "accounttype", "drcrdirect", "datatype", "exchange", "entryrate", ACCOUNTSCALE, "isparticipmerge", "isaccountoffset", "iscaltype", "permclass"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap3", "dimmapset"});
        }
    }

    private void setEnableOfListPage() {
        String pageItem = (String)this.getView().getFormShowParameter().getCustomParam("pageItem");
        if ("show_table".equals(pageItem)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"parentname", "storagetype", "shielddim", "aggoprt", "number", "number", "number", "number"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "name", "simplename", "accounttype", "drcrdirect", "datatype", "exchange", "entryrate", "isparticipmerge", "isaccountoffset", "islosscarry", "iscaltype", ACCOUNTSCALE, "permclass"});
        }
    }

    private void setFilter2LossCarry() {
        BasedataEdit bs = (BasedataEdit)this.getControl("losscarryto");
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        bs.setQFilter(new QFilter("model", "=", (Object)modelId).and(new QFilter("islosscarry", "=", (Object)"1")));
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (BlackListUtils.hasFeatureInCm((String)"CMTraJur")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryrate"});
        }
        if (BlackListUtils.hasFeatureInCm((String)"CMTra")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"exchange"});
        }
    }

    @Override
    public void beforePropertyChanged(PropertyChangedArgs e) {
        String oldvalue;
        super.beforePropertyChanged(e);
        String propName = e.getProperty().getName();
        if ("datatype".equals(propName)) {
            oldvalue = (String)this.getModel().getValue("datatype");
            this.getPageCache().put("datatype", oldvalue);
        }
        if ("value".equals(propName)) {
            oldvalue = (String)this.getModel().getValue("value");
            this.getPageCache().put("value", oldvalue);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object propValue = changeSet[0].getNewValue();
        switch (propName) {
            case "value": {
                if (this.getModel().getValue("value") == null) break;
                String id = (String)this.getModel().getValue("value");
                this.getModel().setValue("enumitem", (Object)id);
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_enumitem", (String)"datatype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(id))});
                String datatype = dynamicObject.getString("datatype");
                this.setExchangeStyle(datatype, true);
                break;
            }
            case "datatype": {
                if (this.getPageCache().get("resetdatatype") != null) {
                    this.getPageCache().remove("resetdatatype");
                    return;
                }
                if (propValue.toString().equals("6")) {
                    this.dataTypeSelectEnumOfAccount(e);
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue("value", (Object)"");
                this.getModel().setValue("enumitem", (Object)"");
                this.getModel().endInit();
                this.getView().setEnable(Boolean.FALSE, new String[]{"value"});
                this.setAggoprtStatus(propValue.toString());
                this.lockExchangeByAccountType((String)this.getModel().getValue("accounttype"), Integer.parseInt(propValue.toString()), false);
                break;
            }
            case "accounttype": {
                if (propValue.toString().equals("1") || propValue.toString().equals("7") || propValue.toString().equals("8") || propValue.toString().equals("9")) {
                    this.getModel().setValue("drcrdirect", (Object)"1");
                }
                if (propValue.toString().equals("2") || propValue.toString().equals("3") || propValue.toString().equals("10")) {
                    this.getModel().setValue("drcrdirect", (Object)"2");
                }
                if (Arrays.asList(drcrdNoneArrary).contains(propValue.toString())) {
                    this.getModel().setValue("drcrdirect", (Object)"0");
                }
                this.lockExchangeByAccountType(propValue.toString(), Integer.parseInt(this.getModel().getValue("datatype").toString()), false);
                break;
            }
            case "storagetype": {
                if ("1".equals(propValue.toString()) || "5".equals(propValue.toString())) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{ACCOUNTSCALE});
                    this.getModel().setValue(ACCOUNTSCALE, null);
                    break;
                }
                if ("1".equals(this.getPageCache().get(EXISTDATA))) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{ACCOUNTSCALE});
                    break;
                }
                this.getView().setEnable(Boolean.valueOf(true), new String[]{ACCOUNTSCALE});
                break;
            }
        }
    }

    private void lockExchangeByAccountType(String accountType, int datatype, boolean fromLoadData) {
        if (AccountDataTypeEnum.RATIO.getIndex() == datatype || AccountDataTypeEnum.TEXT.getIndex() == datatype || AccountDataTypeEnum.DATE.getIndex() == datatype) {
            if (!fromLoadData) {
                this.getModel().setValue("exchange", (Object)ExchangeEnum.NONE.index);
            }
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"exchange"});
        } else {
            String exchangeValue = AccountMemberEdit.getExchangeByAccountType(accountType);
            if (!fromLoadData) {
                this.getModel().setValue("exchange", (Object)exchangeValue);
            }
        }
        Object storagetype = this.getModel().getValue("storagetype");
        if (storagetype != null && StorageTypeEnum.SHARE.getOIndex().equals(storagetype.toString())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"exchange"});
        }
        String propValue = this.getModel().getValue("datatype").toString();
        if (DataTypeEnum.TXT.getOIndex().equals(propValue) || DataTypeEnum.DATETP.getOIndex().equals(propValue) || DataTypeEnum.PROPORTION.getOIndex().equals(propValue)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"exchange"});
        }
        this.getView().updateView("exchange");
    }

    public static String getExchangeByAccountType(String accountType) {
        String exchange = null;
        switch (accountType) {
            case "1": 
            case "2": {
                exchange = ExchangeEnum.TERMINAL.index;
                break;
            }
            case "3": 
            case "7": 
            case "10": {
                exchange = ExchangeEnum.AVERAGE.index;
                break;
            }
            default: {
                exchange = ExchangeEnum.NONE.index;
            }
        }
        return exchange;
    }
}

