/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimensionnew;

import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.DimensionUtils;
import kd.fi.bcm.formplugin.dimensionnew.DimensionMemberBaseEdit;
import kd.fi.bcm.formplugin.dimensionnew.prpertychangeaction.PropertyChangeTips;
import org.apache.commons.lang.StringUtils;

public class AudittrialMemberEdit
extends DimensionMemberBaseEdit {
    private static String KEYNUMBER = "DataCollection";
    private static String ctl_isdatacollect = "isdatacollect";

    @Override
    protected String getModelType() {
        return "bcm_audittrialmember";
    }

    @Override
    protected String getTreeModelType() {
        return "bcm_audittrialmembertree";
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnableOfAsso();
        this.setRootMemberProp();
        PropertyChangeTips.afterOpenPage(this.getModel(), this.getView());
    }

    private void setRootMemberProp() {
        Integer level = (Integer)this.getModel().getValue("level");
        if (level == 1) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"shielddim", "permclass", "use"});
        }
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel iDataModel = this.getModel();
        this.hideDataCollection(iDataModel);
        iDataModel.setDataChanged(false);
        PermClassEntityHelper.loadPermClass((IDataModel)this.getModel(), (Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"), (boolean)StorageTypeEnum.SHARE.index.equals(this.getModel().getValue("storagetype")));
        if (StorageTypeEnum.SHARE.index.equals(this.getModel().getValue("storagetype"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"permclass"});
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl("permclass")), (Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        this.addAssoBeforeF7SelectListenerNoDatatype(e);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel iDataModel = this.getModel();
        this.hideDataCollection(iDataModel);
        iDataModel.setDataChanged(false);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        PermClassEntityHelper.savePermClass((IDataModel)this.getModel(), (Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"), (OperationStatus)this.getView().getFormShowParameter().getStatus());
    }

    private void hideDataCollection(IDataModel iDataModel) {
        Object number = iDataModel.getValue("number");
        if (!KEYNUMBER.equals(number)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ctl_isdatacollect});
        }
    }

    @Override
    protected void setEnableOfAsso() {
        super.setEnableOfAsso();
        String longnumber = (String)this.getModel().getValue("longnumber");
        QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
        Set ids = DimensionUtils.getAllSuitAuMemsOfAssoSto((long)this.getModelId()).stream().map(x -> x.getId()).collect(Collectors.toSet());
        qf.and("id", "in", ids);
        qf.and("longnumber", "like", (Object)(longnumber + '!' + "%"));
        DynamicObjectCollection mems = QueryServiceHelper.query((String)"bcm_audittrialmembertree", (String)"id", (QFilter[])qf.toArray());
        if (mems.size() > 0) {
            this.getPageCache().put("suit_ids", SerializationUtils.toJsonString(mems.stream().map(x -> x.getLong("id")).collect(Collectors.toSet())));
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"assostoremem"});
        }
    }

    @Override
    protected void addAssoBeforeF7SelectListenerNoDatatype(EventObject e) {
        BasedataEdit assostoremem = (BasedataEdit)this.getControl("assostoremem");
        assostoremem.addBeforeF7SelectListener(event -> {
            String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
            List customQFilters = event.getCustomQFilters();
            customQFilters.add(new QFilter("model", "=", (Object)Long.parseLong(modelId)));
            String suitIds = this.getPageCache().get("suit_ids");
            if (StringUtils.isNotEmpty((String)suitIds)) {
                Set ids = (Set)SerializationUtils.fromJsonString((String)suitIds, Set.class);
                customQFilters.add(new QFilter("longnumber", "like", (Object)(this.getModel().getValue("longnumber").toString() + '!' + "%")));
                customQFilters.add(new QFilter("id", "in", (Object)ids));
            } else {
                customQFilters.add(new QFilter("number", "=", (Object)""));
            }
        });
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String suitIds;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("storagetype".equals(name) && StringUtils.isEmpty((String)(suitIds = this.getPageCache().get("suit_ids")))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"assostoremem"});
        }
    }
}

