/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimensionnew;

import com.google.common.collect.LinkedHashMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.DynamicComputingServiceHelper;
import kd.fi.bcm.business.dimension.struct.ShareNodeStructSyncHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.dimension.DimensionCircleCheckAlgorithm;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class DimMemberSycnPlugin
extends AbstractBaseListPlugin {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DimMemberSycnPlugin.class);

    private static String getOperationSyn() {
        return ResManager.loadKDString((String)"\u540c\u6b65", (String)"DimMemberSycnPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private static String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"DimMemberSycnPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private static String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"DimMemberSycnPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private static String getResult() {
        return ResManager.loadKDString((String)"\u672a\u540c\u6b65", (String)"DimMemberSycnPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), "model");
        if (StringUtils.isEmpty((String)modelId)) {
            return;
        }
        this.getModel().setValue("model", (Object)modelId);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_search": {
                this.checkModelExists();
                this.refreshData();
                break;
            }
            case "bar_sycn": {
                this.checkModelExists();
                this.syncDimensionShortNumber2Cube();
                this.syncOrg();
                this.syncMembers();
                ShareNodeStructSyncHelper.resyncShareNodeStructureForAllDimensions((long)this.getModelId());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"DimMemberSycnPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "bar_syncfactor": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5feb\u901f\u540c\u6b65", (String)"DimMemberSycnPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5c06\u5f53\u524d\u4f53\u7cfb\u7684\u6240\u6709\u7ef4\u5ea6\u7684\u5b58\u50a8\u7c7b\u578b\u4e3a\u201c\u52a8\u6001\u8ba1\u7b97\u201d\u7684\u6210\u5458\u7684\u52a8\u6001\u8ba1\u7b97\u903b\u8f91\u540c\u6b65\u5230\u5bf9\u5e94\u7684\u591a\u7ef4\u6570\u636e\u5e93\u4e2d\uff0c\u8be5\u64cd\u4f5c\u4ec5\u4fee\u590d\u591a\u7ef4\u6570\u636e\u5e93\u7684\u5b58\u50a8\u7c7b\u578b\u4e3a\u201c\u52a8\u6001\u8ba1\u7b97\u201d\u7684\u6210\u5458\u7684\u8ba1\u7b97\u903b\u8f91\uff0c\u4e0d\u4f1a\u6539\u53d8\u6210\u5458\u7684\u4efb\u4f55\u5c5e\u6027\u548c\u5185\u5bb9\u3002\u786e\u5b9a\u540c\u6b65\uff1f", (String)"DimMemberSycnPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Wait, new ConfirmCallBackListener("bar_syncfactor", (IFormPlugin)this));
                break;
            }
            case "bar_syncfactorbydim": {
                ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bcm_dimension", (boolean)true);
                QFilter filter = QFilter.of((String)"model = ?", (Object[])new Object[]{this.getModelId()});
                filter.and("number", "!=", (Object)SysDimensionEnum.Scenario.getNumber());
                lsp.getListFilterParameter().setFilter(filter);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "syncfactorbydim");
                lsp.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)lsp);
                break;
            }
        }
    }

    private void syncDimensionShortNumber2Cube() {
        String modelCUBE = MemberReader.findModelNumberById((Object)this.getModelId());
        OlapServiceHelper.syncDimensionShortNumber2Cube((String)modelCUBE);
    }

    private void syncOrg() {
        QFilter modelFilter = new QFilter("model", "=", (Object)this.getModelId());
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter parentFilter = QFilter.isNotNull((String)"parent").and(new QFilter("parent", "!=", (Object)0L));
        QFilter[] filters = new QFilter[]{modelFilter, statusFilter, parentFilter, new QFilter("isexchangerate", "=", (Object)"0")};
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"number,aggoprt,parent.number,storagetype", (QFilter[])filters);
        HashSet<String> set = new HashSet<String>(query.size());
        for (DynamicObject dyn : query) {
            String number = dyn.getString("number");
            String pNumber = dyn.getString("parent.number");
            String storagetype = dyn.getString("storagetype");
            if (!StorageTypeEnum.SHARE.getOIndex().equals(storagetype)) {
                set.add(number);
            }
            set.add(pNumber + "_" + number);
        }
        String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
        OlapServiceHelper.batchCreateDimensionMembers((String)modelNum, (String)"Entity", (String[])set.toArray(new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String key = messageBoxClosedEvent.getCallBackId();
        if ("bar_syncfactor".equals(key)) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u540c\u6b65\u4e2d\u3002\u3002\u3002", (String)"DimMemberSycnPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                try {
                    this.syncMemberFactor();
                }
                finally {
                    this.getView().hideLoading();
                }
            }
        } else if ("bar_syncfactorbydim".equals(key) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u540c\u6b65\u4e2d\u3002\u3002\u3002", (String)"DimMemberSycnPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            try {
                DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)this.getModelId(), (String)"bcm_model", (String)"number");
                String cube = model.getString("number");
                ListSelectedRowCollection lsp = (ListSelectedRowCollection)SerializationUtils.fromJsonString((String)this.getPageCache().get("syncfactorbydim"), ListSelectedRowCollection.class);
                ArrayList syncDimNums = new ArrayList(5);
                StringBuilder sb = new StringBuilder();
                lsp.forEach(l -> {
                    String dimNum = l.getNumber();
                    sb.append(l.getName());
                    sb.append(' ');
                    syncDimNums.add(dimNum);
                });
                BatchProcessHelper.handle(syncDimNums, dimNum -> {
                    long tick = System.currentTimeMillis();
                    if ("Account".equals(dimNum)) {
                        String memberform = DimEntityNumEnum.getEntieyNumByNumber((String)dimNum);
                        DynamicObjectCollection allLongNums = QueryServiceHelper.query((String)memberform, (String)"longnumber", (QFilter[])new QFilter("model.number", "=", (Object)cube).and(new QFilter("dimension.number", "=", dimNum)).and(new QFilter("status", "!=", (Object)"A")).toArray());
                        Collection<String> riskMembers = DimensionCircleCheckAlgorithm.staticCheckCycle(allLongNums.stream().map(x -> x.getString("longnumber")).collect(Collectors.toList()));
                        riskMembers.stream().forEach(x -> logger.info("member_cycle_risk member:" + x));
                    }
                    DynamicComputingServiceHelper.repairModelByDim((String)cube, (String)dimNum, (boolean)true);
                    logger.info(String.format("update_model for entity: %s %s cost time: %s", cube, dimNum, System.currentTimeMillis() - tick));
                    return null;
                }, (Integer)500);
                String msg = String.format(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u201c%1$s\u201d\u7ef4\u5ea6\u7684\u8ba1\u7b97\u56e0\u5b50\u540c\u6b65\u3002", (String)"DimMemberSycnPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb.toString());
                sb.append(OpItemEnum.DIMENSION.getName());
                sb.append(",");
                sb.append(OpItemEnum.SYNC.getName());
                sb.append(ResultStatusEnum.SUCCESS.getName());
                OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u540c\u6b65\u52a8\u6001\u8ba1\u7b97-\u5168\u91cf\u540c\u6b65", "DimMemberSycnPlugin_19", "fi-bcm-formplugin", "syncDynAllSync");
                this.writeMultiLangLog(opName, OPDescMultiLangEnumBridge.genUnTransBridge((String)sb.toString()));
                this.getView().showSuccessNotification(msg);
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if ("syncfactorbydim".equals(key)) {
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            ListSelectedRowCollection lsp = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            this.getPageCache().put("syncfactorbydim", SerializationUtils.toJsonString((Object)lsp));
            StringBuilder sb = new StringBuilder();
            lsp.forEach(l -> {
                sb.append(l.getName());
                sb.append(' ');
            });
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\u5168\u91cf\u540c\u6b65", (String)"DimMemberSycnPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb.toString()), ResManager.loadKDString((String)"\u5c06\u5f53\u524d\u4f53\u7cfb\u7684\u9009\u62e9\u7ef4\u5ea6\u7684\u6240\u6709\u6210\u5458\u7684\u52a8\u6001\u8ba1\u7b97\u903b\u8f91\u540c\u6b65\u5230\u5bf9\u5e94\u7684\u591a\u7ef4\u6570\u636e\u5e93\u4e2d\uff0c\u8be5\u64cd\u4f5c\u5c06\u4fee\u590d\u591a\u7ef4\u6570\u636e\u5e93\u7684\u9009\u62e9\u7ef4\u5ea6\u7684\u6240\u6709\u6210\u5458\u7684\u8ba1\u7b97\u903b\u8f91\uff0c\u4e0d\u4f1a\u6539\u53d8\u6210\u5458\u7684\u4efb\u4f55\u5c5e\u6027\u548c\u5185\u5bb9\u3002\u786e\u5b9a\u540c\u6b65\uff1f", (String)"DimMemberSycnPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Wait, new ConfirmCallBackListener("bar_syncfactorbydim", (IFormPlugin)this));
        }
    }

    private void syncMemberFactor() {
        DynamicComputingServiceHelper.syncModel((long)this.getModelId());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"DimMemberSycnPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u540c\u6b65\u52a8\u6001\u8ba1\u7b97-\u5feb\u901f\u540c\u6b65", "DimMemberSycnPlugin_17", "fi-bcm-formplugin", "syncDynQucklySync");
        OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u540c\u6b65\u6210\u529f", "DimMemberSycnPlugin_18", "fi-bcm-formplugin", null);
        this.writeMultiLangLog(opName, opDes);
    }

    private void checkModelExists() {
        if (this.getModelId() == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DimMemberSycnPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equals("model")) {
            this.refreshData();
        }
    }

    private void refreshData() {
        logger.startWatch();
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("entryentity");
        LinkedHashMultimap notSycnRecord = DimensionServiceHelper.getNotSyncDimensionMember((long)this.getModelId());
        logger.info("refresh olap data size:" + notSycnRecord.size());
        if (!notSycnRecord.isEmpty()) {
            dataModel.beginInit();
            dataModel.batchCreateNewEntryRow("entryentity", notSycnRecord.values().size());
            dataModel.endInit();
            DynamicObjectCollection entryRows = dataModel.getEntryEntity("entryentity");
            AtomicInteger rowIndex = new AtomicInteger(0);
            notSycnRecord.keySet().forEach(dimNum -> {
                long dimId = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)dimNum);
                String dimName = MemberReader.getDimensionNameById((long)dimId);
                notSycnRecord.get(dimNum).forEach(record -> {
                    DynamicObject rowEntry = (DynamicObject)entryRows.get(rowIndex.getAndIncrement());
                    rowEntry.set("dimensionname", (Object)dimName);
                    rowEntry.set("dimensionnum", dimNum);
                    rowEntry.set("sycnresult", (Object)DimMemberSycnPlugin.getResult());
                    String member = (String)record.get("num");
                    String olapMember = (String)record.get("onum");
                    String numbers = (String)record.get("numbers");
                    if (StringUtils.isNotEmpty((String)member)) {
                        rowEntry.set("relationmembernum", record.get("num"));
                        rowEntry.set("relationmembername", record.get("name"));
                    } else if (StringUtils.isNotEmpty((String)numbers)) {
                        String[] str = numbers.split("\\|");
                        if (str.length > 1) {
                            rowEntry.set("relationmembernum", (Object)str[0]);
                            rowEntry.set("relationmembername", record.get("name"));
                            rowEntry.set("olapmembernum", (Object)str[1]);
                        }
                    } else if (StringUtils.isNotEmpty((String)olapMember)) {
                        rowEntry.set("olapmembernum", (Object)olapMember);
                    }
                });
            });
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        grid.clearEntryState();
        this.getView().updateView("entryentity");
        logger.infoEnd("refresh olap data end.");
    }

    private void syncMembers() {
        Map<String, PairList<String, String>> allMembers = this.getNeededSynchronizeMembers();
        try {
            if (!allMembers.isEmpty()) {
                String cubeName = MemberReader.findModelNumberById((Object)this.getModelId());
                allMembers.keySet().stream().forEach(p -> {
                    HashMap<String, String> olapMap = new HashMap<String, String>(16);
                    List pairList = ((PairList)allMembers.get(p)).toList();
                    pairList.stream().filter(m -> StringUtils.isNotEmpty((String)((String)m.p2))).forEach(f -> {
                        String cfr_ignored_0 = (String)olapMap.put((String)f.p2, (String)f.p1);
                    });
                    String entityNum = DimEntityNumEnum.getEntieyNumByNumber((String)p);
                    QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
                    filter.and("storagetype", "!=", (Object)"3");
                    filter.and("number", "in", pairList.stream().map(m -> (String)m.p1).collect(Collectors.toSet()));
                    DynamicObjectCollection docs = QueryServiceHelper.query((String)entityNum, (String)"number, aggoprt, parent.number", (QFilter[])new QFilter[]{filter});
                    ArrayList<Tuple> tuples = new ArrayList<Tuple>(16);
                    if (docs != null && docs.size() > 0) {
                        HashSet<String> members = new HashSet<String>(16);
                        for (DynamicObject dynamicObject : docs) {
                            String number = dynamicObject.getString("number");
                            if (members.contains(number)) continue;
                            members.add(number);
                            tuples.add(Tuple.create((Object)number, (Object)dynamicObject.getInt("aggoprt"), (Object)dynamicObject.getString("parent.number")));
                        }
                        OlapServiceHelper.batchCreateDimensionMembers((String)cubeName, (String)p, tuples);
                    }
                    olapMap.forEach((k, v) -> OlapServiceHelper.alterMemberName((String)cubeName, (String)p, (String)k, (String)v));
                });
            }
            this.writeOperationLog(DimMemberSycnPlugin.getOperationSyn(), DimMemberSycnPlugin.getOperationStstusSuccess());
        }
        catch (Exception e) {
            this.writeOperationLog(DimMemberSycnPlugin.getOperationSyn(), DimMemberSycnPlugin.getOperationStstusFail());
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u540c\u6b65\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u3002", (String)"DimMemberSycnPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getMessage()));
            return;
        }
        this.refreshData();
    }

    public Map<String, PairList<String, String>> getNeededSynchronizeMembers() {
        DynamicObjectCollection entryData = this.getModel().getEntryEntity("entryentity");
        int[] selects = ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows();
        if (selects != null && selects.length > 0) {
            HashMap<String, PairList<String, String>> allMembers = new HashMap<String, PairList<String, String>>(selects.length);
            Arrays.stream(selects).forEach(p -> {
                DynamicObject record = (DynamicObject)entryData.get(p);
                String number = record.getString("relationmembernum");
                String olapNumber = record.getString("olapmembernum");
                if (StringUtils.isNotEmpty((String)number)) {
                    allMembers.computeIfAbsent(record.getString("dimensionnum"), k -> new PairList()).add(Pair.onePair((Object)number, (Object)olapNumber));
                }
            });
            return allMembers;
        }
        return new HashMap<String, PairList<String, String>>(0);
    }
}

