/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimensionnew;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.dimension.helper.ExtDimensionHelper;
import kd.fi.bcm.business.dimension.helper.SaveDimMemberHelper;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataUtil;
import kd.fi.bcm.business.mq.consumer.MQMessagePublisherServiceHelper;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.ExtConvertServiceHelper;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.prop.DefinedPropertyUtil;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExchangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.log.DimMemberOperateTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.dimensionnew.DimensionMemberBaseEdit;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.commons.collections.CollectionUtils;

public class ExtDimMemberEdit
extends DimensionMemberBaseEdit
implements BeforeF7SelectListener {
    private static Log LOG = LogFactory.getLog(ExtDimMemberEdit.class);
    private static final String textPrefix = "textext";
    private static final String numPrefix = "numext";
    private static final String datePrefix = "dateext";
    private static final String DATA_TYPE = "datatype";
    private static final String INDEXTOIDS = "indexToIds";
    private static final String MEMBERKEY = "memberid";
    protected static final String ISEXTDIM = "isExtDim";
    protected static final String ASSO_DIM = "assodimension";
    protected static final String ASSO_MEMBER = "assomember";
    protected static final String CLEAR_DIM = "cleardim";
    protected static final String ASSO_DIM_MEMBER = "assodimmember";
    protected static final String ENTRY_ENTITY_ASSO = "entryentityasso";
    private Map<String, Long> indexToIds;
    private static final String EXTFIELD_NUM = "ExtField_Num";
    private static final String EXTFIELD_TEXT = "ExtField_Text";
    private static final String EXTFIELD_DATE = "ExtField_Date";
    private static Pattern pattern = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9_]*");

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long modelId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        if ("bar_save".equals(key)) {
            if ("ADDNEW".equals(this.getView().getFormShowParameter().getStatus().toString())) {
                if (StringUtils.isEmpty((String)this.getPageCache().get("newID"))) {
                    DynamicObject dynamicObject = this.saveNewMemberData();
                    if (dynamicObject != null) {
                        this.getPageCache().put("newID", dynamicObject.get("id").toString());
                        this.adjustViewControlStatus(dynamicObject);
                        MQMessagePublisherServiceHelper.publishClearDimMemberCache((String)MemberReader.findModelNumberById((Object)modelId), (String)"bcm_structofextend");
                    }
                } else {
                    this.getView().getFormShowParameter().setCustomParam("id", (Object)this.getPageCache().get("newID"));
                    this.saveEditMemberData();
                }
            } else if ("EDIT".equals(formShowParameter.getStatus().toString())) {
                this.saveEditMemberData();
            }
        } else if ("baritemaddlevel".equals(key)) {
            Long userId = LongUtil.toLong((Object)RequestContext.get().getCurrUserId());
            String bizAppId = this.getBizAppId();
            BcmFunPermissionHelper.checkPerm((String)key, (String)"bcm_dimensionmembertree", (Long)modelId, (Long)userId, (String)bizAppId);
            if (this.getModel().getDataChanged() && !this.getModel().getDataEntity().getLastDirty().isEmpty()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u8df3\u8f6c\u81f3\u65b0\u9875\u9762\uff1f", (String)"DimensionMemberBaseEdit_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("chengepage", (IFormPlugin)this));
                return;
            }
            this.openNewPage(key);
        } else if ("bar_close".equals(key)) {
            String rowidList;
            ArrayList<String> oldIds = new ArrayList<String>(16);
            String id = "";
            id = OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus() ? this.getPageCache().get("newID") : (String)this.getView().getFormShowParameter().getCustomParam("id");
            DynamicObjectCollection docs = this.queryProperty(id);
            if (docs.size() > 0) {
                for (int i = 0; i < this.getDefinedProperty().size(); ++i) {
                    String property = ((DynamicObject)docs.get(0)).getString(i);
                    if (!StringUtils.isNotEmpty((String)property) || "0".equals(property)) continue;
                    oldIds.add(property);
                }
            }
            if (StringUtils.isNotEmpty((String)(rowidList = this.getPageCache().get("rowidList")))) {
                List newIds = (List)SerializationUtils.fromJsonString((String)rowidList, List.class);
                if (oldIds.size() != newIds.size()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u9009\u81ea\u5b9a\u4e49\u5c5e\u6027\u503c\u4fee\u6539\u540e\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\uff1f", (String)"DimensionMemberBaseEdit_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("save_comfirm", (IFormPlugin)this));
                    return;
                }
                for (Map map : newIds) {
                    if (oldIds.contains(((String)map.get("rowid")).split(",")[0])) continue;
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u9009\u81ea\u5b9a\u4e49\u5c5e\u6027\u503c\u4fee\u6539\u540e\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\uff1f", (String)"DimensionMemberBaseEdit_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("save_comfirm", (IFormPlugin)this));
                    return;
                }
            }
            this.getView().close();
        } else if ("datatypecorrect".equals(key)) {
            this.dataTypeCorrectOfMappingError();
        } else if (CLEAR_DIM.equals(key)) {
            this.getModel().setValue(ASSO_DIM, null);
            this.getModel().setValue(ASSO_MEMBER, null);
            this.getPageCache().remove(ASSO_MEMBER);
        } else {
            super.itemClick(evt);
        }
    }

    private void adjustViewControlStatus(DynamicObject dynamicObject) {
        int level = dynamicObject.getInt("level");
        if (level == 2) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "parentname", "storagetype", DATA_TYPE, "grouptype"});
        }
        if (level == 3) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "storagetype", "parentname", "grouptype"});
        }
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
    }

    private DynamicObject[] saveInExtDimMemb() {
        DynamicObject extDimMemb = BusinessDataServiceHelper.newDynamicObject((String)"bcm_membofextend");
        extDimMemb.set("name", this.getModel().getValue("name"));
        extDimMemb.set("number", this.getModel().getValue("number"));
        extDimMemb.set("simplename", this.getModel().getValue("simplename"));
        extDimMemb.set("dimension", (Object)Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("dimensionID")));
        extDimMemb.set("model", this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        extDimMemb.set("creator", (Object)currUserId);
        extDimMemb.set("createtime", (Object)date);
        extDimMemb.set("modifier", (Object)currUserId);
        extDimMemb.set("modifytime", (Object)date);
        extDimMemb.set("status", (Object)"C");
        extDimMemb.set("enable", (Object)"1");
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{extDimMemb});
    }

    @Override
    protected String getTreeModelType() {
        return "bcm_structofextend";
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String level = (String)formShowParameter.getCustomParam("level");
        String parName = this.getParentName(formShowParameter);
        this.getPageCache().put(this.dimensionKey, (String)formShowParameter.getCustomParam("dimensionID"));
        this.getPageCache().put(MEMBERKEY, (String)formShowParameter.getCustomParam("id"));
        this.getPageCache().put("KEY_MODEL_ID", (String)formShowParameter.getCustomParam("KEY_MODEL_ID"));
        this.getModel().setValue("dimension", formShowParameter.getCustomParam("dimensionID"));
        this.getModel().setValue("model", formShowParameter.getCustomParam("KEY_MODEL_ID"));
        this.getModel().setValue("id", formShowParameter.getCustomParam("id"));
        this.getModel().setValue("member", formShowParameter.getCustomParam("member"));
        if ("ADDNEW".equals(this.getView().getFormShowParameter().getStatus().toString())) {
            if (level.equals("2")) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"exchange", "entryrate", "value"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{DATA_TYPE, "storagetype", "parentname", "baritemaddlevel", "isaccountoffset"});
                this.getModel().setValue("parentname", (Object)parName);
                this.getModel().setValue("storagetype", (Object)StorageTypeEnum.LABEL.getOIndex());
                this.getModel().setValue(DATA_TYPE, (Object)DataTypeEnum.TXT.getOIndex());
                Object grouptype = formShowParameter.getCustomParam("grouptype");
                if (!Objects.isNull(grouptype)) {
                    this.getModel().setValue("grouptype", grouptype);
                }
            }
            if (level.equals("3")) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"isparticipmerge", "isaccountoffset", "grouptype", "value"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"storagetype", "parentname", "baritemaddlevel"});
                this.getModel().setValue("parentname", (Object)parName);
                this.getModel().setValue("storagetype", (Object)StorageTypeEnum.STORAGE.getOIndex());
                this.getModel().setValue("grouptype", formShowParameter.getCustomParam("grouptype"));
            }
            this.searchProperty();
            this.refreshMembers();
        }
        if ("EDIT".equals(this.getView().getFormShowParameter().getStatus().toString())) {
            this.getModel().setValue("name", formShowParameter.getCustomParam("name"));
            this.getModel().setValue("number", formShowParameter.getCustomParam("number"));
            this.getModel().setValue("simplename", formShowParameter.getCustomParam("simplename"));
            this.getModel().setValue("description", formShowParameter.getCustomParam("description"));
            this.getModel().setValue(DATA_TYPE, formShowParameter.getCustomParam(DATA_TYPE));
            this.getModel().setValue("storagetype", formShowParameter.getCustomParam("storagetype"));
            this.getModel().setValue("parentname", (Object)parName);
            if (level.equals("2")) {
                Boolean isparticipmerge = (Boolean)formShowParameter.getCustomParam("isparticipmerge");
                this.getModel().setValue("grouptype", formShowParameter.getCustomParam("grouptype"));
                this.getModel().setValue("isparticipmerge", formShowParameter.getCustomParam("isparticipmerge"));
                this.getModel().setValue("isaccountoffset", formShowParameter.getCustomParam("isaccountoffset"));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"isparticipmerge", "isaccountoffset", "grouptype"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"exchange", "entryrate", "fieldmapped", "value"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"parentname", "storagetype", DATA_TYPE, "grouptype"});
                if (!isparticipmerge.booleanValue()) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"isaccountoffset"});
                }
            }
            if (level.equals("3")) {
                this.getModel().setValue("entryrate", formShowParameter.getCustomParam("entryrate"));
                this.getModel().setValue("fieldmapped", formShowParameter.getCustomParam("fieldmapped"));
                this.getModel().setValue("enumitem", formShowParameter.getCustomParam("enumitem"));
                this.getModel().setValue("grouptype", formShowParameter.getCustomParam("grouptype"));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"exchange", "entryrate", "fieldmapped"});
                if ("6".equals(formShowParameter.getCustomParam(DATA_TYPE))) {
                    this.initEnumValueCtrl();
                    this.setValueItem((Long)this.getView().getFormShowParameter().getCustomParam("value"));
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"isparticipmerge", "isaccountoffset", "grouptype"});
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"storagetype", "parentname", "grouptype"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"isparticipmerge", "isaccountoffset", "grouptype", "value"});
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"storagetype", "parentname", "grouptype", "value"});
                }
                String number = (String)formShowParameter.getCustomParam("number");
                if ("INTR_000".equals(number) || "INTR_001".equals(number)) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{DATA_TYPE, "value"});
                }
                String datatype = (String)formShowParameter.getCustomParam(DATA_TYPE);
                String exchange = (String)formShowParameter.getCustomParam("exchange");
                if (DataTypeEnum.TXT.getOIndex().equals(datatype) || DataTypeEnum.DATETP.getOIndex().equals(datatype) || DataTypeEnum.PROPORTION.getOIndex().equals(datatype)) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"exchange"});
                    this.getModel().setValue("exchange", (Object)"0");
                } else {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"exchange"});
                    this.getModel().setValue("exchange", (Object)exchange);
                }
            }
            this.initDproperty();
            if (StorageTypeEnum.SHARE.getOIndex().equals(formShowParameter.getCustomParam("storagetype"))) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"fs_baseinfo"});
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long modelId = Long.parseLong(this.getPageCache().get("KEY_MODEL_ID"));
        if (!ConfigServiceHelper.getBoolParam((Long)modelId, (String)"isOpenExtDtCorrect")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"datatypecorrect"});
        }
        this.initExchangeCombs();
        this.setStatusOfAssoDim();
        this.echoAssoDimMemberValue();
    }

    private void echoAssoDimMemberValue() {
        String number = (String)this.getModel().getValue("number");
        if (OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus() || StringUtils.isEmpty((String)number)) {
            return;
        }
        MultiF7Results results = ExtDataUtil.getMultiF7ValueByExtMem((String)number, (long)this.getModelId());
        this.getModel().setValue(ASSO_DIM, (Object)results.getDimDy());
        this.getModel().setValue(ASSO_MEMBER, (Object)results.getShowText());
        this.getPageCache().put(ASSO_MEMBER, SerializationUtils.toJsonString((Object)results.toList()));
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
    }

    private void setStatusOfAssoDim() {
        Object datatype = this.getModel().getValue(DATA_TYPE);
        if (datatype != null && !DataTypeEnum.TXT.getOIndex().equals(datatype) || "2".equals(this.getView().getFormShowParameter().getCustomParam("level"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ASSO_DIM_MEMBER});
        }
        if (StorageTypeEnum.SHARE.getOIndex().equals(this.getModel().getValue("storagetype"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ASSO_DIM_MEMBER});
        }
    }

    private void initExchangeCombs() {
        ComboEdit exchangeCombs = (ComboEdit)this.getControl("exchange");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        items.add(new ComboItem(new LocaleString(ExchangeEnum.TERMINAL.getName()), ExchangeEnum.TERMINAL.index));
        items.add(new ComboItem(new LocaleString(ExchangeEnum.AVERAGE.getName()), ExchangeEnum.AVERAGE.index));
        items.add(new ComboItem(new LocaleString(ExchangeEnum.UserdefinedRate.getName()), ExchangeEnum.UserdefinedRate.index));
        DynamicObjectCollection rateOfExtend = this.getRateOfExtend();
        if (CollectionUtils.isNotEmpty((Collection)rateOfExtend)) {
            for (DynamicObject account : rateOfExtend) {
                items.add(new ComboItem(new LocaleString(account.getString("name")), account.getString("number")));
            }
        }
        items.add(new ComboItem(new LocaleString(ExchangeEnum.ONE.getName()), ExchangeEnum.ONE.index));
        items.add(new ComboItem(new LocaleString(ExchangeEnum.NONE.getName()), ExchangeEnum.NONE.index));
        exchangeCombs.setComboItems(items);
    }

    private String getParentName(FormShowParameter formShowParameter) {
        Object parent = formShowParameter.getCustomParam("parent");
        if (parent != null) {
            QFilter qFilter = new QFilter("id", "=", parent);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"name,number", (QFilter[])new QFilter[]{qFilter});
            return dynamicObject.getString("name");
        }
        return "";
    }

    private boolean extDimDataCheck(List<String> dataFieldArray, DynamicObject extDimMemb, String type, int maxNum) {
        QFilter qf = new QFilter("level", "=", (Object)3);
        qf.and(new QFilter("model", "=", (Object)Long.valueOf(this.getPageCache().get("KEY_MODEL_ID"))));
        qf.and(new QFilter("dimension", "=", (Object)Long.valueOf(this.getPageCache().get(this.dimensionKey))));
        Long parentId = 0L;
        parentId = "ADDNEW".equals(this.getView().getFormShowParameter().getStatus().toString()) && 0L == extDimMemb.getLong("id") ? Long.valueOf(extDimMemb.getLong("parent")) : Long.valueOf(extDimMemb.getLong("parent.id"));
        qf.and(new QFilter("parent", "=", (Object)parentId));
        ArrayList<String> dataTypeEnums = new ArrayList<String>(16);
        switch (type) {
            case "ExtField_Text": {
                dataTypeEnums.add(DataTypeEnum.TXT.getOIndex());
                break;
            }
            case "ExtField_Num": {
                dataTypeEnums.addAll(Arrays.asList(DataTypeEnum.CURRENCY.getOIndex(), DataTypeEnum.UNCURRENCY.getOIndex(), DataTypeEnum.PROPORTION.getOIndex(), DataTypeEnum.DEFAULT.getOIndex()));
                break;
            }
            case "ExtField_Date": {
                dataTypeEnums.add(DataTypeEnum.DATETP.getOIndex());
                break;
            }
        }
        qf.and(new QFilter(DATA_TYPE, "in", dataTypeEnums));
        DynamicObjectCollection results = QueryServiceHelper.query((String)"bcm_structofextend", (String)"fieldmapped", (QFilter[])qf.toArray());
        DynamicObjectCollection dynamicObjects = this.calcEnumDatatypeAmount(parentId, dataTypeEnums);
        List fieldmapped = results.stream().map(x -> (String)x.get("fieldmapped")).collect(Collectors.toList());
        int sum = results.size();
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            sum += dynamicObjects.size();
            fieldmapped.addAll(dynamicObjects.stream().map(x -> (String)x.get("fieldmapped")).collect(Collectors.toList()));
        }
        if (sum >= maxNum) {
            return false;
        }
        if (EXTFIELD_TEXT.equals(type)) {
            for (int i = 1; i <= dataFieldArray.size(); ++i) {
                if (fieldmapped.contains(dataFieldArray.get(i - 1))) continue;
                extDimMemb.set("fieldmapped", (Object)(textPrefix + i));
                break;
            }
        } else if (EXTFIELD_NUM.equals(type)) {
            for (int i = 1; i <= dataFieldArray.size(); ++i) {
                if (fieldmapped.contains(dataFieldArray.get(i - 1))) continue;
                extDimMemb.set("fieldmapped", (Object)(numPrefix + i));
                break;
            }
        } else {
            for (int i = 1; i <= dataFieldArray.size(); ++i) {
                if (fieldmapped.contains(dataFieldArray.get(i - 1))) continue;
                extDimMemb.set("fieldmapped", (Object)(datePrefix + i));
                break;
            }
        }
        return true;
    }

    private DynamicObjectCollection calcEnumDatatypeAmount(Long parentId, List<String> dataTypeEnums) {
        if (dataTypeEnums.contains("0")) {
            dataTypeEnums.remove("0");
        }
        QFilter qf = new QFilter("parent", "=", (Object)parentId);
        qf.and(new QFilter(DATA_TYPE, "=", (Object)"6"));
        qf.and(new QFilter("enumitem.datatype", "in", dataTypeEnums));
        return QueryServiceHelper.query((String)"bcm_structofextend", (String)"fieldmapped", (QFilter[])qf.toArray());
    }

    private String checkMember(String modelId, boolean isCheckNum) {
        OrmLocaleValue name;
        if (isCheckNum) {
            String number = (String)this.getModel().getValue("number");
            if (number == null || "".equals(number)) {
                return ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u3002", (String)"ExtDimEditPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            if (!this.formatYes(number)) {
                return ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u548c\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ExtDimEditPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            QFilter qf = new QFilter("model", "=", (Object)Long.valueOf(modelId));
            qf.and(new QFilter("number", "=", (Object)number));
            if (QueryServiceHelper.exists((String)"bcm_structofextend", (QFilter[])new QFilter[]{qf}) || QueryServiceHelper.exists((String)"bcm_dimension", (QFilter[])new QFilter[]{qf})) {
                return ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d", (String)"ExtDimEditPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
        }
        if (StringUtils.isEmpty((String)(name = (OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue())) {
            return ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0", (String)"ExtDimEditPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        Object assoDim = this.getModel().getValue(ASSO_DIM);
        Object assoMem = this.getModel().getValue(ASSO_MEMBER);
        if (assoDim != null && (assoMem == null || StringUtils.isEmpty((String)assoMem.toString()))) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5173\u8054\u6210\u5458", (String)"ExtDimEditPlugin_210", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String property = e.getProperty().getName();
        String value = (String)this.getModel().getValue(DATA_TYPE);
        if (DATA_TYPE.equals(property)) {
            if ("6".equals(value)) {
                ArrayList<ComboItem> items;
                ComboEdit comboEdit;
                QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
                if (!ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isOpenNewEnum")) {
                    String dimensionId = (String)this.getView().getFormShowParameter().getCustomParam("dimensionID");
                    filter.and(new QFilter("dimension", "=", (Object)ConvertUtil.convertStrToLong((String)dimensionId)));
                }
                DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_enumitem_new", (String)"id,name", (QFilter[])filter.toArray(), (String)"dseq");
                HashMap<String, Long> indexToIds = new HashMap<String, Long>();
                if (dcs != null && dcs.size() > 0) {
                    int i = 1;
                    comboEdit = (ComboEdit)this.getControl("value");
                    items = new ArrayList<ComboItem>();
                    for (DynamicObject dynamicObject : dcs) {
                        String name = dynamicObject.get("name").toString();
                        items.add(new ComboItem(new LocaleString(name), String.valueOf(i)));
                        indexToIds.put(String.valueOf(i), dynamicObject.getLong("id"));
                        ++i;
                    }
                } else {
                    ChangeData[] dataArray;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u4e0d\u5b58\u5728\u4efb\u4f55\u679a\u4e3e\uff0c\u8bf7\u5148\u7ef4\u62a4\u679a\u4e3e\u3002", (String)"ExtDimEditPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    for (ChangeData changeData : dataArray = e.getChangeSet()) {
                        this.getPageCache().put("resetdatatype", "true");
                        this.getModel().setValue(DATA_TYPE, changeData.getOldValue());
                    }
                    return;
                }
                comboEdit.setComboItems(items);
                this.getPageCache().put(INDEXTOIDS, ObjectSerialUtil.toByteSerialized(indexToIds));
                this.getView().setEnable(Boolean.TRUE, new String[]{"value"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"value"});
                this.getValueItemIdMap();
                this.getModel().setValue("enumitem", (Object)this.indexToIds.get("1"));
                this.getModel().setValue("value", (Object)"1");
            } else {
                this.getModel().beginInit();
                this.getModel().setValue("value", (Object)"");
                this.getModel().setValue("enumitem", (Object)"");
                this.getModel().endInit();
                this.getView().setEnable(Boolean.FALSE, new String[]{"value"});
            }
            if (DataTypeEnum.TXT.getOIndex().equals(value)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{ASSO_DIM_MEMBER});
            } else {
                this.getModel().setValue(ASSO_DIM, null);
                this.getModel().setValue(ASSO_MEMBER, null);
                this.getView().setVisible(Boolean.FALSE, new String[]{ASSO_DIM_MEMBER});
                this.getPageCache().remove(ASSO_MEMBER);
            }
        } else if ("value".equals(property)) {
            if (this.getModel().getValue("value") != null) {
                this.getValueItemIdMap();
                this.getModel().setValue("enumitem", (Object)this.indexToIds.get(this.getModel().getValue("value")));
                Long id = this.indexToIds.get(this.getModel().getValue("value"));
                this.getModel().setValue("enumitem", (Object)id);
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_enumitem", (String)DATA_TYPE, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                String datatype = dynamicObject.getString(DATA_TYPE);
                this.setExchangeStyle(datatype, false);
            }
        } else if ("isparticipmerge".equals(property)) {
            Boolean isparticipmerge = (Boolean)this.getModel().getValue("isparticipmerge");
            if (!isparticipmerge.booleanValue()) {
                this.getModel().setValue("isaccountoffset", (Object)false);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"isaccountoffset"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"isaccountoffset"});
            }
        } else if (ASSO_DIM.equals(property)) {
            this.setStatusOfAssoMember();
        }
    }

    private void setStatusOfAssoMember() {
        TextEdit textEdit = (TextEdit)this.getControl(ASSO_MEMBER);
        if (this.getModel().getValue(ASSO_DIM) != null) {
            textEdit.setMustInput(Boolean.TRUE.booleanValue());
        } else {
            textEdit.setMustInput(Boolean.FALSE.booleanValue());
        }
        this.getModel().setValue(ASSO_MEMBER, null);
    }

    private void getValueItemIdMap() {
        if (this.getPageCache().get(INDEXTOIDS) != null) {
            this.indexToIds = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(INDEXTOIDS));
        }
    }

    private void searchProperty() {
        String dimensionID = this.getPageCache().get(this.dimensionKey);
        DynamicObjectCollection dcs = this.getProperty(dimensionID);
        if (dcs != null && dcs.size() > 0) {
            List rowidList;
            TreeView tree = (TreeView)this.getView().getControl("treeviewap");
            TreeNode root = new TreeNode();
            root.setId("root");
            for (DynamicObject task : dcs) {
                TreeNode definedpropertyNode = new TreeNode();
                definedpropertyNode.setId(task.getString("id"));
                definedpropertyNode.setText((String)task.get("name"));
                definedpropertyNode.setData((Object)task);
                root.addChild(definedpropertyNode);
            }
            tree.addNode(root);
            tree.expand("root");
            tree.focusNode((TreeNode)root.getChildren().get(0));
            this.getPageCache().put(this.definedpropertyKey, ((TreeNode)root.getChildren().get(0)).getId());
            Label label = (Label)this.getControl("labelap");
            label.setText("");
            if (this.getPageCache().get("rowidList") != null && (rowidList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("rowidList"), List.class)) != null) {
                StringBuilder sb = new StringBuilder();
                for (Map maplist : rowidList) {
                    sb.append((String)maplist.get("text")).append(';');
                }
                label.setText(sb.toString());
            }
        } else {
            Label label = (Label)this.getControl("labelap");
            label.setText(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u4e0d\u5b58\u5728\u4efb\u4f55\u81ea\u5b9a\u4e49\u5c5e\u6027\uff0c\u8bf7\u5148\u7ef4\u62a4\u81ea\u5b9a\u4e49\u5c5e\u6027\u3002", (String)"DimensionMemberBaseEdit_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void openNewPage(String key) {
        DataEntityPropertyCollection procol = this.getModel().getDataEntityType().getProperties();
        DynamicObject dot = this.getModel().getDataEntity();
        HashMap<String, Object> teMap = new HashMap<String, Object>(procol.size());
        for (int i = 0; i < procol.size(); ++i) {
            teMap.put(((IDataEntityProperty)procol.get(i)).getName(), dot.get(((IDataEntityProperty)procol.get(i)).getName()));
        }
        String selectFields = "name,number,model";
        String dimensionid = (String)this.getView().getFormShowParameter().getCustomParam("dimensionID");
        QFilter fdimenId = new QFilter("id", "=", (Object)LongUtil.toLong((Object)dimensionid));
        QFilter[] filters = new QFilter[]{fdimenId};
        DynamicObject dcs = QueryServiceHelper.queryOne((String)"bcm_dimension_ext", (String)selectFields, (QFilter[])filters);
        if (dcs != null) {
            String dimensionName = dcs.getString("name");
            String entityId = "bcm_structofextend";
            String modelId = dcs.getString("model");
            QFilter numberQf = new QFilter("number", "=", this.getModel().getValue("number"));
            QFilter modelQf = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
            QFilter qFilterDimId = new QFilter("dimension", "=", (Object)LongUtil.toLong((Object)dimensionid));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{modelQf, qFilterDimId, numberQf});
            String id = dynamicObject != null ? dynamicObject.getString("id") : "";
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId(entityId);
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCustomParam("id", (Object)id);
            showParameter.setCustomParam("dimensionName", (Object)dimensionName);
            showParameter.setCustomParam("entityId", (Object)entityId);
            showParameter.setCustomParam("nodeId", this.getView().getFormShowParameter().getCustomParam("nodeId"));
            showParameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
            showParameter.setCustomParam("actionName", (Object)key);
            showParameter.setCustomParam("dimensionID", (Object)dimensionid);
            showParameter.setCustomParam("lastNumber", (Object)this.getPageCache().get("lastNumber"));
            showParameter.setCustomParam("map", (Object)SerializationUtils.serializeToBase64(teMap));
            showParameter.setCustomParam(ISEXTDIM, (Object)Boolean.TRUE.toString());
            showParameter.setCustomParam("parent", this.getView().getFormShowParameter().getCustomParam("parent"));
            selectFields = "level,number,issysmember,grouptype,parent.grouptype";
            fdimenId = new QFilter("id", "=", (Object)LongUtil.toLong((Object)id));
            filters = new QFilter[]{fdimenId};
            dcs = QueryServiceHelper.queryOne((String)entityId, (String)selectFields, (QFilter[])filters);
            if (dcs != null) {
                int level = dcs.getInt("level");
                if (2 == level) {
                    showParameter.setCustomParam("grouptype", (Object)dcs.getString("grouptype"));
                    showParameter.setCaption(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u4e1a\u52a1\u5206\u7ec4\u6210\u5458", (String)"ExtDimEditPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                } else if (3 == level) {
                    showParameter.setCustomParam("grouptype", (Object)dcs.getString("parent.grouptype"));
                    showParameter.setCaption(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u5b57\u6bb5\u6210\u5458", (String)"ExtDimEditPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                showParameter.setCustomParam("level", (Object)String.valueOf(level));
            }
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.getOpenStyle().setTargetKey("_submaintab_");
            this.getView().showForm((FormShowParameter)showParameter);
            this.getView().close();
        }
    }

    private void setValueItem(long value) {
        if (value != 0L) {
            this.initEnumValueCtrl();
            this.getValueItemIdMap();
            for (Map.Entry<String, Long> entry : this.indexToIds.entrySet()) {
                if (value != entry.getValue()) continue;
                this.getModel().setValue("value", (Object)entry.getKey());
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"value"});
        }
    }

    private void initEnumValueCtrl() {
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"value"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"value"});
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        if (!ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isOpenNewEnum")) {
            String dimensionId = (String)this.getView().getFormShowParameter().getCustomParam("dimensionID");
            filter.and(new QFilter("dimension", "=", (Object)ConvertUtil.convertStrToLong((String)dimensionId)));
        }
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_enumitem_new", (String)"id,name", (QFilter[])filter.toArray(), (String)"dseq");
        HashMap<String, Long> indexToIds = new HashMap<String, Long>();
        if (dcs != null && dcs.size() > 0) {
            int i = 1;
            ComboEdit comboEdit = (ComboEdit)this.getControl("value");
            comboEdit.setMustInput(true);
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            for (DynamicObject dy : dcs) {
                String name = dy.get("name").toString();
                items.add(new ComboItem(new LocaleString(name), String.valueOf(i)));
                indexToIds.put(String.valueOf(i), dy.getLong("id"));
                ++i;
            }
            comboEdit.setComboItems(items);
        }
        this.getPageCache().put(INDEXTOIDS, ObjectSerialUtil.toByteSerialized(indexToIds));
    }

    private DynamicObject saveNewMemberData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String modelId = (String)formShowParameter.getCustomParam("KEY_MODEL_ID");
        String message = this.checkMember(modelId, true);
        if (StringUtils.isNotEmpty((String)message)) {
            this.getView().showTipNotification(message);
            return null;
        }
        int level = Integer.parseInt((String)formShowParameter.getCustomParam("level"));
        DynamicObject extDimMemb = BusinessDataServiceHelper.newDynamicObject((String)"bcm_structofextend");
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        extDimMemb.set("name", this.getModel().getValue("name"));
        extDimMemb.set("number", this.getModel().getValue("number"));
        this.setLongNumber((Long)formShowParameter.getCustomParam("parent"), extDimMemb, (String)this.getModel().getValue("number"));
        extDimMemb.set("level", (Object)level);
        extDimMemb.set("simplename", this.getModel().getValue("simplename"));
        extDimMemb.set("parent", formShowParameter.getCustomParam("parent"));
        extDimMemb.set("description", this.getModel().getValue("description"));
        extDimMemb.set("model", (Object)Long.valueOf(modelId));
        extDimMemb.set("issysmember", (Object)0);
        Object enumitem = this.getModel().getValue("enumitem");
        if (enumitem != null && !"".equals(enumitem)) {
            extDimMemb.set("enumitem", (Object)((DynamicObject)enumitem).getLong("id"));
        } else {
            extDimMemb.set("enumitem", (Object)0L);
        }
        extDimMemb.set("dimension", (Object)Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("dimensionID")));
        extDimMemb.set("creator", (Object)currUserId);
        extDimMemb.set("createtime", (Object)date);
        extDimMemb.set("modifier", (Object)currUserId);
        extDimMemb.set("modifytime", (Object)date);
        extDimMemb.set("status", (Object)"C");
        extDimMemb.set("enable", (Object)"1");
        extDimMemb.set("isleaf", (Object)"1");
        ExtDimensionHelper.setSeqValue((DynamicObject)extDimMemb, (List)Lists.newArrayList());
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bcm_structofextend");
        DynamicObject dynamicObject = BusinessDataReader.loadSingle((Object)extDimMemb.getString("parent"), (DynamicObjectType)dataEntityType);
        Object grouptype = null;
        if ("baritemaddlevel".equals(formShowParameter.getCustomParam("actionName"))) {
            extDimMemb.set("addtext", (Object)"baritemaddlevel");
        } else {
            extDimMemb.set("addtext", (Object)"baritemaddsub");
        }
        grouptype = this.getModel().getValue("grouptype");
        if (level == 2) {
            extDimMemb.set("grouptype", grouptype);
            extDimMemb.set("storagetype", (Object)StorageTypeEnum.LABEL.getOIndex());
            extDimMemb.set("isparticipmerge", this.getModel().getValue("isparticipmerge"));
            extDimMemb.set("isaccountoffset", this.getModel().getValue("isaccountoffset"));
        } else if (level == 3) {
            extDimMemb.set("storagetype", (Object)StorageTypeEnum.STORAGE.getOIndex());
            extDimMemb.set("exchange", this.getModel().getValue("exchange"));
            extDimMemb.set("entryrate", this.getModel().getValue("entryrate"));
            this.changeIsLeafStatus(dynamicObject);
        }
        String datatype = (String)this.getModel().getValue(DATA_TYPE);
        if ("6".equals(datatype)) {
            QFilter qFilter = new QFilter("id", "=", extDimMemb.get("enumitem"));
            datatype = QueryServiceHelper.queryOne((String)"bcm_enumitem", (String)DATA_TYPE, (QFilter[])new QFilter[]{qFilter}).getString(DATA_TYPE);
        }
        boolean flag = false;
        if (level == 3) {
            if (!"3".equals(grouptype)) {
                Integer numMax = 0;
                Integer textMax = 0;
                Integer dateMax = 0;
                Tuple tuple = ExtDimensionHelper.getTypeDataByGroupType((Integer)numMax, (Integer)textMax, (Integer)dateMax, (String)dynamicObject.getString("grouptype"));
                numMax = (Integer)tuple.p1;
                textMax = (Integer)tuple.p2;
                dateMax = (Integer)tuple.p3;
                if (datatype.equals(DataTypeEnum.TXT.getOIndex())) {
                    flag = this.extDimDataCheck(ExtDataServiceHelper.getSQLFieldArray((String)textPrefix, (int)textMax), extDimMemb, EXTFIELD_TEXT, textMax);
                } else if (datatype.equals(DataTypeEnum.CURRENCY.getOIndex()) || datatype.equals(DataTypeEnum.UNCURRENCY.getOIndex()) || datatype.equals(DataTypeEnum.PROPORTION.getOIndex()) || datatype.equals(DataTypeEnum.DEFAULT.getOIndex())) {
                    flag = this.extDimDataCheck(ExtDataServiceHelper.getSQLFieldArray((String)numPrefix, (int)numMax), extDimMemb, EXTFIELD_NUM, numMax);
                } else if (datatype.equals(DataTypeEnum.DATETP.getOIndex())) {
                    flag = this.extDimDataCheck(ExtDataServiceHelper.getSQLFieldArray((String)datePrefix, (int)dateMax), extDimMemb, EXTFIELD_DATE, dateMax);
                }
                if (!flag) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u7c7b\u578b\u5b57\u6bb5\u6210\u5458\u5df2\u8fbe\u5230\u4e0a\u9650\u3002", (String)"ExtDimEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return null;
                }
                if (!ExtDimensionHelper.checkIsExistOfField((String)extDimMemb.getString("fieldmapped"), (String)dynamicObject.getString("grouptype"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u6620\u5c04\u5b57\u6bb5\u5728\u5bf9\u5e94\u6570\u636e\u8868\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"ExtDimEditPlugin_205", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return null;
                }
            } else {
                extDimMemb.set("fieldmapped", (Object)"");
            }
            extDimMemb.set(DATA_TYPE, this.getModel().getValue(DATA_TYPE));
        } else if (level == 2) {
            extDimMemb.set(DATA_TYPE, this.getModel().getValue(DATA_TYPE));
        }
        this.setAssoDimMemberValue(Lists.newArrayList((Object[])new DynamicObject[]{extDimMemb}), OperationStatus.ADDNEW);
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            SaveDimMemberHelper.saveLog((DynamicObject)extDimMemb);
            DynamicObject[] dynamicObjects = this.saveInExtDimMemb();
            extDimMemb.set("member", (Object)dynamicObjects[0].getLong("id"));
            this.addValueOfCustomProperty();
            for (int i = 1; i < 11; ++i) {
                extDimMemb.set("dpropertyid" + i, this.getModel().getValue("dpropertyid" + i));
            }
            DynamicObject[] results = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{extDimMemb});
            if ("2".equals(extDimMemb.getString("grouptype")) && level == 2) {
                ExtDimensionHelper.savePreSharedMembers((List)Lists.newArrayList((Object[])new DynamicObject[]{extDimMemb}));
            }
            this.getModel().setDataChanged(false);
            this.getView().setEnable(Boolean.TRUE, new String[]{"baritemaddlevel"});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ExtDimEditPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            DynamicObject dynamicObject2 = results[0];
            return dynamicObject2;
        }
        catch (Exception e) {
            try {
                LOG.error("ext_preset_dim_save, error:" + e.getMessage(), (Throwable)e);
                tx.markRollback();
                throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)("Failed to save data: " + e.getMessage())), new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private void setAssoDimMemberValue(List<DynamicObject> extDimMembs, OperationStatus status) {
        block6: {
            String jsonStr;
            block5: {
                if (CollectionUtils.isEmpty(extDimMembs)) {
                    return;
                }
                jsonStr = this.getPageCache().get(ASSO_MEMBER);
                if (!StringUtils.isEmpty((String)jsonStr)) break block5;
                if (OperationStatus.EDIT != status) break block6;
                for (DynamicObject member : extDimMembs) {
                    member.getDynamicObjectCollection(ENTRY_ENTITY_ASSO).clear();
                }
                break block6;
            }
            Object assoDim = this.getModel().getValue(ASSO_DIM);
            List results = (List)SerializationUtils.fromJsonString((String)jsonStr, List.class);
            if (CollectionUtils.isNotEmpty((Collection)results)) {
                DynamicObjectType entryDyType = extDimMembs.get(0).getDynamicObjectCollection(ENTRY_ENTITY_ASSO).getDynamicObjectType();
                for (DynamicObject member : extDimMembs) {
                    ArrayList<DynamicObject> entryDys = new ArrayList<DynamicObject>(10);
                    int seq = 1;
                    for (Map multiF7 : results) {
                        DynamicObject entryDy = new DynamicObject(entryDyType);
                        entryDy.set("assodim", assoDim);
                        entryDy.set("assomem", multiF7.get("id"));
                        entryDy.set("dproperty", (Object)(multiF7.get("pid") == null ? Integer.valueOf(0) : (Serializable)multiF7.get("pid")));
                        entryDy.set("scope", multiF7.get("scope"));
                        entryDy.set("subtype", (Object)(multiF7.get("pid") == null ? "0" : "1"));
                        entryDy.set("seq", (Object)seq);
                        entryDys.add(entryDy);
                        ++seq;
                    }
                    DynamicObjectCollection entryAssoDys = member.getDynamicObjectCollection(ENTRY_ENTITY_ASSO);
                    entryAssoDys.clear();
                    entryAssoDys.addAll(entryDys);
                }
            }
        }
    }

    private void saveEditMemberData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long modelId = Long.parseLong((String)formShowParameter.getCustomParam("KEY_MODEL_ID"));
        Long id = Long.parseLong((String)formShowParameter.getCustomParam("id"));
        String message = this.checkMember(String.valueOf(modelId), false);
        if (StringUtils.isNotEmpty((String)message)) {
            this.getView().showTipNotification(message);
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bcm_structofextend");
        DynamicObject load = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)dataEntityType);
        Object[] allMemTrees = null;
        if ("3".equals(load.getString("level"))) {
            DynamicObjectCollection shareMems = QueryServiceHelper.query((String)"bcm_structofextend", (String)"id", (QFilter[])new QFilter[]{new QFilter("copyfrom", "=", (Object)id)});
            Set copyIds = shareMems.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
            DynamicObject[] copyMems = BusinessDataServiceHelper.load((Object[])copyIds.toArray(), (DynamicObjectType)dataEntityType);
            allMemTrees = new DynamicObject[copyMems.length + 1];
            this.copyArrays(copyMems, (DynamicObject[])allMemTrees);
            allMemTrees[0] = load;
        } else {
            allMemTrees = new DynamicObject[]{load};
        }
        DynamicObject parent = BusinessDataReader.loadSingle((Object)load.getLong("parent.id"), (DynamicObjectType)dataEntityType);
        String level = (String)formShowParameter.getCustomParam("level");
        String datatype = (String)this.getModel().getValue(DATA_TYPE);
        String modelShowNumber = MemberReader.findModelSNumberById((Object)modelId);
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        Object enumitem = this.getModel().getValue("enumitem");
        Long enumitemId = 0L;
        if (enumitem != null && !"".equals(enumitem) && "6".equals(datatype)) {
            enumitemId = ((DynamicObject)enumitem).getLong("id");
        }
        for (DynamicObject dynamicObject : allMemTrees) {
            dynamicObject.set("name", this.getModel().getValue("name"));
            dynamicObject.set("simplename", this.getModel().getValue("simplename"));
            dynamicObject.set("description", this.getModel().getValue("description"));
            if ("2".equals(level)) {
                dynamicObject.set("isparticipmerge", this.getModel().getValue("isparticipmerge"));
                dynamicObject.set("isaccountoffset", this.getModel().getValue("isaccountoffset"));
            } else if ("3".equals(level)) {
                dynamicObject.set("exchange", this.getModel().getValue("exchange"));
                dynamicObject.set("entryrate", this.getModel().getValue("entryrate"));
            }
            String grouptype = parent.getString("grouptype");
            if (!datatype.equals(dynamicObject.getString(DATA_TYPE)) || "6".equals(datatype) && "6".equals(dynamicObject.getString(DATA_TYPE)) && enumitem != null && !((DynamicObject)enumitem).getString(DATA_TYPE).equals(dynamicObject.getString("enumitem.datatype"))) {
                if (Arrays.asList("1", "2").contains(grouptype) && ExtDataServiceHelper.isExistDataOfExt((String)modelShowNumber, Collections.singletonList(Long.valueOf((String)formShowParameter.getCustomParam("id"))), (DynamicObject)parent)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b57\u6bb5\u6210\u5458\u6216\u5176\u5171\u4eab\u6210\u5458\u5df2\u6709\u6570\u636e\uff0c\u4e0d\u80fd\u4fee\u6539\u6570\u636e\u7c7b\u578b\u3002", (String)"ExtDimEditPlugin_72", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if ("3".equals(grouptype) && ExtDataServiceHelper.isExistDataOfInvestExtMem((String)modelShowNumber, (String)"", Collections.singletonList(load.getString("number")))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b57\u6bb5\u6210\u5458\u6216\u5176\u5171\u4eab\u6210\u5458\u5df2\u6709\u6570\u636e\uff0c\u4e0d\u80fd\u4fee\u6539\u6570\u636e\u7c7b\u578b\u3002", (String)"ExtDimEditPlugin_72", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!this.updateDatetypeOrEnum(dynamicObject, datatype, level, enumitemId)) {
                    return;
                }
            }
            dynamicObject.set("enumitem", (Object)enumitemId);
            dynamicObject.set("modifier", (Object)currUserId);
            dynamicObject.set("modifytime", (Object)date);
            this.addValueOfCustomProperty();
            for (int i = 1; i < 11; ++i) {
                dynamicObject.set("dpropertyid" + i, this.getModel().getValue("dpropertyid" + i));
            }
        }
        if (this.checkAssoDimMembers(modelShowNumber, Arrays.asList(allMemTrees), parent)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b57\u6bb5\u6210\u5458\u6216\u5176\u5171\u4eab\u6210\u5458\u5df2\u6709\u6570\u636e\uff0c\u4e0d\u80fd\u53d6\u6d88\u6216\u4fee\u6539\u5173\u8054\u591a\u7ef4\u6210\u5458\u3002", (String)"ExtDimMemberEdit_07", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setAssoDimMemberValue(Lists.newArrayList((Object[])allMemTrees), OperationStatus.EDIT);
        try (TXHandle tx = TX.required();){
            try {
                SaveDimMemberHelper.batchSaveLog((DynamicObject[])allMemTrees, (DimMemberOperateTypeEnum)DimMemberOperateTypeEnum.EDIT);
                SaveServiceHelper.save((DynamicObject[])allMemTrees);
            }
            catch (Exception e) {
                LOG.error("ext_preset_dim_save, error:" + e.getMessage(), (Throwable)e);
                tx.markRollback();
                throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)("Failed to save data: " + e.getMessage())), new Object[0]);
            }
        }
        this.getModel().setDataChanged(false);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ExtDimEditPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        MQMessagePublisherServiceHelper.publishClearDimMemberCache((String)MemberReader.findModelNumberById((Object)modelId), (String)"bcm_structofextend");
        ExtConvertServiceHelper.clearExtGroupCache((Long)modelId, (Long)parent.getLong("id"));
    }

    private boolean checkAssoDimMembers(String modelSNum, List<DynamicObject> existDys, DynamicObject parent) {
        String jsonStr = this.getPageCache().get(ASSO_MEMBER);
        List results = StringUtils.isEmpty((String)jsonStr) ? new ArrayList(10) : (List)SerializationUtils.fromJsonString((String)jsonStr, List.class);
        Object value = this.getModel().getValue(ASSO_DIM);
        if (value != null) {
            DynamicObject dimDy = (DynamicObject)value;
            for (Map result : results) {
                result.put("dimId", dimDy.getString("id"));
            }
        }
        if (ExtDataUtil.compareAssoDimMembers(results, (DynamicObject)existDys.get(0))) {
            boolean existDataOfExt = ExtDataServiceHelper.isExistDataOfExt((String)modelSNum, existDys.stream().map(x -> x.getLong("id")).collect(Collectors.toList()), (DynamicObject)parent);
            boolean existDataOfInvestExtMem = ExtDataServiceHelper.isExistDataOfInvestExtMem((String)modelSNum, (String)"", existDys.stream().map(x -> x.getString("number")).collect(Collectors.toList()));
            return existDataOfExt || existDataOfInvestExtMem;
        }
        return false;
    }

    private void copyArrays(DynamicObject[] copyMems, DynamicObject[] allMemTrees) {
        for (int i = 0; i < copyMems.length; ++i) {
            allMemTrees[i + 1] = copyMems[i];
        }
    }

    private boolean updateDatetypeOrEnum(DynamicObject load, String datatype, String level, Long enumitemId) {
        if ("6".equals(datatype)) {
            QFilter qFilter = new QFilter("id", "=", (Object)enumitemId);
            datatype = QueryServiceHelper.queryOne((String)"bcm_enumitem", (String)DATA_TYPE, (QFilter[])new QFilter[]{qFilter}).getString(DATA_TYPE);
        }
        boolean flag = false;
        if ("3".equals(level)) {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"grouptype", (QFilter[])new QFilter("id", "=", (Object)load.getLong("parent.id")).toArray());
            String grouptype = dynamicObject.getString("grouptype");
            Integer numMax = 0;
            Integer textMax = 0;
            Integer dateMax = 0;
            Tuple tuple = ExtDimensionHelper.getTypeDataByGroupType((Integer)numMax, (Integer)textMax, (Integer)dateMax, (String)grouptype);
            numMax = (Integer)tuple.p1;
            textMax = (Integer)tuple.p2;
            dateMax = (Integer)tuple.p3;
            if (!"3".equals(grouptype) && this.judgeIsChangeType(load, datatype)) {
                if (datatype.equals(DataTypeEnum.TXT.getOIndex())) {
                    flag = this.extDimDataCheck(ExtDataServiceHelper.getSQLFieldArray((String)textPrefix, (int)textMax), load, EXTFIELD_TEXT, textMax);
                } else if (datatype.equals(DataTypeEnum.CURRENCY.getOIndex()) || datatype.equals(DataTypeEnum.UNCURRENCY.getOIndex()) || datatype.equals(DataTypeEnum.PROPORTION.getOIndex()) || datatype.equals(DataTypeEnum.DEFAULT.getOIndex())) {
                    flag = this.extDimDataCheck(ExtDataServiceHelper.getSQLFieldArray((String)numPrefix, (int)numMax), load, EXTFIELD_NUM, numMax);
                } else if (datatype.equals(DataTypeEnum.DATETP.getOIndex())) {
                    flag = this.extDimDataCheck(ExtDataServiceHelper.getSQLFieldArray((String)datePrefix, (int)dateMax), load, EXTFIELD_DATE, dateMax);
                }
                if (!flag) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u5206\u7ec4\u6216\u5171\u4eab\u6210\u5458\u7684\u4e1a\u52a1\u5206\u7ec4\u4e2d\uff0c\u8be5\u6570\u636e\u7c7b\u578b\u5b57\u6bb5\u6210\u5458\u5df2\u8fbe\u5230\u4e0a\u9650\u3002", (String)"ExtDimEditPlugin_207", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (!ExtDimensionHelper.checkIsExistOfField((String)load.getString("fieldmapped"), (String)dynamicObject.getString("grouptype"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u6620\u5c04\u5b57\u6bb5\u5728\u5bf9\u5e94\u6570\u636e\u8868\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"ExtDimEditPlugin_205", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return false;
                }
                load.set(DATA_TYPE, this.getModel().getValue(DATA_TYPE));
                return true;
            }
            load.set(DATA_TYPE, this.getModel().getValue(DATA_TYPE));
            return true;
        }
        return true;
    }

    private boolean judgeIsChangeType(DynamicObject load, String datatype) {
        List<String> textList = Collections.singletonList("3");
        List<String> numList = Arrays.asList("0", "1", "2", "5");
        List<String> dateList = Collections.singletonList("4");
        String dt = load.getString(DATA_TYPE);
        if ("6".equals(dt)) {
            QFilter qFilter = new QFilter("id", "=", (Object)((DynamicObject)load.get("enumitem")).getLong("id"));
            dt = QueryServiceHelper.queryOne((String)"bcm_enumitem", (String)DATA_TYPE, (QFilter[])new QFilter[]{qFilter}).getString(DATA_TYPE);
        }
        boolean result = textList.contains(dt) && textList.contains(datatype) ? false : (numList.contains(dt) && numList.contains(datatype) ? false : !dateList.contains(dt) || !dateList.contains(datatype));
        return result;
    }

    private void addValueOfCustomProperty() {
        List rowidList;
        if (this.getPageCache().get("rowidList") != null && (rowidList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("rowidList"), List.class)) != null) {
            HashSet<String> set = new HashSet<String>(rowidList.size());
            for (Map map : rowidList) {
                String[] rowid = ((String)map.get("rowid")).split(",");
                this.getModel().setValue(rowid[1], (Object)rowid[0]);
                set.add(rowid[1]);
            }
            Long dimId = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)DimEntityNumEnum.EXTENDS.getNumber());
            for (String s : DefinedPropertyUtil.getDefinedProperty((Long)dimId)) {
                boolean bl = set.add(s);
                if (!bl) continue;
                this.getModel().setValue(s, null);
            }
        }
    }

    private void changeIsLeafStatus(DynamicObject dynamicObject) {
        if (dynamicObject.getBoolean("isleaf")) {
            dynamicObject.set("isleaf", (Object)"0");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    private void setLongNumber(Long parentId, DynamicObject extDimMemb, String number) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bcm_structofextend");
        DynamicObject dynamicObject = BusinessDataReader.loadSingle((Object)parentId, (DynamicObjectType)dataEntityType);
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bbe\u7f6e\u957f\u7f16\u7801\u51fa\u9519\u3002", (String)"ExtDimEditPlugin_67", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        extDimMemb.set("longnumber", (Object)(dynamicObject.getString("longnumber") + '!' + number));
    }

    private boolean formatYes(String number) {
        Matcher matcher = pattern.matcher(number);
        if (!matcher.matches()) {
            return false;
        }
        return !number.contains("..") && !number.startsWith(".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataTypeCorrectOfMappingError() {
        Long id = (Long)this.getModel().getValue("id");
        Long pId = (Long)this.getView().getFormShowParameter().getCustomParam("parent");
        Long modelId = Long.valueOf(this.getPageCache().get("KEY_MODEL_ID"));
        String modelNumber = MemberReader.findModelSNumberById((Object)modelId);
        QFilter qfGroup = new QFilter("id", "=", (Object)pId);
        DynamicObject groupDy = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"id, number, grouptype", (QFilter[])qfGroup.toArray());
        String grouptype = groupDy.getString("grouptype");
        if ("3".equals(grouptype)) {
            return;
        }
        QFilter qf = new QFilter("id", "=", (Object)id);
        DynamicObject extMem = BusinessDataServiceHelper.loadSingle((String)"bcm_structofextend", (String)"id, datatype, fieldmapped, enumitem, parent", (QFilter[])qf.toArray());
        String fieldmapped = extMem.getString("fieldmapped");
        QFilter qf1 = new QFilter("parent", "=", (Object)pId);
        qf1.and("fieldmapped", "=", (Object)fieldmapped);
        DynamicObject[] sameMppedMems = BusinessDataServiceHelper.load((String)"bcm_structofextend", (String)"id, datatype, fieldmapped, enumitem.datatype, parent", (QFilter[])qf1.toArray());
        if (sameMppedMems.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u5458\u6620\u5c04\u91cd\u590d\uff0c\u65e0\u6cd5\u77eb\u6b63\u3002", (String)"ExtDimMemberEdit_04", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String datatype = extMem.getString(DATA_TYPE);
        if ("6".equals(datatype)) {
            datatype = extMem.getString("enumitem.datatype");
        }
        List<String> textList = Collections.singletonList("3");
        List<String> numList = Arrays.asList("0", "1", "2", "5");
        List<String> dateList = Collections.singletonList("4");
        boolean ifText = textList.contains(datatype);
        boolean ifNum = numList.contains(datatype);
        boolean ifDate = dateList.contains(datatype);
        if ((ifNum || ifDate) && fieldmapped.startsWith(textPrefix)) {
            String msg = this.judgeAndSetValue(extMem, grouptype);
            if (StringUtils.isNotEmpty((String)msg)) {
                this.getView().showErrorNotification(msg);
                return;
            }
            String newFieldMapped = extMem.getString("fieldmapped");
            DynamicObject[] extDatas = ExtDataServiceHelper.queryDataOfMem((String)modelNumber, (String)fieldmapped, (DynamicObject)groupDy, (String)newFieldMapped);
            if (extDatas != null && extDatas.length > 0) {
                for (DynamicObject extData : extDatas) {
                    block21: {
                        if (ifNum) {
                            String data = extData.getString(fieldmapped);
                            extData.set(newFieldMapped, (Object)new BigDecimal(data.trim()));
                        } else {
                            try {
                                String dateStr = extData.getString(fieldmapped);
                                if (dateStr == null) break block21;
                                Date date = null;
                                try {
                                    date = DateTimeUtils.parseStrDate((String)dateStr);
                                }
                                catch (ParseException ex) {
                                    try {
                                        date = DateTimeUtils.parseStrDate2((String)dateStr);
                                    }
                                    catch (ParseException ex2) {
                                        date = DateTimeUtils.parseStrDate3((String)dateStr);
                                    }
                                }
                                finally {
                                    extData.set(newFieldMapped, (Object)date);
                                }
                            }
                            catch (Exception e) {
                                throw new KDBizException((Throwable)e, new ErrorCode("", ""), new Object[]{e.getMessage()});
                            }
                        }
                    }
                    extData.set(fieldmapped, (Object)"");
                }
                this.saveMemAndData(extMem, extDatas);
            } else {
                this.saveMemAndData(extMem, null);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u77eb\u6b63\u6210\u529f\u3002", (String)"ExtDimMemberEdit_01", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if ((ifText || ifDate) && fieldmapped.startsWith(numPrefix) || (ifText || ifNum) && fieldmapped.startsWith(datePrefix)) {
            String msg = this.judgeAndSetValue(extMem, grouptype);
            if (StringUtils.isNotEmpty((String)msg)) {
                this.getView().showErrorNotification(msg);
                return;
            }
            this.saveMemAndData(extMem, null);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u77eb\u6b63\u6210\u529f\u3002", (String)"ExtDimMemberEdit_01", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u6b63\u786e\uff0c\u4e0d\u9700\u8981\u77eb\u6b63\u3002", (String)"ExtDimMemberEdit_03", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void saveMemAndData(DynamicObject extMem, DynamicObject[] extDatas) {
        try (TXHandle tx = TX.required((String)"saveMemAndData");){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{extMem});
                if (extDatas != null) {
                    SaveServiceHelper.save((DynamicObject[])extDatas);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                LOG.error(e.getMessage(), (Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("", ""), new Object[]{e.getMessage()});
            }
        }
    }

    private String judgeAndSetValue(DynamicObject dy, String grouptype) {
        String sameDatatype = dy.getString(DATA_TYPE);
        if ("6".equals(sameDatatype)) {
            sameDatatype = dy.getString("enumitem.datatype");
        }
        boolean flag = false;
        Integer numMax = 0;
        Integer textMax = 0;
        Integer dateMax = 0;
        Tuple tuple = ExtDimensionHelper.getTypeDataByGroupType((Integer)numMax, (Integer)textMax, (Integer)dateMax, (String)grouptype);
        numMax = (Integer)tuple.p1;
        textMax = (Integer)tuple.p2;
        dateMax = (Integer)tuple.p3;
        if (sameDatatype.equals(DataTypeEnum.TXT.getOIndex())) {
            flag = this.extDimDataCheck(ExtDataServiceHelper.getSQLFieldArray((String)textPrefix, (int)textMax), dy, EXTFIELD_TEXT, textMax);
        } else if (sameDatatype.equals(DataTypeEnum.CURRENCY.getOIndex()) || sameDatatype.equals(DataTypeEnum.UNCURRENCY.getOIndex()) || sameDatatype.equals(DataTypeEnum.PROPORTION.getOIndex()) || sameDatatype.equals(DataTypeEnum.DEFAULT.getOIndex())) {
            flag = this.extDimDataCheck(ExtDataServiceHelper.getSQLFieldArray((String)numPrefix, (int)numMax), dy, EXTFIELD_NUM, numMax);
        } else if (sameDatatype.equals(DataTypeEnum.DATETP.getOIndex())) {
            flag = this.extDimDataCheck(ExtDataServiceHelper.getSQLFieldArray((String)datePrefix, (int)dateMax), dy, EXTFIELD_DATE, dateMax);
        }
        if (!flag) {
            return ResManager.loadKDString((String)"\u8be5\u6570\u636e\u7c7b\u578b\u5b57\u6bb5\u6210\u5458\u5df2\u8fbe\u5230\u4e0a\u9650\u3002", (String)"ExtDimEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (!ExtDimensionHelper.checkIsExistOfField((String)dy.getString("fieldmapped"), (String)grouptype)) {
            return ResManager.loadKDString((String)"\u9884\u6620\u5c04\u5b57\u6bb5\u5728\u5bf9\u5e94\u6570\u636e\u8868\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"ExtDimEditPlugin_205", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private DynamicObjectCollection getRateOfExtend() {
        String modelId;
        Object model = this.getModel().getValue("model");
        if (model != null && (modelId = ((DynamicObject)model).getString("id")) != null) {
            DynamicObjectCollection defineDyc = ExportUtil.getAllRatesOfExtend((Long)Long.parseLong(modelId));
            return defineDyc;
        }
        return null;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bde = (BasedataEdit)this.getControl(ASSO_DIM);
        bde.addBeforeF7SelectListener(evt -> {
            ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter qf = new QFilter("model", "=", (Object)Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID")));
            qf.and("number", "not in", (Object)ExtDataUtil.exceptDims);
            listFilterParameter.setFilter(qf);
            listFilterParameter.setOrderBy("dseq");
        });
        this.addClickListeners(ASSO_MEMBER);
        this.addItemClickListeners("advcontoolbarap2");
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (ASSO_MEMBER.equals(key)) {
            if (this.getModel().getValue(ASSO_DIM) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5173\u8054\u7ef4\u5ea6\u3002", (String)"ExtDimEditPlugin_211", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.openDimF7View(key);
        }
    }

    private void openDimF7View(String key) {
        Object assoDim = this.getModel().getValue(ASSO_DIM);
        if (assoDim == null) {
            return;
        }
        DynamicObject dimDy = (DynamicObject)assoDim;
        long dimensionID = dimDy.getLong("id");
        List dimSeq = MemberReader.getDimDyoByModelId((long)this.getModelId()).values().stream().filter(x -> x.getLong("id") == dimensionID).map(x -> x.getString("dseq")).collect(Collectors.toList());
        String name = dimDy.getString("name");
        String dimNum = dimDy.getString("number");
        FormShowParameter para = new FormShowParameter();
        if ("InternalCompany".equalsIgnoreCase(dimNum)) {
            para.setFormId("bcm_mulmemberf7_tem_ic");
            para.setCustomParam("sign", (Object)("assomember_" + DimTypesEnum.INTERCOMPANY.getNumber()));
        } else {
            para.setFormId("bcm_mulmemberf7base_tem");
            para.setCustomParam("sign", (Object)ASSO_MEMBER);
        }
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCustomParam("dimensionid", (Object)dimensionID);
        para.setCustomParam("dimension", dimSeq.size() > 0 ? dimSeq.get(0) : "-1");
        para.setCustomParam("KEY_MODEL_ID", (Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID").toString());
        para.setCaption(String.format(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - %s", (String)"ExtDimMemberEdit_06", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (ASSO_MEMBER.equals(actionId)) {
            Object returnData = evt.getReturnData();
            if (returnData == null) {
                return;
            }
            DynamicObjectCollection memScopes = (DynamicObjectCollection)evt.getReturnData();
            if (memScopes == null || memScopes.size() == 0) {
                this.getModel().setValue(actionId, (Object)"");
                this.getPageCache().put(actionId, "");
            } else {
                MultiF7Results results = MultiF7Results.buildParam((DynamicObjectCollection)memScopes, (long)this.getModelId());
                this.getModel().setValue(actionId, (Object)results.getShowText());
                this.getPageCache().put(actionId, SerializationUtils.toJsonString((Object)results.toList()));
            }
        }
    }

    @Override
    public void beforePropertyChanged(PropertyChangedArgs e) {
        Object newValue;
        super.beforePropertyChanged(e);
        String name = e.getProperty().getName();
        if (ASSO_MEMBER.equals(name) && ((newValue = e.getChangeSet()[0].getNewValue()) == null || StringUtils.isEmpty((String)newValue.toString()))) {
            this.getPageCache().remove(ASSO_MEMBER);
            this.getPageCache().remove("showtext");
        }
    }
}

