/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimensionnew;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.papertemplate.ExtDimHelper;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class ExtDimMemberF7Plugin
extends AbstractBaseListPlugin
implements SearchEnterListener,
RowClickEventListener {
    private static Log log = LogFactory.getLog(ExtDimMemberF7Plugin.class);
    private static final String CONTROL_MODEL = "extendmodel";
    private static final String CONTROL_FIELD_ENTRY = "fieldentry";
    private static final String BTN_OK = "btnok";
    private static final String CONTROL_SEARCH = "searchap";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_OK, CONTROL_SEARCH);
        Search search = (Search)this.getControl(CONTROL_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        EntryGrid grid = (EntryGrid)this.getControl(CONTROL_FIELD_ENTRY);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadExtendmodel();
        this.refreshGrid(null);
    }

    public void search(SearchEnterEvent evt) {
        this.refreshGrid(evt.getText());
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String keyName;
        super.propertyChanged(e);
        switch (keyName = e.getProperty().getName()) {
            case "extendmodel": {
                ((Search)this.getControl(CONTROL_SEARCH)).setSearchKey("");
                this.getView().updateView(CONTROL_SEARCH);
                this.refreshGrid(null);
                break;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                if (!this.validate()) break;
                this.btnOk();
                break;
            }
        }
    }

    private void loadExtendmodel() {
        Long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        Long extendModelId = (Long)this.getFormCustomParam("model");
        HashSet<Long> modelIds = new HashSet<Long>();
        Object filterModelId = this.getFormCustomParam("filterModelId");
        if (Objects.nonNull(filterModelId)) {
            Long selectModelId = Long.valueOf(filterModelId.toString());
            modelIds.add(selectModelId);
            extendModelId = selectModelId;
        } else {
            Object seller = this.getFormCustomParam("seller");
            Object purchaser = this.getFormCustomParam("purchaser");
            Object mergenode = this.getFormCustomParam("mergenode");
            if (Objects.nonNull(seller) && seller instanceof Long) {
                modelIds.add((Long)seller);
            }
            if (Objects.nonNull(purchaser) && purchaser instanceof Long) {
                modelIds.add((Long)purchaser);
            }
            if (Objects.nonNull(mergenode) && mergenode instanceof Long) {
                modelIds.add((Long)mergenode);
            }
        }
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("status", "=", (Object)"C");
        filter.and("id", "in", modelIds);
        DynamicObjectCollection extendsModelList = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id,number,name", (QFilter[])new QFilter[]{filter}, (String)"number");
        ComboEdit comboEdit = (ComboEdit)this.getControl(CONTROL_MODEL);
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(extendsModelList.size());
        for (DynamicObject obj : extendsModelList) {
            data.add(new ComboItem(new LocaleString(obj.getString("name")), obj.getString("id")));
        }
        comboEdit.setComboItems(data);
        if (Objects.isNull(extendModelId) && CollectionUtils.isNotEmpty((Collection)extendsModelList)) {
            extendModelId = ((DynamicObject)extendsModelList.get(0)).getLong("id");
        }
        this.getModel().setValue(CONTROL_MODEL, (Object)extendModelId);
    }

    private void refreshGrid(String search) {
        this.getModel().deleteEntryData(CONTROL_FIELD_ENTRY);
        EntryGrid grid = (EntryGrid)this.getControl(CONTROL_FIELD_ENTRY);
        String extendModelId = (String)this.getValue(CONTROL_MODEL);
        if (!StringUtils.isEmpty((String)extendModelId)) {
            Object filterDim;
            Long selectedFieldId = (Long)this.getFormCustomParam("field");
            Integer selectedRow = null;
            Boolean isShowBuySellField = (Boolean)this.getFormCustomParam("isShowBuySellField");
            if (isShowBuySellField == null) {
                isShowBuySellField = false;
            }
            List fields = ExtDimHelper.getTmpFields4Tmpl((Long)Long.valueOf(extendModelId), (boolean)isShowBuySellField);
            Object dataTypes = this.getFormCustomParam("filterDatatype");
            if (dataTypes != null) {
                Set filterDataTypes = Arrays.stream(dataTypes.toString().split(",")).collect(Collectors.toSet());
                fields.removeIf(e -> !filterDataTypes.contains(e.getDataType()));
            }
            if ((filterDim = this.getFormCustomParam("filterDim")) != null) {
                fields.removeIf(e -> !(!e.isLinkDim() ? filterDim.equals(e.getNumber()) : filterDim.equals(e.getDimInfo().p2)));
            }
            if (StringUtils.isNotEmpty((String)search)) {
                fields.removeIf(e -> !e.getNumber().contains(search) && !e.getName().contains(search));
            }
            if (fields.size() <= 0) {
                return;
            }
            grid.getModel().batchCreateNewEntryRow(CONTROL_FIELD_ENTRY, fields.size());
            int row = 0;
            this.getModel().beginInit();
            for (IntrField field : fields) {
                DynamicObject rowObj = this.getModel().getEntryRowEntity(CONTROL_FIELD_ENTRY, row);
                rowObj.set("fieldid", (Object)field.getId());
                rowObj.set("listnumber", (Object)field.getNumber());
                rowObj.set("listname", (Object)field.getName());
                if (field.getId().equals(selectedFieldId)) {
                    selectedRow = row;
                }
                ++row;
            }
            this.getModel().endInit();
            grid.setPageIndex(1);
            this.getView().updateView(CONTROL_FIELD_ENTRY);
            if (selectedRow != null) {
                grid.selectRows(selectedRow.intValue(), true);
            }
        }
    }

    private void btnOk() {
        Long extendModelId = null;
        String extendModelIdStr = (String)this.getModel().getValue(CONTROL_MODEL);
        if (StringUtils.isNotEmpty((String)extendModelIdStr)) {
            extendModelId = Long.valueOf(extendModelIdStr);
        }
        Tuple extendField = null;
        EntryGrid grid = (EntryGrid)this.getControl(CONTROL_FIELD_ENTRY);
        if (grid.getSelectRows().length > 0) {
            DynamicObject rowObj = this.getModel().getEntryRowEntity(CONTROL_FIELD_ENTRY, grid.getSelectRows()[0]);
            extendField = new Tuple((Object)rowObj.getLong("fieldid"), (Object)rowObj.getString("listnumber"), (Object)rowObj.getString("listname"));
        }
        Tuple returnData = new Tuple((Object)extendModelId, extendField, this.getFormCustomParam("controlKey"));
        this.getView().returnDataToParent((Object)returnData);
        this.getView().close();
    }

    private boolean validate() {
        String extendModelId = (String)this.getValue(CONTROL_MODEL);
        if (StringUtils.isEmpty((String)extendModelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u4e1a\u52a1\u6a21\u578b\u201d\u3002", (String)"ExtDimMemberF7Plugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        EntryGrid grid = (EntryGrid)this.getControl(CONTROL_FIELD_ENTRY);
        if (0 == grid.getSelectRows().length) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u62d3\u5c55\u7ef4\u5ea6\u6210\u5458\u201d\u3002", (String)"ExtDimMemberF7Plugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.btnOk();
    }
}

