/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimensionnew;

import java.util.Calendar;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.util.UpgradeUtil;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;
import kd.fi.bcm.formplugin.dimensionnew.DimensionMemberBaseEdit;
import kd.fi.bcm.formplugin.dimensionnew.prpertychangeaction.PropertyChangeTips;
import kd.fi.bcm.formplugin.util.ApplicationUtils;
import org.apache.commons.lang3.StringUtils;

public class FYMemberEdit
extends DimensionMemberBaseEdit {
    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel iDataModel = this.getModel();
        iDataModel.setDataChanged(false);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String actionName = this.getPageCache().get("actionName");
        if (("baritemaddsub".equals(actionName) || "baritemaddlevel".equals(actionName) || "baritemaddshare".equals(actionName)) && !ApplicationUtils.hasBudget(this.getView())) {
            this.initNumber();
        }
        IDataModel iDataModel = this.getModel();
        iDataModel.setDataChanged(false);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long modelId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        boolean notEditAble = UpgradeUtil.existPeriodInfo((Long)modelId, (String)this.getModel().getValue("number").toString());
        if (notEditAble) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"shielddim"});
        }
        this.setRootMemberProp();
        PropertyChangeTips.afterOpenPage(this.getModel(), this.getView());
    }

    private void setRootMemberProp() {
        Integer level = (Integer)this.getModel().getValue("level");
        if (level == 1) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"shielddim"});
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String actionName;
        super.beforeDoOperation(e);
        if (e.getSource() instanceof Save) {
            this.checkNumberLegal(e);
        }
        if ((actionName = this.getModel().getValue("addtext").toString()) == null) {
            actionName = this.getPageCache().get("actionName");
        }
        String id = this.getView().getFormShowParameter().getCustomParam("id").toString();
        boolean ischange = this.getModel().getDataChanged();
        this.getModel().setValue("listselectedrowid", (Object)String.valueOf(id));
        if ("baritemaddsub".equals(actionName) || "baritemaddlevel".equals(actionName) || "baritemaddshare".equals(actionName)) {
            switch (actionName) {
                case "baritemaddsub": {
                    this.getModel().setValue("addtext", (Object)"baritemaddsub");
                    break;
                }
                case "baritemaddlevel": {
                    this.getModel().setValue("addtext", (Object)"baritemaddlevel");
                    break;
                }
                case "baritemaddshare": {
                    this.getModel().setValue("addtext", (Object)"baritemaddshare");
                    break;
                }
            }
        }
        this.getModel().setDataChanged(ischange);
    }

    private void checkNumberLegal(BeforeDoOperationEventArgs e) {
        if (ApplicationUtils.hasBudget(this.getView())) {
            String fyNumber = (String)this.getModel().getValue("number");
            String id = this.getView().getFormShowParameter().getCustomParam("id").toString();
            boolean isGeneralFy = DimensionUtil.isAddGeneralFY(this.getClass().getName(), this.getPageCache().get("actionName"), Long.parseLong(id));
            if (!(isGeneralFy || !StringUtils.isEmpty((CharSequence)fyNumber) && this.checkNumber(fyNumber))) {
                e.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u662f\u5408\u6cd5\u7684\u8d22\u5e74\u6210\u5458\u7f16\u7801\uff08\u8d22\u5e74\u7f16\u7801\u5fc5\u987b\u4ee5FY\u5f00\u59cb\uff0c\u4ee5\u6570\u5b57\u7ed3\u675f\u7684\u7f16\u7801\uff0c\u652f\u6301\u7684\u7f16\u7801\u8303\u56f4\u4e3a\u5f53\u524d\u5e74\u524d\u540e50\u5e74\u7684\u671f\u95f4\u8303\u56f4\uff09\u3002", (String)"FYMemberEdit_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    protected String getModelType() {
        return "bcm_fymember";
    }

    @Override
    protected String getTreeModelType() {
        return "bcm_fymembertree";
    }

    protected void initNumber() {
        boolean language;
        long id = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("id"));
        String selectFields = "level";
        QFilter fdimenId = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{fdimenId};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_fymembertree", (String)selectFields, (QFilter[])filters, (String)"");
        boolean bl = language = !Lang.get().equals((Object)Lang.zh_CN) && !Lang.get().equals((Object)Lang.zh_TW);
        if (dcs != null && dcs.size() == 1) {
            int level = ((DynamicObject)dcs.get(0)).getInt("level");
            if (level == 2) {
                if ("baritemaddsub".equals(this.getView().getFormShowParameter().getCustomParam("actionName"))) {
                    selectFields = "number";
                    fdimenId = new QFilter("parent", "=", (Object)id);
                    filters = new QFilter[]{fdimenId};
                    dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_fymembertree", (String)selectFields, (QFilter[])filters, (String)"dseq");
                    if (dcs != null && dcs.size() > 0) {
                        String number = ((DynamicObject)dcs.get(dcs.size() - 1)).getString("number");
                        if (!DimensionUtil.isAddGeneralFY(this.getClass().getName(), this.getPageCache().get("actionName"), id)) {
                            int fynum = Integer.parseInt(number.substring(2));
                            number = "FY" + (fynum + 1);
                            this.getModel().setValue("number", (Object)number);
                            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
                            String yearLs = ResManager.loadKDString((String)"\u5e74", (String)"FYMemberEdit_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                            String name = language ? String.valueOf(fynum + 1) : fynum + 1 + yearLs;
                            this.getModel().setValue("name", (Object)name);
                        }
                    }
                }
            } else if (level == 3) {
                selectFields = "parent";
                fdimenId = new QFilter("id", "=", (Object)id);
                filters = new QFilter[]{fdimenId};
                dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_fymembertree", (String)selectFields, (QFilter[])filters, (String)"");
                if (dcs != null && dcs.size() > 0) {
                    String parentid = ((DynamicObject)dcs.get(0)).getString("parent");
                    selectFields = "number";
                    fdimenId = new QFilter("parent", "=", (Object)ConvertUtil.convertStrToLong((String)parentid));
                    filters = new QFilter[]{fdimenId};
                    dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_fymembertree", (String)selectFields, (QFilter[])filters, (String)"dseq");
                    if (dcs != null && dcs.size() > 0) {
                        String number = ((DynamicObject)dcs.get(dcs.size() - 1)).getString("number");
                        if (!DimensionUtil.isAddGeneralFY(this.getClass().getName(), this.getPageCache().get("actionName"), id)) {
                            int fynum = Integer.parseInt(number.substring(2));
                            number = "FY" + (fynum + 1);
                            String yearLs = ResManager.loadKDString((String)"\u5e74", (String)"FYMemberEdit_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                            String name = language ? String.valueOf(fynum + 1) : fynum + 1 + yearLs;
                            this.getModel().setValue("name", (Object)name);
                            this.getModel().setValue("number", (Object)number);
                            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
                        }
                    }
                }
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    protected boolean checkNumber(String fyNumber) {
        boolean re;
        boolean bl = re = fyNumber != null && fyNumber.matches("FY[\\d]{4}");
        if (re) {
            Calendar calendar = Calendar.getInstance();
            int cuYear = calendar.get(1);
            int rangeSize = 50;
            int year = Integer.parseInt(fyNumber.substring(2));
            if (year > cuYear + rangeSize || year < cuYear - rangeSize) {
                re = false;
            }
        }
        return re;
    }
}

