/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimensionnew;

import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.formplugin.dimensionnew.DimensionMemberBaseEdit;
import kd.fi.bcm.formplugin.dimensionnew.prpertychangeaction.PropertyChangeTips;

public class InterCompanyMemberEdit
extends DimensionMemberBaseEdit {
    private static final String ENTRY_ENTITY = "forbiddenrecords";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl("permclass")), (Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        this.addAssoBeforeF7SelectListenerNoDatatype(e);
        this.addItemClickListeners("ictoolbarap", "bar_save");
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnableOfAsso();
        this.setRootMemberProp();
        Object parent = this.getModel().getValue("parent");
        if (parent != null && "ICEntity".equals(((DynamicObject)parent).getString("number"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"simplename"});
        }
        PropertyChangeTips.afterOpenPage(this.getModel(), this.getView());
    }

    private void setRootMemberProp() {
        Integer level = (Integer)this.getModel().getValue("level");
        if (level == 1) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"permclass", "shielddim", "aggoprt"});
        }
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.setRecord();
    }

    private void setRecord() {
        if (ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM060")) {
            QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
            filter.and(new QFilter("number", "=", this.getModel().getValue("number")));
            filter.and(new QFilter("isinnerorg", "=", (Object)true));
            filter.and(new QFilter("entitypart.isouterorg", "=", (Object)true));
            this.getView().setVisible(Boolean.valueOf(QueryServiceHelper.exists((String)"bcm_entitymembertree", (QFilter[])filter.toArray())), new String[]{"icrecordap"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"icrecordap"});
        }
        IDataModel iDataModel = this.getModel();
        iDataModel.setDataChanged(false);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setRecord();
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult().isSuccess() && ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM060")) {
            QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
            filter.and(new QFilter("number", "=", this.getModel().getValue("number")));
            filter.and(new QFilter("id", "!=", this.getModel().getValue("id")));
            DynamicObject obj = QueryServiceHelper.queryOne((String)"bcm_icmembertree", (String)"id", (QFilter[])filter.toArray());
            if (obj != null) {
                DynamicObject member = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)"bcm_icmembertree");
                DynamicObjectCollection records = member.getDynamicObjectCollection(ENTRY_ENTITY);
                records.sort(Comparator.comparing(r -> r.getDate("forbiddeneffdate")));
                DynamicObject other = BusinessDataServiceHelper.loadSingle((Object)obj.getLong("id"), (String)"bcm_icmembertree");
                DynamicObjectCollection otherRecords = new DynamicObjectCollection();
                for (int i = 0; i < records.size(); ++i) {
                    ((DynamicObject)records.get(i)).set("seq", (Object)(i + 1));
                    otherRecords.add((Object)((DynamicObject)OrmUtils.clone((IDataEntityBase)((IDataEntityBase)records.get(i)), (boolean)true, (boolean)true)));
                }
                other.set(ENTRY_ENTITY, (Object)otherRecords);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{other, member});
            }
        }
        if ("save".equals(e.getOperateKey())) {
            PermClassEntityHelper.savePermClass((IDataModel)this.getModel(), (Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"), (OperationStatus)this.getView().getFormShowParameter().getStatus());
        }
        this.setRecord();
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    protected String getModelType() {
        return "bcm_intercompanymember";
    }

    @Override
    protected String getTreeModelType() {
        return "bcm_icmembertree";
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("addrow".equals(key)) {
            DynamicObject row = this.getModel().getEntryEntity(ENTRY_ENTITY).addNew();
            row.set("forbiddenmodifier", (Object)RequestContext.get().getCurrUserId());
            row.set("forbiddenmodifytime", (Object)TimeServiceHelper.now());
            this.getModel().createNewEntryRow(ENTRY_ENTITY, row);
        } else if ("deleterow".equals(key)) {
            EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] rows = grid.getSelectRows();
            if (rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u884c\u3002", (String)"InterCompanyMemberEdit_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                this.getModel().deleteEntryRows(ENTRY_ENTITY, rows);
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (propName.equals("forbiddeneffdate") || propName.equals("forbiddenexpdate")) {
            this.checkDate();
        }
    }

    private void checkDate() {
        int index = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        DynamicObjectCollection records = this.getModel().getEntryEntity(ENTRY_ENTITY);
        Date startDate = ((DynamicObject)records.get(index)).getDate("forbiddeneffdate");
        if (records.size() == 0 || startDate == null) {
            return;
        }
        Date endDate = ((DynamicObject)records.get(index)).getDate("forbiddenexpdate");
        String modelId = ((DynamicObject)this.getModel().getValue("model")).getString("id");
        Date modelBeginDate = EntityVersioningUtil.getModelBeginDate((Object)modelId);
        if (startDate.before(modelBeginDate)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e%s\u3002", (String)"InterCompanyMemberEdit_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new SimpleDateFormat("yyyy-MM-dd").format(modelBeginDate)));
            this.getModel().setValue("forbiddeneffdate", null, index);
            this.getModel().setDataChanged(false);
            return;
        }
        if (endDate != null && endDate.before(startDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"InterCompanyMemberEdit_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("forbiddenexpdate", null, index);
            this.getModel().setDataChanged(false);
        }
    }
}

