/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimensionnew;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimensionnew.DimensionMemberBaseEdit;
import kd.fi.bcm.formplugin.dimensionnew.prpertychangeaction.PropertyChangeTips;
import kd.fi.bcm.formplugin.util.FormUtils;
import kd.fi.bcm.spread.common.util.StringUtil;

public class PeriodMemberEdit
extends DimensionMemberBaseEdit {
    private static int[] dayofMonth = new int[]{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final String effmonthID = "effmonth";
    public static final String expmonthID = "expmonth";
    private static final String LAST_PERIOD = "lastperiod";
    private static final String USE_YEAR = "useyear";
    private static final String IS_ADJUST = "isadjust";
    private static final Map<String, Integer> month2Dys = new HashMap<String, Integer>(){
        {
            this.put("1", 31);
            this.put("2", 28);
            this.put("3", 31);
            this.put("4", 30);
            this.put("5", 31);
            this.put("6", 30);
            this.put("7", 31);
            this.put("8", 31);
            this.put("9", 30);
            this.put("10", 31);
            this.put("11", 30);
            this.put("12", 31);
        }
    };

    @Override
    protected String getModelType() {
        return "bcm_periodmember";
    }

    @Override
    protected String getTreeModelType() {
        return "bcm_periodmembertree";
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.addAdjustPeriod();
        this.setRootMemberProp();
        PropertyChangeTips.afterOpenPage(this.getModel(), this.getView());
    }

    private void setRootMemberProp() {
        Integer level = (Integer)this.getModel().getValue("level");
        if (level == 1) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"simplename", "shielddim"});
        }
    }

    public void addEnum(String d, int a) {
        ComboEdit edit = (ComboEdit)this.getView().getControl(d);
        ArrayList<String[]> keysAndValues = new ArrayList<String[]>(a);
        int startDay = 1;
        int startValue = 1;
        for (int i = 0; i < a; ++i) {
            String[] keysAndValue = new String[]{String.valueOf(startDay), String.valueOf(startValue)};
            keysAndValues.add(keysAndValue);
            ++startDay;
            ++startValue;
        }
        FormUtils.customDynamicEnum(keysAndValues, edit);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        Object ob;
        Integer maxDay;
        super.propertyChanged(e);
        if (effmonthID.equals(e.getProperty().getName())) {
            Integer effday;
            String monthStart = (String)this.getModel().getValue(effmonthID);
            this.addEnum("effday", dayofMonth[Integer.parseInt(monthStart)]);
            maxDay = month2Dys.get(monthStart);
            ob = this.getModel().getValue("effday");
            if (ob != null && ((effday = Integer.valueOf(Integer.parseInt((String)ob))) < 0 || effday > maxDay)) {
                this.getModel().setValue("effday", null);
            }
        }
        if (expmonthID.equals(e.getProperty().getName())) {
            Integer expday;
            String monthEnd = (String)this.getModel().getValue(expmonthID);
            this.addEnum("expday", dayofMonth[Integer.parseInt(monthEnd)]);
            maxDay = month2Dys.get(monthEnd);
            ob = this.getModel().getValue("expday");
            if (ob != null && ((expday = Integer.valueOf(Integer.parseInt((String)ob))) < 0 || expday > maxDay)) {
                this.getModel().setValue("expday", null);
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.addAdjustmentPeriod();
        IDataModel iDataModel = this.getModel();
        iDataModel.setDataChanged(false);
    }

    private boolean addAdjustmentPeriod() {
        String selectFields;
        String actionName = (String)this.getView().getFormShowParameter().getCustomParam("actionName");
        String selectId = (String)this.getView().getFormShowParameter().getCustomParam("id");
        boolean addSub = "baritemaddsub".equals(actionName);
        boolean addLevel = "baritemaddlevel".equals(actionName);
        QFilter fid = new QFilter("id", "=", (Object)LongUtil.toLong((Object)selectId));
        if (addSub) {
            selectFields = "number";
        } else if (addLevel) {
            selectFields = "parent.number";
        } else {
            return false;
        }
        boolean flag = false;
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_periodmembertree", (String)selectFields, (QFilter[])new QFilter[]{fid});
        if (null != dynamicObject) {
            String selectNumber = dynamicObject.getString(selectFields);
            boolean yearTotal = selectNumber.equalsIgnoreCase("M_YearTotal");
            boolean qYearTotal = selectNumber.equalsIgnoreCase("Q_YearTotal");
            boolean qHf2 = selectNumber.equalsIgnoreCase("Q_HF2");
            boolean mFixNum = yearTotal || selectNumber.startsWith("M_HF") || selectNumber.startsWith("M_Q");
            boolean qFixNum = qYearTotal || qHf2;
            boolean isAdjust = (Boolean)this.getModel().getValue(IS_ADJUST);
            if (!isAdjust && (addSub || addLevel) && mFixNum) {
                this.createNumberName("M_M");
                flag = true;
            }
            if (!isAdjust && (addSub || addLevel) && qFixNum) {
                this.createNumberName("Q_Q");
                flag = true;
            }
            if (mFixNum) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{IS_ADJUST});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{USE_YEAR});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{IS_ADJUST});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{USE_YEAR});
            }
        }
        this.getPageCache().put("addAdjustmentPeriod", flag ? "1" : "0");
        return flag;
    }

    private void createNumberName(String preset) {
        QFilter modelf;
        Integer newNum = 0;
        String end = "";
        boolean mm = "M_M".equals(preset);
        boolean qq = "Q_Q".equals(preset);
        QFilter numf = new QFilter("number", "like", (Object)(preset + "%"));
        QFilter[] filters = new QFilter[]{numf, modelf = new QFilter("model", "=", (Object)LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID")))};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"number", (QFilter[])filters);
        if (dynamicObjects == null || dynamicObjects.isEmpty()) {
            newNum = 1;
        } else {
            if (mm) {
                end = ResManager.loadKDString((String)"\u671f", (String)"PeriodMemberEdit_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            } else if (qq) {
                end = ResManager.loadKDString((String)"\u5b63\u5ea6", (String)"PeriodMemberEdit_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            Set<String> numbers = dynamicObjects.stream().map(d -> d.getString("number")).collect(Collectors.toSet());
            newNum = this.getPeriodNumber(numbers, preset, dynamicObjects.size());
        }
        if (mm) {
            this.getModel().setValue("number", (Object)preset);
        } else {
            this.getModel().setValue("number", (Object)(preset + newNum));
            this.getModel().setValue("name", (Object)(newNum + end));
            this.getModel().setValue(effmonthID, (Object)"12");
            this.getModel().setValue("effday", (Object)"31");
            this.getModel().setValue(expmonthID, (Object)"12");
            this.getModel().setValue("expday", (Object)"31");
        }
    }

    private int getPeriodNumber(Set<String> numbers, String preset, int index) {
        if (numbers.contains(preset + ++index)) {
            return this.getPeriodNumber(numbers, preset, index);
        }
        return index;
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String storagetypecurrency = (String)this.getView().getFormShowParameter().getCustomParam("isstorage");
        if (ResManager.loadKDString((String)"\u5171\u4eab", (String)"PeriodMemberEdit_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(storagetypecurrency)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"name"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"storagetype"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"description"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"simplename"});
        }
        boolean isAdjust = (Boolean)this.getModel().getValue(IS_ADJUST);
        String issysmember = (String)this.getView().getFormShowParameter().getCustomParam("issysmember");
        if (isAdjust || "1".equals(issysmember) || ResManager.loadKDString((String)"\u5171\u4eab", (String)"PeriodMemberEdit_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(storagetypecurrency)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{effmonthID, "effday", expmonthID, "expday"});
        }
        String monthStart = (String)this.getModel().getValue(effmonthID);
        this.addEnum("effday", dayofMonth[Integer.parseInt(monthStart)]);
        String monthEnd = (String)this.getModel().getValue(expmonthID);
        this.addEnum("expday", dayofMonth[Integer.parseInt(monthEnd)]);
        String number = (String)this.getModel().getValue("number");
        this.getView().setVisible(Boolean.valueOf(isAdjust), new String[]{USE_YEAR});
        IDataModel iDataModel = this.getModel();
        iDataModel.setDataChanged(false);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        boolean isAdjust = (Boolean)this.getModel().getValue(IS_ADJUST);
        String useYear = (String)this.getModel().getValue(USE_YEAR);
        String number = (String)this.getModel().getValue("number");
        String lastPeriod = (String)this.getModel().getValue(LAST_PERIOD);
        if (args.getSource() instanceof Save) {
            if (this.isNew() && number.equalsIgnoreCase("M_M")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7f16\u8f91\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u3002", (String)"PeriodMemberEdit_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (this.isNew() && PeriodUtils.isStandardMonthPeriod((String)number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6807\u51c6\u7f16\u7801\u53ea\u80fd\u901a\u8fc7\u4f53\u7cfb\u8be6\u60c5\u9875\u8fdb\u884c\u7ef4\u62a4\uff0c\u4e0d\u80fd\u624b\u5de5\u65b0\u589e\u3002", (String)"PeriodMemberEdit_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (isAdjust && !number.startsWith("M_M")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u671f\u95f4\u7f16\u7801\u5fc5\u987b\u4ee5M_M\u5f00\u5934\u3002", (String)"PeriodMemberEdit_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (StringUtils.isEmpty((CharSequence)lastPeriod) && PeriodUtils.isStandardMonthPeriod((String)number) && !"M_M01".equals(number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u4e00\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PeriodMemberEdit_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (isAdjust && StringUtil.isEmptyString((String)useYear)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u7528\u8d22\u5e74\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PeriodMemberEdit_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String isAdd = this.getPageCache().get("addAdjustmentPeriod");
            if (!isAdjust && "0".equals(isAdd) && PeriodUtils.hasSystemPrefix((String)number) && this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u624b\u5de5\u65b0\u589e\u671f\u95f4\u7f16\u7801\u4e0d\u80fd\u4ee5M_\u3001Q_\u3001YD_\u3001YW_\u3001HF_\u5f00\u5934\u3002", (String)"PeriodMemberEdit_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        String errorMessage = "";
        if (this.getModel().getValue("effday") == null || StringUtil.isEmptyString((String)((String)this.getModel().getValue("effday")))) {
            errorMessage = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5f00\u59cb\u65e5\u671f\u3002", (String)"PeriodMemberEdit_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (this.getModel().getValue("expday") == null || StringUtil.isEmptyString((String)((String)this.getModel().getValue("expday")))) {
            errorMessage = errorMessage.length() > 0 ? String.format(ResManager.loadKDString((String)"%s,\u7ed3\u675f\u65e5\u671f", (String)"PeriodMemberEdit_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), errorMessage) : ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ed3\u675f\u65e5\u671f\u3002", (String)"PeriodMemberEdit_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (errorMessage.length() > 0) {
            this.getView().showTipNotification(errorMessage);
            args.setCancel(true);
            return;
        }
        if (this.getModel().getValue(effmonthID) != null && this.getModel().getValue("effday") != null && this.getModel().getValue(expmonthID) != null && this.getModel().getValue("expday") != null) {
            int effmonth = Integer.parseInt(this.getModel().getValue(effmonthID).toString());
            int effday = Integer.parseInt(this.getModel().getValue("effday").toString());
            int expmonth = Integer.parseInt(this.getModel().getValue(expmonthID).toString());
            int expday = Integer.parseInt(this.getModel().getValue("expday").toString());
            if (effmonth > expmonth || effmonth == expmonth && effday > expday) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"PeriodMemberEdit_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            String dayLs = ResManager.loadKDString((String)"\u65e5", (String)"ModelList_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String monthLs = ResManager.loadKDString((String)"\u6708", (String)"ModelList_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            this.getModel().setValue("effdate", (Object)(effmonth + monthLs + effday + dayLs));
            this.getModel().setValue("expdate", (Object)(expmonth + monthLs + expday + dayLs));
        }
        long id = LongUtil.toLong((Object)this.getModel().getValue("id"));
        if (StringUtils.isNotEmpty((CharSequence)useYear) && isAdjust && id != 0L) {
            String modelNumber = ((DynamicObject)this.getModel().getValue("model")).getString("number");
            HashSet yearIds = new HashSet(16);
            Arrays.stream(useYear.split(",")).forEach(y -> yearIds.add(MemberReader.findMemberByNumber((String)modelNumber, (String)"Year", (String)y).getId()));
            DynamicObject[] periods = BusinessDataServiceHelper.load((String)"bcm_userselect", (String)"year,period", (QFilter[])new QFilter[]{new QFilter("model.number", "=", (Object)modelNumber), new QFilter("period", "=", (Object)id), new QFilter("year", "not in", yearIds)});
            if (periods != null && periods.length > 0) {
                Arrays.stream(periods).forEach(p -> p.set("period", (Object)0));
                SaveServiceHelper.update((DynamicObject[])periods);
            }
        }
    }

    private void addAdjustPeriod() {
        String number = (String)this.getModel().getValue("number");
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        QFilter mFilter = new QFilter("model", "=", (Object)model.getLong("id"));
        if (PeriodUtils.isStandardMonthPeriod((String)number)) {
            DynamicObject dynamicObject;
            QFilter pFilter = new QFilter("longnumber", "like", (Object)"Period!M_YearTotal!%");
            QFilter lFilter = new QFilter("isleaf", "=", (Object)"1");
            ComboEdit lastCombo = (ComboEdit)this.getControl(LAST_PERIOD);
            ArrayList<ComboItem> lastItems = new ArrayList<ComboItem>(16);
            String lastPeriodNum = PeriodUtils.getLastStandardMonth((String)number);
            DynamicObjectCollection periods = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id,number,name,isadjust,dseq,parent,relatednumber,effmonth", (QFilter[])new QFilter[]{mFilter, pFilter, lFilter});
            Comparator<DynamicObject> comparator = Comparator.comparing(a -> StringUtils.isEmpty((CharSequence)a.getString(effmonthID)) ? 0 : Integer.parseInt(a.getString(effmonthID)));
            Comparator<DynamicObject> seqComparator = Comparator.comparing(a -> a.getInt("dseq"));
            periods.sort(comparator.thenComparing(seqComparator));
            Iterator iterator = periods.iterator();
            while (iterator.hasNext() && (!(dynamicObject = (DynamicObject)iterator.next()).getString("number").equals(number) || "M_M01".equals(number))) {
                if ("M_M01".equals(number) && (dynamicObject.getString("number").equals("M_M12") || dynamicObject.getString("relatednumber").equals("M_M12"))) {
                    lastItems.add(new ComboItem(new LocaleString(dynamicObject.getString("name")), dynamicObject.getString("number")));
                    continue;
                }
                if (dynamicObject.getString("number").equals(lastPeriodNum)) {
                    lastItems.add(new ComboItem(new LocaleString(dynamicObject.getString("name")), dynamicObject.getString("number")));
                    continue;
                }
                if (lastItems.isEmpty()) continue;
                lastItems.add(new ComboItem(new LocaleString(dynamicObject.getString("name")), dynamicObject.getString("number")));
            }
            if ("M_M01".equals(number)) {
                lastItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"<\u7a7a>", (String)"PeriodMemberEdit_12", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "M_M00"));
            }
            lastCombo.setComboItems(lastItems);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{LAST_PERIOD});
        } else {
            QFilter yFilter = new QFilter("level", "=", (Object)3);
            DynamicObjectCollection yearDoc = QueryServiceHelper.query((String)"bcm_fymembertree", (String)"id,number,name", (QFilter[])new QFilter[]{mFilter, yFilter}, (String)"dseq");
            ComboEdit yearCombo = (ComboEdit)this.getControl(USE_YEAR);
            ArrayList<ComboItem> yearItems = new ArrayList<ComboItem>(16);
            for (DynamicObject yearObject : yearDoc) {
                yearItems.add(new ComboItem(new LocaleString(yearObject.getString("name")), yearObject.getString("number")));
            }
            yearCombo.setComboItems(yearItems);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LAST_PERIOD});
        }
        if (this.isNew() && number.startsWith("M_M")) {
            this.getModel().setValue(IS_ADJUST, (Object)true);
            String selectId = (String)this.getView().getFormShowParameter().getCustomParam("id");
            DynamicObject selectPeriod = QueryServiceHelper.queryOne((String)"bcm_periodmembertree", (String)"number,effmonth,effday,expmonth,expday", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)LongUtil.toLong((Object)selectId))});
            this.getModel().setValue("relatednumber", (Object)selectPeriod.getString("number"));
            this.getModel().setValue(effmonthID, (Object)selectPeriod.getString(effmonthID));
            this.getModel().setValue("effday", (Object)selectPeriod.getString("effday"));
            this.getModel().setValue(expmonthID, (Object)selectPeriod.getString(expmonthID));
            this.getModel().setValue("expday", (Object)selectPeriod.getString("expday"));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{effmonthID, "effday", expmonthID, "expday"});
        }
        this.getView().setVisible(Boolean.valueOf(number.startsWith("M_M")), new String[]{IS_ADJUST});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{IS_ADJUST});
        long modelId = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
        if (!ConfigServiceHelper.getBoolParam((Long)modelId, (String)"isOpenAdjust")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{IS_ADJUST});
        }
        IDataModel iDataModel = this.getModel();
        iDataModel.setDataChanged(false);
    }
}

