/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimensionnew;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.plugin.TemplateTreePlugin;
import kd.bos.lang.Lang;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.enums.PeriodLangENEnum;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;
import kd.fi.bcm.spread.common.util.StringUtil;

public class PeriodMemberList
extends TemplateTreePlugin {
    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        DynamicObjectCollection pageData = e.getPageData();
        if (pageData.size() > 0) {
            long modelId = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)pageData.get(0)).getLong("id"), (String)"bcm_periodmembertree", (String)"model.id").getLong("model.id");
            Set<Long> ids = pageData.stream().map(data -> data.getLong("id")).collect(Collectors.toSet());
            List<Long> orderPeriods = DimensionUtil.getOrderedMemberIds(modelId, "bcm_periodmembertree", ids);
            pageData.sort(Comparator.comparingInt(p -> orderPeriods.indexOf(p.getLong("id"))));
        }
    }

    public void packageData(PackageDataEvent e) {
        String key;
        boolean needTranslation;
        boolean bl = needTranslation = !Lang.get().equals((Object)Lang.zh_CN) && !Lang.get().equals((Object)Lang.zh_TW);
        if (needTranslation && ColumnDesc.class.isAssignableFrom(e.getSource().getClass()) && (StringUtil.equals((String)(key = ((ColumnDesc)e.getSource()).getKey()), (String)"effdate") || StringUtil.equals((String)key, (String)"expdate"))) {
            String value = e.getRowData().get(key).toString();
            String dayLs = ResManager.getLocaleString((String)"\u65e5", (String)"ModelList_20", (String)"fi-bcm-formplugin").getLocaleValue_zh_CN();
            String monthLs = ResManager.getLocaleString((String)"\u6708", (String)"ModelList_19", (String)"fi-bcm-formplugin").getLocaleValue_zh_CN();
            if (StringUtils.isNotEmpty((String)value) && value.substring(0, 1).matches("[0-9]+") && value.contains(dayLs) && value.contains(monthLs)) {
                String mouth = value.substring(0, value.indexOf(monthLs));
                String day = value.substring(value.indexOf(monthLs) + 1, value.indexOf(dayLs));
                String newdate = PeriodLangENEnum.getMouthDayByIndex((int)Integer.parseInt(mouth), (int)Integer.parseInt(day));
                e.setFormatValue((Object)newdate);
            }
        }
    }
}

