/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimensionnew;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.CurrencyScaleEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.DimMemTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.dimensionnew.MemberSomeCommonFunEdit;
import kd.fi.bcm.formplugin.dimensionnew.prpertychangeaction.PropertyChangeTips;

public class SceneMemberEdit
extends MemberSomeCommonFunEdit {
    private static String ctl_scale = "scaletext";
    private static String ctl_scaleentry = "scaleentry";
    private static String CURRENCYCACHEKEY = "CURRENCYSCALECACHEKEY";

    private void initCacheCurrencyInfo() {
        String modeId;
        DynamicObjectCollection currencyInfoList;
        if (this.getPageCache().get(CURRENCYCACHEKEY) == null && (currencyInfoList = this.getCurrencyInfoList(modeId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"))) != null && currencyInfoList.size() > 0) {
            ArrayList list = new ArrayList();
            StringBuilder sb = new StringBuilder();
            for (DynamicObject currencyInfo : currencyInfoList) {
                HashMap<String, Object> currrencyMap = new HashMap<String, Object>();
                Long id = currencyInfo.getLong("id");
                String name = currencyInfo.getString("name");
                String number = currencyInfo.getString("number");
                currrencyMap.put("id", id);
                currrencyMap.put("name", name);
                currrencyMap.put("number", number);
                currrencyMap.put("scale", 2);
                sb.append(name).append(':').append(CurrencyScaleEnum.TWOSCALE.getValue()).append(',');
                list.add(currrencyMap);
            }
            String result = sb.toString();
            if (list.size() > 0) {
                this.getPageCache().put(CURRENCYCACHEKEY, SerializationUtils.toJsonString(list));
                this.getModel().setValue(ctl_scale, (Object)result.substring(0, result.length() - 1));
            }
        }
    }

    private void initCacheScale() {
        if (this.getPageCache().get(CURRENCYCACHEKEY) != null) {
            String id;
            String modeId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
            DynamicObjectCollection scaleInfoList = this.getScaleEntryList(modeId, id = (String)this.getView().getFormShowParameter().getCustomParam("id"));
            if (scaleInfoList == null || scaleInfoList.size() == 0) {
                return;
            }
            List rows = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(CURRENCYCACHEKEY), List.class);
            HashMap<String, String> scaleMap = new HashMap<String, String>();
            for (Object scaleInfo : scaleInfoList) {
                String number = scaleInfo.getString("number");
                String scale = scaleInfo.getString("scale");
                scaleMap.putIfAbsent(number, scale);
            }
            StringBuilder sb = new StringBuilder();
            for (Map row : rows) {
                String name = (String)row.get("name");
                String number = (String)row.get("number");
                Object value = scaleMap.get(number);
                if (value != null) {
                    String valueStr = value.toString();
                    row.put("scale", valueStr);
                    sb.append(name).append(':').append(CurrencyScaleEnum.value((String)valueStr).getValue()).append(',');
                    continue;
                }
                sb.append(name).append(':').append(row.get("scale").toString()).append(',');
            }
            String result = sb.toString();
            if (!result.isEmpty()) {
                this.getPageCache().put(CURRENCYCACHEKEY, SerializationUtils.toJsonString((Object)rows));
                this.getModel().setValue(ctl_scale, (Object)result.substring(0, result.length() - 1));
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        OperationStatus status;
        super.afterBindData(e);
        this.getModel().setValue("aggoprt", (Object)"5");
        boolean isOpenSceneVersion = ConfigServiceHelper.getGlobalBoolParam((String)"isOpenSceneVersion");
        ApplicationTypeEnum app = ModelUtil.queryApp(this.getView());
        if (!isOpenSceneVersion || ApplicationTypeEnum.RPT == app) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isversioned", "scenequote"});
        }
        if (OperationStatus.EDIT == (status = this.getView().getFormShowParameter().getStatus())) {
            this.setEnableOfVersion();
        }
        this.setRootMemberProp();
        PropertyChangeTips.afterOpenPage(this.getModel(), this.getView());
    }

    private void setRootMemberProp() {
        Integer level = (Integer)this.getModel().getValue("level");
        if (level == 1) {
            this.getModel().setValue("scaletext", (Object)"");
            this.getModel().setDataChanged(false);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"shielddim", "aggoprt", "datatype", "dchangetype", "scaletext", "sceneperiod", "isversioned", "permclass", "scenecslscheme"});
        }
    }

    private void setEnableOfVersion() {
        Long id = (Long)this.getModel().getValue("id");
        QFilter qf = new QFilter("id", "=", (Object)id);
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_scenemembertree", (String)"issysmember", (QFilter[])qf.toArray());
        String issysmember = dy.getString("issysmember");
        if ("1".equals(issysmember) || "2".equalsIgnoreCase(issysmember)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"isversioned"});
        }
    }

    private DynamicObjectCollection getCurrencyInfoList(String modeId) {
        String selectFields = "id,name,number";
        QFilter modelFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modeId));
        QFilter numberFilter = new QFilter("number", "not in", (Object)new String[]{"Currency", "EC", "PC", "DC"});
        return QueryServiceHelper.query((String)"bcm_currencymembertree", (String)selectFields, (QFilter[])new QFilter[]{modelFilter, numberFilter}, (String)"dseq");
    }

    private DynamicObjectCollection getScaleEntryList(String modeId, String id) {
        String selectFields = "scaleentry.currency.id as id,scaleentry.currency.name as name,scaleentry.currency.number as number,scaleentry.scale as scale";
        QFilter modelFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modeId));
        QFilter idFilter = new QFilter("id", "=", (Object)LongUtil.toLong((Object)id));
        QFilter numberFilter = new QFilter("scaleentry.currency.number", "not in", (Object)new String[]{"Currency", "EC", "PC"});
        return QueryServiceHelper.query((String)"bcm_scenemembertree", (String)selectFields, (QFilter[])new QFilter[]{modelFilter, idFilter, numberFilter}, (String)"dseq");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(ctl_scale, "scenecslscheme");
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl("permclass")), (Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        BasedataEdit scenequote = (BasedataEdit)this.getControl("scenequote");
        scenequote.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit sceneCsl = (MulBasedataEdit)this.getControl("scenecslscheme");
        sceneCsl.addBeforeF7SelectListener(evt -> {
            List customQFilters = evt.getCustomQFilters();
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
            qFilter.and("number", "!=", (Object)"DefaultRateScheme");
            qFilter.and("nodetype", "=", (Object)"1");
            customQFilters.add(qFilter);
            evt.getFormShowParameter().setCustomParam("scenecslscheme_filter", (Object)"scenecslscheme");
        });
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (ctl_scale.equals(key)) {
            FormShowParameter para = new FormShowParameter();
            para.setFormId("bcm_scene_currencyscale");
            para.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("sign", CURRENCYCACHEKEY);
            para.setCustomParams(params);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            para.setCloseCallBack(closeCallBack);
            this.getView().showForm(para);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        DynamicObjectCollection doc;
        super.closedCallBack(evt);
        if (evt.getReturnData() == null) {
            return;
        }
        if (evt.getReturnData() instanceof DynamicObjectCollection && (doc = (DynamicObjectCollection)evt.getReturnData()) != null) {
            StringBuilder sb = new StringBuilder();
            ArrayList list = new ArrayList(doc.size());
            for (int i = 0; i < doc.size(); ++i) {
                HashMap<String, String> map = new HashMap<String, String>();
                String id = ((DynamicObject)doc.get(i)).get("currencyid").toString();
                String num = ((DynamicObject)doc.get(i)).get("currencynum").toString();
                String name = ((DynamicObject)doc.get(i)).get("currencyname").toString();
                String scale = ((DynamicObject)doc.get(i)).get("cbscale").toString();
                map.put("id", id);
                map.put("number", num);
                map.put("name", name);
                map.put("scale", scale);
                sb.append(name).append(':').append(CurrencyScaleEnum.value((String)scale).getValue()).append(',');
                list.add(map);
            }
            if (list.size() > 0) {
                this.getPageCache().put(CURRENCYCACHEKEY, SerializationUtils.toJsonString(list));
                String result = sb.toString();
                this.getModel().setValue(ctl_scale, (Object)result.substring(0, result.length() - 1));
            }
            IDataModel model = this.getModel();
            if (list.size() > 0) {
                model.deleteEntryData(ctl_scaleentry);
            }
            for (int i = 0; i < list.size(); ++i) {
                Map map = (Map)list.get(i);
                Long id = Long.valueOf(map.get("id").toString());
                DynamicObject currency = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_currencymembertree");
                int row = model.createNewEntryRow(ctl_scaleentry);
                model.setValue("currency", (Object)currency, row);
                model.setValue("scale", map.get("scale"), row);
            }
        }
    }

    @Override
    protected String getModelType() {
        return "bcm_scenemember";
    }

    @Override
    protected String getTreeModelType() {
        return "bcm_scenemembertree";
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        Object source = e.getSource();
        if (source instanceof Save && ((Boolean)this.getModel().getValue("isversioned")).booleanValue()) {
            DynamicObject versionScene;
            if (this.getModel().getValue("scenequote") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f\u5f15\u7528\u6210\u5458\u3002", (String)"SceneMemberEdit_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                e.setCancel(true);
                return;
            }
            Long id = Long.valueOf(this.getModel().getValue("id").toString());
            if (id != 0L && (versionScene = QueryServiceHelper.queryOne((String)"bcm_scenemembertree", (String)"name, number", (QFilter[])new QFilter("scenequote", "=", (Object)id).toArray())) != null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u60c5\u666f\u6210\u5458\u5df2\u88ab\u5176\u5b83\u60c5\u666f\u6210\u5458\u201c%s\u201d\u5f15\u7528\uff0c\u4e0d\u80fd\u7248\u672c\u5316\u3002", (String)"SceneMemberEdit_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), versionScene.getString("number") + " " + versionScene.getString("name")), Integer.valueOf(3000));
                e.setCancel(true);
                return;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String msg = (String)ThreadCache.get((Object)"sync_msg");
        boolean success = e.getOperationResult().isSuccess();
        String operateKey = e.getOperateKey();
        if (success && "save".equals(operateKey)) {
            if (((Boolean)this.getModel().getValue("isversioned")).booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"sceneperiod", "isversioned", "scenequote"});
            }
            if ("success".equals(msg)) {
                e.getOperationResult().setShowMessage(false);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u5f15\u7528\u4e86\u8be5\u60c5\u666f\u7684\u7248\u672c\u5316\u60c5\u666f\u6210\u5458\u540c\u6b65\u66f4\u65b0\u3002", (String)"", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                ThreadCache.remove((Object)"sync_msg");
            }
        }
        PermClassEntityHelper.savePermClass((IDataModel)this.getModel(), (Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"), (OperationStatus)this.getView().getFormShowParameter().getStatus());
    }

    @Override
    public void initialize() {
        super.initialize();
        this.initF7Filters();
    }

    private void initF7Filters() {
        String modeId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (modeId == null) {
            return;
        }
        QFilter modelFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modeId));
        modelFilter.and("isleaf", "=", (Object)true);
        modelFilter.and(new QFilter("number", "not in", Arrays.asList("CurrentPeriod", "LastPeriod")));
        MulBasedataEdit periodMulF7 = (MulBasedataEdit)this.getControl("sceneperiod");
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        filterList.add(modelFilter);
        periodMulF7.setQFilters(filterList);
        periodMulF7.addBeforeF7SelectListener(evt -> {
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = parameter.getListFilterParameter();
            parameter.setListFilterParameter(new ListFilterParameter(filterParameter.getQFilters(), "dseq"));
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCacheCurrencyInfo();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"value"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"value"});
        if (this.getView().getFormShowParameter().getCustomParam("open") != null) {
            Map temp = (Map)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam("map")));
            this.getModel().setValue("enablehisrec", temp.get("enablehisrec"));
            this.getModel().setValue("dchangetype", temp.get("dchangetype"));
            this.getModel().setValue("value", temp.get("value"));
        }
        IDataModel iDataModel = this.getModel();
        iDataModel.setDataChanged(false);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"alonemergeconfig", "scenequote"});
    }

    @Override
    public void afterLoadData(EventObject e) {
        int dimMemType;
        super.afterLoadData(e);
        this.initCacheCurrencyInfo();
        this.initCacheScale();
        String storagetypecurrency = (String)this.getView().getFormShowParameter().getCustomParam("isstorage");
        if (ResManager.loadKDString((String)"\u5171\u4eab", (String)"SceneMemberEdit_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(storagetypecurrency)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"name"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"storagetype"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"description"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"enablehisrec"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"dchangetype"});
        }
        IDataModel iDataModel = this.getModel();
        iDataModel.setDataChanged(false);
        String dataTypeValue = (String)this.getModel().getValue("datatype");
        this.setAggoprtStatus(dataTypeValue);
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        PermClassEntityHelper.loadPermClass((IDataModel)this.getModel(), (Object)modelId, (boolean)StorageTypeEnum.SHARE.index.equals(this.getModel().getValue("storagetype")));
        if (StorageTypeEnum.SHARE.index.equals(this.getModel().getValue("storagetype"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"permclass"});
        }
        this.getPageCache().put("modelId", modelId);
        Boolean isversioned = (Boolean)this.getModel().getValue("isversioned");
        if (isversioned == null) {
            this.getModel().setValue("isversioned", (Object)false);
            isversioned = false;
        }
        if ((dimMemType = Integer.parseInt(this.getModel().getValue("issysmember").toString())) == DimMemTypeEnum.SYSMEM.getIndex() || dimMemType == DimMemTypeEnum.IMPORTMEM.getIndex()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"isversioned"});
        } else {
            Long id = Long.valueOf(this.getModel().getValue("id").toString());
            if (QueryServiceHelper.exists((String)"bcm_scenemembertree", (QFilter[])new QFilter("scenequote", "=", (Object)id).toArray())) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"isversioned", "alonemergeconfig", "scenequote"});
            } else {
                String olapNumber = ((DynamicObject)this.getModel().getValue("model")).getString("number");
                String number = this.getModel().getValue("number").toString();
                if (isversioned.booleanValue()) {
                    number = ((DynamicObject)this.getModel().getValue("scenequote")).getString("number");
                }
                if (OlapServiceHelper.hasOlapData((String)olapNumber, (List)Lists.newArrayList((Object[])new String[]{number}), (String)"Scenario")) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"isversioned", "alonemergeconfig", "scenequote"});
                }
            }
        }
        this.getView().setVisible(isversioned, new String[]{"alonemergeconfig", "scenequote"});
        this.getView().setEnable(Boolean.valueOf(isversioned == false), new String[]{"sceneperiod", "isversioned", "scenequote"});
    }

    @Override
    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
        String propName = e.getProperty().getName();
        if ("datatype".equals(propName)) {
            String oldvalue = (String)this.getModel().getValue("datatype");
            this.getPageCache().put("datatype", oldvalue);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (propName == null || propName.length() == 0) {
            return;
        }
        switch (propName) {
            case "value": {
                this.getModel().setValue("enumitem", this.getModel().getValue("value"));
                break;
            }
            case "datatype": {
                if (this.getPageCache().get("resetdatatype") != null) {
                    this.getPageCache().remove("resetdatatype");
                    return;
                }
                String dataTypeValue = (String)this.getModel().getValue("datatype");
                if (dataTypeValue.equals("6")) {
                    this.dataTypeSelectEnum(e);
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue("value", (Object)"");
                this.getModel().setValue("enumitem", (Object)"");
                this.getModel().endInit();
                ComboEdit comboEdit = (ComboEdit)this.getControl("value");
                comboEdit.setMustInput(false);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"value"});
                this.setAggoprtStatus(dataTypeValue);
                break;
            }
            case "sceneperiod": {
                DynamicObjectCollection oldVal = (DynamicObjectCollection)e.getChangeSet()[0].getOldValue();
                DynamicObjectCollection newVal = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
                Set oldPeriods = oldVal.stream().map(n -> ((DynamicObject)n.get("fbasedataid")).getString("number")).collect(Collectors.toSet());
                Set newPeriods = newVal.stream().map(n -> ((DynamicObject)n.get("fbasedataid")).getString("number")).collect(Collectors.toSet());
                Set<String> deletePeriods = oldPeriods.stream().filter(o -> !newPeriods.contains(o)).collect(Collectors.toSet());
                StringBuilder numbers = new StringBuilder();
                String modelNumber = ((DynamicObject)this.getModel().getValue("model")).getString("number");
                deletePeriods.forEach(d -> {
                    if (OlapServiceHelper.hasOlapData((String)modelNumber, (List)Lists.newArrayList((Object[])new String[]{d}), (String)"Period")) {
                        if (numbers.length() > 0) {
                            numbers.append(",");
                        }
                        numbers.append((String)d);
                    }
                });
                OperationStatus status = this.getView().getFormShowParameter().getStatus();
                if (numbers.length() <= 0 || OperationStatus.ADDNEW == status) break;
                String json = ObjectSerialUtil.toByteSerialized((Object)oldVal);
                this.getPageCache().put("scenePeriodOldValue", json);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u671f\u95f4\u6210\u5458\u201c%s\u201d\u5b58\u5728\u591a\u7ef4\u6570\u636e\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u9700\u8981\u53d6\u6d88\uff1f", (String)"SceneMemberEdit_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), numbers.toString()), MessageBoxOptions.YesNo, new ConfirmCallBackListener("sceneperiod", (IFormPlugin)this));
                break;
            }
            case "isversioned": {
                Boolean isversioned = (Boolean)this.getModel().getValue("isversioned");
                this.getView().setVisible(isversioned, new String[]{"alonemergeconfig", "scenequote"});
                this.getView().setEnable(Boolean.valueOf(isversioned == false), new String[]{"sceneperiod"});
                ((BasedataEdit)this.getControl("scenequote")).setMustInput(isversioned.booleanValue());
                if (isversioned.booleanValue()) break;
                this.getModel().setValue("scenequote", null);
                this.getModel().setValue("alonemergeconfig", (Object)false);
                break;
            }
            case "scenequote": {
                DynamicObject scenequote = (DynamicObject)this.getModel().getValue("scenequote");
                if (scenequote == null) break;
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)scenequote.getLong("id"), (String)"bcm_scenemembertree");
                this.getModel().setValue("sceneperiod", (Object)dynamicObject.getDynamicObjectCollection("sceneperiod"));
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if ("sceneperiod".equals(callBackId)) {
            if (MessageBoxResult.Yes.getValue() != event.getResult().getValue()) {
                String serial = this.getPageCache().get("scenePeriodOldValue");
                DynamicObjectCollection oldVal = (DynamicObjectCollection)ObjectSerialUtil.deSerializedBytes((String)serial);
                this.getModel().beginInit();
                this.getModel().setValue("sceneperiod", (Object)oldVal);
                this.getModel().endInit();
                this.getView().updateView("sceneperiod");
            }
            return;
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        if ("scenequote".equals(evt.getProperty().getName())) {
            QFilter qFilter = new QFilter("model", "=", (Object)Long.parseLong(this.getPageCache().get("modelId")));
            qFilter.and("isleaf", "=", (Object)true);
            qFilter.and("isversioned", "=", (Object)false);
            qFilter.and("id", "!=", this.getModel().getValue("id"));
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            param.getListFilterParameter().getQFilters().add(qFilter);
        }
    }
}

