/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimensionnew.extend;

import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.dimension.FieldTypeEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class ExtModelFieldSettingPlugin
extends AbstractBaseFormPlugin {
    public static final String ENTRYENTITY = "entryentity";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_confirm", "btn_cancel");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        int rowIndex;
        super.afterCreateNewData(e);
        String serial = (String)this.getFormCustomParam("extendsModel");
        Long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        ExtendsModel extendsModel = (ExtendsModel)this.deSerializedBytes(serial);
        HashSet numberSet = Sets.newHashSet((Object[])new String[]{DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber(), DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.CURRENCY.getNumber(), DimTypesEnum.PROCESS.getNumber(), DimTypesEnum.AUDITTRIAL.getNumber()});
        Set dimNumbers = extendsModel.getFieldEntry().stream().filter(o -> o.getName() != null && FieldTypeEnum.DIM_FIELD.getType() == o.getFieldType()).map(o -> o.getDimension().getNumber()).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(dimNumbers)) {
            numberSet.addAll(dimNumbers);
        }
        Set extNumbers = extendsModel.getFieldEntry().stream().filter(o -> o.getName() != null && FieldTypeEnum.EXT_FIELD.getType() == o.getFieldType()).map(o -> o.getExtField().getNumber()).collect(Collectors.toSet());
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        QFilter dimQf = new QFilter("number", "not in", (Object)numberSet);
        QFilter extQf = new QFilter("level", "=", (Object)3).and("parent", "=", (Object)extendsModel.getExtendsGroup());
        if (!CollectionUtils.isEmpty(extNumbers)) {
            extQf.and("number", "not in", extNumbers);
        }
        DynamicObjectCollection dims = null;
        dims = "3".equals(extendsModel.getExtendsGroupType()) ? new DynamicObjectCollection() : QueryServiceHelper.query((String)"bcm_dimension", (String)"number,id,name", (QFilter[])new QFilter[]{modelQf, dimQf});
        DynamicObjectCollection extFields = QueryServiceHelper.query((String)"bcm_structofextend", (String)"number,id,name,datatype", (QFilter[])new QFilter[]{modelQf, extQf}, (String)"dseq");
        for (DynamicObject dim : dims) {
            rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue("id", (Object)dim.getLong("id"), rowIndex);
            this.getModel().setValue("number", (Object)dim.getString("number"), rowIndex);
            this.getModel().setValue("name", (Object)dim.getString("name"), rowIndex);
            this.getModel().setValue("type", (Object)FieldTypeEnum.DIM_FIELD.getName(), rowIndex);
            this.getModel().setValue("typecode", (Object)FieldTypeEnum.DIM_FIELD.getType(), rowIndex);
        }
        for (DynamicObject ext : extFields) {
            rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue("id", (Object)ext.getLong("id"), rowIndex);
            this.getModel().setValue("number", (Object)ext.getString("number"), rowIndex);
            this.getModel().setValue("name", (Object)ext.getString("name"), rowIndex);
            this.getModel().setValue("type", (Object)FieldTypeEnum.EXT_FIELD.getName(), rowIndex);
            this.getModel().setValue("typecode", (Object)FieldTypeEnum.EXT_FIELD.getType(), rowIndex);
            this.getModel().setValue("datatype", (Object)ext.getString("datatype"), rowIndex);
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{ENTRYENTITY});
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_confirm": {
                EntryGrid entity = (EntryGrid)this.getControl(ENTRYENTITY);
                if (entity.getSelectRows().length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u6570\u636e", (String)"ExtModelFieldSettingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    this.getView().close();
                    return;
                }
                List<DynamicObject> entrySeleteDatas = this.getEntrySeleteDatas(ENTRYENTITY);
                this.returnDataToParent(entrySeleteDatas);
                this.getView().close();
                break;
            }
            case "btn_cancel": {
                this.getView().close();
            }
        }
    }
}

