/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimensionnew.extend;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;

public class ExtendsDataDumpPlugin
extends AbstractBaseFormPlugin
implements DynamicPage {
    private static WatchLogger LOG = BcmLogFactory.getWatchLogInstance(ExtendsDataDumpPlugin.class);
    private static final String MODEL_ID = "model";
    private static final String SIGN_KEY = "sign";
    private static final String ORG_F7 = "org";
    private static final String BTN_OK = "btn_ok";
    private static final String SCENE_F7 = "scene";
    private static final String YEAR_F7 = "year";
    private static final String PERIOD_F7 = "period";
    private static final String SCOPE = "scope";
    private static final String RADIO = "radio";
    private static final String[] F7ARR = new String[]{"scene", "year", "period"};

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_OK, ORG_F7);
        Arrays.asList(F7ARR).forEach(x -> {
            MulBasedataEdit mulF7 = (MulBasedataEdit)this.getControl((String)x);
            mulF7.addBeforeF7SelectListener(evt -> {
                ListShowParameter form = (ListShowParameter)evt.getFormShowParameter();
                form.getListFilterParameter().setFilter(new QFilter(MODEL_ID, "=", this.getView().getFormShowParameter().getCustomParam(MODEL_ID)));
                if (SCENE_F7.equals(((MulBasedataEdit)evt.getSource()).getKey())) {
                    form.getListFilterParameter().setFilter(new QFilter("longnumber", "!=", (Object)"Scenario"));
                }
                if (PERIOD_F7.equals(((MulBasedataEdit)evt.getSource()).getKey())) {
                    DynamicObjectCollection scenes = (DynamicObjectCollection)this.getModel().getValue(SCENE_F7);
                    if (scenes == null || scenes.size() == 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u60c5\u666f\u3002", (String)"ExtendsDataDumpPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    Set sceneIds = scenes.stream().map(y -> y.getLong("fbasedataid.id")).collect(Collectors.toSet());
                    QFilter qf = new QFilter("id", "in", sceneIds);
                    DynamicObject[] result = BusinessDataServiceHelper.load((String)"bcm_scenemembertree", (String)"sceneperiod", (QFilter[])qf.toArray());
                    Set sceneperiod = Arrays.stream(result).map(sc -> sc.getDynamicObjectCollection("sceneperiod")).collect(Collectors.toSet());
                    Set periodIds = sceneperiod.stream().flatMap(sc -> sc.stream().map(per -> per.getLong("fbasedataid.id"))).collect(Collectors.toSet());
                    form.getListFilterParameter().setFilter(new QFilter("id", "in", periodIds));
                }
                if (YEAR_F7.equals(((MulBasedataEdit)evt.getSource()).getKey())) {
                    form.getListFilterParameter().setFilter(new QFilter("parent.longnumber", "=", (Object)"Year!AllYear"));
                    form.getListFilterParameter().setOrderBy("dseq");
                } else {
                    form.getListFilterParameter().setOrderBy("level, dseq");
                }
            });
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("KEY_MODEL_ID", this.getView().getFormShowParameter().getCustomParam(MODEL_ID).toString());
        QFilter qf = new QFilter("id", "=", (Object)this.getModelId());
        String modelNumber = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id, shownumber", (QFilter[])qf.toArray()).getString("shownumber");
        this.getPageCache().put("KEY_MODEL_NUMBER", modelNumber);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (ORG_F7.equals(key)) {
            this.openEntityF7View(key);
        } else if (BTN_OK.equals(key)) {
            String msg = this.checkNotNull();
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                this.getView().showTipNotification(msg);
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u6e05\u9664\u6240\u9009\u62d3\u5c55\u6570\u636e\u6a21\u578b\u5bf9\u5e94\u60c5\u666f\u3001\u8d22\u5e74\u3001\u671f\u95f4\u548c\u7ec4\u7ec7\u4e0a\u7684\u6570\u636e\uff1f\u6b64\u64cd\u4f5c\u4e0d\u53ef\u6062\u590d\u3002", (String)"ExtendsDataDumpPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("clear_data", (IFormPlugin)this));
        }
    }

    private String checkNotNull() {
        DynamicObjectCollection scenes = (DynamicObjectCollection)this.getModel().getValue(SCENE_F7);
        if (scenes.size() == 0) {
            return String.format(ResManager.loadKDString((String)"\u7f3a\u5931\u5fc5\u9009\u7ef4\u5ea6 - %s", (String)"ExtendsDataDumpPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.SCENARIO.getName());
        }
        DynamicObjectCollection years = (DynamicObjectCollection)this.getModel().getValue(YEAR_F7);
        if (years.size() == 0) {
            return String.format(ResManager.loadKDString((String)"\u7f3a\u5931\u5fc5\u9009\u7ef4\u5ea6 - %s", (String)"ExtendsDataDumpPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.YEAR.getName());
        }
        DynamicObjectCollection periods = (DynamicObjectCollection)this.getModel().getValue(PERIOD_F7);
        if (periods.size() == 0) {
            return String.format(ResManager.loadKDString((String)"\u7f3a\u5931\u5fc5\u9009\u7ef4\u5ea6 - %s", (String)"ExtendsDataDumpPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.PERIOD.getName());
        }
        return "";
    }

    private void openEntityF7View(String key) {
        FormShowParameter param = this.getView().getFormShowParameter();
        QFilter qf = new QFilter(MODEL_ID, "=", param.getCustomParam(MODEL_ID));
        QFilter qf1 = new QFilter("number", "=", (Object)"Entity");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id,membermodel", (QFilter[])new QFilter[]{qf, qf1});
        if (dynamicObject == null) {
            throw new KDBizException("the dimension of entity is not exist");
        }
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bcm_mulmemberf7base_tem");
        para.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("dimensionid", dynamicObject.getLong("id"));
        params.put(SIGN_KEY, key);
        params.put("ext_data_dump", key);
        params.put("KEY_MODEL_ID", param.getCustomParam(MODEL_ID).toString());
        para.setCustomParams(params);
        para.setCaption(ResManager.loadKDString((String)"\u7ec4\u7ec7 - \u6210\u5458\u9009\u62e9", (String)"ExtendsDataDumpPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (ORG_F7.equals(actionId)) {
            Map map = (Map)event.getReturnData();
            if (map == null) {
                return;
            }
            DynamicObjectCollection memScopes = (DynamicObjectCollection)map.get("doc");
            if (memScopes == null || memScopes.size() == 0) {
                this.getModel().setValue(actionId, (Object)"");
                this.getPageCache().put(actionId, "");
                this.getPageCache().put(RADIO, "");
                this.getPageCache().put("showtext", "");
            } else {
                MultiF7Results results = MultiF7Results.buildParam((DynamicObjectCollection)memScopes, (long)this.getModelId());
                this.getModel().setValue(actionId, (Object)results.getShowText());
                this.getPageCache().put(actionId, SerializationUtils.toJsonString((Object)results.toList()));
                this.getPageCache().put(RADIO, (String)map.get(RADIO));
                this.getPageCache().put("showtext", results.getShowText());
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if ("clear_data".equals(callBackId) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            Map<String, Object> result = this.modelDataDump();
            FormShowParameter param = new FormShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId("bcm_extdata_dump_tip");
            param.setCustomParam(MODEL_ID, (Object)this.getModelId());
            param.setCustomParam("result_log", result);
            HashMap<String, List<String>> params = new HashMap<String, List<String>>(4);
            this.pottingChoisesParms(params);
            param.setCustomParam("params", params);
            param.setCustomParam("ext_model_list", this.getView().getFormShowParameter().getCustomParam("extModelList"));
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "log_download"));
            this.getView().showForm(param);
        }
    }

    private void pottingChoisesParms(Map<String, List<String>> params) {
        DynamicObjectCollection scenes = (DynamicObjectCollection)this.getModel().getValue(SCENE_F7);
        List sceneNams = scenes.stream().map(x -> x.getString("fbasedataid.name")).collect(Collectors.toList());
        DynamicObjectCollection years = (DynamicObjectCollection)this.getModel().getValue(YEAR_F7);
        List yearNams = years.stream().sorted(Comparator.comparingInt(x -> x.getInt("fbasedataid.level")).thenComparingInt(x -> x.getInt("fbasedataid.dseq"))).map(x -> x.getString("fbasedataid.name")).collect(Collectors.toList());
        DynamicObjectCollection periods = (DynamicObjectCollection)this.getModel().getValue(PERIOD_F7);
        List periodNams = periods.stream().sorted(Comparator.comparing(x -> x.getInt("fbasedataid.level")).thenComparingInt(x -> x.getInt("fbasedataid.dseq"))).map(x -> x.getString("fbasedataid.name")).collect(Collectors.toList());
        params.put("scenes", sceneNams);
        params.put("years", yearNams);
        params.put("periods", periodNams);
        String entityStr = this.getPageCache().get(ORG_F7);
        List entitys = null;
        ArrayList entStrs = new ArrayList(16);
        if (StringUtils.isNotEmpty((CharSequence)entityStr)) {
            entitys = (List)SerializationUtils.fromJsonString((String)entityStr, List.class);
            entitys.forEach(x -> {
                StringBuilder entStr = new StringBuilder(8);
                entStr.append((String)x.get("name")).append('.');
                this.appScope(entStr, (Map<String, String>)x);
                entStrs.add(entStr.toString());
            });
            params.put("entitys", entStrs);
        }
    }

    private void appScope(StringBuilder entStr, Map<String, String> x) {
        String scope;
        switch (scope = x.get(SCOPE)) {
            case "10": {
                entStr.append(ResManager.loadKDString((String)"\u4ec5\u81ea\u5df1", (String)"ExtendsDataDumpPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "20": {
                entStr.append(ResManager.loadKDString((String)"\u76f4\u63a5\u4e0b\u7ea7\u4e0d\u542b\u81ea\u5df1", (String)"ExtendsDataDumpPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "30": {
                entStr.append(ResManager.loadKDString((String)"\u76f4\u63a5\u4e0b\u7ea7\u542b\u81ea\u5df1", (String)"ExtendsDataDumpPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "40": {
                entStr.append(ResManager.loadKDString((String)"\u6240\u6709\u4e0b\u7ea7\u4e0d\u542b\u81ea\u5df1", (String)"ExtendsDataDumpPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "50": {
                entStr.append(ResManager.loadKDString((String)"\u6240\u6709\u4e0b\u7ea7\u542b\u81ea\u5df1", (String)"ExtendsDataDumpPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "60": {
                entStr.append(ResManager.loadKDString((String)"\u6240\u6709\u5e73\u7ea7\u4e0d\u542b\u81ea\u5df1", (String)"ExtendsDataDumpPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "70": {
                entStr.append(ResManager.loadKDString((String)"\u6240\u6709\u5e73\u7ea7\u542b\u81ea\u5df1", (String)"ExtendsDataDumpPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private Map<String, Object> modelDataDump() {
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        long modelId = this.getModelId();
        List extModelList = JSONArray.parseArray((String)((JSONArray)this.getView().getFormShowParameter().getCustomParam("extModelList")).toJSONString(), Map.class);
        List<DynamicObject> extModels = this.getAllExtModels(modelId);
        String entityStr = this.getPageCache().get(ORG_F7);
        String radio = this.getPageCache().get(RADIO);
        List objects = null;
        HashSet<String> entNums = new HashSet<String>(16);
        Set<Long> entIds = new HashSet<Long>(16);
        Map<String, Long> num2Ids = new HashMap<String, Long>(16);
        if (StringUtils.isNotEmpty((CharSequence)entityStr)) {
            objects = (List)SerializationUtils.fromJsonString((String)entityStr, List.class);
            for (Map combs : objects) {
                if ("10".equals(radio)) {
                    this.getAllMemsByScope(combs, entNums, entIds, num2Ids);
                    continue;
                }
                entIds = QueryMemberDetailsHelper.getMemberIdsByDefinedRange((String)"bcm_entitymembertree", (Long)Long.parseLong((String)combs.get("id")), (int)Integer.parseInt((String)combs.get(SCOPE)), (String)Long.toString(modelId), (DetailTypeEnum)DetailTypeEnum.OTHERS);
                this.getAllNumsByIds(entIds, entNums, num2Ids);
            }
        } else {
            QFilter qf = new QFilter(MODEL_ID, "=", (Object)modelId);
            DynamicObjectCollection orgMems = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, number, storagetype", (QFilter[])qf.toArray());
            List filterOrgMems = orgMems.stream().filter(x -> !StorageTypeEnum.SHARE.getOIndex().equals(x.getString("storagetype"))).collect(Collectors.toList());
            Set nums = filterOrgMems.stream().map(x -> x.getString("number")).collect(Collectors.toSet());
            Set ids = filterOrgMems.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
            num2Ids = filterOrgMems.stream().collect(Collectors.toMap(x -> x.getString("number"), y -> y.getLong("id"), (v1, v2) -> v1));
            entNums.addAll(nums);
            entIds.addAll(ids);
        }
        DynamicObjectCollection scenes = (DynamicObjectCollection)this.getModel().getValue(SCENE_F7);
        Set sceneIds = scenes.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toSet());
        DynamicObjectCollection years = (DynamicObjectCollection)this.getModel().getValue(YEAR_F7);
        Set yearIds = years.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toSet());
        DynamicObjectCollection periods = (DynamicObjectCollection)this.getModel().getValue(PERIOD_F7);
        Set periodIds = periods.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toSet());
        QFilter qf = new QFilter("id", "in", sceneIds);
        DynamicObjectCollection sceneList = QueryServiceHelper.query((String)"bcm_scenemembertree", (String)"id, number, name", (QFilter[])qf.toArray());
        QFilter qf1 = new QFilter("id", "in", yearIds);
        DynamicObjectCollection yearList = QueryServiceHelper.query((String)"bcm_fymembertree", (String)"id, number, name", (QFilter[])qf1.toArray());
        QFilter qf2 = new QFilter("id", "in", periodIds);
        DynamicObjectCollection periodList = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id, number, name", (QFilter[])qf2.toArray());
        Set<String> sceneNums = sceneList.stream().map(x -> x.getString("number")).collect(Collectors.toSet());
        Set<String> yearNums = yearList.stream().map(x -> x.getString("number")).collect(Collectors.toSet());
        Set<String> periodNums = periodList.stream().map(x -> x.getString("number")).collect(Collectors.toSet());
        Map<String, String> sceneMap = sceneList.stream().collect(Collectors.toMap(x -> x.getString("number"), y -> y.getString("id")));
        Map<String, String> yearMap = yearList.stream().collect(Collectors.toMap(x -> x.getString("number"), y -> y.getString("id")));
        Map<String, String> periodMap = periodList.stream().collect(Collectors.toMap(x -> x.getString("number"), y -> y.getString("id")));
        Set<String> combs = this.filterHaveDataCombs(entNums, sceneNums, yearNums, periodNums, extModelList);
        if (combs == null || combs.size() == 0) {
            map.put("noOpenDims", new HashSet(0));
            map.put("noFitMergeDims", new HashSet(0));
            map.put("noCompleteRepDims", new HashSet(0));
            map.put("noInvSheetsDims", new HashSet(0));
            map.put("mapped", new HashSet(0));
            map.put("mappedInv", new HashSet(10));
            return map;
        }
        combs = this.replaceNum2Id(combs, sceneMap, yearMap, periodMap);
        HashSet<String> dimsComb = new HashSet<String>(32);
        HashMap<String, List<String>> combMaps = new HashMap<String, List<String>>(32);
        for (String comb : combs) {
            String dims = comb.substring(comb.indexOf(";") + 1);
            dimsComb.add(dims);
            List list = combMaps.computeIfAbsent(dims, k -> new ArrayList(16));
            list.add(comb);
        }
        Map<String, Set<String>> opResult = this.filterNoOpenPeriodList(combs, dimsComb, combMaps);
        Set<String> noOpenDims = opResult.get("noOpenDims");
        Set<String> opendDims = opResult.get("opendDims");
        if (opendDims.size() == 0) {
            map.put("noOpenDims", noOpenDims);
            map.put("noFitMergeDims", new HashSet(0));
            map.put("noCompleteRepDims", new HashSet(0));
            map.put("noInvSheetsDims", new HashSet(0));
            map.put("mapped", new HashSet(0));
            map.put("mappedInv", new HashSet(10));
            return map;
        }
        LOG.info("noOpenDims content\uff1a" + String.join((CharSequence)",", noOpenDims));
        LOG.info("opendDims content\uff1a" + String.join((CharSequence)",", opendDims));
        Map<String, Set<String>> mcResult = this.smartMergeCheck(opendDims, num2Ids);
        Set<String> noFitMergeDims = mcResult.get("noFitMergeDims");
        Set<String> mcSubmitDims = mcResult.get("mcSubmitDims");
        if (mcSubmitDims.size() == 0) {
            map.put("noOpenDims", noOpenDims);
            map.put("noFitMergeDims", noFitMergeDims);
            map.put("noCompleteRepDims", new HashSet(0));
            map.put("noInvSheetsDims", new HashSet(0));
            map.put("mapped", new HashSet(0));
            map.put("mappedInv", new HashSet(10));
            return map;
        }
        LOG.info("noFitMergeDims content\uff1a" + String.join((CharSequence)",", noFitMergeDims));
        LOG.info("mcSubmitDims content\uff1a" + String.join((CharSequence)",", mcSubmitDims));
        Set noInvIds = extModels.stream().filter(x -> !"3".equals(x.getString("extendsgroup.grouptype"))).map(x -> x.getLong("id")).collect(Collectors.toSet());
        List<Map> noInvExtModelList = extModelList.stream().filter(x -> noInvIds.contains(x.get("pkv"))).collect(Collectors.toList());
        Map<String, Set<String>> reResult = this.reportStatusFilter(mcSubmitDims, noInvExtModelList);
        Set<String> completedRepDims = reResult.get("completedRepDims");
        Set<String> noCompleteRepDims = reResult.get("noCompleteRepDims");
        Set<String> mapped = reResult.get("mapped");
        if (noCompleteRepDims.size() == 0) {
            map.put("noOpenDims", noOpenDims);
            map.put("noFitMergeDims", noFitMergeDims);
            map.put("noCompleteRepDims", noCompleteRepDims);
            map.put("noInvSheetsDims", new HashSet(10));
            map.put("mapped", mapped);
            map.put("mappedInv", new HashSet(10));
            return map;
        }
        LOG.info("completedRepDims content\uff1a" + String.join((CharSequence)",", completedRepDims));
        LOG.info("noCompleteRepDims content\uff1a" + String.join((CharSequence)",", noCompleteRepDims));
        LOG.info("mapped content\uff1a" + String.join((CharSequence)",", mapped));
        Set invIds = extModels.stream().filter(x -> "3".equals(x.getString("extendsgroup.grouptype"))).map(x -> x.getLong("id")).collect(Collectors.toSet());
        List<Map> invExtModelList = extModelList.stream().filter(x -> invIds.contains(x.get("pkv"))).collect(Collectors.toList());
        Map<String, Set<String>> invResult = this.invSheetFilter(mcSubmitDims, invExtModelList);
        Set<String> invSheetsDims = invResult.get("invSheetsDims");
        Set<String> noInvSheetsDims = invResult.get("noInvSheetsDims");
        Set<String> mappedInv = invResult.get("mapped");
        if (noInvSheetsDims.size() == 0) {
            map.put("noOpenDims", noOpenDims);
            map.put("noFitMergeDims", noFitMergeDims);
            map.put("noCompleteRepDims", noCompleteRepDims);
            map.put("noInvSheetsDims", noInvSheetsDims);
            map.put("mapped", mapped);
            map.put("mappedInv", mappedInv);
            return map;
        }
        LOG.info("invSheetsDims content\uff1a" + String.join((CharSequence)",", invSheetsDims));
        LOG.info("noInvSheetsDims content\uff1a" + String.join((CharSequence)",", noInvSheetsDims));
        LOG.info("mappedInv content\uff1a" + String.join((CharSequence)",", mappedInv));
        this.datadumpOfExtend(noCompleteRepDims, noInvSheetsDims, scenes, years, periods, extModelList);
        this.writeOperationLogDefined(extModelList, scenes, years, periods, radio);
        map.put("noOpenDims", noOpenDims);
        map.put("noFitMergeDims", noFitMergeDims);
        map.put("noCompleteRepDims", noCompleteRepDims);
        map.put("noInvSheetsDims", noInvSheetsDims);
        map.put("mapped", mapped);
        map.put("mappedInv", mappedInv);
        return map;
    }

    private void writeOperationLogDefined(List<Map> extModelList, DynamicObjectCollection scenes, DynamicObjectCollection years, DynamicObjectCollection periods, String radio) {
        OPDescMultiLangEnumBridge opDes;
        String extModel = String.join((CharSequence)",", extModelList.stream().map(x -> (String)x.get("nu")).collect(Collectors.toSet()));
        String scene = String.join((CharSequence)",", scenes.stream().map(x -> x.getString("fbasedataid.number")).collect(Collectors.toSet()));
        String year = String.join((CharSequence)",", years.stream().map(x -> x.getString("fbasedataid.number")).collect(Collectors.toSet()));
        String period = String.join((CharSequence)",", periods.stream().map(x -> x.getString("fbasedataid.number")).collect(Collectors.toSet()));
        String showtext = this.getPageCache().get("showtext");
        if (StringUtils.isEmpty((CharSequence)showtext)) {
            opDes = new OPDescMultiLangEnumBridge("\u5bf9\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u62d3\u5c55\u6570\u636e\u6a21\u578b\uff0c\u5728\u60c5\u666f\u201c%3$s\u201d\uff0c\u8d22\u5e74\u201c%4$s\u201d\uff0c\u671f\u95f4\u201c%5$s\u201d\u4e0a\u6e05\u9664\u6570\u636e\u3002", "ExtendsDataDumpPlugin_33", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{this.getModelNumber(), extModel, scene, year, period}));
        } else {
            String entityName = "10".equals(radio) ? ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"", (String)"", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027", (String)"", (String)"", (Object[])new Object[0]);
            opDes = new OPDescMultiLangEnumBridge("\u5bf9\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u62d3\u5c55\u6570\u636e\u6a21\u578b\uff0c\u5728\u60c5\u666f\u201c%3$s\u201d\uff0c\u8d22\u5e74\u201c%4$s\u201d\uff0c\u671f\u95f4\u201c%5$s\u201d\uff0c\u201c%6$s\u201d\u201c%7$s\u201d\u4e0a\u6e05\u9664\u6570\u636e\u3002", "ExtendsDataDumpPlugin_30", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{this.getModelNumber(), extModel, scene, year, period, entityName, showtext}));
        }
        OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u6e05\u9664\u6570\u636e", "ExtendsDataDumpPlugin_27", "fi-bcm-formplugin", "clearData");
        this.writeMultiLangLog(opName, opDes);
    }

    private void getAllNumsByIds(Set<Long> entIds, Set<String> entNums, Map<String, Long> num2Ids) {
        QFilter qf = new QFilter("id", "in", entIds);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, number, storagetype", (QFilter[])qf.toArray());
        List<DynamicObject> filterOrgMems = result.stream().filter(x -> !StorageTypeEnum.SHARE.getOIndex().equals(x.getString("storagetype"))).collect(Collectors.toList());
        filterOrgMems.forEach(x -> {
            String number = x.getString("number");
            Long id = x.getLong("id");
            entNums.add(number);
            num2Ids.put(number, id);
        });
    }

    private void datadumpOfExtend(Set<String> noCompleteRepDims, Set<String> noInvSheetsDims, DynamicObjectCollection scenes, DynamicObjectCollection years, DynamicObjectCollection periods, List<Map> extModels) {
        Set extModelNums = noCompleteRepDims.stream().map(x -> x.substring(0, x.indexOf(";"))).collect(Collectors.toSet());
        Map<Object, Object> num2IdMap = extModels.stream().collect(Collectors.toMap(x -> x.get("nu"), y -> y.get("pkv"), (v1, v2) -> v1));
        Set extIds = extModelNums.stream().map(x -> num2IdMap.get(x)).collect(Collectors.toSet());
        if (noInvSheetsDims.size() > 0) {
            noCompleteRepDims.addAll(noInvSheetsDims);
        }
        ArrayList<String[]> combs = new ArrayList<String[]>(64);
        for (String dimStr : noCompleteRepDims) {
            String[] arr = new String[5];
            String[] dims = dimStr.split(";");
            arr[0] = dims[0];
            arr[1] = dims[1];
            arr[2] = scenes.stream().filter(x -> Long.parseLong(dims[2]) == x.getDynamicObject("fbasedataid").getLong("id")).findFirst().get().getString("fbasedataid.number");
            arr[3] = years.stream().filter(x -> Long.parseLong(dims[3]) == x.getDynamicObject("fbasedataid").getLong("id")).findFirst().get().getString("fbasedataid.number");
            arr[4] = periods.stream().filter(x -> Long.parseLong(dims[4]) == x.getDynamicObject("fbasedataid").getLong("id")).findFirst().get().getString("fbasedataid.number");
            combs.add(arr);
        }
        QFilter qfModel = new QFilter("id", "in", extIds);
        DynamicObjectCollection extModelList = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id, number, extendsgroup.grouptype", (QFilter[])qfModel.toArray());
        List jyGroups = extModelList.stream().filter(x -> "2".equals(x.getString("extendsgroup.grouptype"))).collect(Collectors.toList());
        List jyNums = jyGroups.stream().map(x -> x.getString("number")).collect(Collectors.toList());
        List qyGroups = extModelList.stream().filter(x -> "3".equals(x.getString("extendsgroup.grouptype"))).collect(Collectors.toList());
        List QyNums = qyGroups.stream().map(x -> x.getString("number")).collect(Collectors.toList());
        this.getView().showLoading(ResManager.getLocaleString((String)"\u6e05\u9664\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"ExtendsDataDumpPlugin_31", (String)"fi-bcm-formplugin"));
        try (TXHandle tx = TX.required((String)"ExtendsDataDumpPlugin_delete_extend_model_data");){
            try {
                for (String[] comb : combs) {
                    QFilter qf1;
                    QFilter qf2 = new QFilter("scenario", "=", (Object)comb[2]);
                    QFilter qf3 = new QFilter(YEAR_F7, "=", (Object)comb[3]);
                    QFilter qf4 = new QFilter(PERIOD_F7, "=", (Object)comb[4]);
                    QFilter qf5 = new QFilter("modelnumber", "=", (Object)this.getModelNumber());
                    QFilter qf = new QFilter("datamodel", "=", (Object)comb[0]);
                    String extModelNumber = comb[0];
                    if (jyNums.contains(extModelNumber)) {
                        qf1 = new QFilter("entity", "=", (Object)comb[1]);
                        DeleteServiceHelper.delete((String)"bcm_extenddata_bus", (QFilter[])new QFilter[]{qf, qf1, qf2, qf3, qf4, qf5});
                        continue;
                    }
                    if (QyNums.contains(extModelNumber)) {
                        qf1 = new QFilter(ORG_F7, "=", (Object)comb[1]);
                        DeleteServiceHelper.delete((String)"bcm_extenddata_inv", (QFilter[])new QFilter[]{qf, qf1, qf2, qf3, qf4, qf5});
                        continue;
                    }
                    qf1 = new QFilter("entity", "=", (Object)comb[1]);
                    DeleteServiceHelper.delete((String)"bcm_extenddata", (QFilter[])new QFilter[]{qf, qf1, qf2, qf3, qf4, qf5});
                }
            }
            catch (Exception e) {
                tx.markRollback();
                LOG.error(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6e05\u9664\u5931\u8d25\uff1a%s", (String)"ExtendsDataDumpPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
        this.getView().hideLoading();
    }

    private Map<String, Set<String>> reportStatusFilter(Set<String> mcSubmitDims, List<Map> extModelList) {
        Set extModelNums = mcSubmitDims.stream().map(x -> x.substring(0, x.indexOf(";"))).collect(Collectors.toSet());
        Map<Object, Object> num2IdMap = extModelList.stream().collect(Collectors.toMap(x -> x.get("nu"), y -> y.get("pkv"), (v1, v2) -> v1));
        Set extIds = extModelNums.stream().map(x -> num2IdMap.get(x)).collect(Collectors.toSet());
        QFilter qf = new QFilter(MODEL_ID, "=", (Object)this.getModelId());
        qf.and("extmodel", "in", extIds);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_extmodelref", (String)"template.id, extmodel.number, template.number", (QFilter[])qf.toArray());
        Map<String, Long> extNum2TemId = templates.stream().collect(Collectors.toMap(x -> x.getString("extmodel.number"), y -> y.getLong("template.id"), (v1, v2) -> v1));
        HashMap<Long, List> temId2ExtNum = new HashMap<Long, List>(16);
        for (Object template : templates) {
            long temId = template.getLong("template.id");
            String extNum = template.getString("extmodel.number");
            List extNums = temId2ExtNum.computeIfAbsent(temId, k -> new ArrayList(16));
            extNums.add(extNum);
        }
        ArrayList reportEntitys = new ArrayList(16);
        for (String combs : mcSubmitDims) {
            String[] result = combs.split(";");
            if (result.length != 5) continue;
            QFilter qf1 = new QFilter("template", "=", (Object)extNum2TemId.get(result[0]));
            QFilter entNum = new QFilter("entity.number", "=", (Object)result[1]);
            QFilter sceneId = new QFilter(SCENE_F7, "=", (Object)Long.parseLong(result[2]));
            QFilter yearId = new QFilter("fyear", "=", (Object)Long.parseLong(result[3]));
            QFilter periodId = new QFilter(PERIOD_F7, "=", (Object)Long.parseLong(result[4]));
            qf1.and(entNum).and(sceneId).and(yearId).and(periodId);
            DynamicObjectCollection reports = QueryServiceHelper.query((String)"bcm_reportentity", (String)"id, entity.number, scene.id, scene.number, fyear.id, fyear.number, period.id, period.number, reportstatus, template.id, currency, template.number", (QFilter[])qf1.toArray());
            reportEntitys.addAll(reports);
        }
        Set filterReports = reportEntitys.stream().filter(x -> ReportStatusEnum.COMPLETE.status().equals(x.getString("reportstatus")) || ReportStatusEnum.COMMIT.status().equals(x.getString("reportstatus"))).collect(Collectors.toSet());
        HashSet completedDims = new HashSet(16);
        HashSet mapped = new HashSet(16);
        filterReports.stream().map(x -> {
            List extNums = (List)temId2ExtNum.get(x.getLong("template.id"));
            for (String extNum : extNums) {
                if (!extModelNums.contains(extNum)) continue;
                String dims = String.format("%s;%s;%s;%s;%s", extNum, x.getString("entity.number"), x.getString("scene.id"), x.getString("fyear.id"), x.getString("period.id"));
                completedDims.add(dims);
                String dimNums = String.format("%s;%s;%s;%s", x.getString("entity.number"), x.getString("scene.number"), x.getString("fyear.number"), x.getString("period.number"));
                String mapping = String.format("%s;%s;%s", extNum, dimNums, x.getString("template.number"));
                mapped.add(mapping);
            }
            return x;
        }).collect(Collectors.toSet());
        mcSubmitDims.removeAll(completedDims);
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(2);
        result.put("noCompleteRepDims", mcSubmitDims);
        result.put("completedRepDims", completedDims);
        result.put("mapped", mapped);
        return result;
    }

    private Map<String, Set<String>> smartMergeCheck(Set<String> opendDims, Map<String, Long> num2Ids) {
        long modelId = this.getModelId();
        HashSet<String> noFitMergeDims = new HashSet<String>(16);
        for (String opendDim : opendDims) {
            String[] dims = opendDim.split(";");
            if (dims.length < 5) continue;
            String entNum = dims[1];
            String scenarioId = dims[2];
            String fyId = dims[3];
            String periodId = dims[4];
            String entityId = num2Ids.get(entNum).toString();
            McStatus mc = McStatus.getMcStatus((Object)modelId, (Object)entityId, (Object)scenarioId, (Object)fyId, (Object)periodId);
            if (!mc.getFlow().isSubmit() && !mc.getFlow().isArchive()) continue;
            noFitMergeDims.add(opendDim);
        }
        opendDims.removeAll(noFitMergeDims);
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(2);
        result.put("noFitMergeDims", noFitMergeDims);
        result.put("mcSubmitDims", opendDims);
        return result;
    }

    private Map<String, Set<String>> filterNoOpenPeriodList(Set<String> combs, Set<String> dimsComb, Map<String, List<String>> combMaps) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(2);
        HashSet noOpenDims = new HashSet(16);
        if (!ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM012")) {
            result.put("noOpenDims", noOpenDims);
            result.put("opendDims", combs);
            return result;
        }
        HashSet entNums = new HashSet(16);
        HashSet sceneIds = new HashSet(16);
        HashSet yearIds = new HashSet(16);
        HashSet periodIds = new HashSet(16);
        combs.forEach(x -> {
            String[] arrs = x.split(";");
            entNums.add(arrs[1]);
            sceneIds.add(Long.parseLong(arrs[2]));
            yearIds.add(Long.parseLong(arrs[3]));
            periodIds.add(Long.parseLong(arrs[4]));
        });
        Map isOpenMap = PeriodSettingHelper.batchCheckPeriodStatus2((long)this.getModelId(), entNums, sceneIds, yearIds, periodIds, (String)"datastatus");
        Iterator iterator = isOpenMap.entrySet().iterator();
        HashSet allValidDims = new HashSet(32);
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            String key = (String)next.getKey();
            if (!dimsComb.contains(key)) continue;
            if (((Boolean)next.getValue()).booleanValue()) {
                allValidDims.addAll(combMaps.get(key));
                continue;
            }
            noOpenDims.addAll(combMaps.get(key));
        }
        result.put("noOpenDims", noOpenDims);
        result.put("opendDims", allValidDims);
        return result;
    }

    private void getAllMemsByScope(Map<String, String> memScope, Set<String> entNums, Set<Long> entIds, Map<String, Long> num2Ids) {
        String scopeValue = memScope.get(SCOPE);
        if ("10".equals(scopeValue)) {
            String number = memScope.get("number");
            Long id = Long.parseLong(memScope.get("id"));
            entNums.add(memScope.get("number"));
            entIds.add(Long.parseLong(memScope.get("id")));
            num2Ids.put(number, id);
        } else {
            Map result = QueryMemberDetailsHelper.getMemberIdsByRange((String)"bcm_entitymembertree", (Long)Long.parseLong(memScope.get("id")), (String)memScope.get("number"), (int)Integer.parseInt(scopeValue), (String)String.valueOf(this.getModelId()));
            entNums.addAll((Set)result.get("numbers"));
            Set ids = ((Set)result.get("ids")).stream().map(x -> Long.parseLong(x)).collect(Collectors.toSet());
            entIds.addAll(ids);
            num2Ids.putAll((Map)result.get("num2Ids"));
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        Object newValue;
        super.beforePropertyChanged(e);
        String name = e.getProperty().getName();
        if (ORG_F7.equals(name) && ((newValue = e.getChangeSet()[0].getNewValue()) == null || StringUtils.isEmpty((CharSequence)newValue.toString()))) {
            this.getPageCache().remove(ORG_F7);
            this.getPageCache().remove("showtext");
        }
    }

    private Set<String> filterHaveDataCombs(Set<String> entNums, Set<String> sceneNums, Set<String> yearNums, Set<String> periodNums, List<Map> extModelList) {
        HashSet<String> combs = new HashSet<String>(32);
        String modelNumber = this.getPageCache().get("KEY_MODEL_NUMBER");
        Set extendModels = extModelList.stream().map(x -> (String)x.get("nu")).collect(Collectors.toSet());
        for (String datamodel : extendModels) {
            HashSet dims = new HashSet(32);
            QFilter qf = new QFilter("modelnumber", "=", (Object)modelNumber);
            qf.and(new QFilter("datamodel", "=", (Object)datamodel));
            qf.and(new QFilter("scenario", "in", sceneNums));
            qf.and(new QFilter(YEAR_F7, "in", yearNums));
            qf.and(new QFilter(PERIOD_F7, "in", periodNums));
            QFilter qfOth = new QFilter("entity", "in", entNums);
            QFilter qfInv = new QFilter(ORG_F7, "in", entNums);
            DynamicObjectCollection extDatas = QueryServiceHelper.query((String)"bcm_extenddata", (String)"datamodel, entity, scenario, year, period", (QFilter[])new QFilter[]{qf, qfOth});
            DynamicObjectCollection extDataBus = QueryServiceHelper.query((String)"bcm_extenddata_bus", (String)"datamodel, entity, scenario, year, period", (QFilter[])new QFilter[]{qf, qfOth});
            DynamicObjectCollection extDataInv = QueryServiceHelper.query((String)"bcm_extenddata_inv", (String)"datamodel, org as entity, scenario, year, period", (QFilter[])new QFilter[]{qf, qfInv});
            extDatas.stream().map(x -> dims.add(String.format("%s;%s;%s;%s;%s", datamodel, x.getString("entity"), x.getString("scenario"), x.getString(YEAR_F7), x.getString(PERIOD_F7)))).collect(Collectors.toSet());
            extDataBus.stream().map(x -> dims.add(String.format("%s;%s;%s;%s;%s", datamodel, x.getString("entity"), x.getString("scenario"), x.getString(YEAR_F7), x.getString(PERIOD_F7)))).collect(Collectors.toSet());
            extDataInv.stream().map(x -> dims.add(String.format("%s;%s;%s;%s;%s", datamodel, x.getString("entity"), x.getString("scenario"), x.getString(YEAR_F7), x.getString(PERIOD_F7)))).collect(Collectors.toSet());
            combs.addAll(dims);
        }
        return combs;
    }

    private Set<String> replaceNum2Id(Set<String> combsSet, Map<String, String> sceneNum2Ids, Map<String, String> yearNum2Ids, Map<String, String> perNum2Ids) {
        HashSet<String> newCombs = new HashSet<String>(32);
        for (String comb : combsSet) {
            String[] arrs = comb.split(";");
            arrs[2] = sceneNum2Ids.get(arrs[2]);
            arrs[3] = yearNum2Ids.get(arrs[3]);
            arrs[4] = perNum2Ids.get(arrs[4]);
            String newComb = String.format("%s;%s;%s;%s;%s", arrs[0], arrs[1], arrs[2], arrs[3], arrs[4]);
            newCombs.add(newComb);
        }
        return newCombs;
    }

    private List<DynamicObject> getAllExtModels(long modelId) {
        QFilter qf = new QFilter(MODEL_ID, "=", (Object)modelId);
        return QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id, number, extendsgroup.grouptype", (QFilter[])qf.toArray());
    }

    private Map<String, Set<String>> invSheetFilter(Set<String> noCompleteRepDims, List<Map> invExtModelList) {
        Object result;
        Set extModelNums = noCompleteRepDims.stream().map(x -> x.substring(0, x.indexOf(";"))).collect(Collectors.toSet());
        Map<Object, Object> num2IdMap = invExtModelList.stream().collect(Collectors.toMap(x -> x.get("nu"), y -> y.get("pkv"), (v1, v2) -> v1));
        Set extIds = extModelNums.stream().map(x -> num2IdMap.get(x)).collect(Collectors.toSet());
        QFilter qf = new QFilter(MODEL_ID, "=", (Object)this.getModelId());
        QFilter qf1 = new QFilter("extdimid", "in", extIds);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id, extdimid.number", (QFilter[])new QFilter[]{qf, qf1});
        Map<String, Long> extNum2TemId = templates.stream().collect(Collectors.toMap(x -> x.getString("extdimid.number"), y -> y.getLong("id"), (v1, v2) -> v1));
        HashMap<Long, List> temId2ExtNum = new HashMap<Long, List>(16);
        for (DynamicObject template : templates) {
            long temId = template.getLong("id");
            String extNum = template.getString("extdimid.number");
            List extNums = temId2ExtNum.computeIfAbsent(temId, k -> new ArrayList(16));
            extNums.add(extNum);
        }
        ArrayList invEntitys = new ArrayList(16);
        String selectedFields = "entity.number, scenario.id, scenario.number, year.id, year.number, period.id, period.number, template.id, template.number";
        for (String combs : noCompleteRepDims) {
            result = combs.split(";");
            if (((String[])result).length != 5) continue;
            QFilter qf2 = new QFilter("template", "=", (Object)extNum2TemId.get(result[0]));
            QFilter entNum = new QFilter("entity.number", "=", (Object)result[1]);
            QFilter sceneId = new QFilter("scenario", "=", (Object)Long.parseLong((String)result[2]));
            QFilter yearId = new QFilter(YEAR_F7, "=", (Object)Long.parseLong((String)result[3]));
            QFilter periodId = new QFilter(PERIOD_F7, "=", (Object)Long.parseLong((String)result[4]));
            qf2.and(entNum).and(sceneId).and(yearId).and(periodId);
            DynamicObjectCollection invSheets = QueryServiceHelper.query((String)"bcm_invlimsheetentity", (String)selectedFields, (QFilter[])new QFilter[]{qf, qf2});
            invEntitys.addAll(invSheets);
        }
        HashSet mapped = new HashSet(16);
        HashSet invSheetReports = new HashSet(16);
        invEntitys.stream().map(x -> {
            List extNums = (List)temId2ExtNum.get(x.getLong("template.id"));
            for (String extNum : extNums) {
                if (!extModelNums.contains(extNum)) continue;
                String dims = String.format("%s;%s;%s;%s;%s", extNum, x.getString("entity.number"), x.getString("scenario.id"), x.getString("year.id"), x.getString("period.id"));
                invSheetReports.add(dims);
                String dimNums = String.format("%s;%s;%s;%s", x.getString("entity.number"), x.getString("scenario.number"), x.getString("year.number"), x.getString("period.number"));
                String mapping = String.format("%s;%s;%s", extNum, dimNums, x.getString("template.number"));
                mapped.add(mapping);
            }
            return x;
        }).collect(Collectors.toSet());
        noCompleteRepDims.removeAll(invSheetReports);
        result = new HashMap(2);
        result.put("noInvSheetsDims", noCompleteRepDims);
        result.put("invSheetsDims", invSheetReports);
        result.put("mapped", mapped);
        return result;
    }
}

