/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimensionnew.extend;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.model.DimFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtField;
import kd.fi.bcm.business.extdata.model.ExtFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.model.FieldEntry;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.dimension.FieldTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.UserUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import org.apache.commons.io.IOUtils;

public class ExtendsModelImportPlugin
extends AbstractBaseFormPlugin
implements UploadListener {
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String NUMBER = "XDMCode";
    private static final String NAME = "XDMName";
    private static final String GROUP = "XGroup";
    private static final String DESCRIPTION = "Description";
    private static final String STATUS = "Status";
    private static final String FIELD_ENTRIES = "Columns";
    private static final String FIELD_NUMBER = "ColCode";
    private static final String FIELD_TYPE = "ColType";
    private static final String IS_NECESARRY = "NotNull";
    private static final String UNIQUE_CHECK = "IsUnique";
    private final List<String> INTR = Lists.newArrayList((Object[])new String[]{"INTR_SALE", "INTR_PURCHASE", "INTR_CONSOL", "INVEST"});

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btnok");
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        if ("btnok".equals(((Button)evt.getSource()).getKey())) {
            TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
            try {
                TempFileCacheDownloadable.Content content;
                String file_url = this.getPageCache().get("file_url");
                if (file_url == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u5bfc\u5165\u6570\u636e\u3002", (String)"ExtendsModelImportPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
                String[] reqParams = new URL(file_url).getQuery().split("&");
                HashMap<String, String> map = new HashMap<String, String>(reqParams.length);
                for (String param : reqParams) {
                    String[] p = param.split("=");
                    map.put(p[0], p[1]);
                }
                try {
                    content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                }
                catch (Exception e1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u5bfc\u5165\u6570\u636e\u3002", (String)"ExtendsModelImportPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
                if (content == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u5bfc\u5165\u6570\u636e\u3002", (String)"ExtendsModelImportPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
                InputStream inputStream = content.getInputStream();
                String jsonString = this.getStringFromInputStream(inputStream);
                this.handleInputStream(jsonString);
            }
            catch (Exception e) {
                log.error("error", (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private void handleInputStream(String jsonString) {
        QFilter qFilter;
        JSONArray jsonArray;
        try {
            jsonArray = (JSONArray)JSON.parse((String)jsonString);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"json\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u4e0a\u4f20\u683c\u5f0f\u6b63\u786e\u7684\u6587\u4ef6\u3002", (String)"ExtendsModelImportPlugin_20", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        ArrayList extendsModelList = Lists.newArrayListWithExpectedSize((int)16);
        for (Object model : jsonArray) {
            JSONObject modelObj = (JSONObject)model;
            ExtendsModel extendsModel = new ExtendsModel();
            extendsModel.setNumber(modelObj.getString(NUMBER).trim());
            extendsModel.setName(modelObj.getString(NAME).trim());
            String groupNumber = modelObj.getString(GROUP).trim();
            QFilter modelQf = new QFilter("model", "=", (Object)this.getModelId());
            QFilter qf1 = new QFilter("number", "=", (Object)groupNumber);
            DynamicObject group = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"id,number,grouptype", (QFilter[])new QFilter[]{modelQf, qf1});
            if (group == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6a21\u578b\u4e0d\u5b58\u5728\u6709\u6548\u7684\u62d3\u5c55\u4e1a\u52a1\u5206\u7ec4:\u201c%2$s\u201d\u3002", (String)"ExtendsModelImportPlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), extendsModel.getNumber(), groupNumber));
            }
            extendsModel.setExtendsGroup(group.getLong("id"));
            extendsModel.setDescription(modelObj.getString(DESCRIPTION));
            extendsModel.setEnable(modelObj.getString(STATUS).trim().equalsIgnoreCase("Valid") ? "1" : "0");
            extendsModel.setModifier(UserUtils.getUserId());
            extendsModel.setModifytime(new Date());
            extendsModel.setExtendsGroupType(group.getString("grouptype"));
            if ("3".equals(group.getString("grouptype"))) {
                extendsModel.setIsConvert(false);
            } else {
                extendsModel.setIsConvert("True".equalsIgnoreCase(modelObj.getString("CanTrans")));
            }
            JSONArray fieldEntries = modelObj.getJSONArray(FIELD_ENTRIES);
            Set extNumbers = fieldEntries.stream().filter(o -> ((JSONObject)o).getString(FIELD_TYPE).trim().equalsIgnoreCase(FieldTypeEnum.EXT_FIELD.getNumber())).map(o -> ((JSONObject)o).getString(FIELD_NUMBER).trim()).collect(Collectors.toSet());
            Set dimNumbers = fieldEntries.stream().filter(o -> ((JSONObject)o).getString(FIELD_TYPE).trim().equalsIgnoreCase(FieldTypeEnum.DIM_FIELD.getNumber())).map(o -> ((JSONObject)o).getString(FIELD_NUMBER).trim()).collect(Collectors.toSet());
            QFilter qf2 = new QFilter("number", "in", extNumbers);
            QFilter qf3 = new QFilter("number", "in", dimNumbers);
            HashMap extDimsMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap dimsMap = Maps.newHashMapWithExpectedSize((int)16);
            if (!CollectionUtils.isEmpty(extNumbers)) {
                DynamicObjectCollection extDims = QueryServiceHelper.query((String)"bcm_structofextend", (String)"id,number,name", (QFilter[])new QFilter[]{modelQf, qf2});
                if (extDims == null || extDims.size() == 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6a21\u578b\u4e0d\u5b58\u5728\u6709\u6548\u62d3\u5c55\u7ef4\u5ea6\u5b57\u6bb5\u3002", (String)"ExtendsModelImportPlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), extendsModel.getNumber()));
                }
                for (DynamicObject extDim : extDims) {
                    extDimsMap.put(extDim.getString("number"), extDim);
                }
            } else {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6a21\u578b\u4e0d\u5b58\u5728\u6709\u6548\u62d3\u5c55\u7ef4\u5ea6\u5b57\u6bb5\u3002", (String)"ExtendsModelImportPlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), extendsModel.getNumber()));
            }
            if (!CollectionUtils.isEmpty(dimNumbers)) {
                DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,name", (QFilter[])new QFilter[]{modelQf, qf3});
                for (DynamicObject dim : dims) {
                    dimsMap.put(dim.getString("number"), dim);
                }
            }
            ArrayList fieldEntryList = Lists.newArrayListWithExpectedSize((int)16);
            int index = 0;
            for (Object obj : fieldEntries) {
                JSONObject jsonObj = (JSONObject)obj;
                FieldEntry fieldEntry = new FieldEntry();
                fieldEntry.setNumber(jsonObj.getString(FIELD_NUMBER).trim());
                fieldEntry.setFieldType(FieldTypeEnum.getTypeByNumber((String)jsonObj.getString(FIELD_TYPE)).intValue());
                if (jsonObj.getString(FIELD_TYPE).trim().equalsIgnoreCase(FieldTypeEnum.EXT_FIELD.getNumber())) {
                    DynamicObject extDim = (DynamicObject)extDimsMap.get(jsonObj.getString(FIELD_NUMBER).trim());
                    if (extDim == null) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0d\u5b58\u5728\u62d3\u5c55\u7ef4\u5ea6\u201c%s\u201d\u3002", (String)"ExtendsModelImportPlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), jsonObj.getString(FIELD_NUMBER).trim()));
                    }
                    ExtField extField = new ExtField();
                    extField.setNumber(extDim.getString("number"));
                    extField.setName(extDim.getString("name"));
                    extField.setId(extDim.getLong("id"));
                    fieldEntry.setExtField(extField);
                } else if (jsonObj.getString(FIELD_TYPE).trim().equalsIgnoreCase(FieldTypeEnum.DIM_FIELD.getNumber())) {
                    DynamicObject dim = (DynamicObject)dimsMap.get(jsonObj.getString(FIELD_NUMBER).trim());
                    if (dim == null) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0d\u5b58\u5728%s\u7ef4\u5ea6\u3002", (String)"ExtendsModelImportPlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), jsonObj.getString(FIELD_NUMBER).trim()));
                    }
                    fieldEntry.setDimension(this.generateDimension(dim.getLong("id"), dim.getString("number"), dim.getString("name")));
                }
                fieldEntry.setSeq(index);
                fieldEntry.setIsNecessary(jsonObj.getString(IS_NECESARRY).trim().equalsIgnoreCase("Y"));
                fieldEntry.setUniqueCheck(jsonObj.getString(UNIQUE_CHECK).trim().equalsIgnoreCase("Y"));
                fieldEntryList.add(fieldEntry);
                ++index;
            }
            extendsModel.setFieldEntry((List)fieldEntryList);
            extendsModelList.add(extendsModel);
        }
        Set collect = extendsModelList.stream().map(o -> o.getNumber()).collect(Collectors.toSet());
        QFilter modelQf = new QFilter("model", "=", (Object)this.getModelId());
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"name, number", (QFilter[])new QFilter[]{modelQf, qFilter = new QFilter("number", "in", collect)});
        if (objects != null && objects.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (DynamicObject object : objects) {
                sb.append(object.getString("number")).append('|').append(object.getString("name")).append(' ');
            }
            this.getPageCache().put("extendsModelList", this.toByteSerialized(extendsModelList));
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("hasSameModel");
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u201c%s\u201d\u62d3\u5c55\u7ef4\u6a21\u578b\uff0c\u662f\u5426\u8986\u76d6\u5df2\u6709\u6a21\u578b\uff1f", (String)"ExtendsModelImportPlugin_17", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), sb.toString()), MessageBoxOptions.YesNo, confirmCallBacks);
        } else {
            this.saveExtendsModel(extendsModelList);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if ("hasSameModel".equals(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            List extendsModelList = (List)this.deSerializedBytes(this.getPageCache().get("extendsModelList"));
            this.saveExtendsModel(extendsModelList);
            this.getPageCache().remove("extendsModelList");
        }
    }

    private void saveExtendsModel(List<ExtendsModel> extendsModelList) {
        Tuple<List<ExtendsModel>, List<ExtendsModel>, Map<String, String>> checkResult = this.checkSaveStatus(extendsModelList);
        if (((List)checkResult.p1).size() > 0) {
            for (ExtendsModel extendsModel : (List)checkResult.p1) {
                TXHandle tx = TX.required();
                Throwable throwable = null;
                try {
                    try {
                        DynamicObject extmodel = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extendsmodel");
                        QFilter modelQf = new QFilter("model", "=", (Object)this.getModelId());
                        QFilter qf1 = new QFilter("number", "=", (Object)extendsModel.getNumber());
                        DynamicObject object = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id", (QFilter[])new QFilter[]{modelQf, qf1});
                        if (object != null && object.getLong("id") != 0L) {
                            Object dy;
                            extmodel = BusinessDataServiceHelper.loadSingle((Object)object.getLong("id"), (String)"bcm_extendsmodel");
                            QFBuilder qb = new QFBuilder("extmodelid", "=", (Object)object.getLong("id"));
                            DynamicObjectCollection extmodelfield = QueryServiceHelper.query((String)"bcm_extmodelfield", (String)"id", (QFilter[])qb.toArray());
                            DynamicObjectCollection extmodeldim = QueryServiceHelper.query((String)"bcm_extmodeldim", (String)"id", (QFilter[])qb.toArray());
                            if (!CollectionUtils.isEmpty((Collection)extmodelfield)) {
                                List fieldids = extmodelfield.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                                dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extmodelfield");
                                DeleteServiceHelper.delete((IDataEntityType)dy.getDynamicObjectType(), (Object[])fieldids.toArray());
                            }
                            if (!CollectionUtils.isEmpty((Collection)extmodeldim)) {
                                List dimids = extmodeldim.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                                dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extmodeldim");
                                DeleteServiceHelper.delete((IDataEntityType)dy.getDynamicObjectType(), (Object[])dimids.toArray());
                            }
                        }
                        extmodel.set("model", (Object)this.getModelId());
                        extmodel.set("number", (Object)extendsModel.getNumber());
                        extmodel.set("name", (Object)extendsModel.getName());
                        extmodel.set("extendsgroup", (Object)extendsModel.getExtendsGroup());
                        extmodel.set("description", (Object)extendsModel.getDescription());
                        extmodel.set("status", (Object)"C");
                        extmodel.set("enable", (Object)(StringUtils.isEmpty((String)extendsModel.getEnable()) ? "1" : extendsModel.getEnable()));
                        extmodel.set("creator", (Object)(null == extendsModel.getCreator() ? UserUtils.getUserId() : extendsModel.getCreator()));
                        extmodel.set("modifier", (Object)UserUtils.getUserId());
                        extmodel.set("createtime", (Object)(null == extendsModel.getCreatetime() ? new Date() : extendsModel.getCreatetime()));
                        extmodel.set("modifytime", (Object)new Date());
                        extmodel.set("isconvert", (Object)extendsModel.getIsConvert());
                        Object[] result = BusinessDataWriter.save((IDataEntityType)extmodel.getDynamicObjectType(), (Object[])new Object[]{extmodel});
                        long extmodelid = ((DynamicObject)result[0]).getLong("id");
                        ArrayList extfields = Lists.newArrayListWithExpectedSize((int)16);
                        for (ExtFieldEntry extFieldEntry : extendsModel.getExtFieldEntry()) {
                            DynamicObject dy2 = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extmodelfield");
                            dy2.set("extfield", (Object)extFieldEntry.getExtField().getId());
                            dy2.set("sequence", (Object)extFieldEntry.getSeq());
                            dy2.set("isnecessary", (Object)extFieldEntry.getIsNecessary());
                            dy2.set("uniquecheck", (Object)extFieldEntry.getUniqueCheck());
                            dy2.set("extmodelid", (Object)extmodelid);
                            extfields.add(dy2);
                        }
                        if (!CollectionUtils.isEmpty((Collection)extfields)) {
                            BusinessDataWriter.save((IDataEntityType)((DynamicObject)extfields.get(0)).getDynamicObjectType(), (Object[])extfields.toArray());
                        }
                        ArrayList dimensions = Lists.newArrayListWithExpectedSize((int)16);
                        for (DimFieldEntry dimFieldEntry : extendsModel.getDimFieldEntry()) {
                            DynamicObject dy2 = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extmodeldim");
                            dy2.set("dimension", (Object)dimFieldEntry.getDimension().getId());
                            dy2.set("sequence", (Object)dimFieldEntry.getSeq());
                            dy2.set("isnecessary", (Object)dimFieldEntry.getIsNecessary());
                            dy2.set("uniquecheck", (Object)dimFieldEntry.getUniqueCheck());
                            dy2.set("extmodelid", (Object)extmodelid);
                            dimensions.add(dy2);
                        }
                        if (CollectionUtils.isEmpty((Collection)dimensions)) continue;
                        BusinessDataWriter.save((IDataEntityType)((DynamicObject)dimensions.get(0)).getDynamicObjectType(), (Object[])dimensions.toArray());
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        ((List)checkResult.p2).add(extendsModel);
                        ((Map)checkResult.p3).put(extendsModel.getNumber(), e.getMessage());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
        }
        this.returnDataToParent(this.gengrateMessage(checkResult));
        this.getView().close();
    }

    private Tuple<Boolean, String, Map<String, String>> gengrateMessage(Tuple<List<ExtendsModel>, List<ExtendsModel>, Map<String, String>> checkResult) {
        ((List)checkResult.p1).removeAll((Collection)checkResult.p2);
        int passSize = ((List)checkResult.p1).size();
        int failSize = ((List)checkResult.p2).size();
        if (failSize == 0) {
            return Tuple.create((Object)Boolean.TRUE, (Object)String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6a21\u578b\u5bfc\u5165\u6210\u529f%1s\u6761\uff0c\u5bfc\u5165\u5931\u8d25%2s\u6761\u3002", (String)"ExtendsModelImportPlugin_18", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), passSize, failSize), null);
        }
        return Tuple.create((Object)Boolean.FALSE, (Object)String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6a21\u578b\u5bfc\u5165\u6210\u529f%1$s\u6761\uff0c\u5bfc\u5165\u5931\u8d25%2$s\u6761\uff0c\u70b9\u51fb\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f\u4e0b\u8f7d\u9519\u8bef\u65e5\u5fd7\u3002", (String)"ExtendsModelImportPlugin_19", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), passSize, failSize), (Object)checkResult.p3);
    }

    private Tuple<List<ExtendsModel>, List<ExtendsModel>, Map<String, String>> checkSaveStatus(List<ExtendsModel> extendsModelList) {
        HashMap messageMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList fails = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList passes = Lists.newArrayListWithExpectedSize((int)16);
        QFilter modelQf = new QFilter("model", "=", (Object)this.getModelId());
        for (ExtendsModel extendsModel : extendsModelList) {
            String regEx;
            Pattern pattern;
            Matcher matcher;
            String number = extendsModel.getNumber();
            if (this.INTR.contains(number)) {
                messageMap.put(number, ResManager.loadKDString((String)"\u9884\u7f6e\u62d3\u5c55\u6a21\u578b\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"ExtendsModelImportPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                fails.add(extendsModel);
                continue;
            }
            QFilter qf1 = new QFilter("number", "=", (Object)number);
            DynamicObject object = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id", (QFilter[])new QFilter[]{modelQf, qf1});
            boolean isEdit = false;
            if (object != null && object.getLong("id") != 0L) {
                isEdit = true;
                extendsModel.setId(object.getLong("id"));
            }
            if (!(matcher = (pattern = Pattern.compile(regEx = "^[-a-zA-Z0-9._]+$")).matcher(number)).matches() || number.contains("..") || number.startsWith(".") || number.startsWith("-")) {
                messageMap.put(number, ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u7f16\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ExtendsModelImportPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                fails.add(extendsModel);
                continue;
            }
            this.generateDimExtEntry(extendsModel);
            if (extendsModel.getExtFieldEntry() == null || extendsModel.getExtFieldEntry().size() == 0) {
                messageMap.put(number, ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u62d3\u5c55\u5b57\u6bb5\u6210\u5458\u3002", (String)"ExtendsModelImportPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                fails.add(extendsModel);
                continue;
            }
            List extFieldIdList = extendsModel.getExtFieldEntry().stream().map(o -> o.getExtField().getId()).collect(Collectors.toList());
            Set extFieldIdSet = extendsModel.getExtFieldEntry().stream().map(o -> o.getExtField().getId()).collect(Collectors.toSet());
            if (extFieldIdList.size() != extFieldIdSet.size()) {
                messageMap.put(number, ResManager.loadKDString((String)"\u76f8\u540c\u62d3\u5c55\u5b57\u6bb5\u6210\u5458\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0\u3002", (String)"ExtendsModelImportPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                fails.add(extendsModel);
                continue;
            }
            Boolean necessaryFlag = true;
            for (Object dimFieldEntry : extendsModel.getDimFieldEntry()) {
                if (dimFieldEntry.getIsNecessary()) continue;
                necessaryFlag = false;
                break;
            }
            if (!necessaryFlag.booleanValue()) {
                messageMap.put(number, ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u8bbe\u7f6e\u8981\u6c42\u5305\u542b\u6240\u6709\u591a\u7ef4\u5b57\u6bb5\u53ca\u81f3\u5c11\u4e00\u4e2a\u62d3\u5c55\u5b57\u6bb5\u3002", (String)"ExtendsModelPlugin_21", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                fails.add(extendsModel);
                continue;
            }
            int count = 0;
            if (!"3".equals(extendsModel.getExtendsGroupType())) {
                Object dimFieldEntry;
                dimFieldEntry = extendsModel.getExtFieldEntry().iterator();
                while (dimFieldEntry.hasNext()) {
                    ExtFieldEntry extFieldEntry = (ExtFieldEntry)dimFieldEntry.next();
                    if (!extFieldEntry.getIsNecessary()) continue;
                    ++count;
                    break;
                }
                if (count == 0) {
                    messageMap.put(number, ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u8bbe\u7f6e\u8981\u6c42\u5305\u542b\u6240\u6709\u591a\u7ef4\u5b57\u6bb5\u53ca\u81f3\u5c11\u4e00\u4e2a\u62d3\u5c55\u5b57\u6bb5\u3002", (String)"ExtendsModelPlugin_21", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    fails.add(extendsModel);
                    continue;
                }
            }
            if (isEdit) {
                boolean isUsed = this.getIsUsed(extendsModel.getId());
                if (isUsed) {
                    messageMap.put(number, ResManager.loadKDString((String)"\u5f53\u524d\u62d3\u5c55\u6570\u636e\u6a21\u578b\u5df2\u88ab\u62a5\u8868\u6a21\u677f\u6216\u6743\u76ca\u62b5\u9500\u5e95\u7a3f\u6a21\u677f\u5f15\u7528\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"ExtendsModelImportPlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    fails.add(extendsModel);
                    continue;
                }
                ExtendsModel extendsModelOri = new ExtendsModel(Long.valueOf(extendsModel.getId()));
                String grouptype = BusinessDataServiceHelper.loadSingle((Object)extendsModel.getExtendsGroup(), (String)"bcm_structofextend").getString("grouptype");
                List oriExtFieldId = extendsModelOri.getExtFieldEntry().stream().map(o -> o.getExtField().getId()).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(oriExtFieldId) && ExtDataServiceHelper.isExistDataOfExtMemSpecific((String)this.getModelShowNumber(), (String)number, oriExtFieldId, (String)grouptype).booleanValue()) {
                    messageMap.put(number, ResManager.loadKDString((String)"\u5f53\u524d\u62d3\u5c55\u6570\u636e\u6a21\u578b\u5df2\u6709\u6570\u636e\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"ExtendsModelImportPlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    fails.add(extendsModel);
                    continue;
                }
                List oriDimFieldNum = extendsModelOri.getDimFieldEntry().stream().map(o -> o.getDimension().getNumber()).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(oriDimFieldNum) && ExtDataServiceHelper.isExistDataOfDimMemSpecific((String)this.getModelShowNumber(), (String)number, oriDimFieldNum, (String)grouptype)) {
                    messageMap.put(number, ResManager.loadKDString((String)"\u5f53\u524d\u62d3\u5c55\u6570\u636e\u6a21\u578b\u5df2\u6709\u6570\u636e\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"ExtendsModelImportPlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    fails.add(extendsModel);
                    continue;
                }
            }
            passes.add(extendsModel);
        }
        return Tuple.create((Object)passes, (Object)fails, (Object)messageMap);
    }

    private boolean getIsUsed(Long id) {
        return ExtDataServiceHelper.isExtModelUsed((long)this.getModelId(), (List)Lists.newArrayList((Object[])new Long[]{id}));
    }

    private String getModelShowNumber() {
        return BusinessDataServiceHelper.loadSingle((Object)this.getModelId(), (String)"bcm_model").getString("shownumber");
    }

    private void generateDimExtEntry(ExtendsModel extendsModel) {
        ArrayList dimFieldEntries = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList extFieldEntries = Lists.newArrayListWithExpectedSize((int)16);
        for (FieldEntry fieldEntry : extendsModel.getFieldEntry()) {
            if (FieldTypeEnum.DIM_FIELD.getType() == fieldEntry.getFieldType()) {
                DimFieldEntry dimFieldEntry = new DimFieldEntry();
                dimFieldEntry.setDimension(fieldEntry.getDimension());
                dimFieldEntry.setSeq(fieldEntry.getSeq());
                dimFieldEntry.setId(fieldEntry.getId());
                dimFieldEntry.setIsNecessary(fieldEntry.getIsNecessary());
                dimFieldEntry.setUniqueCheck(fieldEntry.getUniqueCheck());
                dimFieldEntries.add(dimFieldEntry);
                continue;
            }
            if (FieldTypeEnum.EXT_FIELD.getType() != fieldEntry.getFieldType()) continue;
            ExtFieldEntry extFieldEntry = new ExtFieldEntry();
            extFieldEntry.setExtField(fieldEntry.getExtField());
            extFieldEntry.setSeq(fieldEntry.getSeq());
            extFieldEntry.setId(fieldEntry.getId());
            extFieldEntry.setIsNecessary(fieldEntry.getIsNecessary());
            extFieldEntry.setUniqueCheck(fieldEntry.getUniqueCheck());
            extFieldEntries.add(extFieldEntry);
        }
        extendsModel.setDimFieldEntry((List)dimFieldEntries);
        extendsModel.setExtFieldEntry((List)extFieldEntries);
    }

    private Dimension generateDimension(long id, String number, String name) {
        Dimension dimension = new Dimension();
        dimension.setId(id);
        dimension.setModelId(String.valueOf(this.getModelId()));
        dimension.setNumber(number);
        dimension.setName(name);
        dimension.setMemberEntityNumber(DimEntityNumEnum.getEntieyNumByNumber((String)number));
        return dimension;
    }

    private String getStringFromInputStream(InputStream inputStream) {
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            log.error("io error", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"IO\u5f02\u5e38\u3002", (String)"ExtendsModelImportPlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        return writer.toString();
    }

    public void upload(UploadEvent evt) {
        for (Object url : evt.getUrls()) {
            this.getPageCache().put("file_url", (String)((Map)url).get("url"));
        }
    }
}

