/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimensionnew.extend;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.extdata.ExportExtModelServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.common.LogConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class ExtendsModelListPlugin
extends AbstractBaseListPlugin
implements HyperLinkClickListener {
    private static final String DOWNLOAD = "download";
    private static final String BILLLISTAP = "billlistap";
    private static final String EXT_DATA_DUMP = "extdatadump";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("btn_add", "btn_delete", "btn_enable", "btn_unable", "btn_refresh", "btn_exit", "btn_datadump");
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addListRowClickListener((ListRowClickListener)this);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("model");
        basedataEdit.addBeforeF7SelectListener(evt -> evt.getCustomQFilters().add(this.getExistExtendsDimFilter()));
    }

    private QFilter getExistExtendsDimFilter() {
        HashSet<Long> modelIds = new HashSet<Long>();
        DynamicObjectCollection result = QueryServiceHelper.query((String)"bcm_dimension_ext", (String)"model.id", (QFilter[])new QFilter("enable", "=", (Object)"1").toArray());
        if (result != null && result.size() > 0) {
            for (DynamicObject object : result) {
                modelIds.add(object.getLong("model.id"));
            }
        }
        return new QFilter("id", "in", modelIds);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setValue("model", this.getModelId());
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.setFilterParameter(new FilterParameter(new QFilter("model", "=", (Object)this.getModelId()), "id"));
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_add": {
                if (this.getValue("model") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExtendsModelListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.openNewFormPage();
                break;
            }
            case "btn_refresh": {
                this.refreshList();
                break;
            }
            case "btn_delete": {
                BillList billlist = (BillList)this.getControl(BILLLISTAP);
                ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
                if (selectedRows == null || selectedRows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u6a21\u578b\u3002", (String)"ExtendsModelListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                List selectRowNums = selectedRows.stream().map(o -> o.getNumber()).collect(Collectors.toList());
                if (selectRowNums.contains("INTR_SALE") || selectRowNums.contains("INTR_PURCHASE") || selectRowNums.contains("INTR_CONSOL") || selectRowNums.contains("INVEST")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u7684\u62d3\u5c55\u6570\u636e\u6a21\u578b\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ExtendsModelListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                List<Long> selectRowIds = selectedRows.stream().map(o -> (Long)o.getPrimaryKeyValue()).collect(Collectors.toList());
                if (this.getIsUsedByIntergrationScheme(selectRowIds)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u88ab\u96c6\u6210\u65b9\u6848\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5\u6216\u5220\u9664\u62d3\u5c55\u6570\u636e\u6a21\u578b\u3002", (String)"ExtendsModelListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.checkDeleteStatus(selectedRows)) {
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("btn_delete", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u9009\u4e2d\u6570\u636e\u6a21\u578b\u5417\uff1f", (String)"ExtendsModelListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u6570\u636e\u6a21\u578b\u6709\u62a5\u8868\u6a21\u677f\u3001\u6743\u76ca\u62b5\u9500\u5e95\u7a3f\u6a21\u677f\u6216\u5185\u90e8\u4ea4\u6613\u5e95\u7a3f\u6a21\u677f\u5f15\u7528\uff0c\u6216\u5df2\u6709\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"ExtendsModelListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "btn_enable": {
                this.updateStatus("1");
                break;
            }
            case "btn_unable": {
                this.updateStatus("0");
                break;
            }
            case "btn_exit": {
                this.getView().close();
                break;
            }
            case "btn_import": {
                this.openImportFormPage();
                break;
            }
            case "btn_export": {
                BillList billlist1 = (BillList)this.getControl(BILLLISTAP);
                ListSelectedRowCollection selectedRows1 = billlist1.getSelectedRows();
                if (selectedRows1 == null || selectedRows1.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6570\u636e\u6a21\u578b\u3002", (String)"ExtendsModelListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.exportModelData(selectedRows1);
                this.writeOperationLog(this.getOperationExport(), "");
                break;
            }
            case "btn_datadump": {
                this.extendsDataDump();
            }
        }
    }

    private String getOperationExport() {
        return ResManager.loadKDString((String)"\u5bfc\u51fa\u62d3\u5c55\u6570\u636e\u6a21\u578b", (String)"ExtendsModelListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationDelete() {
        return ResManager.loadKDString((String)"\u5220\u9664\u62d3\u5c55\u6570\u636e\u6a21\u578b", (String)"ExtendsModelListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private void exportModelData(ListSelectedRowCollection selectedRows) {
        List selectRowNums = selectedRows.stream().map(o -> o.getNumber()).collect(Collectors.toList());
        JSONArray json = ExportExtModelServiceHelper.getModel(selectRowNums, (long)this.getModelId());
        String pretty = JSON.toJSONString((Object)json, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        String url = ExportExtModelServiceHelper.downloadJsonFile((String)pretty);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction(DOWNLOAD, (Object)url);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (MessageBoxResult.Yes.getValue() == event.getResult().getValue() && "btn_delete".equals(callBackId)) {
            this.deleteRecord();
        }
    }

    private boolean checkDeleteStatus(ListSelectedRowCollection selectedRows) {
        List selectRowNums = selectedRows.stream().map(o -> o.getNumber()).collect(Collectors.toList());
        List selectRowIds = selectedRows.stream().map(o -> (Long)o.getPrimaryKeyValue()).collect(Collectors.toList());
        boolean extModelExistData = ExtDataServiceHelper.isExtModelExistData((String)this.getModelShowNumber(), selectRowNums);
        boolean isExistDataOfInvestExtModel = ExtDataServiceHelper.isExistDataOfInvestExtModel((String)this.getModelShowNumber(), selectRowNums);
        Boolean extModelUsed = ExtDataServiceHelper.isExtModelUsed((long)this.getModelId(), selectRowIds);
        return !extModelExistData && !isExistDataOfInvestExtModel && extModelUsed == false;
    }

    private void updateStatus(String enable) {
        DynamicObject[] object;
        BillList billlist = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
        List pks = selectedRows.stream().map(o -> o.getPrimaryKeyValue().toString()).collect(Collectors.toList());
        QFilter qf = new QFilter("id", "in", (Object)LongUtil.toLongList(pks));
        DynamicObjectCollection models = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id, number, name, enable", (QFilter[])qf.toArray());
        StringBuilder sb = new StringBuilder();
        for (DynamicObject model : models) {
            if (!enable.equals(model.get("enable"))) continue;
            sb.append(model.get("number")).append(" ").append(model.get("name")).append(" ");
        }
        if (sb.length() > 0) {
            if ("1".equals(enable)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u201c%s\u201d\u5df2\u542f\u7528\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\u3002", (String)"ExtendsModelListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb.toString()));
            } else if ("0".equals(enable)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u201c%s\u201d\u5df2\u7981\u7528\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\u3002", (String)"ExtendsModelListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb.toString()));
            }
            return;
        }
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extendsmodel");
        for (DynamicObject dynamicObject : object = BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)dy.getDynamicObjectType())) {
            dynamicObject.set("enable", (Object)enable);
        }
        SaveServiceHelper.update((DynamicObject[])object);
        for (DynamicObject dynamicObject : object) {
            String number = dynamicObject.getString("number");
            String name = dynamicObject.getString("name");
            if ("1".equals(enable)) {
                this.writeOperationLog(OpItemEnum.ENABLE.getName(), number, name, LogConstant.getOperationStatusSuccess());
                continue;
            }
            if (!"0".equals(enable)) continue;
            this.writeOperationLog(OpItemEnum.DISABLE.getName(), number, name, LogConstant.getOperationStatusSuccess());
        }
        if ("1".equals(enable)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"ExtendsModelListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else if ("0".equals(enable)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"ExtendsModelListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.refreshList();
    }

    private void deleteRecord() {
        try (TXHandle tx = TX.required();){
            try {
                BillList billlist = (BillList)this.getControl(BILLLISTAP);
                ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
                List pks = selectedRows.stream().map(o -> o.getPrimaryKeyValue()).collect(Collectors.toList());
                StringBuilder sb = new StringBuilder();
                selectedRows.stream().forEach(o -> sb.append(o.getName()).append('\uff08').append(o.getNumber()).append('\uff09').append('\u3001'));
                DynamicObject extmodel = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extendsmodel");
                DeleteServiceHelper.delete((IDataEntityType)extmodel.getDynamicObjectType(), (Object[])pks.toArray());
                QFBuilder qb = new QFBuilder("extmodelid", "in", pks);
                DeleteServiceHelper.delete((String)"bcm_extmodelfield", (QFilter[])qb.toArray());
                DeleteServiceHelper.delete((String)"bcm_extmodeldim", (QFilter[])qb.toArray());
                this.refreshList();
                sb.deleteCharAt(sb.lastIndexOf("\u3001"));
                this.writeOperationLog(this.getOperationDelete(), sb.toString());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ExtendsModelListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private void refreshList() {
        BillList billlist = (BillList)this.getControl(BILLLISTAP);
        billlist.setFilterParameter(new FilterParameter(new QFilter("model", "=", (Object)this.getModelId()), "id"));
        billlist.refresh();
        billlist.clearSelection();
    }

    private boolean getIsUsedByIntergrationScheme(List<Long> ids) {
        return QueryServiceHelper.exists((String)"bcm_isscheme", (QFilter[])new QFilter[]{new QFilter("extendsmodel", "in", ids)});
    }

    private void openNewFormPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_addextendsmodel");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "add");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void openImportFormPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_extendsmodelimport");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "import");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("add".equalsIgnoreCase(actionId)) {
            Map map = (Map)this.deSerializedBytes((String)evt.getReturnData());
            if (map == null) {
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bcm_extendsmodel");
            parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCustomParam("group", map.get("group"));
            parameter.setCustomParam("field", map.get("field"));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "open");
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameter);
        } else if ("open".equalsIgnoreCase(actionId)) {
            this.refreshList();
        } else if ("import".equalsIgnoreCase(actionId) && evt.getReturnData() != null) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bcm_extmodel_import_info");
            parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("result", evt.getReturnData());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "importResult");
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameter);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        if ("number".equals(e.getFieldName())) {
            BillList list = (BillList)e.getSource();
            Object focusId = list.getFocusRowPkId();
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bcm_extendsmodel");
            parameter.setPageId(this.getView().getPageId() + "bcm_extendsmodel" + focusId);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            parameter.setCustomParam("focusId", focusId);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "open");
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameter);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("model".equals(e.getProperty().getName())) {
            BillList billlist = (BillList)this.getControl(BILLLISTAP);
            billlist.setFilterParameter(new FilterParameter(new QFilter("model", "=", (Object)this.getModelId()), "modifytime"));
            billlist.refresh();
        }
    }

    private String getModelShowNumber() {
        return MemberReader.findModelSNumberById((Object)this.getModelId());
    }

    private void extendsDataDump() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u62d3\u5c55\u6570\u636e\u6a21\u578b\u3002", (String)"ExtendsModelListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection billListSelectedRowCollection = selectedRows.getBillListSelectedRowCollection();
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("bcm_extdatadump");
        param.setCustomParam("model", (Object)this.getModelId());
        param.setCustomParam("extModelList", (Object)billListSelectedRowCollection);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EXT_DATA_DUMP));
        this.getView().showForm(param);
    }
}

