/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimensionnew.extend;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.model.DimFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtField;
import kd.fi.bcm.business.extdata.model.ExtFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.model.FieldEntry;
import kd.fi.bcm.business.serviceHelper.ExtConvertServiceHelper;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.dimension.FieldTypeEnum;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.UserUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.template.util.TemplateExtendModelRefUtil;
import org.apache.commons.collections.CollectionUtils;

public class ExtendsModelPlugin
extends AbstractBaseFormPlugin {
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    public static final String KEY_EXTENDS_MODEL = "extends_model";
    public static final String KEY_EXTENDS_MODEL_ORIGIN = "extends_model_origin";
    public static final String ENTRYENTITY = "entryentity";
    public static final Pattern ONLY_MATH = Pattern.compile("^\\d+$");
    private static List<String> NUMBER_TYPES = Lists.newArrayList((Object[])new String[]{DataTypeEnum.DEFAULT.getOIndex(), DataTypeEnum.UNCURRENCY.getOIndex(), DataTypeEnum.CURRENCY.getOIndex(), DataTypeEnum.PROPORTION.getOIndex()});
    private ExtendsModel extendsModel;
    private final List<String> INTR = Lists.newArrayList((Object[])new String[]{"INTR_SALE", "INTR_PURCHASE", "INTR_CONSOL"});

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("tbmain", "tbfield");
        this.addClickListeners("field");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultValue();
    }

    private void setDefaultValue() {
        Object focusId = this.getFocusId();
        String grouptype = "";
        if (focusId == null) {
            DynamicObject group = (DynamicObject)ObjectSerialUtil.deSerializedBytes((String)((String)this.getPlugin().getView().getFormShowParameter().getCustomParam("group")));
            this.setValue("model", this.getModelId());
            this.setValue("extendsgroup", group);
            this.extendsModel = this.getExtendsModel();
            this.extendsModel.setExtendsGroup(group.getLong("id"));
            this.extendsModel.put("extendsGroupType", (Object)group.getString("grouptype"));
        } else {
            this.extendsModel = new ExtendsModel((Long)focusId);
            this.getPageCache().put(KEY_EXTENDS_MODEL_ORIGIN, this.toSerialExtendsModel(this.extendsModel));
            this.setValue("model", this.extendsModel.getModelId());
            this.setValue("number", this.extendsModel.getNumber());
            this.setValue("name", this.extendsModel.getName());
            this.setValue("extendsgroup", this.extendsModel.getExtendsGroup());
            this.setValue("description", this.extendsModel.getDescription());
            this.setValue("isconvert", this.extendsModel.getIsConvert());
            grouptype = this.extendsModel.getExtendsGroupType();
            if ("3".equals(grouptype)) {
                List fieldEntry = this.extendsModel.getFieldEntry();
                List dimFields = fieldEntry.stream().filter(x -> FieldTypeEnum.DIM_FIELD.getType() == x.getFieldType()).collect(Collectors.toList());
                fieldEntry.removeAll(dimFields);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"isconvert"});
            }
            for (FieldEntry fieldEntry : this.extendsModel.getFieldEntry()) {
                int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY);
                this.getModel().setValue("field", (Object)fieldEntry.getName(), rowIndex);
                this.getModel().setValue("fieldnumber", (Object)fieldEntry.getNumber(), rowIndex);
                this.getModel().setValue("isnecessary", (Object)fieldEntry.getIsNecessary(), rowIndex);
                this.getModel().setValue("uniquecheck", (Object)fieldEntry.getUniqueCheck(), rowIndex);
                if (!"3".equals(grouptype)) continue;
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"isnecessary", "uniquecheck"});
            }
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
            if (this.INTR.contains(this.extendsModel.getNumber())) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{ENTRYENTITY, "addrow", "deleterow"});
            }
        }
        this.updateExtendsModelCache();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"model", "extendsgroup"});
    }

    private boolean isNumberTypes(String datatype, long fieldId) {
        DynamicObject extDim;
        DynamicObject enumItem;
        if (NUMBER_TYPES.contains(datatype)) {
            return true;
        }
        return DataTypeEnum.ENUMTP.getOIndex().equalsIgnoreCase(datatype) && NUMBER_TYPES.contains((enumItem = BusinessDataServiceHelper.loadSingle((Object)(extDim = BusinessDataServiceHelper.loadSingle((Object)fieldId, (String)"bcm_structofextend")).getLong("enumitem.id"), (String)"bcm_enumitem")).getString("datatype"));
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_save": {
                Object focusId = this.getFocusId();
                if (null == focusId) {
                    this.saveExtendsModel(false, null);
                    break;
                }
                this.saveExtendsModel(true, focusId);
                break;
            }
            case "bar_close": {
                if (StringUtils.isNotEmpty((String)this.getPageCache().get(KEY_EXTENDS_MODEL_ORIGIN)) && !this.getPageCache().get(KEY_EXTENDS_MODEL_ORIGIN).equals(this.toSerialExtendsModel(this.getExtendsModel()))) {
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("bar_close", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u7528\u6237\u5df2\u66f4\u6539\u7684\u5185\u5bb9\u4e0d\u4f1a\u4fdd\u5b58\uff0c\u662f\u5426\u4ecd\u7136\u9000\u51fa\uff1f", (String)"ExtendsModelPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
                    return;
                }
                this.getView().close();
                break;
            }
            case "addrow": {
                this.addRow();
                break;
            }
            case "deleterow": {
                this.deleteRow();
                break;
            }
            case "moveup": {
                if (!this.checkIfCanMove()) break;
                this.move(true);
                break;
            }
            case "movedown": {
                if (!this.checkIfCanMove()) break;
                this.move(false);
                break;
            }
        }
    }

    private boolean checkIfCanMove() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 1) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\u3002", (String)"ExtendsModelPlugin_17", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        return false;
    }

    private void move(boolean isUp) {
        this.extendsModel = this.getExtendsModel();
        int index = this.getSelectedRowIndex(ENTRYENTITY);
        if (isUp && index == 0 || !isUp && index == this.extendsModel.getFieldEntry().size() - 1) {
            return;
        }
        for (FieldEntry fieldEntry : this.extendsModel.getFieldEntry()) {
            if (!StringUtils.isEmpty((String)fieldEntry.getName())) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u7a7a\u884c\uff0c\u65e0\u6cd5\u4e0a\u79fb\u4e0b\u79fb\u3002", (String)"ExtendsModelPlugin_19", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        FieldEntry current = (FieldEntry)this.extendsModel.getFieldEntry().get(index);
        boolean currentIsNecessary = current.getIsNecessary();
        boolean currentUniqueCheck = current.getUniqueCheck();
        if (isUp) {
            FieldEntry upper = (FieldEntry)this.extendsModel.getFieldEntry().get(index - 1);
            current.setSeq(index - 1);
            upper.setSeq(index);
            this.getModel().setValue("field", (Object)current.getName(), index - 1);
            this.getModel().setValue("fieldnumber", (Object)current.getNumber(), index - 1);
            this.getModel().setValue("isnecessary", (Object)current.getIsNecessary(), index - 1);
            this.getModel().setValue("uniquecheck", (Object)current.getUniqueCheck(), index - 1);
            this.getModel().setValue("field", (Object)upper.getName(), index);
            this.getModel().setValue("fieldnumber", (Object)upper.getNumber(), index);
            this.getModel().setValue("isnecessary", (Object)upper.getIsNecessary(), index);
            this.getModel().setValue("uniquecheck", (Object)upper.getUniqueCheck(), index);
            current.setIsNecessary(currentIsNecessary);
            current.setUniqueCheck(currentUniqueCheck);
            entryGrid.selectRows(index - 1);
        } else {
            FieldEntry downner = (FieldEntry)this.extendsModel.getFieldEntry().get(index + 1);
            current.setSeq(index + 1);
            downner.setSeq(index);
            this.getModel().setValue("field", (Object)current.getName(), index + 1);
            this.getModel().setValue("fieldnumber", (Object)current.getNumber(), index + 1);
            this.getModel().setValue("isnecessary", (Object)current.getIsNecessary(), index + 1);
            this.getModel().setValue("uniquecheck", (Object)current.getUniqueCheck(), index + 1);
            this.getModel().setValue("field", (Object)downner.getName(), index);
            this.getModel().setValue("fieldnumber", (Object)downner.getNumber(), index);
            this.getModel().setValue("isnecessary", (Object)downner.getIsNecessary(), index);
            this.getModel().setValue("uniquecheck", (Object)downner.getUniqueCheck(), index);
            current.setIsNecessary(currentIsNecessary);
            current.setUniqueCheck(currentUniqueCheck);
            entryGrid.selectRows(index + 1);
        }
        this.extendsModel.getFieldEntry().sort(Comparator.comparing(FieldEntry::getSeq, Comparator.nullsFirst(Comparator.naturalOrder())));
        this.updateExtendsModelCache();
    }

    private Object getFocusId() {
        String focusIdStr = this.getPageCache().get("focusId");
        Object focusId = StringUtils.isNotEmpty((String)focusIdStr) ? Long.valueOf(focusIdStr) : this.getPlugin().getView().getFormShowParameter().getCustomParam("focusId");
        return focusId;
    }

    @Override
    public void click(EventObject evt) {
        String key;
        this.extendsModel = this.getExtendsModel();
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "field": {
                this.openFieldForm();
            }
        }
    }

    private void openFieldForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_extmodelfieldsetting");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        parameter.setCustomParam("extendsModel", (Object)this.getPageCache().get(KEY_EXTENDS_MODEL));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectField");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        this.extendsModel = this.getExtendsModel();
        switch (key = e.getProperty().getName()) {
            case "isnecessary": {
                int index = this.getSelectedRowIndex(ENTRYENTITY);
                FieldEntry fieldEntry = (FieldEntry)this.extendsModel.getFieldEntry().get(index);
                fieldEntry.setIsNecessary(((Boolean)e.getChangeSet()[0].getNewValue()).booleanValue());
                break;
            }
            case "uniquecheck": {
                int index2 = this.getSelectedRowIndex(ENTRYENTITY);
                FieldEntry fieldEntry2 = (FieldEntry)this.extendsModel.getFieldEntry().get(index2);
                fieldEntry2.setUniqueCheck(((Boolean)e.getChangeSet()[0].getNewValue()).booleanValue());
            }
        }
        this.updateExtendsModelCache();
    }

    private void deleteRow() {
        this.extendsModel = this.getExtendsModel();
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        this.getModel().deleteEntryRows(ENTRYENTITY, selectRows);
        this.extendsModel.removeFieldByIndexes(selectRows);
        this.updateExtendsModelCache();
    }

    private void addRow() {
        this.extendsModel = this.getExtendsModel();
        int newEntryRow = this.getModel().createNewEntryRow(ENTRYENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.selectRows(newEntryRow);
        this.extendsModel.addField(new FieldEntry());
        if ("3".equals(this.extendsModel.getExtendsGroupType())) {
            this.getView().setEnable(Boolean.valueOf(false), newEntryRow, new String[]{"isnecessary", "uniquecheck"});
        }
        this.updateExtendsModelCache();
    }

    private void saveExtendsModel(Boolean isEdit, Object focusId) {
        if (this.checkSaveStatus(isEdit)) {
            this.saveDatasOfExtModel(isEdit, focusId);
        }
    }

    private void generateDimExtEntry() {
        this.extendsModel = this.getExtendsModel();
        ArrayList dimFieldEntries = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList extFieldEntries = Lists.newArrayListWithExpectedSize((int)16);
        for (FieldEntry fieldEntry : this.extendsModel.getFieldEntry()) {
            if (FieldTypeEnum.DIM_FIELD.getType() == fieldEntry.getFieldType()) {
                DimFieldEntry dimFieldEntry = new DimFieldEntry();
                dimFieldEntry.setDimension(fieldEntry.getDimension());
                dimFieldEntry.setSeq(fieldEntry.getSeq());
                dimFieldEntry.setId(fieldEntry.getId());
                dimFieldEntry.setIsNecessary(fieldEntry.getIsNecessary());
                dimFieldEntry.setUniqueCheck(fieldEntry.getUniqueCheck());
                dimFieldEntries.add(dimFieldEntry);
                continue;
            }
            if (FieldTypeEnum.EXT_FIELD.getType() != fieldEntry.getFieldType()) continue;
            ExtFieldEntry extFieldEntry = new ExtFieldEntry();
            extFieldEntry.setExtField(fieldEntry.getExtField());
            extFieldEntry.setSeq(fieldEntry.getSeq());
            extFieldEntry.setId(fieldEntry.getId());
            extFieldEntry.setIsNecessary(fieldEntry.getIsNecessary());
            extFieldEntry.setUniqueCheck(fieldEntry.getUniqueCheck());
            extFieldEntries.add(extFieldEntry);
        }
        this.extendsModel.setDimFieldEntry((List)dimFieldEntries);
        this.extendsModel.setExtFieldEntry((List)extFieldEntries);
        this.updateExtendsModelCache();
    }

    private boolean checkSaveStatus(Boolean isEdit) {
        String number = (String)this.getValue("number");
        String regEx = "^[-a-zA-Z0-9._]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        String message = ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u7f16\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\uff0c\u4e0d\u80fd\u5168\u4e3a\u6570\u5b57\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ExtendsModelPlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        if (!matcher.matches() || !isEdit.booleanValue() && ONLY_MATH.matcher(number).matches()) {
            this.getView().showTipNotification(message);
            return false;
        }
        if (number.contains("..") || number.startsWith(".") || number.startsWith("-")) {
            this.getView().showTipNotification(message);
            return false;
        }
        QFBuilder qb = new QFBuilder("model", "=", (Object)this.getModelId());
        qb.add(new QFilter("number", "=", (Object)number));
        if (!isEdit.booleanValue() && QueryServiceHelper.exists((String)"bcm_extendsmodel", (QFilter[])qb.toArray())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u6a21\u578b\u7f16\u7801\u3002", (String)"ExtendsModelPlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        this.extendsModel = this.getExtendsModel();
        for (FieldEntry fieldEntry : this.extendsModel.getFieldEntry()) {
            if (!StringUtils.isEmpty((String)fieldEntry.getName())) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u8bbe\u7f6e\u7f3a\u5931\u5185\u5bb9\u3002", (String)"ExtendsModelPlugin_18", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        this.generateDimExtEntry();
        if (this.extendsModel.getExtFieldEntry() == null || this.extendsModel.getExtFieldEntry().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u62d3\u5c55\u5b57\u6bb5\u6210\u5458\u3002", (String)"ExtendsModelPlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        List extFieldIdList = this.extendsModel.getExtFieldEntry().stream().map(o -> o.getExtField().getId()).collect(Collectors.toList());
        Set extFieldIdSet = this.extendsModel.getExtFieldEntry().stream().map(o -> o.getExtField().getId()).collect(Collectors.toSet());
        if (extFieldIdList.size() != extFieldIdSet.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u76f8\u540c\u62d3\u5c55\u5b57\u6bb5\u6210\u5458\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0\u3002", (String)"ExtendsModelPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        for (Object dimFieldEntry : this.extendsModel.getDimFieldEntry()) {
            if (dimFieldEntry.getIsNecessary()) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u8bbe\u7f6e\u8981\u6c42\u5305\u542b\u6240\u6709\u591a\u7ef4\u5b57\u6bb5\u53ca\u81f3\u5c11\u4e00\u4e2a\u62d3\u5c55\u5b57\u6bb5\u3002", (String)"ExtendsModelPlugin_21", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        int count = 0;
        for (ExtFieldEntry extFieldEntry : this.extendsModel.getExtFieldEntry()) {
            if (!extFieldEntry.getIsNecessary()) continue;
            ++count;
            break;
        }
        if (count == 0 && !"3".equals(this.extendsModel.getExtendsGroupType())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u8bbe\u7f6e\u8981\u6c42\u5305\u542b\u6240\u6709\u591a\u7ef4\u5b57\u6bb5\u53ca\u81f3\u5c11\u4e00\u4e2a\u62d3\u5c55\u5b57\u6bb5\u3002", (String)"ExtendsModelPlugin_21", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (isEdit.booleanValue()) {
            List dimFieldNum = this.extendsModel.getDimFieldEntry().stream().map(o -> o.getDimension().getNumber()).collect(Collectors.toList());
            List<Long> extFieldId = this.extendsModel.getExtFieldEntry().stream().map(o -> o.getExtField().getId()).collect(Collectors.toList());
            ExtendsModel extendsModelOri = this.getExtendsModelFromSerial(this.getPageCache().get(KEY_EXTENDS_MODEL_ORIGIN));
            List<Long> oriExtFieldId = extendsModelOri.getExtFieldEntry().stream().map(o -> o.getExtField().getId()).collect(Collectors.toList());
            List oriDimFieldNum = extendsModelOri.getDimFieldEntry().stream().map(o -> o.getDimension().getNumber()).collect(Collectors.toList());
            Map<String, List<String>> deletedAndAddedMems = this.getDeletedAndCacheChangeInfo(this.extendsModel, extendsModelOri);
            List<String> deletedMems = deletedAndAddedMems.get("deleted");
            List<String> addedMems = deletedAndAddedMems.get("added");
            List<String> changedMems = deletedAndAddedMems.get("changed");
            List changeDimFiledNums = this.extendsModel.getDimFieldEntry().stream().filter(x -> changedMems.contains(x.getDimension().getNumber())).map(y -> y.getDimension().getNumber()).collect(Collectors.toList());
            List changeExtFiledIds = this.extendsModel.getExtFieldEntry().stream().filter(x -> changedMems.contains(x.getExtField().getNumber())).map(y -> y.getExtField().getId()).collect(Collectors.toList());
            QFilter qf = new QFilter("id", "=", (Object)this.extendsModel.getExtendsGroup());
            String grouptype = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"grouptype", (QFilter[])qf.toArray()).getString("grouptype");
            boolean isUsed = this.getIsUsed();
            if (isUsed) {
                if ("3".equals(grouptype) && !this.checkUserdOfEquityByTemplate(oriExtFieldId, extFieldId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62d3\u5c55\u6570\u636e\u6a21\u578b\u5220\u9664\u7684\u5b57\u6bb5\u5df2\u88ab\u6743\u76ca\u62b5\u9500\u5e95\u7a3f\u6a21\u677f\u5f15\u7528\uff0c\u4e0d\u80fd\u4fee\u6539\u5b57\u6bb5\u3002", (String)"ExtendsModelPlugin_32", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return false;
                }
                if (CollectionUtils.isNotEmpty(deletedMems) && !this.checkUserdOfNotEquityByTemplate(deletedMems)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62d3\u5c55\u6570\u636e\u6a21\u578b\u5220\u9664\u7684\u5b57\u6bb5\u5df2\u88ab\u62a5\u8868\u6a21\u677f\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u5b57\u6bb5\u3002", (String)"ExtendsModelPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return false;
                }
            }
            oriExtFieldId.removeAll(extFieldId);
            oriExtFieldId.addAll(changeExtFiledIds);
            if (!CollectionUtils.isEmpty(oriExtFieldId) && ExtDataServiceHelper.isExistDataOfExtMemSpecific((String)this.getModelShowNumber(), (String)this.extendsModel.getNumber(), oriExtFieldId, (String)grouptype).booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62d3\u5c55\u6570\u636e\u6a21\u578b\u5df2\u6709\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664\u6216\u4fee\u6539\u62d3\u5c55\u7ef4\u5b57\u6bb5\u3002", (String)"ExtendsModelPlugin_35", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return false;
            }
            if (!"3".equals(this.extendsModel.getExtendsGroupType())) {
                oriDimFieldNum.removeAll(dimFieldNum);
                oriDimFieldNum.addAll(changeDimFiledNums);
                if (!CollectionUtils.isEmpty(oriDimFieldNum) && ExtDataServiceHelper.isExistDataOfDimMemSpecific((String)this.getModelShowNumber(), (String)this.extendsModel.getNumber(), oriDimFieldNum, (String)grouptype)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62d3\u5c55\u6570\u636e\u6a21\u578b\u5df2\u6709\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664\u6216\u4fee\u6539\u591a\u7ef4\u5b57\u6bb5\u3002", (String)"ExtendsModelPlugin_36", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return false;
                }
            }
            if (!CollectionUtils.isEmpty(deletedMems) && ExtDataServiceHelper.isExistDataOfInvestExtMem((String)this.getModelShowNumber(), (String)this.extendsModel.getNumber(), deletedMems)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62d3\u5c55\u6570\u636e\u6a21\u578b\u5df2\u6709\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664\u5b57\u6bb5\u3002", (String)"ExtendsModelPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return false;
            }
            List<DynamicObject> usedIsschemes = this.getIsUsedByIntergrationScheme(this.extendsModel);
            if (usedIsschemes != null && usedIsschemes.size() > 0) {
                boolean openStatus = usedIsschemes.stream().anyMatch(x -> "1".equals(x.getString("status")));
                if (!(CollectionUtils.isEmpty(deletedMems) && CollectionUtils.isEmpty(addedMems) && CollectionUtils.isEmpty(changedMems))) {
                    if (openStatus) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f15\u7528\u8be5\u6a21\u578b\u7684\u96c6\u6210\u65b9\u6848\u5df2\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u6216\u5220\u9664\u5b57\u6bb5\u3002", (String)"ExtendsModelPlugin_33", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                        return false;
                    }
                    Set isschemeNums = usedIsschemes.stream().map(x -> x.getString("number")).collect(Collectors.toSet());
                    String tips = String.format(ResManager.loadKDString((String)"\u8be5\u6a21\u578b\u5df2\u88ab\u96c6\u6210\u65b9\u6848\u201c%s\u201d\u5f15\u7528\uff0c\u4fee\u6539\u5b8c\u6210\u540e\u9700\u5bf9\u5e94\u4fee\u6539\u96c6\u6210\u65b9\u6848\u7684\u914d\u7f6e\u6216\u91cd\u5efa\u96c6\u6210\u65b9\u6848\u3002\u8bf7\u786e\u8ba4\u662f\u5426\u4fee\u6539\uff1f", (String)"ExtendsModelPlugin_34", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), String.join((CharSequence)",", isschemeNums));
                    this.getView().showConfirm(tips, MessageBoxOptions.YesNo, new ConfirmCallBackListener("extendmodel_save", (IFormPlugin)this));
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkUserdOfEquityByTemplate(List<Long> oriExtFieldId, List<Long> extFieldId) {
        Set tmpIds;
        QFilter tmpQf;
        DynamicObjectCollection extMems;
        boolean flag = true;
        QFilter extQf = new QFilter("extdimid", "=", (Object)this.extendsModel.getId());
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id", (QFilter[])extQf.toArray());
        if (templates != null && templates.size() > 0 && (extMems = QueryServiceHelper.query((String)"bcm_invsheetacclayout", (String)"extdimid", (QFilter[])(tmpQf = new QFilter("template", "in", tmpIds = templates.stream().map(x -> x.getLong("id")).collect(Collectors.toSet()))).toArray())) != null && extMems.size() > 0) {
            Set extdimids = extMems.stream().map(x -> x.getLong("extdimid")).collect(Collectors.toSet());
            if (!this.checkCollectionIsContained(oriExtFieldId, extFieldId)) {
                oriExtFieldId.removeAll(extFieldId);
                flag = Collections.disjoint(oriExtFieldId, extdimids);
            }
        }
        return flag;
    }

    private boolean checkUserdOfNotEquityByTemplate(List<String> deletedMems) {
        boolean flag = true;
        HashSet quoteFields = Sets.newHashSetWithExpectedSize((int)16);
        Map<Tuple<String, String, String>, Set<String>> templateRefExtendModelCols = TemplateExtendModelRefUtil.getTemplateRefExtendModelCols(this.getExtendsModel());
        Iterator<Map.Entry<Tuple<String, String, String>, Set<String>>> iterator = templateRefExtendModelCols.entrySet().iterator();
        while (iterator.hasNext()) {
            quoteFields.addAll((Collection)iterator.next().getValue());
        }
        if (CollectionUtils.isNotEmpty(deletedMems)) {
            flag = Collections.disjoint(deletedMems, quoteFields);
        }
        return flag;
    }

    private List<DynamicObject> getIsUsedByIntergrationScheme(ExtendsModel extendsModel) {
        long id = extendsModel.getId();
        QFilter qFilter = new QFilter("extendsmodel", "=", (Object)id);
        return QueryServiceHelper.query((String)"bcm_isscheme", (String)"id, number, name, status", (QFilter[])qFilter.toArray());
    }

    private boolean checkCollectionIsContained(Collection a, Collection b) {
        if (b.size() >= a.size()) {
            a.removeAll(b);
            if (a.size() == 0) {
                return true;
            }
        }
        return false;
    }

    private Map<String, List<String>> getDeletedAndCacheChangeInfo(ExtendsModel extendsModel, ExtendsModel extendsModelOri) {
        List fieldNum = extendsModel.getFieldEntry().stream().map(o -> o.getNumber()).collect(Collectors.toList());
        List oriFieldNum = extendsModelOri.getFieldEntry().stream().map(o -> o.getNumber()).collect(Collectors.toList());
        ArrayList addFieldNum = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList changeFieldNum = Lists.newArrayListWithExpectedSize((int)16);
        for (Object fieldEntry : extendsModel.getFieldEntry()) {
            if (oriFieldNum.contains(fieldEntry.getNumber())) {
                FieldEntry oriFieldEntry = extendsModelOri.getFieldEntryByNumber(fieldEntry.getNumber());
                if (fieldEntry.getIsNecessary() == oriFieldEntry.getIsNecessary() && fieldEntry.getUniqueCheck() == oriFieldEntry.getUniqueCheck()) continue;
                changeFieldNum.add(fieldEntry.getNumber());
                continue;
            }
            addFieldNum.add(fieldEntry.getNumber());
        }
        oriFieldNum.removeAll(fieldNum);
        StringBuilder sb = new StringBuilder();
        if (oriFieldNum.size() > 0 || addFieldNum.size() > 0 || changeFieldNum.size() > 0) {
            sb.append(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6a21\u578b", (String)"ExtendsModelPlugin_30", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])).append(extendsModel.getName()).append('\uff08').append(extendsModel.getNumber()).append('\uff09');
        }
        if (oriFieldNum.size() > 0) {
            sb.append(ResManager.loadKDString((String)"\u5220\u9664", (String)"ExtendsModelPlugin_25", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            for (String s : oriFieldNum) {
                sb.append(s).append('\u3001');
            }
            sb.deleteCharAt(sb.lastIndexOf("\u3001"));
            sb.append(ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"ExtendsModelPlugin_26", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (addFieldNum.size() > 0) {
            sb.append("/");
            sb.append(ResManager.loadKDString((String)"\u65b0\u589e", (String)"ExtendsModelPlugin_27", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            for (String s : addFieldNum) {
                sb.append(s).append('\u3001');
            }
            sb.deleteCharAt(sb.lastIndexOf("\u3001"));
            sb.append(ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"ExtendsModelPlugin_26", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (changeFieldNum.size() > 0) {
            sb.append("/");
            sb.append(ResManager.loadKDString((String)"\u4fee\u6539", (String)"ExtendsModelPlugin_29", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            for (String s : changeFieldNum) {
                sb.append(s).append('\u3001');
            }
            sb.deleteCharAt(sb.lastIndexOf("\u3001"));
            sb.append(ResManager.loadKDString((String)"\u5b57\u6bb5\u8bbe\u7f6e", (String)"ExtendsModelPlugin_28", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (sb.length() > 0) {
            this.getPageCache().put("editLog", sb.toString());
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(2);
        result.put("deleted", oriFieldNum);
        result.put("added", addFieldNum);
        result.put("changed", changeFieldNum);
        return result;
    }

    private boolean getIsUsed() {
        return ExtDataServiceHelper.isExtModelUsed((long)this.getModelId(), (List)Lists.newArrayList((Object[])new Long[]{this.getExtendsModel().getId()}));
    }

    private int getSelectedRowIndex(String entry) {
        EntryGrid eg = (EntryGrid)this.getControl(entry);
        return eg.getSelectRows()[0];
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        int index = this.getSelectedRowIndex(ENTRYENTITY);
        this.extendsModel = this.getExtendsModel();
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("selectField".equalsIgnoreCase(actionId)) {
            List fields = (List)this.deSerializedBytes((String)closedCallBackEvent.getReturnData());
            if (CollectionUtils.isNotEmpty((Collection)fields)) {
                if (fields.size() == 1) {
                    this.setFieldValue((DynamicObject)fields.get(0), index);
                } else {
                    this.setFieldValueOfMultiline(fields, index);
                }
            }
            this.updateExtendsModelCache();
        }
    }

    private void setFieldValueOfMultiline(List<DynamicObject> fields, int startInx) {
        this.extendsModel = this.getExtendsModel();
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, fields.size() - 1);
        for (int i = 0; i < fields.size(); ++i) {
            DynamicObject field = fields.get(i);
            this.setFieldValue(field, startInx);
            ++startInx;
            if (i == fields.size() - 1) continue;
            this.extendsModel.addField(new FieldEntry());
            if (!"3".equals(this.extendsModel.getExtendsGroupType())) continue;
            this.getView().setEnable(Boolean.valueOf(false), startInx, new String[]{"isnecessary", "uniquecheck"});
        }
    }

    private void setFieldValue(DynamicObject field, int index) {
        if (field != null) {
            FieldEntry fieldEntry = new FieldEntry();
            fieldEntry.setName(field.getString("name"));
            fieldEntry.setNumber(field.getString("number"));
            fieldEntry.setSeq(index);
            if (FieldTypeEnum.DIM_FIELD.getType() == field.getInt("typecode")) {
                fieldEntry.setDimension(this.generateDimension(field.getLong("id"), field.getString("number"), field.getString("name")));
                fieldEntry.setFieldType(FieldTypeEnum.DIM_FIELD.getType());
                fieldEntry.setIsNecessary(true);
                fieldEntry.setUniqueCheck(true);
                this.getModel().setValue("field", (Object)field.getString("name"), index);
                this.getModel().setValue("fieldnumber", (Object)field.getString("number"), index);
                this.getModel().setValue("isnecessary", (Object)true, index);
                this.getModel().setValue("uniquecheck", (Object)true, index);
            } else if (FieldTypeEnum.EXT_FIELD.getType() == field.getInt("typecode")) {
                ExtField extField = new ExtField();
                extField.setNumber(field.getString("number"));
                extField.setName(field.getString("name"));
                extField.setId(field.getLong("id"));
                fieldEntry.setExtField(extField);
                fieldEntry.setFieldType(FieldTypeEnum.EXT_FIELD.getType());
                fieldEntry.setIsNecessary(false);
                if (!this.isNumberTypes(field.getString("datatype"), field.getLong("id"))) {
                    fieldEntry.setUniqueCheck(true);
                    this.getModel().setValue("uniquecheck", (Object)true, index);
                } else {
                    fieldEntry.setUniqueCheck(false);
                    this.getModel().setValue("uniquecheck", (Object)false, index);
                }
                this.getModel().setValue("field", (Object)field.getString("name"), index);
                this.getModel().setValue("fieldnumber", (Object)field.getString("number"), index);
                if (!"3".equals(this.extendsModel.getExtendsGroupType())) {
                    this.getModel().setValue("isnecessary", (Object)false, index);
                }
            }
            this.extendsModel.updateFieldByIndex(index, fieldEntry);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        DynamicObject[] dataEntitys;
        super.afterDeleteRow(e);
        this.extendsModel = this.getExtendsModel();
        if ("3".equals(this.extendsModel.getExtendsGroupType()) && (dataEntitys = ((EntryGrid)this.getControl(ENTRYENTITY)).getEntryData().getDataEntitys()).length > 0) {
            for (int i = 0; i < dataEntitys.length; ++i) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"isnecessary", "uniquecheck"});
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (MessageBoxResult.Yes.getValue() == event.getResult().getValue()) {
            if ("bar_close".equals(callBackId)) {
                this.getView().close();
            } else if ("extendmodel_save".equals(callBackId)) {
                Object focusId = this.getFocusId();
                if (null == focusId) {
                    this.saveDatasOfExtModel(false, null);
                } else {
                    this.saveDatasOfExtModel(true, focusId);
                }
            }
        }
    }

    private Dimension generateDimension(long id, String number, String name) {
        Dimension dimension = new Dimension();
        dimension.setId(id);
        dimension.setModelId(String.valueOf(this.getModelId()));
        dimension.setNumber(number);
        dimension.setName(name);
        dimension.setMemberEntityNumber(DimEntityNumEnum.getEntieyNumByNumber((String)number));
        return dimension;
    }

    public ExtendsModel getExtendsModel() {
        if (this.extendsModel != null) {
            return this.extendsModel;
        }
        Predicate<String> p = t -> StringUtils.isEmpty((String)t);
        String serial = this.getPageCache().get(KEY_EXTENDS_MODEL);
        if (p.test(serial)) {
            serial = (String)this.getFormCustomParam(KEY_EXTENDS_MODEL);
            this.extendsModel = !p.test(serial) ? this.getExtendsModelFromSerial(serial) : new ExtendsModel();
            this.getPageCache().put(KEY_EXTENDS_MODEL, this.toSerialExtendsModel(this.extendsModel));
        } else {
            this.extendsModel = this.getExtendsModelFromSerial(serial);
        }
        return this.extendsModel;
    }

    private String toSerialExtendsModel(ExtendsModel extendsModel) {
        return this.toByteSerialized(extendsModel);
    }

    private ExtendsModel getExtendsModelFromSerial(String serial) {
        return (ExtendsModel)this.deSerializedBytes(serial);
    }

    private void updateExtendsModelCache() {
        this.getPageCache().put(KEY_EXTENDS_MODEL, this.toSerialExtendsModel(this.extendsModel));
    }

    private String getModelShowNumber() {
        return BusinessDataServiceHelper.loadSingle((Object)this.getModelId(), (String)"bcm_model").getString("shownumber");
    }

    private void saveDatasOfExtModel(Boolean isEdit, Object focusId) {
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject extmodel = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extendsmodel");
                if (isEdit.booleanValue()) {
                    Object dy;
                    extmodel = BusinessDataServiceHelper.loadSingle((Object)focusId, (String)"bcm_extendsmodel");
                    QFBuilder qb = new QFBuilder("extmodelid", "=", focusId);
                    DynamicObjectCollection extmodelfield = QueryServiceHelper.query((String)"bcm_extmodelfield", (String)"id", (QFilter[])qb.toArray());
                    DynamicObjectCollection extmodeldim = QueryServiceHelper.query((String)"bcm_extmodeldim", (String)"id", (QFilter[])qb.toArray());
                    if (!CollectionUtils.isEmpty((Collection)extmodelfield)) {
                        List fieldids = extmodelfield.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                        dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extmodelfield");
                        DeleteServiceHelper.delete((IDataEntityType)dy.getDynamicObjectType(), (Object[])fieldids.toArray());
                    }
                    if (!CollectionUtils.isEmpty((Collection)extmodeldim)) {
                        List dimids = extmodeldim.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                        dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extmodeldim");
                        DeleteServiceHelper.delete((IDataEntityType)dy.getDynamicObjectType(), (Object[])dimids.toArray());
                    }
                }
                this.extendsModel = this.getExtendsModel();
                extmodel.set("model", (Object)this.getModelId());
                extmodel.set("number", this.getValue("number"));
                extmodel.set("name", this.getValue("name"));
                extmodel.set("extendsgroup", this.getValue("extendsgroup"));
                extmodel.set("description", this.getValue("description"));
                extmodel.set("status", (Object)"C");
                extmodel.set("enable", (Object)(StringUtils.isEmpty((String)this.extendsModel.getEnable()) ? "1" : this.extendsModel.getEnable()));
                extmodel.set("creator", (Object)(null == this.extendsModel.getCreator() ? UserUtils.getUserId() : this.extendsModel.getCreator()));
                extmodel.set("modifier", (Object)UserUtils.getUserId());
                extmodel.set("createtime", (Object)(null == this.extendsModel.getCreatetime() ? new Date() : this.extendsModel.getCreatetime()));
                extmodel.set("modifytime", (Object)new Date());
                extmodel.set("isconvert", this.getValue("isconvert"));
                Object[] result = BusinessDataWriter.save((IDataEntityType)extmodel.getDynamicObjectType(), (Object[])new Object[]{extmodel});
                long extmodelid = ((DynamicObject)result[0]).getLong("id");
                ArrayList extfields = Lists.newArrayListWithExpectedSize((int)16);
                for (Object extFieldEntry : this.extendsModel.getExtFieldEntry()) {
                    DynamicObject dy2 = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extmodelfield");
                    dy2.set("extfield", (Object)extFieldEntry.getExtField().getId());
                    dy2.set("sequence", (Object)extFieldEntry.getSeq());
                    dy2.set("isnecessary", (Object)extFieldEntry.getIsNecessary());
                    dy2.set("uniquecheck", (Object)extFieldEntry.getUniqueCheck());
                    dy2.set("extmodelid", (Object)extmodelid);
                    dy2.set("id", (Object)extFieldEntry.getId());
                    extfields.add(dy2);
                }
                if (!CollectionUtils.isEmpty((Collection)extfields)) {
                    BusinessDataWriter.save((IDataEntityType)((DynamicObject)extfields.get(0)).getDynamicObjectType(), (Object[])extfields.toArray());
                }
                ArrayList dimensions = Lists.newArrayListWithExpectedSize((int)16);
                for (DimFieldEntry dimFieldEntry : this.extendsModel.getDimFieldEntry()) {
                    DynamicObject dy2 = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extmodeldim");
                    dy2.set("dimension", (Object)dimFieldEntry.getDimension().getId());
                    dy2.set("sequence", (Object)dimFieldEntry.getSeq());
                    dy2.set("isnecessary", (Object)dimFieldEntry.getIsNecessary());
                    dy2.set("uniquecheck", (Object)dimFieldEntry.getUniqueCheck());
                    dy2.set("extmodelid", (Object)extmodelid);
                    dy2.set("id", (Object)dimFieldEntry.getId());
                    dimensions.add(dy2);
                }
                if (!CollectionUtils.isEmpty((Collection)dimensions)) {
                    BusinessDataWriter.save((IDataEntityType)((DynamicObject)dimensions.get(0)).getDynamicObjectType(), (Object[])dimensions.toArray());
                }
                this.getPageCache().put("focusId", String.valueOf(extmodelid));
                this.extendsModel = new ExtendsModel(Long.valueOf(extmodelid));
                this.getPageCache().put(KEY_EXTENDS_MODEL_ORIGIN, this.toSerialExtendsModel(this.extendsModel));
                this.updateExtendsModelCache();
                if (isEdit.booleanValue()) {
                    String editLog = this.getPageCache().get("editLog");
                    if (StringUtils.isNotEmpty((String)editLog)) {
                        OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u4fee\u6539\u4fdd\u5b58", "ExtendsModelPlugin_31", FI_BCM_FORMPLUGIN, "save");
                        this.writeOperationLog(opName, editLog);
                        this.getPageCache().remove("editLog");
                    }
                    ExtConvertServiceHelper.clearExtModelCache((Long)extmodelid);
                } else {
                    this.writeOperationLog(new OpNameMultiLangEnumBridge("\u65b0\u589e\u4fdd\u5b58", "ExtendsModelPlugin_23", FI_BCM_FORMPLUGIN, "Add Save"), this.extendsModel.getNumber(), this.extendsModel.getName(), ResManager.loadKDString((String)"\u6210\u529f", (String)"ExtendsModelPlugin_24", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ExtendsModelPlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ClientViewProxy clientViewProxy = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(ENTRYENTITY, "setColEditorProp", new Object[]{"field", "sx", false});
    }
}

